/*
 * dia_IOCtrlDisplayTestScreenCMC.h
 *
 *  Created on: Mar 14, 2019
 *      Author: mky6kor
 */

#ifndef DIA_IOCTRLDISPLAYTESTSCREENCMC_H_
#define DIA_IOCTRLDISPLAYTESTSCREENCMC_H_
#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DISPLAYPATTERNAIVI_LISTENER__
#include "project/interfaces/dia_IDisplayPatternAIVIListener.h"
#endif

enum dia_eDisplayCtrlID
{
	DIA_EN_DISPLAY_CTRL_VALUE_NONE=0,
	DIA_EN_DISPLAY_CTRL_VALUE_WHITE,
	DIA_EN_DISPLAY_CTRL_VALUE_BLACK,
	DIA_EN_DISPLAY_CTRL_VALUE_RED,
	DIA_EN_DISPLAY_CTRL_VALUE_GREEN,
	DIA_EN_DISPLAY_CTRL_VALUE_BLUE,
	DIA_EN_DISPLAY_CTRL_VALUE_COLOURED,
	DIA_EN_DISPLAY_CTRL_VALUE_FLICKER_TEST
};

class dia_IOCtrlDisplayTestScreenCMC
:public dia_IOCtrlSignal,
  public dia_IDisplayPatternAIVIListenerImpl{
public:
	//! Class Constructor
	dia_IOCtrlDisplayTestScreenCMC(void);
	//! Class Destructor
	virtual ~dia_IOCtrlDisplayTestScreenCMC(void);
	//!Handles the incoming request
	virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
	//!
	virtual void handleTimeout ( void );
	virtual void vOnSetDisplayTestPatternDone ( tDiaResult u32Result );

	//! called to request the current state of the corresponding service
	virtual void getCurrentState ( std::vector<tU8>& results );

protected:
	//! switch off the test screen
	virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

	tDiaResult setScreen(tU8 u8Screen);
private:
	 dia_eDisplayPatternAIVIID getDisplayPatternFromCtrlValue(dia_eDisplayCtrlID ctrlID);

	 static const std::map<const dia_eDisplayCtrlID,const dia_eDisplayPatternAIVIID> CTRL_VALUE_2_PATTERN_MAPPING;
};
#endif /* DIA_IOCTRLDISPLAYTESTSCREENCMC_H_ */
