/*
 * dia_IOCtrlDisplayTestScreenCMC.cpp
 *
 *  Created on: Mar 14, 2019
 *      Author: mky6kor
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif
#ifndef DIA_IOCTRL_DISPLAY_TEST_SCREEN_CMC_H_
#include "project/services/customer/dia_IOCtrlDisplayTestScreenCMC.h"
#endif
#ifndef __INCLUDED_DIA_IOCTRL_MANAGER__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlManager.h"
#endif

const std::map<const dia_eDisplayCtrlID, const dia_eDisplayPatternAIVIID> dia_IOCtrlDisplayTestScreenCMC::CTRL_VALUE_2_PATTERN_MAPPING = {
    { DIA_EN_DISPLAY_CTRL_VALUE_NONE, DIA_EN_DISPLAY_PATTERN_AIVI_NONE },
    { DIA_EN_DISPLAY_CTRL_VALUE_WHITE, DIA_EN_DISPLAY_PATTERN_AIVI_WHITE },
    { DIA_EN_DISPLAY_CTRL_VALUE_BLACK, DIA_EN_DISPLAY_PATTERN_AIVI_BLACK },
    { DIA_EN_DISPLAY_CTRL_VALUE_RED, DIA_EN_DISPLAY_PATTERN_AIVI_RED },
    { DIA_EN_DISPLAY_CTRL_VALUE_GREEN, DIA_EN_DISPLAY_PATTERN_AIVI_GREEN },
    { DIA_EN_DISPLAY_CTRL_VALUE_BLUE, DIA_EN_DISPLAY_PATTERN_AIVI_BLUE },
    { DIA_EN_DISPLAY_CTRL_VALUE_COLOURED, DIA_EN_DISPLAY_PATTERN_AIVI_COLOURED },
    { DIA_EN_DISPLAY_CTRL_VALUE_FLICKER_TEST, DIA_EN_DISPLAY_PATTERN_AIVI_FLICKER_TEST }
};

#define DIA_C_U8_MAX_NUMBER_OF_CMC_TEST_PATTERNS  ((tU8)    8)

dia_IOCtrlDisplayTestScreenCMC::dia_IOCtrlDisplayTestScreenCMC()
: dia_IOCtrlSignal (
		"dia_IOCtrlDisplayTestScreenCMC",
	    DIA_C_U16_DID_CENTER_CMC_19_DISPLAY_TEST_PATTERN ,
		1,
		DIA_EN_IOCTRL_CTRLMODE_TESTER
		)
{
	// TODO Auto-generated constructor stub
	dia_tclFnctTrace trc("dia_IOCtrlDisplayTestScreenCMC::dia_IOCtrlDisplayTestScreenCMC");
}

dia_IOCtrlDisplayTestScreenCMC::~dia_IOCtrlDisplayTestScreenCMC() {
	// TODO Auto-generated destructor stub
	_BP_TRY_BEGIN
	{
		(void) unsetSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
	}
	_BP_CATCH_ALL
	{
		DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlDisplayTestScreenCMC::~dia_IOCtrlDisplayTestScreenCMC !!!");
		DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END
}
//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlDisplayTestScreenCMC::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
	dia_tclFnctTrace oTrace("dia_IOCtrlDisplayTestScreenCMC::handleRequest()");
    if((ctrlValue->at(0)) >= DIA_C_U8_MAX_NUMBER_OF_CMC_TEST_PATTERNS)
    {
    	DIA_TR_ERR(" ---  INVALID ENTRY FOR SET SCREEN!!!!");
    	return DIA_FAILED;
    }
    else
    {
    	if ( DIA_SUCCESS != setScreen( ctrlValue->at(0) ) )
    	{
    		(void) unsetSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
    		DIA_TR_ERR(" ---  SEND TO HMI FAILED!!!!");
    		return DIA_FAILED;
    	}
    }

	// now initialize the counter for the timer
	vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

	mIsResultReady = FALSE;

	// NO_ERROR allows the service handler to return immediately
	return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlDisplayTestScreenCMC::vOnTerminate ( dia_eIOCtrlStatus status )
{
	dia_tclFnctTrace oTrace("dia_IOCtrlDisplayTestScreenCMC::vOnTerminate()");

	tDiaResult retCode = DIA_E_NOERROR;

	if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
	{
		if ( status == DIA_EN_IOCTRL_STATUS_INACTIVE)
		{
			// we have to wait for the response
			mIsResultReady = FALSE;
		}

		// Set to normal HMI screen
		if ( DIA_SUCCESS != setScreen(0) )
		{
			DIA_TR_INF("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SET : TEST SCREEN !!!");
			retCode = DIA_FAILED;
		}
	}

	return retCode;
}


//-----------------------------------------------------------------------------

void
dia_IOCtrlDisplayTestScreenCMC::vOnSetDisplayTestPatternDone (  tDiaResult result )
{
	dia_tclFnctTrace trc("dia_IOCtrlDisplayTestScreenCMC::vOnSetDisplayTestPatternDone");

	(void) unsetSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
	mIsResultReady = TRUE;

	if(DIA_SUCCESS == result)
	{
		setErrorInfo(DIA_E_NOERROR);
	}
	else
	{
		setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
	}

	dia_IOCtrlManager::vOnSignalUpdate(*this);

}

//-----------------------------------------------------------------------------

void
dia_IOCtrlDisplayTestScreenCMC::handleTimeout ( void )
{
	dia_tclFnctTrace trc("dia_IOCtrlDisplayTestScreenCMC::handleTimeout");
	(void) unsetSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlDisplayTestScreenCMC::setScreen(tU8 u8Screen)
{
	dia_tclFnctTrace trc("dia_IOCtrlDisplayTestScreenCMC::setScreen");

	dia_eDisplayPatternAIVIID ePatternID = DIA_EN_DISPLAY_PATTERN_AIVI_UNKNOWN;
	dia_eDisplayCtrlID ctrlID=static_cast<dia_eDisplayCtrlID>(u8Screen);

	tDiaResult retCode = DIA_FAILED;

	dia_IDisplayPatternAIVI* pInterface = 0;
	if ( querySysAdapterInterface<dia_IDisplayPatternAIVI>(&pInterface) == DIA_SUCCESS )
	{
		if ( pInterface )
		{
			ePatternID=getDisplayPatternFromCtrlValue(ctrlID);
			if ( ePatternID != DIA_EN_DISPLAY_PATTERN_AIVI_UNKNOWN )
			{
				(void) setSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
				retCode = pInterface->setDisplayPatternID(ePatternID);
			}
		}
	}
	return retCode;
}

//------------------------------------------------------------------------------

dia_eDisplayPatternAIVIID
dia_IOCtrlDisplayTestScreenCMC::getDisplayPatternFromCtrlValue(dia_eDisplayCtrlID ctrlID)
{
	dia_tclFnctTrace trc("dia_IOCtrlDisplayTestScreenCMC::getDisplayPatternFromCtrlValue(dia_eDisplayCtrlID)");
	dia_eDisplayPatternAIVIID ePattern = DIA_EN_DISPLAY_PATTERN_AIVI_UNKNOWN;

    auto it  = CTRL_VALUE_2_PATTERN_MAPPING.find(ctrlID);
    if (it != CTRL_VALUE_2_PATTERN_MAPPING.end())
    {
    	ePattern = it->second;
    }
    return ePattern;
}

//------------------------------------------------------------------------------
//!Center CM-C 19:Deliberately suppressing the return byte for IO Control Freeze and Return Services as per the Customer Requirement
void
dia_IOCtrlDisplayTestScreenCMC::getCurrentState ( std::vector<tU8>& results )
{
   dia_tclFnctTrace trc("dia_IOCtrlDisplayTestScreenCMC::getCurrentState");
}

//------------------------------------------------------------------------------
