/*
* dia_IOCtrlDisplayTest.cpp
*
*  Created on: 12.01.2014
*      Author: wgl2hi
*/

#ifndef __INCLUDED_DIA_IOCTRL_DISPLAY_TEST_H__
#include "project/services/customer/dia_IOCtrlDisplayTest.h"
#endif

#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define DIA_UDS_DIAPLAY_CTRL_VALUE_WHITE            0x01
#define DIA_UDS_DIAPLAY_CTRL_VALUE_BLACK            0x02

#define DIA_DISPLAY_TEST_CTRL_VALUE_SIZE            0x01
#define DIA_DISPLAY_TEST_PATTERN_POS                0x00

//------------------------------------------------------------------------------

dia_IOCtrlDisplayTest::dia_IOCtrlDisplayTest ( void )
: dia_IOCtrlSignal ( DIA_C_U16_DID_AIVI_DISPLAY_TEST,
#if 0
      //Signal Type already used by Bosch service
                     DIA_EN_IOCTRL_SIGTYPE_DISPLAY_TEST,
#else
                     DIA_EN_IOCTRL_SIGTYPE_DISPLAY_TEST_PATTERN,
#endif
                     DIA_DISPLAY_TEST_CTRL_VALUE_SIZE,
                     DIA_EN_IOCTRL_CTRLMODE_TESTER,
                     DIA_EN_IOCTRL_MONITORING_MODE_SHORT_TERM_ADJUSTMENT )
{
}

//------------------------------------------------------------------------------

dia_IOCtrlDisplayTest::~dia_IOCtrlDisplayTest ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlDisplayTest::~dia_IOCtrlDisplayTest !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlDisplayTest::handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlDisplayTest::handleRequest()");

   tDiaResult retVal = DIA_E_CONDITIONS_NOT_CORRECT;

   if ( ctrlValue->size() > DIA_DISPLAY_TEST_PATTERN_POS )
   {
      dia_eDisplayPatternAIVIID ePatternID = getDisplayPatternID (ctrlValue->at(DIA_DISPLAY_TEST_PATTERN_POS));

      if ( ePatternID == DIA_EN_DISPLAY_PATTERN_AIVI_NONE )
      {
         DIA_TR_ERR(" ---  The control value is not supported!!!!");
         retVal = DIA_E_OUT_OF_RANGE;
      }
	  else
	  {
         if ( DIA_SUCCESS != setScreen(ePatternID) )
         {
            DIA_TR_ERR(" ---  SEND TO HMI FAILED!!!!");
         }
		 else
		 {
            // now initialize the counter for the timer
            vSetTimer(timerValue);
            mIsResultReady = FALSE;

            retVal = DIA_SUCCESS;
		 }
	  }
   }
   else
   {
      DIA_TR_ERR(" ---  The control value is not set!!!!");
   }

   if (retVal != DIA_SUCCESS)
   {
      (void) unsetSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
   }

   // NO_ERROR allows the service handler to return immediately
   return retVal;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlDisplayTest::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlDisplayTest::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( (status == DIA_EN_IOCTRL_STATUS_INACTIVE) || (status == DIA_EN_IOCTRL_STATUS_INACTIVE_TIMEOUT))
      {
         // wait for the response
         mIsResultReady = FALSE;
         status = DIA_EN_IOCTRL_STATUS_INACTIVE;
      }

      // Set to normal HMI screen
      if ( DIA_SUCCESS != setScreen(DIA_EN_DISPLAY_PATTERN_AIVI_NONE) )
      {
         DIA_TR_INF("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SET : TEST SCREEN !!!");
      }
      else
      {
#if 1 //Workaround for no response from HMI
            mIsResultReady = TRUE;
         #ifndef __DIA_UNIT_TESTING__
            dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
         #endif
#endif
      }
   }

   // this ioctrl is controlled by the external tester
   eSetMode(DIA_EN_IOCTRL_CTRLMODE_ECU);

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlDisplayTest::vOnSetDisplayTestPatternDone (  tDiaResult /*res*/ )
{
   dia_tclFnctTrace trc("dia_IOCtrlDisplayTest::vOnSetDisplayTestPatternDone");

	(void) unsetSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
   mIsResultReady = TRUE;
#ifndef __DIA_UNIT_TESTING__
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
#endif
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlDisplayTest::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlDisplayTest::handleTimeout");

	(void) unsetSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
}

//------------------------------------------------------------------------------

tDiaResult 
dia_IOCtrlDisplayTest::setScreen(dia_eDisplayPatternAIVIID eScreen)
{
   dia_tclFnctTrace trc("dia_IOCtrlDisplayTest::setScreen");
   tDiaResult ret = DIA_FAILED;
   dia_IDisplayPatternAIVI* pInterface = 0;

   if ( querySysAdapterInterface<dia_IDisplayPatternAIVI>(&pInterface) == DIA_SUCCESS )
   {
      if ( pInterface )
      {
         (void) setSysAdapterListener<dia_IDisplayPatternAIVIListener>(this);
         ret = pInterface->setDisplayPatternID(eScreen);
      }
   }
   
   return ret;
}

//------------------------------------------------------------------------------

dia_eDisplayPatternAIVIID
dia_IOCtrlDisplayTest::getDisplayPatternID ( tU8 u8CtrlValue )
{
   dia_eDisplayPatternAIVIID ePattern = DIA_EN_DISPLAY_PATTERN_AIVI_NONE;

   switch (u8CtrlValue)
   {
   case DIA_UDS_DIAPLAY_CTRL_VALUE_WHITE:
      ePattern = DIA_EN_DISPLAY_PATTERN_AIVI_WHITE;
	  break;

   case DIA_UDS_DIAPLAY_CTRL_VALUE_BLACK:
      ePattern = DIA_EN_DISPLAY_PATTERN_AIVI_BLACK;
	  break;

   default:
	   break;
   }

   return ePattern;
}
