/*
 * dia_GenericConfigItemVarLengthRead.cpp
 *
 *  Created on: 14.09.2015
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_CRC_CALCULATOR__
#include "common/framework/utils/dia_CRCCalculator.h"
#endif

#include "dia_GenericConfigItemVarLengthRead.h"

#define DATA_START      3
#define CHUNK_SIZE      230

//------------------------------------------------------------------------------

dia_GenericConfigItemVarLengthRead::dia_GenericConfigItemVarLengthRead ( tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS(name, sid, did)
{
#ifdef __DIA_UNIT_TESTING__
    dia_tclFnctTrace oTrace("dia_GenericConfigItemVarLengthRead::dia_GenericConfigItemVarLengthRead(name, sid, did)");
#endif
}

//------------------------------------------------------------------------------

dia_GenericConfigItemVarLengthRead::~dia_GenericConfigItemVarLengthRead ( void )
{
}

//-----------------------------------------------------------------------------

void
dia_GenericConfigItemVarLengthRead::vProcessRequest ( const std::vector<void*>& vecArgs )
{
   dia_tclFnctTrace trc("dia_GenericConfigItemVarLengthRead::vProcessRequest");

   if (vecArgs.size() < 1)
   {
      DIA_TR_ERR("dia_GenericConfigItemVarLengthRead::vProcessRequest => no vecArgs");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      return;
   }

   std::vector<tU8> chunkBuffer;
   tU32 u32PropId = (tU32) vecArgs[0];

   dia_PropertyInfo* pPropInfo = NULL;
   dia_ConfigManager* pConfigManager = getInstanceOfConfigManager();
   if (pConfigManager &&
         (NULL != (pPropInfo = pConfigManager->getPropertyInfo(u32PropId))) &&
         (u32PropId == pPropInfo->mPropKey))
   {
      if (pConfigManager->getProperty(pPropInfo->mPropKey, chunkBuffer) == DIA_SUCCESS)
      {
         DIA_TR_INF("dia_GenericConfigItemVarLengthRead::vProcessRequest => ConfigItem (0x%x) size=%d/%d",
               pPropInfo->mPropKey, chunkBuffer.size(), pPropInfo->mPropSize);
      }
      else
      {
         DIA_TR_ERR("dia_GenericConfigItemVarLengthRead::vProcessRequest => Failed to read (0x%x)!!!", pPropInfo->mPropKey);
         vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
         return;
      }
   }
   else
   {
      DIA_TR_ERR("dia_GenericConfigItemVarLengthRead::vProcessRequest invalid ConfigItem (0x%x)", u32PropId);
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      return;
   }

   // extract the data from the received message
   tU16 chunk = oDiagMsgBuffer().u16GetSubServiceId();
   DIA_TR_INF("dia_GenericConfigItemVarLengthRead:: chunk = (0x%04x)", chunk);
   chunk -= mDID;
   DIA_TR_INF("dia_GenericConfigItemVarLengthRead:: chunk = (0x%04x), mDID = (0x%04x)", chunk, mDID);   

   tU32 chunkOffset = 0;
   tU32 dataLength = 0;
   if (chunk == 0)
   {
      dataLength = chunkBuffer.size();
      if (dataLength > (4095 - DATA_START))
      {
         // Limit the payload to the max. size of an ISO-TP response
         dataLength = (4095 - DATA_START);
      }
   }
   else
   {
      chunkOffset = (chunk - 1) * CHUNK_SIZE;

      if (chunkOffset > chunkBuffer.size())
      {
         DIA_TR_ERR("dia_GenericConfigItemVarLengthRead::vProcessRequest invalid chunkOffset %d>%d", chunkOffset, chunkBuffer.size());
         vSendNegativeResponse(DIA_E_U8_UDS_OUT_OF_RANGE);
         return;
      }

      dataLength = chunkBuffer.size() - chunkOffset;
      if (dataLength > CHUNK_SIZE)
      {
         dataLength = CHUNK_SIZE;
      }
   }

   DIA_TR_INF("dia_GenericConfigItemVarLengthRead::vProcessRequest ChunkNo=%d", chunk);
   DIA_TR_INF("dia_GenericConfigItemVarLengthRead::vProcessRequest chunkOffset=%d", chunkOffset);
   DIA_TR_INF("dia_GenericConfigItemVarLengthRead::vProcessRequest dataLength=%d", dataLength);

   // copy data to the response
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength((tU16)(DATA_START + dataLength));
   for ( tU32 i = 0; i < dataLength; i++)
   {
      (void) oDiagMsgBuffer().vSetDataU8((tU16)(DATA_START + i), chunkBuffer[chunkOffset + i]);
   }
   vResReadyAndQuit();
}

//------------------------------------------------------------------------------
const std::map<const tU16, const tU16> dia_GenericConfigItemVarLengthRead::_Conflict_DID_to_PrjSpecific_DID_Map = 
{
//  { Conflicting DID, Project Specific Map DID }
	{ DIA_C_U16_DID_CENTER_CMC_19_CONFLICT_VICTIM_D010, DIA_C_U16_DID_CENTER_CMC_19_CONFLICT_MAP_D010},
	{ DIA_C_U16_DID_CENTER_CMC_19_CONFLICT_VICTIM_D002, DIA_C_U16_DID_CENTER_CMC_19_CONFLICT_MAP_D002}
};
//------------------------------------------------------------------------------

tDiaResult
dia_GenericConfigItemVarLengthRead::makeLookupKeys ( std::vector<dia_LookupKey*>& keys )
{
   dia_tclFnctTrace trc("dia_GenericConfigItemVarLengthRead::makeLookupKeys");

#if 0 //Full 20K
   for (tU8 u8SubDID = 0; u8SubDID < 93; u8SubDID++)
#else //Only 4K
   for (tU8 u8SubDID = 0; u8SubDID < 19; u8SubDID++)
#endif
   {
	  auto it = _Conflict_DID_to_PrjSpecific_DID_Map.find((mDID | u8SubDID));
	
	  if(it != _Conflict_DID_to_PrjSpecific_DID_Map.end())
	  {
	  	keys.push_back( OSAL_NEW dia_LookupKey( mSID, (tU16)it->second, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) );
	  }
	  else
	  {
		keys.push_back( OSAL_NEW dia_LookupKey( mSID, (tU16)(mDID | u8SubDID), DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) );
	  }
      //keys.push_back( OSAL_NEW dia_LookupKey( mSID, (tU16)(mDID | u8SubDID), DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) );
   }

   return DIA_SUCCESS;
}

