/*
 * \file        dia_EcuResetHardResetPrj.cpp
 *
 * \brief       {insert brief description here}
 *
 * \details     {insert file description here}
 *
 * \author      kaa1hi
 * \date        Apr 22, 2015
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include "common/framework/engine/dia_EngineManager.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include "common/framework/engine/dia_EngineServer.h"
#endif

#ifndef __INCLUDED_DIA_SESSION_CONTROLLER__
#include "common/framework/application/dia_SessionController.h"
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include "common/framework/engine/dia_Session.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif


#include "dia_EcuResetHardResetPrj.h"

//------------------------------------------------------------------------------

dia_EcuResetHardResetPrj::dia_EcuResetHardResetPrj ( tCString name, dia_ResetType resetType )
   : dia_EcuResetHardReset ( name, resetType )
{
   dia_tclFnctTrace oTrace("dia_EcuResetHardResetPrj::dia_EcuResetHardResetPrj()");
}

//------------------------------------------------------------------------------

dia_EcuResetHardResetPrj::~dia_EcuResetHardResetPrj ( void )
{
}

//------------------------------------------------------------------------------

tDiaResetResponse
dia_EcuResetHardResetPrj::handleRequest ( void )
{
   dia_tclFnctTrace oTrace("dia_EcuResetHardResetPrj::handleRequest()");

   dia_EngineServer* pEngine = 0;
   if (( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS ) && pEngine )
   {
      tU8 u8Session = pEngine->getSessionController()->getActiveSession()->getID();

      DIA_TR_INF("ECUReset during Session = %d", u8Session);

      if (u8Session == DIA_C_U8_UDS_SESSION_PROGRAMMING)
      {
         tDiaResult diaResult = DIA_FAILED;

         //Perform flush for all bags.
         dia_ConfigManager* pConfigMgr = getInstanceOfConfigManager();
         if ( pConfigMgr )
         {
            DIA_TR_INF("dia_EcuResetHardResetPrj::handleRequest - Flush for all bags");
            diaResult = pConfigMgr->forceFlush();
         }

         if (DIA_SUCCESS!=diaResult)
         {
            DIA_TR_ERR("dia_EcuResetHardResetPrj::handleRequest - Flush FAILED with 0x%x.", diaResult);
            DIA_ASSERT_ALWAYS();
         }
      }
   }

   return dia_EcuResetHardReset::handleRequest();
}

//------------------------------------------------------------------------------

