/**
 * \file      dia_WlanInfo.h
 *
 * \brief     Utility class for getting the Wlan related information (e.g. connection speed, frequency, etc..)
 *
 *
 *  Created on: Mar 10, 2016
 *      Author: jas1hi
 *
 * \copyright Robert Bosch Car Multimedia 2016
 */


#ifndef DIA_WLANINFO_H_
#define DIA_WLANINFO_H_

#include <net/if.h>

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#define MAX_ESSID_STR_LENGTH (tU16) 15
#define MAX_WIFI_STANDARD_STR_LENGTH (tU16) 5


typedef struct WiFiInfoElement_ {
	// Interface device
	tChar iface[IFNAMSIZ]; // e.g. wlan0

	// ESSID
	tChar essId[MAX_ESSID_STR_LENGTH];
	tBool essIdAvailable;

	tBool connected; // only in Managed mode?

	// Connection frequency
	tU16 frequency; // e.g. 2412 Hz
	// Connection speed
	tU16 bitRate; // e.g. 54 MBit/s
	// WiFi standard
//	tChar standard[MAX_WIFI_STANDARD_STR_LENGTH]; // e.g. ac

	WiFiInfoElement_()
	{
		memset(iface, '\0', sizeof(tChar)*IFNAMSIZ);
		memset(essId, '\0', sizeof(tChar)*MAX_ESSID_STR_LENGTH);
		essIdAvailable = FALSE;
		connected = FALSE;
		frequency = 0;
		bitRate = 0;
//		memset(standard, '\0', sizeof(tChar)*MAX_WIFI_STANDARD_STR_LENGTH);
	}

} WiFiInfoElement;


class dia_WlanInfo {
public:
	dia_WlanInfo();
	virtual ~dia_WlanInfo();

	virtual tDiaResult initNlSocket();
	virtual tDiaResult updateWiFiInfo();

	virtual tBool isNlInitialized() {return m_nlSocketInitialized;}
	virtual tBool isWlanInfoAvailable() {return m_wlanInfoAvailable;}

	virtual WiFiInfoElement getWiFiInfoElement();

private:
	virtual tDiaResult getInterfaceInfo();
	virtual tDiaResult getStationInfo(tCString ifname, tU8 ifIndex); // e.g. ifname="wlan0"
	virtual tDiaResult getScanInfo(tCString ifname, tU8 ifIndex);

	tBool m_nlSocketInitialized;
	tBool m_wlanInfoAvailable;
};

#endif /* DIA_WLANINFO_H_ */
