/*
 * dia_WifiPowerChange.cpp
 *
 *  Created on: Nov 28, 2016
 *      Author: jas1hi
 *--------------------------------------------------------------------------------------------------------------------
  * 16.03.2017		| 1.2	| NLK1KOR (RBEI)	| Implemented AIVI-47067  calibration operation status

 *--------------------------------------------------------------------------------------------------------------------
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_WifiPowerChange.h"

#ifndef __INCLUDED_DIA_DEFS_CONFIG_DEBUGTRACE_PROJECT__
#include "project/services/customer/MonitoringCalibration/config/dia_defsDebugTraceConfig.h"
#endif

dia_WifiPowerChange::dia_WifiPowerChange()
:	m_pWifiMost(OSAL_NULL),
 	m_WifiPowerStatus(0)//coverity fix:87123:Non-static class member m_WifiPowerStatus is initialized in this constructor
{

}

dia_WifiPowerChange::~dia_WifiPowerChange()
{
	_BP_TRY_BEGIN
	{
	  (void) unsetSysAdapterListener<dia_IWifiMostListener>(this);
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_WifiPowerChange::~dia_WifiPowerChange !!!");
	  DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END

	if (m_pWifiMost)
		m_pWifiMost = OSAL_NULL;
}

tDiaResult dia_WifiPowerChange::changeWifiTransmitPower(tU8 wifiPowerAttenuation)
{
	m_WifiPowerStatus = 0;
	// Make subscription for the first time
	if (m_pWifiMost == OSAL_NULL) {
		if ((querySysAdapterInterface<dia_IWifiMost>(&m_pWifiMost) != DIA_SUCCESS))
		{
			DIA_TR_ERR("dia_WifiPowerChange::changeWifiTransmitPower. Querying a SystemAdapterd failed...");
			 m_WifiPowerStatus = DIA_ERR_REQUEST_SEND;
			(void) setSysAdapterListener<dia_IWifiMostListener>(this); // Activate the subscription
			return DIA_FAILED;
		}
	}

	if (m_pWifiMost) {
	  if (wifiPowerAttenuation <= 10) // Check the requested range: coverity:65998 fix:unsigned int is always >=0 so no need to check.
	  {
		  DIA_TR_INF("dia_WifiPowerChange::changeWifiTransmitPower. New attenuation value: '%d' [dB]", wifiPowerAttenuation);
		  if (DIA_SUCCESS != (m_pWifiMost->vChangeWifiTransmitPower(wifiPowerAttenuation)))
		  {
			m_WifiPowerStatus = DIA_ERR_REQUEST_SEND;
			DIA_TR_ERR("dia_WifiPowerChange::changeWifiTransmitPower - FAILED!!!!");
			return DIA_FAILED;
		  }
		  else
		  {
			DIA_TR_INF("dia_WifiPowerChange::changeWifiTransmitPower. Sent request...");
		  }
	   }
	   else {
		   m_WifiPowerStatus = DIA_ERR_INVALID_REQUEST;
		   DIA_TR_ERR("dia_WifiPowerChange::changeWifiTransmitPower. Unsupported range '%d' [dB]", wifiPowerAttenuation);
		   return DIA_FAILED;
	   }
	}

	return DIA_SUCCESS;
}

void dia_WifiPowerChange::vOnChangeWifiTransmitPower (tDiaResult eDiaResult)
{
	switch (eDiaResult)
	{
		case DIA_SUCCESS:
		{
			DIA_TR_INF("dia_WifiPowerChange::vOnChangeWifiTransmitPower - SUCCESS");
			break;
		}
		case DIA_FAILED:
		{
			m_WifiPowerStatus = DIA_ERR_RESPONSE_RECEIVE;
			DIA_TR_ERR("dia_WifiPowerChange::vOnChangeWifiTransmitPower - FAILED");
			break;
		}
		default:
			break;
	}
}

void dia_WifiPowerChange::vOnChangeWifiTransmitPowerError (const tU8 errCode)
{
	m_WifiPowerStatus = DIA_ERR_RESPONSE_RECEIVE;
	DIA_TR_ERR("dia_WifiPowerChange::vOnChangeWifiTransmitPowerError. Error code: '%d'", errCode);
}
tU8 dia_WifiPowerChange::getWifiPowerstatus()
{
	DIA_TR_INF("dia_WifiPowerChange::getWifiPowerstatus");
	DIA_TR_INF("dia_WifiPowerChange::m_WifiPowerStatus = %d",m_WifiPowerStatus );
	return m_WifiPowerStatus;
}