/*
 * dia_VersionInfo.cpp
 *
 *  Created on: Feb 28, 2017
 *      Author: jas1hi
 */

#include <fstream>

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_VersionInfo.h"

#ifndef DEBUGFSUSBDEVICESFILE
#define DEBUGFSUSBDEVICESFILE "/sys/kernel/debug/usb/devices"
#endif



dia_VersionInfo::dia_VersionInfo()
:	mTCUVersionInfoSubscriptionDone(FALSE),
    mTCUVersionInfoAvailable(FALSE),
    mUSBHubInfoAvailable(FALSE)
{

}

dia_VersionInfo::~dia_VersionInfo()
{
	_BP_TRY_BEGIN
	{
	  (void) unsetSysAdapterListener<dia_ITCUListener>(this);
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_VersionInfo::~dia_VersionInfo !!!");
	  DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END
}

tDiaResult dia_VersionInfo::subscribeForTCUVersionInfo()
{
	if (mTCUVersionInfoSubscriptionDone == FALSE) {
		dia_ITCU* pTCUInfo;
		if (querySysAdapterInterface<dia_ITCU>(&pTCUInfo) == DIA_SUCCESS) {
			 if (pTCUInfo) {
				 (tVoid) setSysAdapterListener<dia_ITCUListener>(this);

				 // Request Software Version
				 if (pTCUInfo->registerForSoftwareVersion() == DIA_SUCCESS) {
					 DIA_TR_INF("dia_VersionInfo::subscribeForTCUVersionInfo registerForSoftwareVersion OK!");
					 if (pTCUInfo->getSoftwareVersion() == DIA_SUCCESS) { // One time request to get the actual value
						 DIA_TR_INF("dia_VersionInfo::subscribeForTCUVersionInfo getSoftwareVersion OK!");
					 }
					 else {
						DIA_TR_ERR("dia_VersionInfo::subscribeForTCUVersionInfo getSoftwareVersion with ERRORS!");
						(tVoid) unsetSysAdapterListener<dia_ITCUListener>(this);
						return DIA_FAILED;
					 }
				 } else {
					DIA_TR_ERR("dia_VersionInfo::subscribeForTCUVersionInfo registerForSoftwareVersion with ERRORS!");
					(tVoid) unsetSysAdapterListener<dia_ITCUListener>(this);
					return DIA_FAILED;
				 }

				 // Request Hardware Version
				 if (pTCUInfo->registerForHardwareVersion() == DIA_SUCCESS) {
					 DIA_TR_INF("dia_VersionInfo::subscribeForTCUVersionInfo registerForHardwareVersion OK!");
					 if (pTCUInfo->getHardwareVersion() == DIA_SUCCESS) { // One time request to get the actual value
						 DIA_TR_INF("dia_VersionInfo::subscribeForTCUVersionInfo getHardwareVersion OK!");
					 }
					 else {
						DIA_TR_ERR("dia_VersionInfo::subscribeForTCUVersionInfo getHardwareVersion with ERRORS!");
						(tVoid) unsetSysAdapterListener<dia_ITCUListener>(this);
						return DIA_FAILED;
					 }
				 } else {
					DIA_TR_ERR("dia_VersionInfo::subscribeForTCUVersionInfo registerForHardwareVersion with ERRORS!");
					(tVoid) unsetSysAdapterListener<dia_ITCUListener>(this);
					return DIA_FAILED;
				 }

				 mTCUVersionInfoSubscriptionDone = TRUE;
			}
		}
		else {
			DIA_TR_ERR("dia_VersionInfo::subscribeForTCUVersionInfo querySysAdapterInterface<dia_ITCU> ERROR!");
		}
	}

	return DIA_SUCCESS;
}

void dia_VersionInfo::vOnSoftwareVersion(const dia_TCUVersionInfo& tcuSwVersionInfo)
{
	DIA_TR_INF("dia_VersionInfo::vOnTCUSoftwareVersion - upper: %d, mid: %d, lower: %d", tcuSwVersionInfo.m_Upper, tcuSwVersionInfo.m_Mid, tcuSwVersionInfo.m_Lower);

	mTCUVersionInfo.tcuSoftwareVersion.m_Upper = tcuSwVersionInfo.m_Upper;
	mTCUVersionInfo.tcuSoftwareVersion.m_Mid   = tcuSwVersionInfo.m_Mid;
	mTCUVersionInfo.tcuSoftwareVersion.m_Lower = tcuSwVersionInfo.m_Lower;

	mTCUVersionInfoAvailable = TRUE;
}

void dia_VersionInfo::vOnHardwareVersion(const dia_TCUVersionInfo& tcuHwVersionInfo)
{
	DIA_TR_INF("dia_VersionInfo::vOnTCUHardwareVersion - upper: %d, mid: %d, lower: %d", tcuHwVersionInfo.m_Upper, tcuHwVersionInfo.m_Mid, tcuHwVersionInfo.m_Lower);

	mTCUVersionInfo.tcuHardwareVersion.m_Upper = tcuHwVersionInfo.m_Upper;
	mTCUVersionInfo.tcuHardwareVersion.m_Mid   = tcuHwVersionInfo.m_Mid;
	mTCUVersionInfo.tcuHardwareVersion.m_Lower = tcuHwVersionInfo.m_Lower;

	mTCUVersionInfoAvailable = TRUE;
}

TCUVersionInfo dia_VersionInfo::getTCUVersionInfo()
{
	DIA_TR_INF("dia_VersionInfo::getTCUVersionInfo");

	if (mTCUVersionInfoAvailable) {
		mTCUVersionInfoAvailable = FALSE; // Avoid subsequent calls to this function
	}

	return mTCUVersionInfo;
}

tDiaResult dia_VersionInfo::readUSBInfo()
{
// Example format of the file (the very first line is a new line char)
//
//	T:  Bus=02 Lev=00 Prnt=00 Port=00 Cnt=00 Dev#=  1 Spd=480  MxCh= 1
//	B:  Alloc=  0/800 us ( 0%), #Int=  0, #Iso=  0
//	D:  Ver= 2.00 Cls=09(hub  ) Sub=00 Prot=01 MxPS=64 #Cfgs=  1
//	P:  Vendor=1d6b ProdID=0002 Rev= 3.14
//	S:  Manufacturer=Linux 3.14.79-05240-g3a16cc7 ehci_hcd
//	S:  Product=EHCI Host Controller
//	S:  SerialNumber=ci_hdrc.1
//	C:* #Ifs= 1 Cfg#= 1 Atr=e0 MxPwr=  0mA
//	I:* If#= 0 Alt= 0 #EPs= 1 Cls=09(hub  ) Sub=00 Prot=00 Driver=hub
//	E:  Ad=81(I) Atr=03(Int.) MxPS=   4 Ivl=256ms
//
//	T:  Bus=01 Lev=00 Prnt=00 Port=00 Cnt=00 Dev#=  1 Spd=480  MxCh= 1
//	B:  Alloc=  0/800 us ( 0%), #Int=  0, #Iso=  0
//	D:  Ver= 2.00 Cls=09(hub  ) Sub=00 Prot=01 MxPS=64 #Cfgs=  1
//	P:  Vendor=1d6b ProdID=0002 Rev= 3.14
//	S:  Manufacturer=Linux 3.14.79-05240-g3a16cc7 ehci_hcd
//	S:  Product=EHCI Host Controller
//	S:  SerialNumber=ci_hdrc.0
//	C:* #Ifs= 1 Cfg#= 1 Atr=e0 MxPwr=  0mA
//	I:* If#= 0 Alt= 0 #EPs= 1 Cls=09(hub  ) Sub=00 Prot=00 Driver=hub
//	E:  Ad=81(I) Atr=03(Int.) MxPS=   4 Ivl=256ms

	DIA_TR_INF("dia_VersionInfo::readUSBInfo");

	std::ifstream infile(DEBUGFSUSBDEVICESFILE);
	if (!infile.is_open()) {
		DIA_TR_ERR("dia_VersionInfo::readUSBHubInfo: Failed to open file %s", DEBUGFSUSBDEVICESFILE);
		return DIA_FAILED;
	}

	USBVersionInfoElement usbVersionInfoElement;
	std::string usbDevicesLineStr;
	while (std::getline(infile, usbDevicesLineStr)) {
		switch (usbDevicesLineStr[0]) {
			case 'T': //  Topology (etc.)
				usbVersionInfoElement.lineT.append(usbDevicesLineStr.c_str(), usbDevicesLineStr.size());
			 break;
			case 'B': // Bandwidth (applies only to USB host controllers, which are virtualized as root hubs)
				usbVersionInfoElement.isHostcontroller = TRUE;
				mUSBHubInfoAvailable = TRUE;
			 break;
			case 'D':// Device descriptor info
				usbVersionInfoElement.lineD.append(usbDevicesLineStr.c_str(), usbDevicesLineStr.size());
			 break;
			case 'P': // Product ID info.
				usbVersionInfoElement.lineP.append(usbDevicesLineStr.c_str(), usbDevicesLineStr.size());
			 break;
//			case '\n': // Line starts with empty char
//				mUSBVersionInfoList.push_back(usbVersionInfoElement);
//
//				// Clear previous element entries
//				usbVersionInfoElement.isHostcontroller = FALSE;
//				usbVersionInfoElement.lineT.clear();
//				usbVersionInfoElement.lineD.clear();
//				usbVersionInfoElement.lineP.clear();
//			 break;
			default:
				if (!usbVersionInfoElement.lineT.empty() && !usbVersionInfoElement.lineD.empty() && !usbVersionInfoElement.lineP.empty()) {
					mUSBVersionInfoList.push_back(usbVersionInfoElement);

					// Clear previous element entries
					usbVersionInfoElement.isHostcontroller = FALSE;
					usbVersionInfoElement.lineT.clear();
					usbVersionInfoElement.lineD.clear();
					usbVersionInfoElement.lineP.clear();
				}
				break;
		}

		DIA_TR_INF("dia_VersionInfo::readUSBInfo. '%s'", usbDevicesLineStr.c_str());
   }

   return DIA_SUCCESS;
}

std::vector<USBVersionInfoElement> dia_VersionInfo::getUSBHubInfo()
{
	DIA_TR_INF("dia_VersionInfo::getUSBHubInfo");

	std::vector<USBVersionInfoElement> usbHubInfoElements;

	for (tU8 i=0; i<mUSBVersionInfoList.size(); i++) {
		if (mUSBVersionInfoList[i].isHostcontroller) {
			usbHubInfoElements.push_back(mUSBVersionInfoList[i]);
		}
	}

	if (mUSBHubInfoAvailable){
		mUSBHubInfoAvailable = FALSE;
	}

	return usbHubInfoElements;
}
