/**
 * \file      dia_VehicleSignalsInfo.h
 *
 * \brief     Utility class for getting different vehicle signals (e.g. RVC On/Off, Parking Brake On/Off, Reverse Gear On / Off, etc..)
 *
 *
 *  Created on: Jan 6, 2016
 *      Author: jas1hi
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */

#ifndef DIA_VEHICLESIGNALSINFO_H_
#define DIA_VEHICLESIGNALSINFO_H_


#ifndef __INCLUDED_DIA_INTERFACE_PARKINGBRAKE_LISTENER__
#include "common/interfaces/dia_IParkingBrakeListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_REVERSEGEAR_LISTENER__
#include "common/interfaces/dia_IReverseGearListener.h"
#endif


class dia_VehicleSignalsInfo:      public dia_IParkingBrakeListenerImpl, public dia_IReverseGearListenerImpl
{
public:
	dia_VehicleSignalsInfo();
	virtual ~dia_VehicleSignalsInfo();

	/**
	 * \brief    	subscribe for Vehicle Data
	 *
	 *				Function subscribes to different SystemAdapters.
	 *				The SystemAdapters return the actual values
	 */
    tDiaResult subscribeForVehicleData();

    //! response to getParkingBrakeStatus
    virtual void vOnParkingBrakeStatus ( dia_eParkingBrakeState status );
    //! response to getReverseGearStatus
    virtual void vOnReverseGearStatus ( dia_eReverseGearStatus status );

    virtual tBool isVehicleDataAvailable() {return m_vehicleDataAvailable;}
    virtual tBool isVehicleDataSubscriptionDone() {return m_vehicleDataSubscriptionDone;}
    //! returns bitcoded vehicle data (e.g. parking brake state)
    virtual tU8 getVehicleData();

private:
    dia_eParkingBrakeState m_ParkingBrakeSate;
    dia_eReverseGearStatus m_ReverseGearState;

    tBool m_vehicleDataAvailable;
    tBool m_vehicleDataSubscriptionDone;
};

#endif /* DIA_VEHICLESIGNALSINFO_H_ */
