/**
 * \file      dia_StartupStatusInfo.h
 *
 * \brief     Utility class for getting the startup status of processes from SPM
 *
 *
 *  Created on: Jan 26, 2016
 *      Author: jas1hi
 *
 * \copyright Robert Bosch Car Multimedia 2016
 */


#ifndef DIA_STARTUPSTATUSINFO_H_
#define DIA_STARTUPSTATUSINFO_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif

#define  PROCESS_STATE_TOSTART  (tU8) 0
#define  PROCESS_STATE_RUNNING  (tU8) 1

#define MAX_DATE_STR_LENGTH (tU16) 20

typedef struct ProcessElement_ {
	 tU8 processID; //	 The name of the process (delivered through SPM) is mapped to predefined processID
	 tU8  state;
	 tU32 startTimeSinceStart;

	 //	 2015-12-31 00:00:01
//	 tChar switchOnDateStr[MAX_DATE_STR_LENGTH];

	 ProcessElement_()
	 : processID(0),
	   state(0),
	   startTimeSinceStart(0)
	{
//		memset(switchOnDateStr, '\0', sizeof(tChar)*MAX_DATE_STR_LENGTH);
	}

} ProcessElement;

typedef struct WakeupHistoryElement_ {
	 // Reason
	 tU8 reason;

	 //	 2017-12-31 00:00:01
	 tChar dateStr[MAX_DATE_STR_LENGTH];

	 WakeupHistoryElement_()
	 {
		reason = 0;
		memset(dateStr, '\0', sizeof(tChar)*MAX_DATE_STR_LENGTH);
	 }

} WakeupHistoryElement;

class dia_StartupStatusInfo: public dia_ISpmListenerImpl
{
public:
	dia_StartupStatusInfo();
	virtual ~dia_StartupStatusInfo();

   /**
	 * \brief    	subscribe to SPM_ProcessInfo
	 *
	 *				Function subscribes to the SystemAdapter of SPM.
	 *				The SystemAdapter returns the startup status (process based)
	 */
   virtual tDiaResult subscribeToSPMForStartupStatus();

   /**
	 * \brief    	subscribe to WakeUpHistory
	 *
	 *				Function subscribes to the SystemAdapter of SPM.
	 *				The SystemAdapter returns the latest wakeup history with time / date
	 */
   virtual tDiaResult subscribeToSPMForWakeupHistory();

   /**
	 * \brief    	Startup status (process based)
	 *
	 *				Function receives the message via its parameter
	 *				It verifies the SA answer and sets the flag that indicates the readiness of result
	 *
	 * \param[in]	const std::vector<dia_tSpmStartupStatus>* startupStatus
   */
   virtual tVoid vOnStartupStatus (const std::vector<dia_tSpmStartupStatus>* startupStatus);

   /**
 	 * \brief    	Wakeup history
 	 *
   */
   virtual tVoid vOnGetWakeUpHistory(const std::vector<tU8>* wakeupElements);

   virtual tBool isStartupStatusAvailable() {return m_startupStatusAvailable;}
   virtual tBool isStartupStatusSubscriptionDone() {return m_startupStatusSubscriptionDone;}
   virtual tBool isWakeupStatusAvailable() {return m_wakeupStatusAvailable;}
   virtual tBool isWakeupStatusSubscriptionDone() {return m_wakeupStatusSubscriptionDone;}

   virtual std::vector<ProcessElement> getStartupStatus(tU16 numberOfRequestedElements);
   virtual std::vector<WakeupHistoryElement> getWakeupStatus(tU16 numberOfRequestedElements);

private:
    tU8 getProcessID(const std::string& processName);

	std::vector<ProcessElement> mProcessElements; // list of all processes configured in start configuration of SPM
	tBool m_startupStatusAvailable;
    tBool m_startupStatusSubscriptionDone;
    tBool m_startupStatusUpdateFinished;

    std::vector<std::string> m_processList;
    std::vector<std::string>::iterator m_processNameListIteratorType;

    std::vector<WakeupHistoryElement> mWakeupHistoryElements; // list of latest Wakeup history elements
   	tBool m_wakeupStatusAvailable;
    tBool m_wakeupStatusSubscriptionDone;
};

#endif /* DIA_STARTUPSTATUSINFO_H_ */
