/*
 * dia_SdsGuiPopupInfo.cpp
 *
 *  Created on: Apr 19, 2016
 *      Author: jas1hi
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_SdsGuiPopupInfo.h"

#ifndef SDS_SCREENID_GLO_MAIN
#define SDS_SCREENID_GLO_MAIN "SR_GLO_Main"
#endif


dia_SdsGuiPopupInfo::dia_SdsGuiPopupInfo()
:	m_pSdsGuiPopup(OSAL_NULL),
 	m_sdsGuiPopupInfoSubscriptionDone(FALSE),
 	m_sdsSpeechStatusAvailable(FALSE),
 	m_sdsScreenIDStatusAvailable(FALSE),
	m_pSdsDiagnosisService(OSAL_NULL),
 	m_sdsDiagnosisServiceInfoSubscriptionDone(FALSE),
 	m_sdsDiagnosisServiceInfoAvailable(FALSE)
{
	 dia_tclFnctTrace trc("dia_SdsGuiPopupInfo::dia_SdsGuiPopupInfo()");
}

dia_SdsGuiPopupInfo::~dia_SdsGuiPopupInfo() {
	_BP_TRY_BEGIN
	{
	  (void) unsetSysAdapterListener<dia_ISdsGuiPopupListener>(this);
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_SdsGuiPopupInfo::~dia_SdsGuiPopupInfo !!!");
	  DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END

	if (m_pSdsGuiPopup)
		m_pSdsGuiPopup = OSAL_NULL;
	
	_BP_TRY_BEGIN
	{
	  (void) unsetSysAdapterListener<dia_ISdsDiagnosisServiceListener>(this);
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_SdsGuiPopupInfo::~dia_SdsGuiPopupInfo !!!");
	  DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END

	if (m_pSdsDiagnosisService)
		m_pSdsDiagnosisService = OSAL_NULL;
}

tDiaResult dia_SdsGuiPopupInfo::subscribeForSdsGuiPopupInfo()
{
	dia_tclFnctTrace trc("dia_SdsGuiPopupInfo::subscribeForSdsGuiPopupInfo");

	if (m_sdsGuiPopupInfoSubscriptionDone == FALSE)
	{
		DIA_TR_INF("dia_SdsGuiPopupInfo::subscribeForSdsGuiPopupInfo()");

		if (querySysAdapterInterface<dia_ISdsGuiPopup>(&m_pSdsGuiPopup) == DIA_SUCCESS) 
		{
			 if (m_pSdsGuiPopup) 
			 {
				 (tVoid) setSysAdapterListener<dia_ISdsGuiPopupListener>(this);

				 if (m_pSdsGuiPopup->registerToSdsScreenID() == DIA_SUCCESS) 
				 { // Register to get updates
					 DIA_TR_INF("dia_SdsGuiPopupInfo::subscribeForSdsGuiPopupInfo registerToSdsScreenID() OK!");
					 if (m_pSdsGuiPopup->getSdsScreenID() == DIA_SUCCESS) 
					 { // One time request to get the actual value
						 DIA_TR_INF("dia_SdsGuiPopupInfo::subscribeForSdsGuiPopupInfo getSdsScreenID() OK!");
					 } 
					 else 
					 {
						DIA_TR_ERR("dia_SdsGuiPopupInfo::subscribeForSdsGuiPopupInfo getSdsScreenID() with ERRORS!");
						(tVoid) unsetSysAdapterListener<dia_ISdsGuiPopupListener>(this);
						return DIA_FAILED;
					 }
				 } 
				 else 
				 {
					DIA_TR_ERR("dia_SdsGuiPopupInfo::subscribeForSdsGuiPopupInfo registerToSdsScreenID() with ERRORS!");
					(tVoid) unsetSysAdapterListener<dia_ISdsGuiPopupListener>(this);
					return DIA_FAILED;
				 }

				 if (m_pSdsGuiPopup->registerToSdsSpeechInputStatus() == DIA_SUCCESS)
					 { // Register to get updates
					 DIA_TR_INF("dia_SdsGuiPopupInfo::subscribeForSdsGuiPopupInfo registerToSdsSpeechInputStatus() OK!");
					 if (m_pSdsGuiPopup->getSdsSpeechInputStatus() == DIA_SUCCESS)
						 { // One time request to get the actual value
						 DIA_TR_INF("dia_SdsGuiPopupInfo::subscribeForSdsGuiPopupInfo getSdsSpeechInputStatus() OK!");
					 } 
					 else 
					 {
						DIA_TR_ERR("dia_SdsGuiPopupInfo::subscribeForSdsGuiPopupInfo getSdsSpeechInputStatus() with ERRORS!");
						(tVoid) unsetSysAdapterListener<dia_ISdsGuiPopupListener>(this);
						return DIA_FAILED;
					 }
				 } 
				 else 
				 {
					DIA_TR_ERR("dia_SdsGuiPopupInfo::subscribeForSdsGuiPopupInfo registerToSdsSpeechInputStatus() with ERRORS!");
					(tVoid) unsetSysAdapterListener<dia_ISdsGuiPopupListener>(this);
					return DIA_FAILED;
				 }


				 m_sdsGuiPopupInfoSubscriptionDone = TRUE;
			}
		}
		else {
			DIA_TR_ERR("dia_SdsGuiPopupInfo::subscribeForSdsGuiPopupInfo querySysAdapterInterface<dia_ISdsGuiPopupListener> ERROR!");
		}
	}

	return DIA_SUCCESS;
}

tVoid dia_SdsGuiPopupInfo::vOnSdsSpeechStatus(dia_eSpeechInputStatus sdsSpeechInputStatus)
{
//#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1
	m_sdsGuiPopupInfoElement.sdsSpeechInputStatus = (tU8) sdsSpeechInputStatus; // UNKNOWN
	m_sdsSpeechStatusAvailable = TRUE;
//#endif

	switch(sdsSpeechInputStatus)
	{
		case DIA_EN_SPEECH_INPUT_STATUS_IDLE:
			DIA_TR_INF("dia_SdsGuiPopupInfo::vOnSdsSpeechStatus. DIA_EN_SPEECH_INPUT_STATUS_IDLE");
			break;

		case DIA_EN_SPEECH_INPUT_STATUS_DIALOGOPEN:
			DIA_TR_INF("dia_SdsGuiPopupInfo::vOnSdsSpeechStatus. DIA_EN_SPEECH_INPUT_STATUS_DIALOGOPEN");
			break;

		case DIA_EN_SPEECH_INPUT_STATUS_LOADING:
			DIA_TR_INF("dia_SdsGuiPopupInfo::vOnSdsSpeechStatus. DIA_EN_SPEECH_INPUT_STATUS_LOADING");
			break;

		case DIA_EN_SPEECH_INPUT_STATUS_ERROR:
			DIA_TR_INF("dia_SdsGuiPopupInfo::vOnSdsSpeechStatus. DIA_EN_SPEECH_INPUT_STATUS_ERROR");
			break;

		case DIA_EN_SPEECH_INPUT_STATUS_LISTENING:
			DIA_TR_INF("dia_SdsGuiPopupInfo::vOnSdsSpeechStatus. DIA_EN_SPEECH_INPUT_STATUS_LISTENING");
			break;

		case DIA_EN_SPEECH_INPUT_STATUS_ACTIVE:
			DIA_TR_INF("dia_SdsGuiPopupInfo::vOnSdsSpeechStatus. DIA_EN_SPEECH_INPUT_STATUS_ACTIVE");
			break;

		case DIA_EN_SPEECH_INPUT_STATUS_PAUSE:
			DIA_TR_INF("dia_SdsGuiPopupInfo::vOnSdsSpeechStatus. DIA_EN_SPEECH_INPUT_STATUS_PAUSE");
			break;

		default:
			DIA_TR_INF("dia_SdsGuiPopupInfo::vOnSdsSpeechStatus. DIA_EN_SPEECH_INPUT_STATUS_UNKNOWN");
			break;
	}

}

tVoid dia_SdsGuiPopupInfo::vOnSdsScreenIDStatus (std::string sdsScreenID)
{
	DIA_TR_INF("dia_SdsGuiPopupInfo::vOnSdsScreenIDStatus. sdsScreenID: '%s'", sdsScreenID.c_str());

	if (sdsScreenID.size() > 0) {
		memcpy(m_sdsGuiPopupInfoElement.screenID, sdsScreenID.c_str(), sizeof(tChar)*MAX_SCREEN_ID_STR_LENGTH);
		m_sdsScreenIDStatusAvailable = TRUE;
	}
}

tBool dia_SdsGuiPopupInfo::isSdsGuiPopupInfoAvailable()
{
	tBool result = FALSE;
	if (m_sdsSpeechStatusAvailable || m_sdsScreenIDStatusAvailable) {
		result = TRUE;
	}

	if (m_sdsSpeechStatusAvailable) {
		// As soon as sdsSpeechInputStatus is not LISTENING && ACTIVE then SDS has finished and the sdsScreenID can be resetted
		if (m_sdsGuiPopupInfoElement.sdsSpeechInputStatus != DIA_EN_SPEECH_INPUT_STATUS_LISTENING && m_sdsGuiPopupInfoElement.sdsSpeechInputStatus != DIA_EN_SPEECH_INPUT_STATUS_ACTIVE) {
			memset(m_sdsGuiPopupInfoElement.screenID, '\0', sizeof(tChar)*MAX_SCREEN_ID_STR_LENGTH);
			m_sdsScreenIDStatusAvailable = TRUE;

			DIA_TR_INF("dia_SdsGuiPopupInfo::isSdsGuiPopupInfoAvailable. Resetting the sdsScreenID: '%s'", m_sdsGuiPopupInfoElement.screenID);
		}
		else if (m_sdsGuiPopupInfoElement.sdsSpeechInputStatus == DIA_EN_SPEECH_INPUT_STATUS_ACTIVE) {
			if (m_sdsGuiPopupInfoElement.screenID[0] == '\0'){ // Check if it was reseted
				memcpy(m_sdsGuiPopupInfoElement.screenID, SDS_SCREENID_GLO_MAIN, sizeof(SDS_SCREENID_GLO_MAIN)); // Set default name
			}

		}
	}

	return result;
}

SdsGuiPopupInfoElement dia_SdsGuiPopupInfo::getSdsGuiPopupInfoElement()
{
	if (m_sdsSpeechStatusAvailable || m_sdsScreenIDStatusAvailable) { // Deliver result even if one value is not available
		m_sdsSpeechStatusAvailable = FALSE;
		m_sdsScreenIDStatusAvailable = FALSE;
	}

	return m_sdsGuiPopupInfoElement;
}

/********************************************************************************************************************************************************************************************************************/
tDiaResult dia_SdsGuiPopupInfo::subscribeForSdsDiagnosisServiceInfo()
{
	dia_tclFnctTrace trc("dia_SdsGuiPopupInfo::subscribeForSdsDiagnosisServiceInfo");

	if (m_sdsDiagnosisServiceInfoSubscriptionDone == FALSE)
	{
		DIA_TR_INF("dia_SdsGuiPopupInfo::subscribeForSdsDiagnosisServiceInfo()");

		if (querySysAdapterInterface<dia_ISdsDiagnosisService>(&m_pSdsDiagnosisService) == DIA_SUCCESS) {
			 if (m_pSdsDiagnosisService) {
				 (tVoid) setSysAdapterListener<dia_ISdsDiagnosisServiceListener>(this);

				 if (m_pSdsDiagnosisService->registerToExtendedSDSLoggingDataUpdate() == DIA_SUCCESS) { // Register to get updates
					 DIA_TR_INF("dia_SdsGuiPopupInfo::subscribeForSdsDiagnosisServiceInfo registerToExtendedSDSLoggingDataUpdate() OK!");

				 } else {
					DIA_TR_ERR("dia_SdsGuiPopupInfo::subscribeForSdsDiagnosisServiceInfo registerToExtendedSDSLoggingDataUpdate() with ERRORS!");
					(tVoid) unsetSysAdapterListener<dia_ISdsDiagnosisServiceListener>(this);
					return DIA_FAILED;
				 }
				 m_sdsDiagnosisServiceInfoSubscriptionDone = TRUE;
			}
		}
		else {
			DIA_TR_ERR("dia_SdsGuiPopupInfo::subscribeForSdsDiagnosisServiceInfo querySysAdapterInterface<dia_ISdsDiagnosisServiceListener> ERROR!");
		}
	}

	return DIA_SUCCESS;
}
/*************************************************************************************************************************************************************************************/


tVoid dia_SdsGuiPopupInfo::vOnSdsDiagnosisServiceUpdate(dia_eExtendedSDSLoggingData extendedSDSLoggingData, tU16 sdsTimestamp)
{

	DIA_TR_INF("dia_SdsGuiPopupInfo::vOnSdsDiagnosisServiceUpdate. sdsTimestamp -> %d",sdsTimestamp);
	m_sdsDiagServiceInfoElement.sdsEventStatus = (tU8)extendedSDSLoggingData; 
	m_sdsDiagServiceInfoElement.sdsEventTimeStamp = (tU16)sdsTimestamp;
	m_sdsDiagnosisServiceInfoAvailable = TRUE;
	switch (extendedSDSLoggingData)
	{
	case DIA_EN_SDS_UNKNOWN:
		DIA_TR_INF("dia_SdsGuiPopupInfo::vOnSdsDiagnosisServiceUpdate. DIA_EN_SDS_UNKNOWN");
		break;

	case DIA_EN_SDS_BEGIN_OF_SPEECH:
		DIA_TR_INF("dia_SdsGuiPopupInfo::vOnSdsDiagnosisServiceUpdate. DIA_EN_BEGIN_OF_SPEECH");
		break;
	case DIA_EN_SDS_END_OF_SPEECH:
		DIA_TR_INF( "dia_SAFeatureSdsDiagnosisService::END_OF_SPEECH");
		break;

	case DIA_EN_SDS_CALLING_PP:
		DIA_TR_INF("dia_SdsGuiPopupInfo::vOnSdsDiagnosisServiceUpdate. DIA_EN_CALLING_PP");
		break;

	case DIA_EN_SDS_START_OF_PROMPT:
		DIA_TR_INF("dia_SdsGuiPopupInfo::vOnSdsDiagnosisServiceUpdate. DIA_EN_START_OF_PROMPT");
		break;

	case DIA_EN_SDS_END_OF_PROMPT:
		DIA_TR_INF("dia_SdsGuiPopupInfo::vOnSdsDiagnosisServiceUpdate. DIA_EN_END_OF_PROMPT");
		break;

	case DIA_EN_SDS_RECOGNIZER_RESULT:
		DIA_TR_INF("dia_SdsGuiPopupInfo::vOnSdsDiagnosisServiceUpdate. DIA_EN_RECOGNIZER_RESULT");
		break;

	default:
		DIA_TR_INF("dia_SdsGuiPopupInfo::vOnSdsDiagnosisServiceUpdate. DIA_EN_SDS_UNKNOWN");
		break;
	}


}

SdsDiagServiceInfoElement dia_SdsGuiPopupInfo::getSdsDiagServiceInfoElement()
{
	return m_sdsDiagServiceInfoElement;
}