/**
 * \file      dia_PowerStatusInfo.h
 *
 * \brief     Utility class for getting power state information (e.g. ACC=ON) from LCM
 *
 *
 *  Created on: Dec 21, 2015
 *      Author: jas1hi
 *
 * \copyright Robert Bosch Car Multimedia 2015
 *--------------------------------------------------------------------------------------------------------------------
 * 24.02.2017		| 1.6	| NLK1KOR (RBCM  )	| implemented feature AIVI-28127 XCP_Provider : P-IVI: Worker class for the power status
 *--------------------------------------------------------------------------------------------------------------------
 * 26.06.2017       | 1.7	| NLK1KOR (RBEI  )	| Implemented Encoder Push key simulation.

 *--------------------------------------------------------------------------------------------------------------------
 */


#ifndef DIA_POWERSTATUSINFO_H_
#define DIA_POWERSTATUSINFO_H_

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif



class dia_PowerStatusInfo: public dia_ISpmListenerImpl
{
public:
	dia_PowerStatusInfo();
	virtual ~dia_PowerStatusInfo();

	/**
	 * \brief    	subscribe to LCM_PowerState
	 *
	 *				Function subscribes to the SystemAdapter of LCM.
	 *				The SystemAdapter returns the actual power state
	 */
	virtual tDiaResult subscribeToLCMForPowerState();
	virtual tDiaResult subscribeToLCMForSystemState();
    //! receive response from component and store value into member variable
    virtual tVoid vOnPowerState ( dia_eSpmSystemPowerState pwrState );
	virtual tVoid vOnSystemState(dia_eSpmSystemState state, dia_eSpmSystemState prevState);
    virtual tBool isPowerStateAvailable() {return m_PowerStateAvailable;}
    virtual tBool isLCMSubscriptionDone() {return m_LCMSubscriptionDone;}
	virtual tBool isSystemStateAvailable() { return m_SystemStateAvailable; }
	virtual tBool isSystemStateSubscriptionDone() { return m_SystemStateSubscriptionDone; }
    //! returns bitcoded power state
    virtual tU8 getPowerState();
	virtual tU8 getSystemState();
	virtual tDiaResult simulateOnOffTrigger(tBool mode);
private:
	   dia_eSpmSystemPowerState m_PowerState;
	   tBool m_PowerStateAvailable;
	   tBool m_LCMSubscriptionDone;
	   dia_eSpmSystemState m_SystemState;
	   tBool m_SystemStateAvailable;
	   tBool m_SystemStateSubscriptionDone;
};

#endif /* DIA_POWERSTATUSINFO_H_ */
