/*
 * dia_PhoneConnectionInfo.cpp
 *
 *  Created on: Jun 2, 2016
 *      Author: jas1hi
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_PhoneConnectionInfo.h"

dia_PhoneConnectionInfo::dia_PhoneConnectionInfo()
	: m_pPhoneConnectionSetting(NULL),
	  m_phoneConnectionInfoSubscriptionDone(FALSE),
	  m_phoneConnectionInfoAvailable(FALSE),
	  m_connectionEstablishmentDuration(0)
{
	dia_tclFnctTrace trc("dia_PhoneConnectionInfo::dia_PhoneConnectionInfo()");
}

dia_PhoneConnectionInfo::~dia_PhoneConnectionInfo()
{
	_BP_TRY_BEGIN
	{
	  (void) unsetSysAdapterListener<dia_IPhoneConnectionSettingListener>(this);
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_PhoneConnectionInfo::~dia_PhoneConnectionInfo !!!");
	  DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END

	if (m_pPhoneConnectionSetting)
		m_pPhoneConnectionSetting = OSAL_NULL;
}

tDiaResult dia_PhoneConnectionInfo::subscribeForPhoneConnectionInfo()
{
	dia_tclFnctTrace trc("dia_PhoneConnectionInfo::subscribeForPhoneConnectionInfo");

	if (m_phoneConnectionInfoSubscriptionDone == FALSE)
	{
		DIA_TR_INF("dia_PhoneConnectionInfo::subscribeForPhoneConnectionInfo()");

		tDiaResult result = querySysAdapterInterface<dia_IPhoneConnectionSetting>(&m_pPhoneConnectionSetting);
		if (result == DIA_SUCCESS) {
			 if (m_pPhoneConnectionSetting) {
				 (tVoid) setSysAdapterListener<dia_IPhoneConnectionSettingListener>(this);

				 if (m_pPhoneConnectionSetting->registerToPhoneConnectionEstablishmentDuration() == DIA_SUCCESS) {
					 if (m_pPhoneConnectionSetting->getPhoneConnectionEstablishmentDuration() == DIA_SUCCESS) { // One time request to get the actual value
						 DIA_TR_INF("dia_PhoneConnectionInfo::subscribeForPhoneConnectionInfo getPhoneConnectionEstablishmentDuration() OK!");
					 } else {
						DIA_TR_ERR("dia_PhoneConnectionInfo::subscribeForPhoneConnectionInfo getPhoneConnectionEstablishmentDuration() with ERRORS!");
						(tVoid) unsetSysAdapterListener<dia_IPhoneConnectionSettingListener>(this);
						return DIA_FAILED;
					 }
				 }
				 else {
					 DIA_TR_ERR("dia_PhoneConnectionInfo::subscribeForPhoneConnectionInfo registerToPhoneConnectionEstablishmentDuration() with ERRORS!");
					(tVoid) unsetSysAdapterListener<dia_IPhoneConnectionSettingListener>(this);
					return DIA_FAILED;
				 }

				 DIA_TR_INF("dia_PhoneConnectionInfo::subscribeForPhoneConnectionInfo. DONE!!!");
				 m_phoneConnectionInfoSubscriptionDone = TRUE;
			}
		}
		else {
			DIA_TR_ERR("dia_PhoneConnectionInfo::subscribeForPhoneConnectionInfo querySysAdapterInterface<dia_IPhoneConnectionSettingListener> ERROR!");
			DIA_TR_ERR("dia_PhoneConnectionInfo::subscribeForPhoneConnectionInfo result: %d", result);
		}
	}

	return DIA_SUCCESS;
}

tVoid dia_PhoneConnectionInfo::vOnPhoneConnectionEstablishmentDurationStatus(tU32 duration)
{
	DIA_TR_INF("dia_PhoneConnectionInfo::vOnPhoneConnectionEstablishmentDurationStatus: %d ms", duration);

	if (duration > 0) {
		m_connectionEstablishmentDuration = duration;
		m_phoneConnectionInfoAvailable = TRUE;
	}
}

tU32 dia_PhoneConnectionInfo::getPhoneConnectionEstablishmentDuration()
{
	if (m_phoneConnectionInfoAvailable) {
		m_phoneConnectionInfoAvailable = FALSE;
	}

	return m_connectionEstablishmentDuration;
}
