/**
 * \file      dia_InputSimulation.h
 *
 * \brief     Utility class for making input simulation (e.g. keyInjection, singleTouch, encoder rotation, etc..)
 *
 *
 *  Created on: Feb 16, 2016
 *      Author: jas1hi
 *
 *--------------------------------------------------------------------------------------------------------------------
 * 16.03.2017		| 1.2	| NLK1KOR (RBEI)	| Implemented AIVI-47067  calibration operation status
 *--------------------------------------------------------------------------------------------------------------------
 * 06.06.2017       | 2.1	| NLK1KOR (RBEI  )	| Implemented 
													AIVI-28699 	AIVI-28698 XCP_Provider : P-IVI: key press operation on the secondary display 	
													AIVI-34710 	AIVI-34709 XCP_Provider : P-IVI: operation history (secondary display)
													PIVI-4235 Operation history of touch panel (secondary display)
*--------------------------------------------------------------------------------------------------------------------

 *--------------------------------------------------------------------------------------------------------------------
 * \copyright Robert Bosch Car Multimedia 2016
 */


#ifndef DIA_INPUTSIMULATION_H_
#define DIA_INPUTSIMULATION_H_

#ifndef __INCLUDED_DIA_INTERFACE_INPUTHANDLINGPRJ_LISTENER__
#include "project/interfaces/dia_IInputHandlingPrjListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include "common/interfaces/dia_ITimerListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_PIVI_INPUTHANDLING_LISTENER__
#include "project/interfaces/dia_IPIVIInputHandlingListener.h"
#endif

#define MAX_LENGTH_KEY_NAME            (tU16) 20
#define MAX_FILE_PATH_LENGTH           (tU16) 40


typedef struct dia_TouchCoordinates_
{
	tU16 xCoord;
	tU16 yCoord;
	tU16 screenNumber;
	tU16 releaseTime;
	dia_eInputHandlingTouchInfoPrj status;

	dia_TouchCoordinates_()
   :   xCoord(0),
       yCoord(0),
	   screenNumber(0),
       releaseTime(0),
	   status(DIA_EN_PRJ_TOUCH_INFO_UNKNOWN)
   {
   }

} dia_TouchCoordinates;



typedef struct dia_KeyPress_
{
	dia_eVdInuptHandlingKeyCodePrj internalKeyID;
	tU16 releaseTime;
	std::string keyName;

	dia_KeyPress_()
   :   internalKeyID(DIA_PRJ_KEY_CODE_UNKNOWN),
       releaseTime(0)
   {
		keyName.clear();
   }

} dia_KeyPress;

typedef struct dia_TouchSlideCoordinates_
{
	tU16 xCoordStart;
	tU16 yCoordStart;
	tU16 xCoordEnd;
	tU16 yCoordEnd;

	dia_TouchSlideCoordinates_()
	:   xCoordStart(0),
        yCoordStart(0),
        xCoordEnd(0),
        yCoordEnd(0)
   {
   }

} dia_TouchSlideCoordinates;




class dia_InputSimulation: public dia_IInputHandlingPrjListenerImpl, public dia_ITimerListener,public dia_IPIVIInputHandlingListenerImpl
{
public:
	dia_InputSimulation();
	virtual ~dia_InputSimulation();

	/**
	 * \brief    	subscribe for events from Input handling
	 *
	 *				Function subscribes to the SystemAdapter for getting the ITC Info.
	 *				The SystemAdapters return the actual values
	 */


	tVoid vOnTimerElapsed ( dia_TimerID id );

	virtual tBool isInputEventsEnabled() {return m_inputEventsEnabled;}

	tDiaResult simulateKeyInjection(tU16 keyCode, tU16 releaseTime); // If releaseTime = 0 then short press otherwise a long press operation
	tVoid vOnSetKey (const tDiaResult eDiaResult);

	tDiaResult simulateEncRotation(tU8 encType, tS8 steps);
	dia_eInputHandlingEncoderPrj getInternalEncoderType(tU8 encType);
	//	 void vOnEncoderStatus ( const bpstl::vector<tU8> /*vecEncoderStatus*/ );

	tDiaResult simulateSingleTouch(tU16 xCoord, tU16 yCoord, tU16 releaseTime); // If releaseTime = 0 then short press otherwise a long press operation
	//	 tVoid vOnTouchInfo ( const tU16 u16X, const tU16 u16Y, const tU16 /*u16DeltaX*/, const tU16 /*u16DeltaY*/, const dia_eInputHandlingTouchInfoPrj eTouchInfo);
	tVoid vOnSetTouch (const tDiaResult eDiaResult);

	tDiaResult simulateTouchSlide(tU16 xCoordStart, tU16 yCoordStart, tU16 xCoordEnd, tU16 yCoordEnd, tU16 duration);
	tVoid vOnSetTouchSlide (const tDiaResult eDiaResult);

	tDiaResult startGestureRecording(const std::string& filePathStr);
	tDiaResult stopGestureRecording(const std::string& filePathStr);
	tVoid vOnRecordGesture ( const tDiaResult eDiaResult);

	tDiaResult startGestureReplay(const std::string& filePathStr);
	tDiaResult stopGestureReplay(const std::string& filePathStr);
	tVoid vOnReplayGesture ( const tDiaResult eDiaResult);
	
	tU8 getKeyInjectionstatus();
	tU8 getEncRotationstatus();
	tU8 getTouchSimulationstatus();
	tU8 getGestureRecordstatus();
	tU8 getGestureReplaystatus();
	
	tVoid vOnSetEncoder(const tDiaResult eDiaResult);

	//calibration Status byte
	tU8 m_keyInjectionStatus;
	tU8 m_EncRotationStatus;
	tU8 m_TouchSimulationStatus;
	tU8 m_GestureRecordStatus;
	tU8 m_GestureReplayStatus;
	tU8  m_TouchPIVISimulationStatus;
	
	tDiaResult simulatePIVITouch(tU16 xCoord, tU16 yCoord,tU16 screenNumber,tU16 releaseTime);
    tVoid vOnSetPIVITouch (const tDiaResult eDiaResult);
private:


	dia_eVdInuptHandlingKeyCodePrj getInternalKeyID(tU16 keyCode);


	tBool m_inputEventsEnabled;

	// Key
	tBool m_keyPressed;
	dia_KeyPress m_lastPressedKey;
//	dia_eVdInuptHandlingKeyCodePrj m_internalKeyID;
//	std::string m_lastProcessedKeyName;

	// Encoder
	tBool m_encoderRotated;
	std::string m_lastProcessedEncoder;

	// Touch
	tBool m_touchPressed;
	dia_TouchCoordinates m_lastPressedTouchArea;

	// Touch slide
	tBool m_touchSlideDone;
	dia_TouchSlideCoordinates m_lastTouchSlideArea;

	// Gesture record
	tBool m_gestureRecordingRunning;
	tBool m_gestureRecordStartRequested;

	// Gesture replay
	tBool m_gestureReplayingRunning;
	tBool m_gestureReplayStartRequested;

    //! timer used for sending the release event for touch operation
    dia_Timer mReleaseTimerTouch;
    tU32 mTimerIDTouch;

    //! timer used for sending the release event for key press operation
    dia_Timer mReleaseTimerKeyPress;
    tU32 mTimerIDKeyPress;
	
	// PIVI touch
	tBool m_touchPIVIPressed ;
	dia_TouchCoordinates m_lastPressedPIVITouchArea;
   


};

#endif /* DIA_INPUTSIMULATION_H_ */
