/**
 * \file      dia_InputHistory.h
 *
 * \brief     Utility class for getting input operation history (e.g. keyInjection, singleTouch, encoder rotation, etc..)
 *
 *
 *  Created on: Feb 8, 2017
 *      Author: jas1hi
 *
 * \copyright Robert Bosch Car Multimedia 2017
 *--------------------------------------------------------------------------------------------------------------------
 * 16.02.2017		| 1.1	| NLK1KOR (RBEI)	| fixed NCG3D-36761
 *--------------------------------------------------------------------------------------------------------------------
* 06.06.2017       | 2.1	| NLK1KOR (RBEI  )	| Implemented 
													AIVI-28699 	AIVI-28698 XCP_Provider : P-IVI: key press operation on the secondary display 	
													AIVI-34710 	AIVI-34709 XCP_Provider : P-IVI: operation history (secondary display)
													PIVI-4235 Operation history of touch panel (secondary display)
*--------------------------------------------------------------------------------------------------------------------

 *-------------------------------------------------------------------------------------------------------------------
 */


#ifndef DIA_INPUTHISTORY_H_
#define DIA_INPUTHISTORY_H_

#ifndef __INCLUDED_DIA_INTERFACE_INPUTHANDLINGPRJ_LISTENER__
#include "project/interfaces/dia_IInputHandlingPrjListener.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACE_PIVI_INPUTHANDLING_LISTENER__
#include "project/interfaces/dia_IPIVIInputHandlingListener.h"
#endif
#define MAX_OPERATION_HISTORY_ELEMS           2

typedef struct dia_TouchCoordinatesHistory_
{
	tU16 xCoord;
	tU16 yCoord;
	tU8 status;

	dia_TouchCoordinatesHistory_()
		: xCoord(0),
		  yCoord(0),
		  status(0)
	{
	}

} dia_TouchCoordinatesHistory;

typedef struct dia_KeyPressedInfoElement_
{
	tU16 mKeyCode;
	tU8 mKeyStatus;

	dia_KeyPressedInfoElement_()
	{
		mKeyCode = 0;
		mKeyStatus = 0;
	}

}dia_KeyPressedInfoElement;

typedef struct dia_EncoderInfoElement_
{
	tS8 mEncoderVal1;
	tS8 mEncoderVal2;

	dia_EncoderInfoElement_()
	{

		mEncoderVal1 = 0;
		mEncoderVal2 = 0;

	}

}dia_EncoderInfoElement;

typedef struct dia_EncoderDirInfoElement_
{
	tU8 mEncoderType;
	tS8 mEncoderDirSteps;

	dia_EncoderDirInfoElement_()
	{
		mEncoderType = 0;
		mEncoderDirSteps = 0;
	}

}dia_EncoderDirInfoElement;


class dia_InputHistory: public dia_IInputHandlingPrjListenerImpl,public dia_IPIVIInputHandlingListenerImpl
{
public:
	dia_InputHistory();
	virtual ~dia_InputHistory();

	virtual void vOnGetPressedKey(const std::vector<dia_tPressedKeyPrj> pressedKeys);
	virtual void vOnTouchInfohistory(const std::vector<dia_tTouchPressHistoryInfoPrj> vecTouchPressInfo); //reply on status of touch screen : implemented to recieve a list of operations for Monitoring and Calibration feature.
	virtual void vOnEncoderDirHistory(const std::vector<dia_tEncoderDirHistoryInfoPrj> vecEncoderDirStatus);
    virtual void vOnPIVITouchInfohistory(const std::vector<dia_tTouchPressHistoryInfoPrj> vecTouchPressInfo);
	tBool isOperationHistorySubscriptionDone() { return m_OperationHistorySubscriptionDone; }
	tBool isgetTouchInfoAvailable() { return m_TouchInfoAvailable; }
	tBool isgetEncoderDirStatusAvailable() { return m_EncoderDirStatusAvailable; }
	tBool isgetEncoderStatusAvailable() { return m_EncoderStatusAvailable; }
	tBool isgetPressedKeysInfoAvailable() { return m_PressedKeysInfoAvailable; }
	tBool isgetPIVITouchInfoAvailable() { return m_PIVITouchInfoAvailable; }

	tDiaResult subscribeForOperationhistoryInfo();
	tVoid requestTouchInfo();
	tVoid requestEncoderDirStatus();
	tVoid requestPressedKeys();
    tVoid requestPIVITouchInfo();
	tBool m_OperationHistorySubscriptionDone;
	tBool m_subscribeForGetTouchInfoDone;
	tBool m_TouchInfoAvailable;
	tBool m_subscribeForEncoderDirStatusDone;
	tBool m_EncoderDirStatusAvailable;
	tBool m_subscribeForEncoderStatusDone;
	tBool m_EncoderStatusAvailable;
	tBool m_subscribeForPressedKeysInfoDone;
	tBool m_PressedKeysInfoAvailable;
	tBool m_subscribeForPIVITouchInfoDone;
	tBool m_PIVITouchInfoAvailable;

	std::vector<dia_KeyPressedInfoElement> getPressedKeyHistory(tU16 maxNumberOfOperationHistoryElements);
	std::vector<dia_EncoderDirInfoElement> getEncoderDirStatus(tU16 maxNumberOfOperationHistoryElements);
	std::vector<dia_EncoderInfoElement> getEncoderStatus(tU16 maxNumberOfOperationHistoryElements);
	std::vector<dia_TouchCoordinatesHistory> getTouchStatus(tU16 maxNumberOfOperationHistoryElements);
	std::vector<dia_TouchCoordinatesHistory> getPIVITouchStatus(tU16 maxNumberOfOperationHistoryElements);
private:
	dia_IInputHandlingPrj* m_pInputHandling;
	dia_IPIVIInputHandling* m_pPIVIInputHandling;

	tU16 getExternalKeyID(dia_eVdInuptHandlingKeyCodePrj enKeyCode);
	std::string getInternalKeyName(dia_eVdInuptHandlingKeyCodePrj enKeyCode);

	std::vector<dia_KeyPressedInfoElement> mKeyPressedHistoryInfo;
	std::vector<dia_EncoderInfoElement> mEncoderStatusHistoryInfo;
	std::vector<dia_TouchCoordinatesHistory> mTouchStatusHistoryInfo;
	std::vector<dia_EncoderDirInfoElement> mEncoderDirStatusHistoryInfo;
	std::vector<dia_TouchCoordinatesHistory> mPIVITouchStatusHistoryInfo;
};

#endif /* DIA_INPUTHISTORY_H_ */
