/*
 * dia_ILMInfo.cpp
 *
 *  Created on: Nov 23, 2015
 *      Author: jas1hi
 */

#ifndef _ILM_COMMON_H_
#include <ilm/ilm_common.h>
#endif

#ifndef _ILM_CONTROL_H_
#include <ilm/ilm_control.h>
#endif

#ifndef _ILM_CLIENT_H_
#include <ilm/ilm_client.h>
#endif


#include "dia_ILMInfo.h"

// ToDo : Display ID to be taken from ScreenLayouts xml
#if defined(GEN3X86)
#define DISPLAY_ID 0
#else
#define DISPLAY_ID 1
#endif


const tU32 SURFACE_ID_SPI_VIDEO_RENDER = 59;
const tU32 SURFACE_ID_SPI_TOUCH_HANDLER = 80;
const tU32 SURFACE_ID_LATE_RVC = 91;
const tU32 SURFACE_ID_FOOTER_BAR = 94;
const tU32 SURFACE_ID_KEY_HANDLER_DUMMY = 99;
const tU32 SURFACE_ID_APP_HMIMASTER = 101;
const tU32 SURFACE_ID_APP_TUNER = 102;
const tU32 SURFACE_ID_APP_NAVIGATION = 103;
const tU32 SURFACE_ID_APP_MEDIA = 104;
const tU32 SURFACE_ID_APP_SYSTEM = 105;
const tU32 SURFACE_ID_APP_SXM = 106;
const tU32 SURFACE_ID_APP_TELEMATICS = 107;
const tU32 SURFACE_ID_APP_TESTMODE = 108;
const tU32 SURFACE_ID_APP_PHONE = 109;
const tU32 SURFACE_ID_APP_HOMESCREEN = 110;
const tU32 SURFACE_ID_APP_VEHICLE = 111;
const tU32 SURFACE_ID_APP_SDS = 112;

// Popup surfaceIDs
const tU32 SURFACE_ID_CENTER_POPUP_MASTER = 2001;
const tU32 SURFACE_ID_CENTER_POPUP_TUNER = 2002;
const tU32 SURFACE_ID_CENTER_POPUP_NAVIGATION = 2003;
const tU32 SURFACE_ID_CENTER_POPUP_MEDIA = 2004;
const tU32 SURFACE_ID_CENTER_POPUP_SYSTEM = 2005;
const tU32 SURFACE_ID_CENTER_POPUP_SXM = 2006;
const tU32 SURFACE_ID_CENTER_POPUP_TELEMATICS = 2007;
const tU32 SURFACE_ID_CENTER_POPUP_TESTMODE = 2008;
const tU32 SURFACE_ID_CENTER_POPUP_PHONE = 2009;
const tU32 SURFACE_ID_CENTER_POPUP_HOMESCREEN = 2010;
const tU32 SURFACE_ID_CENTER_POPUP_VEHICLE = 2011;
const tU32 SURFACE_ID_CENTER_POPUP_SDS = 2012;
const tU32 SURFACE_ID_TOP_POPUP_MASTER = 3001;
const tU32 SURFACE_ID_TOP_POPUP_TUNER = 3002;
const tU32 SURFACE_ID_TOP_POPUP_NAVIGATION = 3003;
const tU32 SURFACE_ID_TOP_POPUP_MEDIA = 3004;
const tU32 SURFACE_ID_TOP_POPUP_SYSTEM = 3005;
const tU32 SURFACE_ID_TOP_POPUP_SXM = 3006;
const tU32 SURFACE_ID_TOP_POPUP_TELEMATICS = 3007;
const tU32 SURFACE_ID_TOP_POPUP_TESTMODE = 3008;
const tU32 SURFACE_ID_TOP_POPUP_PHONE = 3009;
const tU32 SURFACE_ID_TOP_POPUP_HOMESCREEN = 3010;
const tU32 SURFACE_ID_TOP_POPUP_VEHICLE = 3011;
const tU32 SURFACE_ID_TOP_POPUP_SDS = 3012;

dia_ILMInfo::dia_ILMInfo()
{
	m_surfaceIdMap.clear();

	m_surfaceIdMap[SURFACE_ID_SPI_VIDEO_RENDER]		 	= std::string("SURFACE_ID_SPI_VIDEO_RENDER");
	m_surfaceIdMap[SURFACE_ID_SPI_TOUCH_HANDLER] 		= std::string("SURFACE_ID_SPI_TOUCH_HANDLER");
	m_surfaceIdMap[SURFACE_ID_LATE_RVC] 				= std::string("SURFACE_ID_LATE_RVC");
	m_surfaceIdMap[SURFACE_ID_FOOTER_BAR]				= std::string("SURFACE_ID_FOOTER_BAR");
	m_surfaceIdMap[SURFACE_ID_KEY_HANDLER_DUMMY] 		= std::string("SURFACE_ID_KEY_HANDLER_DUMMY");
	m_surfaceIdMap[SURFACE_ID_APP_HMIMASTER] 			= std::string("SURFACE_ID_APP_HMIMASTER");
	m_surfaceIdMap[SURFACE_ID_APP_TUNER] 				= std::string("SURFACE_ID_APP_TUNER");
	m_surfaceIdMap[SURFACE_ID_APP_NAVIGATION] 			= std::string("SURFACE_ID_APP_NAVIGATION");
	m_surfaceIdMap[SURFACE_ID_APP_MEDIA] 				= std::string("SURFACE_ID_APP_MEDIA");
	m_surfaceIdMap[SURFACE_ID_APP_SYSTEM] 				= std::string("SURFACE_ID_APP_SYSTEM");
	m_surfaceIdMap[SURFACE_ID_APP_SXM] 					= std::string("SURFACE_ID_APP_SXM");
	m_surfaceIdMap[SURFACE_ID_APP_TELEMATICS] 			= std::string("SURFACE_ID_APP_TELEMATICS");
	m_surfaceIdMap[SURFACE_ID_APP_TESTMODE] 			= std::string("SURFACE_ID_APP_TESTMODE");
	m_surfaceIdMap[SURFACE_ID_APP_PHONE] 				= std::string("SURFACE_ID_APP_PHONE");
	m_surfaceIdMap[SURFACE_ID_APP_HOMESCREEN] 			= std::string("SURFACE_ID_APP_HOMESCREEN");
	m_surfaceIdMap[SURFACE_ID_APP_VEHICLE] 				= std::string("SURFACE_ID_APP_VEHICLE");
	m_surfaceIdMap[SURFACE_ID_APP_SDS] 					= std::string("SURFACE_ID_APP_SDS");

	m_surfaceIdMap[SURFACE_ID_CENTER_POPUP_MASTER] 		= std::string("SURFACE_ID_CENTER_POPUP_MASTER");
	m_surfaceIdMap[SURFACE_ID_CENTER_POPUP_TUNER] 		= std::string("SURFACE_ID_CENTER_POPUP_TUNER");
	m_surfaceIdMap[SURFACE_ID_CENTER_POPUP_NAVIGATION] 	= std::string("SURFACE_ID_CENTER_POPUP_NAVIGATION");
	m_surfaceIdMap[SURFACE_ID_CENTER_POPUP_MEDIA] 		= std::string("SURFACE_ID_CENTER_POPUP_MEDIA");
	m_surfaceIdMap[SURFACE_ID_CENTER_POPUP_SYSTEM] 		= std::string("SURFACE_ID_CENTER_POPUP_SYSTEM");
	m_surfaceIdMap[SURFACE_ID_CENTER_POPUP_SXM] 		= std::string("SURFACE_ID_CENTER_POPUP_SXM");
	m_surfaceIdMap[SURFACE_ID_CENTER_POPUP_TELEMATICS] 	= std::string("SURFACE_ID_CENTER_POPUP_TELEMATICS");
	m_surfaceIdMap[SURFACE_ID_CENTER_POPUP_TESTMODE] 	= std::string("SURFACE_ID_CENTER_POPUP_TESTMODE");
	m_surfaceIdMap[SURFACE_ID_CENTER_POPUP_PHONE] 		= std::string("SURFACE_ID_CENTER_POPUP_PHONE");
	m_surfaceIdMap[SURFACE_ID_CENTER_POPUP_HOMESCREEN] 	= std::string("SURFACE_ID_CENTER_POPUP_HOMESCREEN");
	m_surfaceIdMap[SURFACE_ID_CENTER_POPUP_VEHICLE] 	= std::string("SURFACE_ID_CENTER_POPUP_VEHICLE");
	m_surfaceIdMap[SURFACE_ID_CENTER_POPUP_SDS] 		= std::string("SURFACE_ID_CENTER_POPUP_SDS");
	m_surfaceIdMap[SURFACE_ID_TOP_POPUP_MASTER] 		= std::string("SURFACE_ID_TOP_POPUP_MASTER");
	m_surfaceIdMap[SURFACE_ID_TOP_POPUP_TUNER] 			= std::string("SURFACE_ID_TOP_POPUP_TUNER");
	m_surfaceIdMap[SURFACE_ID_TOP_POPUP_NAVIGATION] 	= std::string("SURFACE_ID_TOP_POPUP_NAVIGATION");
	m_surfaceIdMap[SURFACE_ID_TOP_POPUP_MEDIA] 			= std::string("SURFACE_ID_TOP_POPUP_MEDIA");
	m_surfaceIdMap[SURFACE_ID_TOP_POPUP_SYSTEM] 		= std::string("SURFACE_ID_TOP_POPUP_SYSTEM");
	m_surfaceIdMap[SURFACE_ID_TOP_POPUP_SXM] 			= std::string("SURFACE_ID_TOP_POPUP_SXM");
	m_surfaceIdMap[SURFACE_ID_TOP_POPUP_TELEMATICS] 	= std::string("SURFACE_ID_TOP_POPUP_TELEMATICS");
	m_surfaceIdMap[SURFACE_ID_TOP_POPUP_TESTMODE] 		= std::string("SURFACE_ID_TOP_POPUP_TESTMODE");
	m_surfaceIdMap[SURFACE_ID_TOP_POPUP_PHONE] 			= std::string("SURFACE_ID_TOP_POPUP_PHONE");
	m_surfaceIdMap[SURFACE_ID_TOP_POPUP_HOMESCREEN] 	= std::string("SURFACE_ID_TOP_POPUP_HOMESCREEN");
	m_surfaceIdMap[SURFACE_ID_TOP_POPUP_VEHICLE] 		= std::string("SURFACE_ID_TOP_POPUP_VEHICLE");
	m_surfaceIdMap[SURFACE_ID_TOP_POPUP_SDS] 			= std::string("SURFACE_ID_TOP_POPUP_SDS");

	ilm_init();
}

dia_ILMInfo::~dia_ILMInfo()
{
    _BP_TRY_BEGIN
    {
    	m_surfaceIdMap.clear();
    	ilm_destroy();
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_ILMInfo::~dia_ILMInfo !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//tDiaResult dia_ILMInfo::getVisibleSurfaceIDs(std::vector<tU32>& visibleSurfaceIdList)
//{
//	if (!ilm_isInitialized()) {
//		DIA_TR_ERR("dia_ILMInfo::getVisibleSurfaceIDs. ILM initialization FAILED");
//		return DIA_FAILED;
//	}
//
//	visibleSurfaceIdList.clear();
//
//	mSurfaceIdMapIteratorType iteratorSurfaceIdMap;
//	for(iteratorSurfaceIdMap = mSurfaceIdMap.begin(); iteratorSurfaceIdMap != mSurfaceIdMap.end(); iteratorSurfaceIdMap++) {
//		t_ilm_bool visible = ILM_FALSE;
//		if (ilm_surfaceGetVisibility(iteratorSurfaceIdMap->first, &visible) != ILM_FAILED) {
//			if (visible == ILM_SUCCESS) {
//				visibleSurfaceIdList.push_back(iteratorSurfaceIdMap->first);
//				DIA_TR_INF("dia_ILMInfo::getVisibleSurfaceIDs. Visible surfaceID: %d (%s)", iteratorSurfaceIdMap->first, iteratorSurfaceIdMap->second.c_str());
//			}
//		}
//		else {
//			DIA_TR_ERR("dia_ILMInfo::getVisibleSurfaceIDs. FAILED for surfaceID: %d", iteratorSurfaceIdMap->first);
//			return DIA_FAILED;
//		}
//	}
//
//	return DIA_SUCCESS;
//}
//
//
//tVoid dia_ILMInfo::getVisibleAndActiveSurfaceId(std::vector<tS32>& surfaceVector, tS32 surfaceState, tS32 surfaceIdent)
//{
//   ilmScreenProperties screenProperties;
//
//   ilmErrorTypes err = ilm_getPropertiesOfScreen(DISPLAY_ID, &screenProperties);
//   if (err == ILM_SUCCESS)
//   {
//      for (unsigned int lIndex = 0; lIndex < screenProperties.layerCount; lIndex++)
//      {
//         t_ilm_int surfaceCount = 0;
//         t_ilm_surface* pAllSurfacesurfaces;
//         unsigned int layerid = screenProperties.layerIds[lIndex];
//         // get all surfaces on the layer
//         err = ilm_getSurfaceIDsOnLayer(layerid, &surfaceCount, &pAllSurfacesurfaces);
//
//         if (err == ILM_SUCCESS)
//         {
//            for (int sIndex = 0; sIndex < surfaceCount; sIndex++)
//            {
//               ilmSurfaceProperties surfaceProperties;
//               int surfaceid = pAllSurfacesurfaces[sIndex];
//               err = ilm_getPropertiesOfSurface(surfaceid, &surfaceProperties);
//               if (err == ILM_SUCCESS)
//               {
//                  if ((surfaceProperties.visibility) && (((surfaceState == VISIBLE_INPUT_KEY) && (surfaceProperties.inputDevicesAcceptance & ILM_INPUT_DEVICE_KEYBOARD)) || (surfaceState == VISIBLE)))
//                  {
//                     int surfaceAttr = surfaceid;
//                     if (surfaceIdent == CREATOR_PID)
//                     {
//                        surfaceAttr = surfaceProperties.creatorPid;
//                     }
//                     std::vector<int>::iterator itr = ::std::find(surfaceVector.begin(), surfaceVector.end(), surfaceAttr);
//                     if (itr != surfaceVector.end())
//                     {
//                        surfaceVector.erase(itr);
//                     }
//                     surfaceVector.push_back(surfaceAttr);
//                  }
//               }
//            }
//         }
//         if (pAllSurfacesurfaces != 0)
//         {
//            free(pAllSurfacesurfaces);
//            pAllSurfacesurfaces = 0;
//         }
//      }
//   }
//}

tBool dia_ILMInfo::isIlmInitialized() const
{
	if (!ilm_isInitialized()) {
		DIA_TR_ERR("dia_ILMInfo::isIlmInitialized. ILM initialization FAILED");
		return FALSE;
	}

	return TRUE;
}

tDiaResult dia_ILMInfo::getPropertiesOfKeyboardFocusSurface(tU16& surfaceID, tU16& fpsOfKeyboardFocusSurface, std::string& surfaceName)
{
	t_ilm_surface keyboardFocusSurfaceId;
	if (ilm_GetKeyboardFocusSurfaceId(&keyboardFocusSurfaceId) == ILM_FAILED) {
		DIA_TR_ERR("dia_ILMInfo::getPropertiesOfKeyboardFocusSurface. Failed to get keyboardFocusSurfaceId");
		return DIA_FAILED;
	}
		if(keyboardFocusSurfaceId == -1)
		{
		  surfaceID = 0;
		}
	    else
		{
		  surfaceID = (tU16) keyboardFocusSurfaceId;
		}

//	DIA_TR_INF("dia_ILMInfo::getPropertiesOfKeyboardFocusSurface. keyboardFocusSurfaceId: %d", keyboardFocusSurfaceId);

	mSurfaceIdMapIteratorType iteratorSurfaceIdMap;
	for(iteratorSurfaceIdMap = m_surfaceIdMap.begin(); iteratorSurfaceIdMap != m_surfaceIdMap.end(); iteratorSurfaceIdMap++) {
		if (iteratorSurfaceIdMap->first == keyboardFocusSurfaceId){
//			DIA_TR_INF("dia_ILMInfo::getPropertiesOfKeyboardFocusSurface. keyboardFocusSurface Name: '%s'", iteratorSurfaceIdMap->second.c_str());
			surfaceName = iteratorSurfaceIdMap->second;
			break;
		}
	}

	ilmSurfaceProperties surfaceProperties;
	if (ilm_getPropertiesOfSurface(keyboardFocusSurfaceId, &surfaceProperties) == ILM_FAILED) {
		DIA_TR_ERR("dia_ILMInfo::getPropertiesOfKeyboardFocusSurface. Failed to get PropertiesOfSurface");
		return DIA_FAILED;
	}
	fpsOfKeyboardFocusSurface = static_cast<tU16>(surfaceProperties.surfaceFps);

//	DIA_TR_INF("dia_ILMInfo::getPropertiesOfKeyboardFocusSurface. FPS of KeyboardFocusSurface: %lf, %d", surfaceProperties.surfaceFps, fpsOfKeyboardFocusSurface);

	return DIA_SUCCESS;
}
