/**
 * \file      dia_HeatControlInfo.h
 *
 * \brief     Utility class for getting the Heat control information (e.g. cpu temperature, cpu fan speed, etc..)
 *
 *
 *  Created on: Mar 31, 2016
 *      Author: jas1hi
 *
 * \copyright Robert Bosch Car Multimedia 2016
 */


#ifndef DIA_HEATCONTROLINFO_H_
#define DIA_HEATCONTROLINFO_H_

#ifndef __INCLUDED_DIA_INTERFACE_HEATCONTROL_LISTENER__
#include "common/interfaces/dia_IHeatControlListener.h"
#endif


typedef struct HeatControlInfoElement_ {

	// Temperature of iMX
	tS16 cpuTemperature; // e.g. 60c

	// Fan speed of iMX
	tU8 cpuFanSpeed; // e.g. 10%

	HeatControlInfoElement_()
	{
		cpuTemperature = 0;
		cpuFanSpeed = 0;
	}

} HeatControlInfoElement;


class dia_HeatControlInfo: public dia_IHeatControlListenerImpl
{
public:
	dia_HeatControlInfo();
	virtual ~dia_HeatControlInfo();


	/**
	 * \brief    	subscribe for Heat Control Info
	 *
	 *				Function subscribes to the SystemAdapter for getting the Heat Control Info.
	 *				The SystemAdapters return the actual values
	 */
	tDiaResult subscribeForHeatControlInfo();

	virtual tVoid vOnTemperatureInfo(std::list<dia_tHeatCtrlTemperature>& temperatureList);
	virtual tVoid vOnFanSpeed(dia_eHeatCtrlFanID fanID, tU16 fanSpeed, tBool bSensorOverride);

	virtual tBool isHeatControlInfoAvailable();
	virtual tBool isHeatControlInfoSubscriptionDone() {return m_heatControlInfoSubscriptionDone;}

	virtual HeatControlInfoElement getHeatControlInfoElement();

private:
    dia_IHeatControl* m_pHeatControl;

    tBool m_heatControlInfoSubscriptionDone;

    tBool m_temperatureAvailable;
    tBool m_fanSpeedAvailable;

    HeatControlInfoElement m_heatControlInfoElement;
};

#endif /* DIA_HEATCONTROLINFO_H_ */
