/*
 * dia_HeatControlInfo.cpp
 *
 *  Created on: Mar 31, 2016
 *      Author: jas1hi
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_HeatControlInfo.h"

dia_HeatControlInfo::dia_HeatControlInfo()
:	m_pHeatControl(OSAL_NULL),
 	m_heatControlInfoSubscriptionDone(FALSE),
 	m_temperatureAvailable(FALSE),
 	m_fanSpeedAvailable(FALSE)
{
	 dia_tclFnctTrace trc("dia_HeatControlInfo::dia_HeatControlInfo()");
}

dia_HeatControlInfo::~dia_HeatControlInfo()
{
	_BP_TRY_BEGIN
	{
	  (void) unsetSysAdapterListener<dia_IHeatControlListener>(this);
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_HeatControlInfo::~dia_HeatControlInfo !!!");
	  DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END

	if (m_pHeatControl)
		m_pHeatControl = OSAL_NULL;
}

tDiaResult dia_HeatControlInfo::subscribeForHeatControlInfo()
{
	dia_tclFnctTrace trc("dia_HeatControlInfo::subscribeForHeatControlInfo");

	if (m_heatControlInfoSubscriptionDone == FALSE)
	{
		DIA_TR_INF("dia_HeatControlInfo::subscribeForHeatControlInfo()");

		if (querySysAdapterInterface<dia_IHeatControl>(&m_pHeatControl) == DIA_SUCCESS) {
			 if (m_pHeatControl) {
				 (tVoid) setSysAdapterListener<dia_IHeatControlListener>(this);

				 if (m_pHeatControl->getTemperatures(DIA_EN_HEATCTRL_TEMPERATURE_CLASS_REAL) == DIA_SUCCESS) { // One time request to get the actual value
					 DIA_TR_INF("dia_HeatControlInfo::subscribeForHeatControlInfo getTemperatures() OK!");
				 } else {
					DIA_TR_ERR("dia_HeatControlInfo::subscribeForHeatControlInfo getTemperatures() with ERRORS!");
					(tVoid) unsetSysAdapterListener<dia_IHeatControlListener>(this);
					return DIA_FAILED;
				 }

				 if (m_pHeatControl->getFanSpeed() == DIA_SUCCESS) { // One time request to get the actual value
					 DIA_TR_INF("dia_HeatControlInfo::subscribeForHeatControlInfo getFanSpeed() OK!");
				 } else {
					DIA_TR_ERR("dia_HeatControlInfo::subscribeForHeatControlInfo getFanSpeed() with ERRORS!");
					(tVoid) unsetSysAdapterListener<dia_IHeatControlListener>(this);
					return DIA_FAILED;
				 }

				 m_heatControlInfoSubscriptionDone = TRUE;
			}
		}
		else {
			DIA_TR_ERR("dia_HeatControlInfo::subscribeForHeatControlInfo querySysAdapterInterface<dia_IHeatControlListener> ERROR!");
		}
	}

	return DIA_SUCCESS;
}

tVoid dia_HeatControlInfo::vOnTemperatureInfo(std::list<dia_tHeatCtrlTemperature>& temperatureList)
{
	std::list<dia_tHeatCtrlTemperature>::iterator it = temperatureList.begin();
	for ( ; it != temperatureList.end(); ++it )
	{
		 if (it->mID == DIA_EN_HEATCTRL_TEMPERATURE_ID_IMX && it->mDiaQuality == DIA_EN_HEATCTRL_TEMPERATURE_QUALITY_VALID){ // save only the real thermal sensor of CPU iMX
			 m_heatControlInfoElement.cpuTemperature = it->mTemperature / 10; // e.g.: value 200 d C means 20,0 C
			 m_temperatureAvailable = TRUE;
//			 DIA_TR_CUS("dia_HeatControlInfo::vOnTemperatureInfo. cpuTemperature: %d", m_heatControlInfoElement.cpuTemperature);

			 break; // no need for a further update
		 }
	}
}

tVoid dia_HeatControlInfo::vOnFanSpeed(dia_eHeatCtrlFanID fanID, tU16 fanSpeed, tBool /*bSensorOverride*/) // bSensorOverride is not used
{
	if (fanID == DIA_EN_HEATCTRL_FAN_ID_CASE) {
		m_heatControlInfoElement.cpuFanSpeed = (tU8) fanSpeed;
		m_fanSpeedAvailable = TRUE;
//		DIA_TR_CUS("dia_HeatControlInfo::vOnFanSpeed. cpuFanSpeed: %d", m_heatControlInfoElement.cpuFanSpeed);
	}
}

tBool dia_HeatControlInfo::isHeatControlInfoAvailable()
{
	tBool heatControlInfoAvailable = FALSE;

	if (m_temperatureAvailable && m_fanSpeedAvailable) {
		heatControlInfoAvailable = TRUE;
	}

	return heatControlInfoAvailable;
}

HeatControlInfoElement dia_HeatControlInfo::getHeatControlInfoElement()
{
	if (m_pHeatControl) {
		if (m_pHeatControl->getTemperatures(DIA_EN_HEATCTRL_TEMPERATURE_CLASS_REAL) == DIA_SUCCESS && m_pHeatControl->getFanSpeed() == DIA_SUCCESS) { // This will deliver the status for the next query
			m_temperatureAvailable = FALSE;
			m_fanSpeedAvailable = FALSE;
		}
	}

	return m_heatControlInfoElement;
}
