/*
 * dia_HMINavigationInfo.cpp
 *
 *  Created on: May 17, 2016
 *      Author: jas1hi
 /*********************************************************************************************
 * REVISION HISTORY:
 * ------------------------------------------------------------------------------------------------
 * Date 				| Rev. 				| Author 		   	| Modification
 * ------------------------------------------------------------------------------------------------
 *--------------------------------------------------------------------------------------------------------------------
 * 09.02.2017		| 1.1	| NLK1KOR (RBEI)	|  AIVI-28703 Worker class for the Sensor simulation via sensor log file
 *--------------------------------------------------------------------------------------------------------------------
 * 16.03.2017		| 1.2	| NLK1KOR (RBEI)	| Implemented AIVI-47067  calibration operation status

 *--------------------------------------------------------------------------------------------------------------------

 *******************************************************************************************************************************/

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_DEBUGTRACE_PROJECT__
#include "project/services/customer/MonitoringCalibration/config/dia_defsDebugTraceConfig.h"
#endif

#include "dia_HMINavigationInfo.h"

dia_HMINavigationInfo::dia_HMINavigationInfo()
:	m_pHMINavigation(OSAL_NULL),
 	m_HMINavigationInfoSubscriptionDone(FALSE),
	m_routeCalDurationAvailable(FALSE),
	m_TripReplaystatus (0),
	m_tripReplayingRunning(FALSE),
	m_tripReplayStartRequested(FALSE) //coverity fix:77692:non-static class members are initialize in constructor.

{
	 dia_tclFnctTrace trc("dia_HMINavigationInfo::dia_HMINavigationInfo()");
}

dia_HMINavigationInfo::~dia_HMINavigationInfo()
{
	_BP_TRY_BEGIN
	{
	  (void) unsetSysAdapterListener<dia_IHMINavigationListener>(this);
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_HMINavigationInfo::~dia_HMINavigationInfo !!!");
	  DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END

	if (m_pHMINavigation)
		m_pHMINavigation = OSAL_NULL;
}

tDiaResult dia_HMINavigationInfo::subscribeForHMINavigationInfo()
{
	dia_tclFnctTrace trc("dia_HMINavigationInfo::subscribeForHMINavigationInfo");

	if (m_HMINavigationInfoSubscriptionDone == FALSE)
	{
		DIA_TR_INF("dia_HMINavigationInfo::subscribeForHMINavigationInfo()");

		if (querySysAdapterInterface<dia_IHMINavigation>(&m_pHMINavigation) == DIA_SUCCESS) {
			 if (m_pHMINavigation) {
				 (tVoid) setSysAdapterListener<dia_IHMINavigationListener>(this);

				 if (m_pHMINavigation->registerToRouteCalculationDuration() == DIA_SUCCESS) {
					 if (m_pHMINavigation->getRouteCalculationDuration() == DIA_SUCCESS) { // One time request to get the actual value
						 DIA_TR_INF("dia_HMINavigationInfo::subscribeForHMINavigationInfo getRouteCalculationDuration() OK!");
					 } else {
						DIA_TR_ERR("dia_HMINavigationInfo::subscribeForHMINavigationInfo getRouteCalculationDuration() with ERRORS!");
						(tVoid) unsetSysAdapterListener<dia_IHMINavigationListener>(this);
						return DIA_FAILED;
					 }
				 }
				 else {
					 DIA_TR_ERR("dia_HMINavigationInfo::subscribeForHMINavigationInfo registerToRouteCalculationDuration() with ERRORS!");
					(tVoid) unsetSysAdapterListener<dia_IHMINavigationListener>(this);
					return DIA_FAILED;
				 }

				 m_HMINavigationInfoSubscriptionDone = TRUE;
			}
		}
		else {
			DIA_TR_ERR("dia_HMINavigationInfo::subscribeForHMINavigationInfo querySysAdapterInterface<dia_IHMINavigationListener> ERROR!");
		}
	}

	return DIA_SUCCESS;
}

tVoid dia_HMINavigationInfo::vOnRouteCalculationDuration(tU32 routeCalDurationToFinalDest, tU32 routeCalDurationToNextDest)
{
	if (routeCalDurationToFinalDest > 0 || routeCalDurationToNextDest > 0) { // at least one parameter must be > 0
		m_hmiNavigationInfoElement.routeCalDurationToFinalDest = routeCalDurationToFinalDest;
		m_hmiNavigationInfoElement.routeCalDurationToNextDest = routeCalDurationToNextDest;
		m_routeCalDurationAvailable = TRUE;
//		DIA_TR_INF("dia_HMINavigationInfo::vOnRouteCalculationDuration. routeCalDurationToFinalDest: %d  routeCalDurationToNextDest: %d", routeCalDurationToFinalDest, routeCalDurationToNextDest);
	}
}

HMINavigationInfoElement dia_HMINavigationInfo::getHMINavigationInfoElement()
{
	if (m_routeCalDurationAvailable) {
		m_routeCalDurationAvailable = FALSE;
	}

	return m_hmiNavigationInfoElement;
}

/***********************************************************************************************************************************************************/
tDiaResult dia_HMINavigationInfo::startTripFileReplayRequest(const std::string& filePathStr)
{
	m_TripReplaystatus = 0;
	if (m_tripReplayStartRequested) {
		DIA_TR_ERR("dia_HMINavigationInfo::startTripFileReplayRequest - Trip replay is already requested!!!");
		m_TripReplaystatus = DIA_ERR_INVALID_REQUEST;
		return DIA_FAILED;
	}

	if (m_tripReplayingRunning) {
		DIA_TR_ERR("dia_HMINavigationInfo::startTripFileReplayRequest - Trip replay is already running!!!");
		m_TripReplaystatus = DIA_ERR_INVALID_REQUEST;
		return DIA_FAILED;
	}



	if (filePathStr.size() == 0)
	{
		DIA_TR_ERR("dia_HMINavigationInfo::startTripFileReplayRequest - filePathStr.size = 0");
		m_TripReplaystatus = DIA_ERR_INPUT_FILE_INVALID;
		return DIA_FAILED;
	}
	else if (filePathStr.size() > MAX_FILE_PATH_LENGTH)
	{
		DIA_TR_ERR("dia_HMINavigationInfo::startTripFileReplayRequest - filePathStr.size (%d) > MAX_FILE_PATH_LENGTH (%d)", filePathStr.size(), MAX_FILE_PATH_LENGTH);
		m_TripReplaystatus = DIA_ERR_INPUT_FILE_INVALID;
		return DIA_FAILED;
	}



	if ((querySysAdapterInterface<dia_IHMINavigation>(&m_pHMINavigation) == DIA_SUCCESS) && m_pHMINavigation)
	{
		(void)setSysAdapterListener<dia_IHMINavigationListener>(this); // Activate the subscription
		if (m_pHMINavigation->registerToTripReplayStatusInfo() == DIA_SUCCESS)
		{
			DIA_TR_INF("dia_HMINavigationInfo::TripReplayStatusInfo - SENT REGISTRATION REQUEST...!");
		}
		else
		{
			m_TripReplaystatus = DIA_ERR_REQUEST_SEND;
			DIA_TR_INF("dia_HMINavigationInfo::TripReplayStatusInfo -  REGISTRATION REQUEST FAILED...!");
		}
		if (DIA_SUCCESS != (m_pHMINavigation->StartTripReplay(filePathStr)))
		{
			m_TripReplaystatus = DIA_ERR_REQUEST_SEND;
			DIA_TR_ERR("dia_HMINavigationInfo::StartTripReplay -  FAILED!!!!");
			return DIA_FAILED;
		}
		else
		{
			DIA_TR_INF("dia_HMINavigationInfo::StartTripReplay - SENT REQUEST...");

			m_tripReplayStartRequested = TRUE;
		}
	}

	return DIA_SUCCESS;
}
/********************************************************************************************************************************************************/
tDiaResult dia_HMINavigationInfo::stopTripFileReplayRequest()
{
	m_TripReplaystatus = 0;
	if ((querySysAdapterInterface<dia_IHMINavigation>(&m_pHMINavigation) == DIA_SUCCESS) && m_pHMINavigation)
	{
		(void)setSysAdapterListener<dia_IHMINavigationListener>(this); // Activate the subscription
		if (DIA_SUCCESS != (m_pHMINavigation->StopTripReplay()))
		{
		    m_TripReplaystatus = DIA_ERR_REQUEST_SEND;
			DIA_TR_ERR("dia_HMINavigationInfo::stopTripFileReplayRequest - SEND FAILED!!!!");
			return DIA_FAILED;
		}
		else
		{
			DIA_TR_INF("dia_HMINavigationInfo::stopTripFileReplayRequest - SENT REQUEST...");
			 
			m_tripReplayStartRequested = FALSE;
		}
	}

	return DIA_SUCCESS;
}
/***********************************************************************************************************************************************************/
tVoid dia_HMINavigationInfo::vOnStartTripFileReplayResponse(tDiaResult eDiaResult)
{
	DIA_TR_INF("dia_HMINavigationInfo::vOnStartTripFileReplayResponse");
	if(eDiaResult == DIA_SUCCESS)
	{

			if (m_tripReplayStartRequested == TRUE /*&& m_tripReplayingRunning == FALSE*/)
			{
				DIA_TR_INF("dia_HMINavigationInfo::vOnStartTripFileReplayResponse - STARTED");
				m_tripReplayingRunning = TRUE; // trip replaying started successfully
								

			}
			else
			{

				DIA_TR_INF("dia_HMINavigationInfo::vOnStartTripFileReplayResponse - STOPPED");
				m_tripReplayingRunning = FALSE; // trip replaying stopped successfully
				(void)unsetSysAdapterListener<dia_IHMINavigationListener>(this);
			}
		DIA_TR_INF("dia_HMINavigationInfo::startTripFileReplayResponse : SUCCESS()");
	}
	else{
		m_TripReplaystatus = DIA_ERR_RESPONSE_RECEIVE;
	}
}
/*************************************************************************************************************************************************************/

tVoid dia_HMINavigationInfo::vOnStopTripFileReplayResponse(tDiaResult eDiaResult)
{
	m_tripReplayStartRequested = FALSE;
	m_tripReplayingRunning = FALSE;
	
    if(eDiaResult == DIA_SUCCESS)
	{
		DIA_TR_INF("dia_HMINavigationInfo::vOnStopTripFileReplayResponse : SUCCESS()");
	}
	else{
		m_TripReplaystatus = DIA_ERR_RESPONSE_RECEIVE;
	}
}

tVoid dia_HMINavigationInfo::vOnTripReplayStatusInfoUpdate(dia_TripReplayStatus status)
{

	DIA_TR_INF("dia_HMINavigationInfo::vOnTripReplayStatusInfoUpdate : SUCCESS()");
	switch(status)
	{
			case DIA_EN_UNKNOWN:
			DIA_TR_INF("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate Trip Replay Status: DIA_EN_UNKNOWN");
			m_TripReplaystatus = DIA_ERR_UNKNOWN;
			break;
			case DIA_EN_RESERVED:
			DIA_TR_INF("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate Trip Replay Status: DIA_EN_RESERVED");
			m_TripReplaystatus = DIA_TRIP_REPLAY_STATUS_RESERVED ;
			break;
			case DIA_EN_NOT_ACTIVE:
			DIA_TR_INF("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate Trip Replay Status: DIA_EN_NOT_ACTIVE");
			m_TripReplaystatus = DIA_TRIP_REPLAY_STATUS_NOT_ACTIVE;
			break;
			case DIA_EN_ACTIVE:
			DIA_TR_INF("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate Trip Replay Status: DIA_EN_ACTIVE");
			m_TripReplaystatus = DIA_TRIP_REPLAY_STATUS_ACTIVE;
			break;
			case DIA_EN_FILE_NOT_FOUND_ERROR:
			DIA_TR_INF("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate Trip Replay Status: DIA_EN_FILE_NOT_FOUND_ERROR");
			m_TripReplaystatus = DIA_ERR_TRIP_REPLAY_FILE_NOT_FOUND;
			break;
			case DIA_EN_INTERNAL_ERROR:
			DIA_TR_INF("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate Trip Replay Status: DIA_EN_INTERNAL_ERROR");
			m_TripReplaystatus = DIA_ERR_TRIP_REPLAY_INTERNAL  ;
			break;
			default :
			DIA_TR_INF("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate Trip Replay Status: DIA_EN_UNKNOWN");
			m_TripReplaystatus = DIA_ERR_UNKNOWN;
			break;
	}
}


      
tU8 dia_HMINavigationInfo::getTripReplaystatus()
{
	DIA_TR_INF("dia_InputHistory::getTripReplaystatus");
	DIA_TR_INF("dia_InputHistory::m_TripReplaystatus = %d",m_TripReplaystatus );
	return m_TripReplaystatus;
}
