/**
 * \file      dia_HMIMonitorInfo.h
 *
 * \brief     Utility class for getting the display contents (e.g. actual screen name, startup time till Logo off)
 *
 *
 *  Created on: Apr 11, 2016
 *      Author: jas1hi
 *--------------------------------------------------------------------------------------------------------------------
 * 16.03.2017		| 1.2	| NLK1KOR (RBEI)	| Implemented AIVI-28509  secondary Screen Name
 *--------------------------------------------------------------------------------------------------------------------
 * \copyright Robert Bosch Car Multimedia 2016
 */

#ifndef DIA_HMIMONITORINFO_H_
#define DIA_HMIMONITORINFO_H_

#ifndef __INCLUDED_DIA_INTERFACE_HMIMONITOR_LISTENER__
#include "project/interfaces/dia_IHMIMonitorListener.h"
#endif

#define MAX_SCREEN_NAME_STR_LENGTH (tU16) 50

#define MAX_SCREEN_DATA_LENGTH (tU16) 20

typedef struct HMIScreenInfoElement_ {
	// Interface device
	tChar activeScreenName[MAX_SCREEN_NAME_STR_LENGTH]; // e.g. MENU
    tChar activeScreenNameUpper[MAX_SCREEN_DATA_LENGTH];
	tChar nextActiveUpperScreenName[MAX_SCREEN_DATA_LENGTH];
    tChar nextActiveLowerScreenName[MAX_SCREEN_DATA_LENGTH];
	HMIScreenInfoElement_()
	{
		memset(activeScreenName, '\0', sizeof(tChar)*MAX_SCREEN_NAME_STR_LENGTH);
		memset(activeScreenNameUpper, '\0', sizeof(tChar)*MAX_SCREEN_DATA_LENGTH);
		memset(nextActiveUpperScreenName, '\0', sizeof(tChar)*MAX_SCREEN_DATA_LENGTH);
		memset(nextActiveLowerScreenName, '\0', sizeof(tChar)*MAX_SCREEN_DATA_LENGTH);
		
	}

} HMIScreenInfoElement;


class dia_HMIMonitorInfo: public dia_IHMIMonitorListener
{
public:
	dia_HMIMonitorInfo();
	virtual ~dia_HMIMonitorInfo();

	/**
	 * \brief    	subscribe for HMI Monitor Info
	 *
	 *				Function subscribes to the SystemAdapter for getting the HMI Monitor Info.
	 *				The SystemAdapters return the actual values
	 */
	tDiaResult subscribeForHMIMonitorInfo();
	tDiaResult setHMIMonitorInfo(tBool hmiMonitorInfoStatus);

	virtual tVoid vOnHMIStartupTimeIntervalStatus ( tU32 startupTimeInterval );
	virtual tVoid vOnHMIActiveForegroundSceneStatus ( std::string activeSceneName );

	virtual tBool isStartupTimeIntervalAvailable() {return m_startupTimeIntervalAvailable;}
	virtual tBool isActiveScreenNameAvailable() {return m_activeSceneNameAvailable;}

	virtual tBool isHMIMonitorInfoSubscriptionDone() {return m_HMIMonitorInfoSubscriptionDone;}

	virtual tBool isSetHMIMonitorInfoDone() { return m_setHMIMonitorInfoDone;}

	virtual tU32 getStartupTimeInterval();
	virtual HMIScreenInfoElement getHMIScreenInfoElement();
	virtual tVoid vOnHMIActiveForegroundSceneUpperStatus ( std::string activeUpperSceneName );
	virtual tVoid vOnHMINextActiveForegroundSceneUpperStatus ( std::string nextActiveUpperSceneName );
	virtual tVoid vOnHMINextActiveForegroundSceneLowerStatus ( std::string nextActiveLowerSceneName ) ;
	virtual tBool isActiveScreenNameUpperAvailable() {return m_activeSceneNameUpperAvailable;}
	virtual tBool isNextActiveLowerSceneNameAvailable() {return m_nextActiveLowerSceneNameAvailable;}
	virtual tBool isNextActiveUpperSceneNameAvailable() {return m_nextActiveUpperSceneNameAvailable;}
private:
	 dia_IHMIMonitor* m_pHMIMonitor;

	 tBool m_HMIMonitorInfoSubscriptionDone;

	 tBool m_startupTimeIntervalAvailable;
	 tBool m_activeSceneNameAvailable;
	 tBool m_activeSceneNameUpperAvailable;
	 tBool m_nextActiveUpperSceneNameAvailable;
	 tBool m_nextActiveLowerSceneNameAvailable;

	 tU32 m_startupTimeInterval;
	 HMIScreenInfoElement m_hmiScreenInfoElement;

	 tBool m_setHMIMonitorInfoDone;
};

#endif /* DIA_HMIMONITORINFO_H_ */
