/*
 * dia_GnssInfo.cpp
 *
 *  Created on: Mar 2, 2016
 *      Author: jas1hi
 */

#include "dia_GnssInfo.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif


dia_GnssInfo::dia_GnssInfo()
:	m_pGnss(OSAL_NULL),
	m_gnssInfoSubscriptionDone(FALSE),
 	m_gnssReceiverStateAvailable(FALSE),
 	m_gnssTimeDateAvailable(FALSE),
 	m_gnssVelocityAvailable(FALSE),
 	m_gpsPositionAvailable(FALSE)
{
	 dia_tclFnctTrace trc("dia_GnssInfo::dia_GnssInfo()");
}

dia_GnssInfo::~dia_GnssInfo()
{
	_BP_TRY_BEGIN
	{
	  (void) unsetSysAdapterListener<dia_IGNSSListener>(this);
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_GnssInfo::~dia_GnssInfo !!!");
	  DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END

	if (m_pGnss)
		m_pGnss = OSAL_NULL;
}

tDiaResult dia_GnssInfo::subscribeForGnssInfo()
{
	dia_tclFnctTrace trc("dia_GnssInfo::subscribeForGnssInfo");

	if (m_gnssInfoSubscriptionDone == FALSE)
	{
		DIA_TR_INF("dia_GnssInfo::subscribeForGnssInfo()");

		if (querySysAdapterInterface<dia_IGNSS>(&m_pGnss) == DIA_SUCCESS) {
			 if (m_pGnss) {
				 (tVoid) setSysAdapterListener<dia_IGNSSListener>(this);
				 if (m_pGnss->getGNSSData() == DIA_SUCCESS) { // One time request to get the actual value
					 DIA_TR_INF("dia_GnssInfo::subscribeForGnssInfo getGNSSData OK!");
					 m_gnssInfoSubscriptionDone = TRUE;
				 } else {
					DIA_TR_ERR("dia_GnssInfo::subscribeForGnssInfo getGNSSData with ERRORS!");
					(tVoid) unsetSysAdapterListener<dia_IGNSSListener>(this);
					return DIA_FAILED;
				 }
			}
		}
		else {
			DIA_TR_ERR("dia_GnssInfo::subscribeForGnssInfo querySysAdapterInterface<dia_IGNSSListener> ERROR!");
		}
	}

	return DIA_SUCCESS;
}

tVoid dia_GnssInfo::vOnGNSSReceiverStatus(const dia_tGNSSReceiverState& gnssReceiverState)
{
	if(gnssReceiverState.m_u8SatellitesVisible<33 && gnssReceiverState.m_u8SatellitesUsed<33 && gnssReceiverState.m_u8SatellitesReceived<33 && gnssReceiverState.m_u8SatellitesHealthy<33) {

		switch(gnssReceiverState.m_u8FixStatus)
		{
			case 0x01: // NOFIX:
				 m_gnssInfoElement.fixStatus = 0;
//				 DIA_TR_CUS("dia_GnssInfo::vOnGNSSReceiverStatus. FixStatus: NO-FIX");
				 break;
			case 0x02: //2DFIX:
				 m_gnssInfoElement.fixStatus = 1;
//				 DIA_TR_CUS("dia_GnssInfo::vOnGNSSReceiverStatus. FixStatus: 2D-FIX");
				 break;
			case 0x04: //3DFIX:
				 m_gnssInfoElement.fixStatus = 2;
//				 DIA_TR_CUS("dia_GnssInfo::vOnGNSSReceiverStatus. FixStatus: 3D-FIX");
				 break;
			default:
				 m_gnssInfoElement.fixStatus = 0;
				 break;
		}

//		DIA_TR_INF("dia_GnssInfo::vOnGNSSReceiverStatus. m_u8SatellitesReceived = %d / 0x%02x ." _ gnssReceiverState.m_u8SatellitesReceived _ gnssReceiverState.m_u8SatellitesReceived);
//		DIA_TR_INF("dia_GnssInfo::vOnGNSSReceiverStatus. m_u8SatellitesUsed     = %d / 0x%02x ." _ gnssReceiverState.m_u8SatellitesUsed _ gnssReceiverState.m_u8SatellitesUsed);
//		DIA_TR_INF("dia_GnssInfo::vOnGNSSReceiverStatus. m_u8SatellitesHealthy  = %d / 0x%02x ." _ gnssReceiverState.m_u8SatellitesHealthy _ gnssReceiverState.m_u8SatellitesHealthy);
//		DIA_TR_INF("dia_GnssInfo::vOnGNSSReceiverStatus. m_u8SatellitesVisible  = %d / 0x%02x ." _ gnssReceiverState.m_u8SatellitesVisible _ gnssReceiverState.m_u8SatellitesVisible);

        m_gnssReceiverStateAvailable = TRUE;
	}
	else {
		DIA_TR_INF("dia_GnssInfo::vOnGNSSReceiverStatus. FAIL");
	}
}

tVoid dia_GnssInfo::vOnGNSSTimeDate(tU16 year, tU8 month, tU8 day, tU8 hour, tU8 minute, tU8 second, tU16 /*millisecond*/) // millisecond is ignored
{
	snprintf(m_gnssInfoElement.dateStr, MAX_DATE_STR_LENGTH, "%.4d-%.2d-%.2d %.2d:%.2d:%.2d", year, month, day, hour, minute, second);

//	DIA_TR_CUS("dia_GnssInfo::vOnGNSSTimeDate. dateStr: '%s'", m_gnssInfoElement.dateStr);

	m_gnssTimeDateAvailable = TRUE;
}

tVoid dia_GnssInfo::vOnGNSSVelocity(tS16 s16VelocityNorth, tS16 s16VelocityEast, tS16 /*s16VelocityUp*/) // s16VelocityUp is ignored
{
	m_gnssInfoElement.velocityNorth = s16VelocityNorth;
	m_gnssInfoElement.velocityEast = s16VelocityEast;

//	DIA_TR_CUS("dia_GnssInfo::vOnGNSSVelocity. velocityNorth: %d, velocityEast: %d", m_gnssInfoElement.velocityNorth, m_gnssInfoElement.velocityEast);

	m_gnssVelocityAvailable = TRUE;
}

tVoid dia_GnssInfo::vOnGNSSPosition(tS32 LatitudeMSeconds, tS32 LongitudeMSeconds, tS16 Altitude)
{
	m_gnssInfoElement.latitudeMSeconds = LatitudeMSeconds;
	m_gnssInfoElement.longitudeMSeconds = LongitudeMSeconds;
	m_gnssInfoElement.altitude = Altitude;

	m_gpsPositionAvailable = TRUE;
}

tBool dia_GnssInfo::isGnssInfoAvailable()
{
	tBool gnssInfoAvailable = FALSE;

	if (m_gnssReceiverStateAvailable && m_gnssTimeDateAvailable && m_gnssVelocityAvailable && m_gpsPositionAvailable) {
		gnssInfoAvailable = TRUE;
	}

	return gnssInfoAvailable;
}

GnssInfoElement dia_GnssInfo::getGnssInfoElement()
{
	if (m_pGnss) {
		if (m_pGnss->getGNSSData() == DIA_SUCCESS) { // This will deliver the status for the next query
			m_gnssReceiverStateAvailable = FALSE;
			m_gnssTimeDateAvailable = FALSE;
			m_gnssVelocityAvailable = FALSE;
			m_gpsPositionAvailable = FALSE;
		}
	}

	return m_gnssInfoElement;
}
