/*!
 * \file       dia_DTCInfo.h
 *
 * \author     jas1hi
 *
 * \created on Feb 1, 2017
 *
 * \brief      Utility class for getting DTC information
 *
 * \details    DTCs by status mask=0x09 (Test failed + Confirmed DTC)
 *
 * \component  Diagnosis
 *
 * \ingroup    dia_DTCInfo
 *
 * \copyright  (c) 2011-2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */


#ifndef DIA_DTCINFO_H_
#define DIA_DTCINFO_H_

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include <common/interfaces/dia_IErrorLogListener.h>
#endif

typedef struct DTCInfoElement_ {
	tU32 dtc;
	tU8 status;

	DTCInfoElement_()
	{
		dtc = 0;
		status = 0;
	}

} DTCInfoElement;


class dia_DTCInfo:  public dia_IErrorLogListenerImpl
{
public:
	dia_DTCInfo();
	virtual ~dia_DTCInfo();

	/**
	 * \brief    	subscribe for DTC Info
	 *
	 *				Function subscribes to the SystemAdapter for getting the DTC Info.
	 *				The SystemAdapters return the actual values
	 */
	tDiaResult subscribeForErrorLog();

	virtual void vOnReadDTCbyStatusMaskResult(const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& errorLogList);

	virtual tBool isErrorLogSubscriptionDone() { return m_errorLogSubscriptionDone; }
	virtual tBool isDTCStatusAvailable() { return m_dtcStatusAvailable; }
	std::vector<DTCInfoElement> getDTCStatusList();

private:
	dia_IErrorLog* m_pErrorLog;

    tBool m_errorLogSubscriptionDone;
    tBool m_dtcStatusAvailable;

    tU8 m_statusMaskTestFailedAndConfirmedDTC;

	std::vector<DTCInfoElement> m_DTCInfoList;
};

#endif /* DIA_DTCINFO_H_ */
