/*
 * dia_DTCInfo.cpp
 *
 *  Created on: Feb 1, 2017
 *      Author: jas1hi
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include <vd_diaglog_if.h>

#include "dia_DTCInfo.h"

dia_DTCInfo::dia_DTCInfo()
: 	m_pErrorLog(OSAL_NULL),
  	m_errorLogSubscriptionDone(FALSE),
  	m_dtcStatusAvailable(FALSE),
  	m_statusMaskTestFailedAndConfirmedDTC(0x09) // 0x09:  Test failed + Confirmed DTC
{

}

dia_DTCInfo::~dia_DTCInfo()
{
	if (m_pErrorLog)
		m_pErrorLog = OSAL_NULL;
}

tDiaResult dia_DTCInfo::subscribeForErrorLog()
{
	dia_tclFnctTrace trc("dia_DTCInfo::subscribeForErrorLog");

	if (m_errorLogSubscriptionDone == FALSE) {
		DIA_TR_INF("dia_DTCInfo::subscribeForErrorLog()");

		if (querySysAdapterInterface<dia_IErrorLog>(&m_pErrorLog) == DIA_SUCCESS) {
			if( m_pErrorLog) {
				(void)setSysAdapterListener<dia_IErrorLogListener>(this);

				// Make the first request
				if (m_pErrorLog->getDTCbyStatusMask(DIAGLOG_MEMORY_CUSTOMER, m_statusMaskTestFailedAndConfirmedDTC) == DIA_SUCCESS) {  // One time request to get an actual status
					DIA_TR_INF("dia_CommunicationStatus::subscribeForTCUCommunicationStatus - getDTCbyStatusMask request for DTCList done!");
					m_errorLogSubscriptionDone = TRUE;
				}
				else {
					DIA_TR_ERR("dia_DTCInfo::subscribeForErrorLog - getDTCbyStatusMask request failed!!!");
					(void)unsetSysAdapterListener<dia_IErrorLogListener>(this);
					return DIA_FAILED;
				}
			}
			else {
				DIA_TR_ERR("dia_DTCInfo::subscribeForErrorLog - m_pErrorLog = NULL!!!");
				(void)unsetSysAdapterListener<dia_IErrorLogListener>(this);
				return DIA_FAILED;
			}
		}
		else {
			DIA_TR_ERR("dia_DTCInfo::subscribeForErrorLog - querySysAdapterInterface request failed!!!");
			return DIA_FAILED;
		}
	}

	return DIA_SUCCESS;
}

void dia_DTCInfo::vOnReadDTCbyStatusMaskResult(const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& errorLogList)
{
	DIA_TR_INF("dia_DTCInfo::vOnReadDTCbyStatusMaskResult - u8DTCStatusAvailabilityMask: 0x%X", u8DTCStatusAvailabilityMask);

	m_DTCInfoList.clear();

    std::list<tdia_IErrorLogResult>::iterator iter = errorLogList.begin();
	for ( ; iter != errorLogList.end(); iter++ ) {
		DTCInfoElement dtcInfoElement;
		dtcInfoElement.dtc = iter->u32DTC;
		dtcInfoElement.status = iter->u8Status;
		DIA_TR_INF("dia_DTCInfo::vOnReadDTCbyStatusMaskResult - DTC: 0x%X, status: 0x%X", iter->u32DTC, iter->u8Status);

		m_DTCInfoList.push_back(dtcInfoElement);
	}

	m_dtcStatusAvailable = TRUE;
}

std::vector<DTCInfoElement> dia_DTCInfo::getDTCStatusList()
{
	if (m_dtcStatusAvailable) {
		m_dtcStatusAvailable = FALSE;

		if (m_pErrorLog) {
			if (m_pErrorLog->getDTCbyStatusMask(DIAGLOG_MEMORY_CUSTOMER, m_statusMaskTestFailedAndConfirmedDTC) != DIA_SUCCESS) {  // This will deliver the status for the next query
				DIA_TR_ERR("dia_CommunicationStatus::subscribeForTCUCommunicationStatus - getDTCbyStatusMask request for DTCList FAILED!!!");
			}
		}
	}

	return m_DTCInfoList;
}
