/*!
 * \file       dia_ConfigInfo.h
 *
 * \author     jas1hi
 *
 * \created on Feb 13, 2017
 *
 * \brief      Utility class for getting Diag Configuration information
 *
 * \details	   ECU identification: VIN, ECU SW No (i.MX + V850), SW-ID (e.g. X119)
 *
 * \component  Diagnosis
 *
 * \ingroup    dia_ConfigInfo
 *
 * \copyright  (c) 2011-2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef DIA_CONFIGINFO_H_
#define DIA_CONFIGINFO_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#define MAX_SW_ID_STR_LENGTH            (tU16) 10  //max length of the SW-ID
#define MAX_VIN_STR_LENGTH   	        (tU16) 17  //max length of the VIN
#define MAX_ECU_SW_NO_STR_LENGTH        (tU16) 23  //max length of the ECU SW No.

typedef struct EcuIdentificationInfo_ {
	// SW-ID
	tChar sw_id[MAX_SW_ID_STR_LENGTH+1]; // +1 for terminating char '\0'
	// VIN
	tChar vin[MAX_VIN_STR_LENGTH+1];
	// ECU SW No
	tChar ecu_sw_no[MAX_ECU_SW_NO_STR_LENGTH+1];

	EcuIdentificationInfo_()
	{
		memset(sw_id, '\0', sizeof(tChar)*MAX_SW_ID_STR_LENGTH+1);
		memset(vin, '\0', sizeof(tChar)*MAX_VIN_STR_LENGTH+1);
		memset(ecu_sw_no, '\0', sizeof(tChar)*MAX_ECU_SW_NO_STR_LENGTH+1);
	}

}EcuIdentificationInfo;


class dia_ConfigInfo
{
public:
	dia_ConfigInfo();
	virtual ~dia_ConfigInfo();

	virtual tBool isConfigInfoAvailable() {return mConfigInfoAvailable;}

	tDiaResult requestEcuIdentificationInfo();
	EcuIdentificationInfo getEcuIdentificationInfo();

private:
	tDiaResult getSwId();
	tDiaResult getVIN();
	tDiaResult getEcuSwNo();

	tBool mConfigInfoAvailable;
	EcuIdentificationInfo mEcuIdentificationInfo;
};

#endif /* DIA_CONFIGINFO_H_ */
