/*
 * dia_ConfigInfo.cpp
 *
 *  Created on: Feb 13, 2017
 *      Author: jas1hi
 */

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#include "dia_ConfigInfo.h"


dia_ConfigInfo::dia_ConfigInfo()
: mConfigInfoAvailable(FALSE)
{

}

dia_ConfigInfo::~dia_ConfigInfo()
{

}

tDiaResult dia_ConfigInfo::requestEcuIdentificationInfo()
{
	if (getSwId() != DIA_SUCCESS)
	{
		DIA_TR_ERR("dia_ConfigInfo::requestEcuIdentificationInfo. Failed to get SW-ID...");
		return DIA_FAILED;
	}

	if (getVIN() != DIA_SUCCESS)
	{
		DIA_TR_ERR("dia_ConfigInfo::requestEcuIdentificationInfo. Failed to get VIN...");
		return DIA_FAILED;
	}

	if (getEcuSwNo() != DIA_SUCCESS)
	{
		DIA_TR_ERR("dia_ConfigInfo::requestEcuIdentificationInfo. Failed to get ECU SW No...");
		return DIA_FAILED;
	}

	mConfigInfoAvailable = TRUE;

	return DIA_SUCCESS;
}

tDiaResult dia_ConfigInfo::getSwId()
{
	tU32 propID = (tU32)DIA_PROP_VERSION_SW_CUSTOMER;

	// data memory
	std::vector<tU8> dataVec;

	// retrieve size of property
	tU16 length = dia_getPropertySize(propID); //DIA_PROP_LENGTH_MAX;
	dataVec.reserve(length);
	dataVec.resize(length);

	DIA_TR_INF("dia_ConfigInfo::getSwId - propID: 0x%X, length %d, dataVec.size() %d", propID, length, dataVec.size());

	tDiaResult retCode = dia_getProperty(propID, dataVec);
	if ( retCode == DIA_SUCCESS )
	{
		if (dataVec.size() <= MAX_SW_ID_STR_LENGTH)
		{
			DIA_TR_INF("dia_ConfigInfo::getSwId - length %d, dataVec.size() %d (new data)", length, dataVec.size());
			memcpy(mEcuIdentificationInfo.sw_id, &dataVec[0], sizeof(tChar)*dataVec.size());
		}
		else
		{
			DIA_TR_ERR("dia_ConfigInfo::getSwId. dataVec.size(%d) > MAX_SW_ID_STR_LENGTH(%d)", dataVec.size(), MAX_SW_ID_STR_LENGTH);
			return DIA_FAILED;
		}
	}
	else
	{
		DIA_TR_ERR("dia_ConfigInfo::getSwId. UNABLE TO READ ITEM (READ OPERATION FAILED)!!!");
		return DIA_FAILED;
	}

	return DIA_SUCCESS;
}

tDiaResult dia_ConfigInfo::getVIN()
{
	tU32 propID = (tU32)DIA_PROP_AIVI_VIN;

	// data memory
	std::vector<tU8> dataVec;

	// retrieve size of property
	tU16 length = dia_getPropertySize(propID); //DIA_PROP_LENGTH_MAX;
	dataVec.reserve(length);
	dataVec.resize(length);

	DIA_TR_INF("dia_ConfigInfo::getVIN - propID: 0x%X, length %d, dataVec.size() %d", propID, length, dataVec.size());

	tDiaResult retCode = dia_getProperty(propID, dataVec);
	if ( retCode == DIA_SUCCESS )
	{
		if (dataVec.size() <= MAX_VIN_STR_LENGTH)
		{
			DIA_TR_INF("dia_ConfigInfo::getVIN - length %d, dataVec.size() %d (new data)", length, dataVec.size());
			memcpy(mEcuIdentificationInfo.vin, &dataVec[0], sizeof(tChar)*dataVec.size());
		}
		else
		{
			DIA_TR_ERR("dia_ConfigInfo::getVIN. dataVec.size(%d) > MAX_VIN_STR_LENGTH(%d)", dataVec.size(), MAX_VIN_STR_LENGTH);
			return DIA_FAILED;
		}
	}
	else
	{
		DIA_TR_ERR("dia_ConfigInfo::getVIN. UNABLE TO READ ITEM (READ OPERATION FAILED)!!!");
		return DIA_FAILED;
	}

	return DIA_SUCCESS;
}

tDiaResult dia_ConfigInfo::getEcuSwNo()
{
	tU32 propID = (tU32)DIA_PROP_AIVI_ECU_SW_VERSION;

	// data memory
	std::vector<tU8> dataVec;

	// retrieve size of property
	tU16 length = dia_getPropertySize(propID); //DIA_PROP_LENGTH_MAX;
	dataVec.reserve(length);
	dataVec.resize(length);

	DIA_TR_INF("dia_ConfigInfo::getEcuSwNo - propID: 0x%X, length %d, dataVec.size() %d", propID, length, dataVec.size());

	tDiaResult retCode = dia_getProperty(propID, dataVec);
	if ( retCode == DIA_SUCCESS )
	{
		if (dataVec.size() <= MAX_ECU_SW_NO_STR_LENGTH)
		{
			DIA_TR_INF("dia_ConfigInfo::getEcuSwNo - length %d, dataVec.size() %d (new data)", length, dataVec.size());
			memcpy(mEcuIdentificationInfo.ecu_sw_no, &dataVec[0], sizeof(tChar)*dataVec.size());
		}
		else
		{
			DIA_TR_ERR("dia_ConfigInfo::getEcuSwNo. dataVec.size(%d) > MAX_ECU_SW_NO_STR_LENGTH(%d)", dataVec.size(), MAX_ECU_SW_NO_STR_LENGTH);
			return DIA_FAILED;
		}
	}
	else
	{
		DIA_TR_ERR("dia_ConfigInfo::getEcuSwNo. UNABLE TO READ ITEM (READ OPERATION FAILED)!!!");
		return DIA_FAILED;
	}

	return DIA_SUCCESS;
}

EcuIdentificationInfo dia_ConfigInfo::getEcuIdentificationInfo()
{
	DIA_TR_INF("dia_ConfigInfo::getEcuIdentificationInfo");

	return mEcuIdentificationInfo;
}
