/**
 * \file      dia_CommunicationStatus.h
 *
 * \brief     Utility class for getting the communication status (DTC/ITC) of target with external units (e.g. TCU, Meter, etc...)
 *
 *
 *  Created on: Jan 11, 2016
 *      Author: jas1hi
 *
 * \copyright Robert Bosch Car Multimedia 2015
 *--------------------------------------------------------------------------------------------------------------------

 * 24.02.2017		| 1.6	| NLK1KOR (RBCM  )	| implemented feature  Feature 	AIVI-38980 	Working class for the Communication (connection) status
 *--------------------------------------------------------------------------------------------------------------------
 */

#ifndef DIA_COMMUNICATIONSTATUS_H_
#define DIA_COMMUNICATIONSTATUS_H_

#ifndef __INCLUDED_DIA_NISSAN_INTERFACE_LISTENER_MCAN__
#include "project/interfaces/dia_INissanMCanInfoListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TCU_LISTENER__
#include "project/interfaces/dia_ITCUListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include "common/interfaces/dia_IErrorLogListener.h"
#endif


typedef struct dia_MeterConnectionInfo_ {
	// Connection status
	tU8 connectionstatusSWC;
	tU8 connectionstatusNAV;
	tU8 connectionstatusAUDIO;


	dia_MeterConnectionInfo_()
	{
		connectionstatusSWC = 0;
		connectionstatusNAV = 0;
		connectionstatusAUDIO = 0;
	}

}dia_MeterConnectionInfo;
class dia_CommunicationStatus: public dia_NissanMCanInfoListenerImpl, public dia_TCUListenerImpl , public dia_IErrorLogListenerImpl 
{
public:
	dia_CommunicationStatus();
	virtual ~dia_CommunicationStatus();

	/**
	 * \brief    	subscribe for ITC Info
	 *
	 *				Function subscribes to the SystemAdapter for getting the ITC Info.
	 *				The SystemAdapters return the actual values
	 */
	tDiaResult subscribeForCommunicationStatus();
	tDiaResult subscribeForMCANMeterConnectionStatus();
	 virtual void vOnMCanInfo ( const dia_NissanMCanInfo& nwInfo );
	 virtual void vOnConnectionInfo ( const dia_TCUConnectionInfo& nwInfo );
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	 virtual void vOnMCanMeterInfo(const std::vector<dia_meterMCANInfo> MCANMeterInfo);
#endif
	 //! notify ITC info
	 virtual void vOnITCInfo ( std::vector<dia_tITCInfo> const& );
	 virtual tU8 getTCUCommunicationStatus();


    virtual tBool isCommunicationStatusAvailable() {return m_communicationStatusAvailable;}
    virtual tBool isCommunicationStatusSubscriptionDone() {return m_communicationStatusSubscriptionDone;}

    //! returns bitcoded Communication Status
    virtual tU8 getCommunicationStatus();

	//void vGetITCInfo(void);

	tDiaResult subscribeForConnectionStatus();
	virtual tBool isConnectionStatusAvailable() { return m_connectionStatusAvailable; }
	virtual tBool isConnectionStatusSubscriptionDone() { return m_connectionStatusSubscriptionDone; }
	tU8 getConnectionStatus();
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	virtual tBool isMCANConnectionStatusAvailable() { return m_MCANConnectionStatusAvailable; }
	virtual tBool isMCANConnectionStatusSubscriptionDone() { return m_MCANConnectionStatusSubscriptionDone; }
	dia_MeterConnectionInfo getMeterConnectionStatus();
#endif
private:
    dia_INissanMCanInfo* m_pMInfo;
    dia_ITCU* m_pTCUInfo;

	tU8 m_u8TcucommunicationStatusByte;
	dia_IErrorLog* m_pErrorLog;

    tBool m_communicationStatusAvailable;
    tBool m_communicationStatusSubscriptionDone;

    tU8 m_meterMCANCommunicationStatus;
    tU8 m_tcuMCANCommunicationStatus;

	tBool m_connectionStatusAvailable;
	tBool m_connectionStatusSubscriptionDone;

	dia_eTCUConnectionStatusType m_eConnectionStatus;

	tBool m_MCANConnectionStatusSubscriptionDone;
	tBool m_MCANConnectionStatusAvailable;
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	dia_MeterConnectionInfo meterInfoElement;
#endif
    //void vGetITCInfo ( void ) const;

};

#endif /* DIA_COMMUNICATIONSTATUS_H_ */
