/*
 * dia_CommunicationStatus.cpp
 *
 *  Created on: Jan 11, 2016
 *      Author: jas1hi
 */
/*********************************************************************************************
* HISTORY:
*------------------------------------------------------------------------------------------------
* Date | Rev. | Author | Modification
*-------------------------------------------------------------------------------------------------- -
*Dec 22, 2016                               nlk1kor             implemented
                                                                AIVI-38980 XCP_Provider : Working class for the 
																Communication (connection) status
*-------------------------------------------------------------------------------------------------- -
*Jan 25, 2017                               nlk1kor             implemented
                                                                AIVI-38980 
																Working class for the Communication (connection) status

* 24.02.2017		| 1.6	| NLK1KOR (RBCM  )	| implemented feature  Feature 	AIVI-38980 	Working class for the Communication (connection) status
*--------------------------------------------------------------------------------------------------------------------
*-------------------------------------------------------------------------------------------------- -*/

#include "dia_CommunicationStatus.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

#define CONNECTION_ERROR					(tU8) 1
#define INDEX_MCAN_METER_CONNECTION_NOK  	(tU8) 1
#define INDEX_MCAN_TCU_CONNECTION_NOK  		(tU8) 2

#define INDEX_TCU_CONNECTION_NOK  		    (tU8) 4


#define INDEX_TCU_COM_ERROR  	            (tU8) 1
#define INDEX_TCU_OPEN_LOAD_ERROR  		    (tU8) 2
#define INDEX_TCU_ELECTRONIC_FAILURE  	    (tU8) 3



#define TCU_COMM_STATUS_OFF	                              (tU8) 0
#define TCU_COMM_STATUS_NOT_CONNECTED  		              (tU8) 1
#define TCU_COMM_STATUS_CONNECTION_WAIT                   (tU8) 2
#define TCU_COMM_STATUS_CONNECTED 	                      (tU8) 3
#define TCU_COMM_STATUS_CONNECTION_ERROR 	              (tU8) 4
#define TCU_COMM_STATUS_CONNECTION_WAIT_AFTER_ERROR	      (tU8) 5
  

dia_CommunicationStatus::dia_CommunicationStatus()
:	m_pMInfo(OSAL_NULL),
 	m_pTCUInfo(OSAL_NULL),
	m_pErrorLog(OSAL_NULL),
	m_communicationStatusAvailable(FALSE),
 	m_communicationStatusSubscriptionDone(FALSE),
 	m_meterMCANCommunicationStatus(0x00),
 	m_tcuMCANCommunicationStatus(0x00),
	m_MCANConnectionStatusSubscriptionDone(FALSE),
	m_MCANConnectionStatusAvailable(FALSE),
	m_u8TcucommunicationStatusByte(0),
	m_connectionStatusAvailable(FALSE),
	m_connectionStatusSubscriptionDone(FALSE),
	m_eConnectionStatus(DIA_EN_COMM_STATUS_OFF)//coverity 67694 fix:non-static class members are initialize in constructor.




{
	 dia_tclFnctTrace trc("dia_CommunicationStatus::dia_CommunicationStatus()");
}

dia_CommunicationStatus::~dia_CommunicationStatus()
{
	_BP_TRY_BEGIN
	{
	  (void) unsetSysAdapterListener<dia_INissanMCanInfoListener>(this);
	  (void) unsetSysAdapterListener<dia_ITCUListener>(this);
	  (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_CommunicationStatus::~dia_CommunicationStatus !!!");
	  DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END

	if (m_pMInfo)
		m_pMInfo = OSAL_NULL;

	if (m_pTCUInfo)
		m_pTCUInfo = OSAL_NULL;
	if (m_pErrorLog)
		m_pErrorLog = OSAL_NULL;
}

tDiaResult dia_CommunicationStatus::subscribeForCommunicationStatus()
{
	dia_tclFnctTrace trc("dia_CommunicationStatus::subscribeForCommunicationStatus");

	if (m_communicationStatusSubscriptionDone == FALSE && m_communicationStatusAvailable == FALSE)
	{
		DIA_TR_INF("dia_CommunicationStatus::subscribeForCommunicationStatus()");

		//----------- Absent State of Cluster
		if (querySysAdapterInterface<dia_INissanMCanInfo>(&m_pMInfo) == DIA_SUCCESS) {
			 if (m_pMInfo) {
				 (tVoid) setSysAdapterListener<dia_INissanMCanInfoListener>(this);
				 if (m_pMInfo->getNissanMCANInfo() == DIA_SUCCESS) { // One time request to get the actual value
					 DIA_TR_INF("dia_CommunicationStatus::subscribeForCommunicationStatus getNissanMCANInfo OK!");
			         m_communicationStatusSubscriptionDone = TRUE;
				 } else {
					DIA_TR_ERR("dia_CommunicationStatus::subscribeForCommunicationStatus getNissanMCANInfo with ERRORS!");
					(tVoid) unsetSysAdapterListener<dia_INissanMCanInfoListener>(this);
					return DIA_FAILED;
				 }
			}
		}
		else {
			DIA_TR_ERR("dia_CommunicationStatus::subscribeForCommunicationStatus querySysAdapterInterface<dia_INissanMCanInfo> ERROR!");
		}

//		#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
		   //------- Get Absent State of ECUs only relevant for Scope 2
		   //----------- Absent State of TCU
           if (querySysAdapterInterface<dia_ITCU>(&m_pTCUInfo) == DIA_SUCCESS) {
				 if (m_pTCUInfo) {
					 (tVoid) setSysAdapterListener<dia_ITCUListener>(this);
					 if (m_pTCUInfo->getConnectionInfo() == DIA_SUCCESS) { // One time request to get the actual value
						 DIA_TR_INF("dia_CommunicationStatus::subscribeForCommunicationStatus getConnectionInfo OK!");
				         m_communicationStatusSubscriptionDone = TRUE;
					 } else {
						DIA_TR_ERR("dia_CommunicationStatus::subscribeForCommunicationStatus getConnectionInfo with ERRORS!");
						(tVoid) unsetSysAdapterListener<dia_ITCUListener>(this);
						return DIA_FAILED;
					 }
				}
			}
            else {
            	DIA_TR_ERR("dia_CommunicationStatus::subscribeForCommunicationStatus querySysAdapterInterface<dia_ITCU> ERROR!");
            }
//		#endif

	}
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
		if ((DIA_SUCCESS == querySysAdapterInterface<dia_IErrorLog>(&m_pErrorLog)) && m_pErrorLog)
		{
			std::vector<tU16> oITCList;
			oITCList.push_back(ITC_AIVI_USB_TCU_COM_ERR);
			oITCList.push_back(ITC_AIVI_USB_TCU_OPEN);
			(void)setSysAdapterListener<dia_IErrorLogListener>(this);
			//m_TCUCommunicationStatusAvailable = FALSE;   check this
			if (m_pErrorLog->getItcInformation(DIAGLOG_MEMORY_CUSTOMER | DIAGLOG_MEMORY_BOSCH, oITCList) == DIA_SUCCESS)
			{
				DIA_TR_INF("dia_CommunicationStatus::subscribeForTCUCommunicationStatus - getItcInformation request for oITCList");
				//m_TCUCommunicationStatusSubscriptionDone = TRUE;
				m_communicationStatusSubscriptionDone = TRUE;
			}
			else
			{
				DIA_TR_INF("dia_CommunicationStatus::subscribeForTCUCommunicationStatus - getItcInformation request failed.");
				(void)unsetSysAdapterListener<dia_IErrorLogListener>(this);
				return DIA_FAILED;
			}
		}
		else
		{
			DIA_TR_INF("dia_CommunicationStatus::subscribeForTCUCommunicationStatus - getItcInformation request failed.");
		}
#endif
	return DIA_SUCCESS;
}

void dia_CommunicationStatus::vOnMCanInfo ( const dia_NissanMCanInfo& nwInfo )
{
	DIA_TR_INF("dia_CommunicationStatus::vOnMCanInfo - absent state AUD: 0x%X", nwInfo.u8AbsentState(DIA_EN_NISSAN_ECU_MCAN_AUD));
	DIA_TR_INF("dia_CommunicationStatus::vOnMCanInfo - absent state SWC: 0x%X", nwInfo.u8AbsentState(DIA_EN_NISSAN_ECU_MCAN_SWC));
	DIA_TR_INF("dia_CommunicationStatus::vOnMCanInfo - absent state NAV: 0x%X", nwInfo.u8AbsentState(DIA_EN_NISSAN_ECU_MCAN_NAV)); //Not supported for scope 1

	m_meterMCANCommunicationStatus = 0x00; // Reset the value
	if (nwInfo.u8AbsentState(DIA_EN_NISSAN_ECU_MCAN_AUD) != 0 || nwInfo.u8AbsentState(DIA_EN_NISSAN_ECU_MCAN_SWC) != 0 || nwInfo.u8AbsentState(DIA_EN_NISSAN_ECU_MCAN_NAV) != 0) {
		m_meterMCANCommunicationStatus = CONNECTION_ERROR;
	}
	DIA_TR_INF("dia_CommunicationStatus::vOnMCanInfo m_meterMCANCommunicationStatus: 0x%X", m_meterMCANCommunicationStatus);

	m_communicationStatusAvailable = TRUE;

//    tU8 val = u8MergeStatus(nwInfo.u8AbsentState(DIA_EN_NISSAN_ECU_MCAN_AUD), nwInfo.u8AbsentState(DIA_EN_NISSAN_ECU_MCAN_SWC));
//    val = u8MergeStatus(val, nwInfo.u8AbsentState(DIA_EN_NISSAN_ECU_MCAN_NAV)); //Not supported for scope 1
//    DIA_TR_INF("dia_CommunicationStatus::vOnMCanInfo - absent state merged: %x", val);

//    responseData[DIA_INDEX_ABSENT_CLUSTER] = val;
//    completionMask |= DIA_ABSENT_STATE_CLUSTER;
//    if ( completionMask == DIA_COMPLETION_MASK )
//    {
//        vGetITCInfo();
//    }
}

void dia_CommunicationStatus::vOnConnectionInfo ( const dia_TCUConnectionInfo& nwInfo )
{
	DIA_TR_INF("dia_CommunicationStatus::vOnConnectionInfo - absent state TCU: 0x%X", nwInfo.getAbsentState());

	m_tcuMCANCommunicationStatus = 0x00; // Reset the value
	if (nwInfo.getAbsentState() != 0) {
		m_tcuMCANCommunicationStatus = CONNECTION_ERROR;
	}
	if (nwInfo.getTCUConnectionStatus() != 0)
	{

		DIA_TR_INF("dia_CommunicationStatus::vOnConnectionInfo - getTCUConnectionType state TCU: %d", nwInfo.getTCUConnectionStatus());
		m_eConnectionStatus = nwInfo.getTCUConnectionStatus();
	}
	m_communicationStatusAvailable = TRUE;
	m_connectionStatusAvailable = TRUE;
}

tU8 dia_CommunicationStatus::getCommunicationStatus()
{
	tU8 communicationStatusByte = 0x00;

	// TODO: Status update should be done automatically in the corresponding SA (e.g. via subscription in startMonitoring() function)
	if (m_pMInfo) {
		if (m_pMInfo->getNissanMCANInfo() == DIA_SUCCESS) { // This will deliver the status for the next query
			switch (m_meterMCANCommunicationStatus) // Status from the previous query
			{
				case CONNECTION_ERROR:
					communicationStatusByte = communicationStatusByte | INDEX_MCAN_METER_CONNECTION_NOK;
					break;

				default: // CONNECTION_OK
					break;
			}
		}
	}

	if (m_pTCUInfo) {
		if (m_pTCUInfo->getConnectionInfo() == DIA_SUCCESS) { // This will deliver the status for the next query
			switch (m_tcuMCANCommunicationStatus) // Status from the previous query
			{
				case CONNECTION_ERROR:
					communicationStatusByte = communicationStatusByte | INDEX_MCAN_TCU_CONNECTION_NOK;
					break;

				default: // CONNECTION_OK
					break;
			}
		}
	}
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	if (m_pErrorLog) 
	{
		std::vector<tU16> oITCList;
		oITCList.push_back(ITC_AIVI_USB_TCU_COM_ERR);
		oITCList.push_back(ITC_AIVI_USB_TCU_OPEN);
		if (m_pErrorLog->getItcInformation(DIAGLOG_MEMORY_CUSTOMER | DIAGLOG_MEMORY_BOSCH, oITCList) == DIA_SUCCESS) 
		{ // This will deliver the status for the next query
			if (m_u8TcucommunicationStatusByte > 0)// Status from the previous query
			{
				DIA_TR_INF("dia_CommunicationStatus::m_u8TcucommunicationStatusByte > 0");
				communicationStatusByte = communicationStatusByte | INDEX_TCU_CONNECTION_NOK;   // CONNECTION_NOK
			}
		}
		
	}
#endif
	// Request ITCs
//	vGetITCInfo();

	return communicationStatusByte;
}

tU8 dia_CommunicationStatus::getConnectionStatus()
{
	tU8 connectionstatus = 0x00;

	// TODO: Status update should be done automatically in the corresponding SA (e.g. via subscription in startMonitoring() function)
	if (m_pTCUInfo)
	{
		if (m_pTCUInfo->registerForConnectionInfo() == DIA_SUCCESS)
		{ // This will deliver the status for the next query
			switch (m_eConnectionStatus) // Status from the previous query
			{
			case DIA_EN_COMM_STATUS_OFF:
				DIA_TR_INF("dia_CommunicationStatus::getConnectionStatus-COMM_STATUS_OFF");
				connectionstatus = TCU_COMM_STATUS_OFF;
				break;
			case DIA_EN_COMM_STATUS_NOT_CONNECTED:
				DIA_TR_INF("dia_CommunicationStatus::getConnectionStatus-COMM_STATUS_NOT_CONNECTED");
				connectionstatus = TCU_COMM_STATUS_NOT_CONNECTED;
				break;
			case DIA_EN_COMM_STATUS_CONNECTION_WAIT:
				DIA_TR_INF("dia_CommunicationStatus::getConnectionStatus-COMM_STATUS_CONNECTION_WAIT");
				connectionstatus = TCU_COMM_STATUS_CONNECTION_WAIT;
				break;
			case DIA_EN_COMM_STATUS_CONNECTED:
				DIA_TR_INF("dia_CommunicationStatus::getConnectionStatus-COMM_STATUS_CONNECTED");
				connectionstatus = TCU_COMM_STATUS_CONNECTED;
				break;
			case DIA_EN_COMM_STATUS_CONNECTION_ERROR:
				DIA_TR_INF("dia_CommunicationStatus::getConnectionStatus-COMM_STATUS_CONNECTION_ERROR");
				connectionstatus = TCU_COMM_STATUS_CONNECTION_ERROR;
				break;
			case DIA_EN_COMM_STATUS_CONNECTION_WAIT_AFTER_ERROR:
				DIA_TR_INF("dia_CommunicationStatus::getConnectionStatus-COMM_STATUS_CONNECTION_WAIT_AFTER_ERROR");
				connectionstatus = TCU_COMM_STATUS_CONNECTION_WAIT_AFTER_ERROR;
				break;
			default:
				DIA_TR_INF("dia_CommunicationStatus::getConnectionStatus-COMM_STATUS_OFF");
				connectionstatus = TCU_COMM_STATUS_OFF;
				break;
			}
		}
	}

	return connectionstatus;
}
//void dia_CommunicationStatus::vGetITCInfo ( void ) const
//{
//   dia_IErrorLog* pErrorLog = OSAL_NULL;
//   if ((DIA_SUCCESS == querySysAdapterInterface<dia_IErrorLog>(&pErrorLog)) && pErrorLog)
//   {
//      std::vector<tU16> oITCList;
//      oITCList.push_back(VDL_ITC_MCAN_BUS_OFF);
//
//   #if 1
//      oITCList.push_back(ITC_AIVI_MCAN_METER_AUD_CMF_MUTE_ERR);
//      oITCList.push_back(ITC_AIVI_MCAN_METER_SWC_CMF_MUTE_ERR);
//      oITCList.push_back(ITC_AIVI_MCAN_METER_NAV_CMF_MUTE_ERR); //Not supported for scope 1
//   #else
//      oITCList.push_back(ITC_AIVI_MCAN_METER_AUD_MPDT_MUTE_ERR);
//   #endif
//
////      tU8 u8Index = DIA_INDEX_ABSENT_CLUSTER;
////      if (responseData[u8Index] != 0xFF)
////      {
////         tU8 counterValue = responseData[u8Index] & 0x3F;
////         if (counterValue == 0)
////         {
//            oITCList.push_back(VDL_ITC_MCAN_METER_AUD_COM_ERR);
//            oITCList.push_back(VDL_ITC_MCAN_METER_SWC_COM_ERR);
//            //oITCList.push_back(VDL_ITC_MCAN_METER_NAV_COM_ERR); //Not supported for scope 1
////         }
////      }
//
////#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
//      //Scope 2
////      u8Index = DIA_INDEX_ABSENT_TCU;
////      if (responseData[u8Index] != 0xFF)
////      {
////         tU8 counterValue = responseData[u8Index] & 0x3F;
////         if (counterValue == 0)
////         {
//            oITCList.push_back(ITC_AIVI_MCAN_TCU_COM_ERR);
////         }
////      }
////#endif
//
//      if ( pErrorLog->getItcInformation(0xFF, oITCList) == DIA_SUCCESS )
//      {
//    	  DIA_TR_INF("dia_CommunicationStatus::vGetITCInfo - getItcInformation request for oITCList.size %04x", ETG_LIST_LEN(oITCList.size()) /*, ETG_LIST_PTR_T16(const_cast<tU16*>(&oITCList[0]))*/);
//      }
//      else
//      {
//    	  DIA_TR_ERR("dia_CommunicationStatus::vGetITCInfo - getItcInformation request failed.");
//      }
//   }
//   else
//   {
//	   DIA_TR_ERR("dia_CommunicationStatus::vGetITCInfo - getItcInformation request failed. Pointer: %x", (tU32) pErrorLog);
//   }
//}

//void dia_CommunicationStatus::vOnITCInfo ( const std::vector<dia_tITCInfo>& roITCInfoList)
//{
//    DIA_TR_INF("dia_CommunicationStatus::vOnITCInfo roITCInfoList.size() %d", roITCInfoList.size());
//
//    for(::size_t i = 0; i < roITCInfoList.size(); ++i)
//    {
//        switch(roITCInfoList[i].m_u16ITC)
//        {
//        case VDL_ITC_MCAN_BUS_OFF:
//            DIA_TR_INF("dia_CommunicationStatus::vOnITCInfo VDL_ITC_MCAN_BUS_OFF");
//            break;
//        case VDL_ITC_MCAN_METER_AUD_COM_ERR:
//        	DIA_TR_INF("dia_CommunicationStatus::vOnITCInfo VDL_ITC_MCAN_METER_AUD_COM_ERR");
//            break;
//        case VDL_ITC_MCAN_METER_SWC_COM_ERR:
//        	DIA_TR_INF("dia_CommunicationStatus::vOnITCInfo VDL_ITC_MCAN_METER_SWC_COM_ERR");
//            break;
//        case VDL_ITC_MCAN_METER_NAV_COM_ERR:
//        	DIA_TR_INF("dia_CommunicationStatus::vOnITCInfo VDL_ITC_MCAN_METER_NAV_COM_ERR");
//            break;
//#if 1
//        case ITC_AIVI_MCAN_METER_AUD_CMF_MUTE_ERR:
//        	DIA_TR_INF("dia_CommunicationStatus::vOnITCInfo ITC_AIVI_MCAN_METER_AUD_CMF_MUTE_ERR");
//            break;
//        case ITC_AIVI_MCAN_METER_SWC_CMF_MUTE_ERR:
//        	DIA_TR_INF("dia_CommunicationStatus::vOnITCInfo ITC_AIVI_MCAN_METER_SWC_CMF_MUTE_ERR");
//            break;
//#if 0 //STC2HI: Need to clarify
//        case ITC_AIVI_MCAN_METER_NAV_CMF_MUTE_ERR:
//        	DIA_TR_INF("dia_CommunicationStatus::vOnITCInfo ITC_AIVI_MCAN_METER_NAV_CMF_MUTE_ERR");
//            break;
//#endif
//#else
//        case ITC_AIVI_MCAN_METER_AUD_MPDT_MUTE_ERR:
//        	DIA_TR_INF("dia_CommunicationStatus::vOnITCInfo ITC_AIVI_MCAN_METER_AUD_MPDT_MUTE_ERR");
//            break;
//#endif
//        case ITC_AIVI_MCAN_TCU_COM_ERR:
//        	DIA_TR_INF("dia_CommunicationStatus::vOnITCInfo ITC_AIVI_MCAN_TCU_COM_ERR");
//            break;
//        default:
//        	DIA_TR_ERR("dia_CommunicationStatus::vOnITCInfo Unknown error: 0x%X", roITCInfoList[i].m_u16ITC);
//            break;
//        }
//    }
//}
////-----------------------------------------------------------------------------

void dia_CommunicationStatus::vOnITCInfo(const std::vector<dia_tITCInfo>& roITCInfoList)
{
	const tU8 c_confirmedBit = 0x08;
	m_u8TcucommunicationStatusByte = 0x00;
	dia_tclFnctTrace trc("dia_CommunicationStatus::vOnITCInfo");


	DIA_TR_INF("dia_CommunicationStatus::vOnITCInfo roITCInfoList.size() %d", roITCInfoList.size());

	for (::size_t i = 0; i < roITCInfoList.size(); ++i)
	{
		switch (roITCInfoList[i].m_u16ITC)
		{
		case ITC_AIVI_USB_TCU_COM_ERR:
			DIA_TR_INF("dia_CommunicationStatus::vOnITCInfo ITC_AIVI_USB_TCU_COM_ERR");
			if(roITCInfoList[i].m_u8Status & c_confirmedBit)
			{
				m_u8TcucommunicationStatusByte = m_u8TcucommunicationStatusByte | INDEX_TCU_COM_ERROR;
			}
			break;
		case ITC_AIVI_USB_TCU_OPEN:
			DIA_TR_INF("dia_CommunicationStatus::vOnITCInfo ITC_AIVI_USB_TCU_OPEN");
			if (roITCInfoList[i].m_u8Status & c_confirmedBit)
			{
				m_u8TcucommunicationStatusByte = m_u8TcucommunicationStatusByte | INDEX_TCU_OPEN_LOAD_ERROR;
			}
			break;
	/*	case ITC_AIVI_USB_TCU_ELECTRONIC_FAILURE_ERR:                                                                //apply these changes once supported by fc_tcu_usb module.
			DIA_TR_INF("dia_CommunicationStatus::vOnITCInfo ITC_AIVI_USB_TCU_COM_ERR");
			m_u8TcucommunicationStatusByte = m_u8TcucommunicationStatusByte | INDEX_TCU_ELECTRONIC_FAILURE;
			break;*/
		default:
			break;
		}
	}

	m_communicationStatusAvailable = TRUE;
}

tU8 dia_CommunicationStatus::getTCUCommunicationStatus()
{
	DIA_TR_INF("dia_CommunicationStatus::getTCUCommunicationStatus. m_u8TcucommunicationStatusByte : 0x%X", m_u8TcucommunicationStatusByte);
	return m_u8TcucommunicationStatusByte;
}
/**********************************************************************************************************************************************************************/
tDiaResult dia_CommunicationStatus::subscribeForConnectionStatus()
{
	dia_tclFnctTrace trc("dia_CommunicationStatus::subscribeForConnectionStatus");

	if (m_connectionStatusSubscriptionDone == FALSE && m_connectionStatusAvailable == FALSE)
	{
		DIA_TR_INF("dia_CommunicationStatus::subscribeForConnectionStatus()");
		if (querySysAdapterInterface<dia_ITCU>(&m_pTCUInfo) == DIA_SUCCESS) {
			if (m_pTCUInfo) {
				(tVoid)setSysAdapterListener<dia_ITCUListener>(this);
				if (m_pTCUInfo->registerForConnectionInfo() == DIA_SUCCESS) { // One time request to get the actual value
					DIA_TR_INF("dia_CommunicationStatus::subscribeForConnectionStatus registerForConnectionInfo OK!");
					m_connectionStatusSubscriptionDone = TRUE;
				}
				else {
					DIA_TR_ERR("dia_CommunicationStatus::subscribeForConnectionStatus registerForConnectionInfo with ERRORS!");
					(tVoid)unsetSysAdapterListener<dia_ITCUListener>(this);
					return DIA_FAILED;
				}
			}
		}
		else {
			DIA_TR_ERR("dia_CommunicationStatus::subscribeForConnectionStatus querySysAdapterInterface<dia_ITCU> ERROR!");
			return DIA_FAILED;
		}
		//		#endif

	}
	return DIA_SUCCESS;
}

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
tDiaResult dia_CommunicationStatus::subscribeForMCANMeterConnectionStatus()
{
	dia_tclFnctTrace trc("dia_CommunicationStatus::subscribeForMCANMeterConnectionStatus");
	DIA_TR_INF("dia_CommunicationStatus::subscribeForMCANMeterConnectionStatus()");
	if (m_MCANConnectionStatusSubscriptionDone == FALSE && m_MCANConnectionStatusAvailable == FALSE)
	{
		DIA_TR_INF("dia_CommunicationStatus::subscribeForMCANMeterConnectionStatus()");

		//----------- Absent State of Cluster
		if (querySysAdapterInterface<dia_INissanMCanInfo>(&m_pMInfo) == DIA_SUCCESS) {
			if (m_pMInfo) {
				(tVoid)setSysAdapterListener<dia_INissanMCanInfoListener>(this);
				if (m_pMInfo->getNissanMCANMeterInfo() == DIA_SUCCESS) { // One time request to get the actual value
					DIA_TR_INF("dia_CommunicationStatus::subscribeForMCANMeterConnectionStatus getNissanMCANInfo OK!");
					m_MCANConnectionStatusSubscriptionDone = TRUE;
				}
				else {
					DIA_TR_ERR("dia_CommunicationStatus::subscribeForMCANMeterConnectionStatus getNissanMCANInfo with ERRORS!");
					(tVoid)unsetSysAdapterListener<dia_INissanMCanInfoListener>(this);
					return DIA_FAILED;
				}
			}
		}
		else {
			DIA_TR_ERR("dia_CommunicationStatus::subscribeForMCANMeterConnectionStatus querySysAdapterInterface<dia_INissanMCanInfo> ERROR!");
		}
		return DIA_SUCCESS;
	}
}

	void dia_CommunicationStatus::vOnMCanMeterInfo(const std::vector<dia_meterMCANInfo> MCANMeterInfo)
	{
		DIA_TR_INF("dia_CommunicationStatus:vOnMCanMeterInfo");
		if (!MCANMeterInfo.empty())
		{
			for (tU16 i = 0; i < MCANMeterInfo.size();i++)
			{
				switch (MCANMeterInfo[i].McanDeviceType)
				{
				case DIA_EN_NISSAN_MCAN_SWC:
					meterInfoElement.connectionstatusSWC = MCANMeterInfo[i].McanConnectionState;
					DIA_TR_INF("dia_CommunicationStatus:vOnMCanMeterInfo: connectionstatusSWC = %d", MCANMeterInfo[i].McanConnectionState);
					break;
				case DIA_EN_NISSAN_MCAN_AUD:
					meterInfoElement.connectionstatusAUDIO = MCANMeterInfo[i].McanConnectionState;
					DIA_TR_INF("dia_CommunicationStatus:vOnMCanMeterInfo: connectionstatusAUDIO = %d", MCANMeterInfo[i].McanConnectionState);
					break;
				case DIA_EN_NISSAN_MCAN_NAV:
					meterInfoElement.connectionstatusNAV = MCANMeterInfo[i].McanConnectionState;
					DIA_TR_INF("dia_CommunicationStatus:vOnMCanMeterInfo: connectionstatusNAV = %d", MCANMeterInfo[i].McanConnectionState);
					break;
				default:
					break;
				}
			}
			m_MCANConnectionStatusAvailable = TRUE;
		}

	}

dia_MeterConnectionInfo dia_CommunicationStatus::getMeterConnectionStatus()
	{
		DIA_TR_INF("dia_CommunicationStatus::getMeterConnectionStatus");
		return meterInfoElement;
	}
#endif