/**
 * \file      dia_ClockSWCConnectionStatusInfo.h
 *
 * \brief     Utility class for getting the SWC connection info 
 *
 *
 *  Created on: Oct 3, 2017
 *      Author: nlk1kor
 *
 * \copyright Robert Bosch Car Multimedia 2016
 */

#ifndef DIA_CLOCKSWCCONNECTIONSTATUSINFO_H_
#define DIA_CLOCKSWCCONNECTIONSTATUSINFO_H_

#ifndef __INCLUDED_DIA_INTERFACE_SWC_LISTENER__
#include "project/interfaces/dia_ISWControlListener.h"
#endif


class dia_ClockSWCConnectionStatusInfo : public dia_ISWControlListenerImpl
{
public :
	dia_ClockSWCConnectionStatusInfo();
	virtual ~dia_ClockSWCConnectionStatusInfo();
	tDiaResult subscribeForSWCConnectionInfo();
	tBool isSubscribeForSWCConnectionStatusInfoDone() {return mSWCConnectionStatusInfoSubscriptionDone;}
	tBool isSWCConnectionInfoAvailable() {return mSWCConnectionInfoAvailable;}
   //! notify SWC connection info
   virtual void vOnSWCConnectionInfo ( const dia_SWCConnectionInfo& );
   tU8 getSWCConnectionInfo();
private :
	tBool mSWCConnectionStatusInfoSubscriptionDone;
	tBool mSWCConnectionInfoAvailable;
    tU8 m_SWCConnectedState;
};
#endif /* DIA_CLOCKSWCCONNECTIONSTATUSINFO_H_ */

