/*
 * dia_ClockSWCConnectionStatusInfo.cpp
 *
 *  Created on: Oct 3, 2017
 *      Author: nlk1kor
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_ClockSWCConnectionStatusInfo.h"


//**********************************************************************************************************************************************

dia_ClockSWCConnectionStatusInfo::dia_ClockSWCConnectionStatusInfo()
	: mSWCConnectionStatusInfoSubscriptionDone(FALSE),
	  mSWCConnectionInfoAvailable(FALSE),
	  m_SWCConnectedState(0)
{
	dia_tclFnctTrace trc("dia_ClockSWCConnectionStatusInfo::dia_ClockSWCConnectionStatusInfo()");
}


//*************************************************************************************************************************************************

dia_ClockSWCConnectionStatusInfo::~dia_ClockSWCConnectionStatusInfo()
{
	_BP_TRY_BEGIN
	{
	  (void) unsetSysAdapterListener<dia_ISWControlListener>(this);
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_ClockSWCConnectionStatusInfo::~dia_ClockSWCConnectionStatusInfo !!!");
	  DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END


}

//*************************************************************************************************************************************************

tDiaResult dia_ClockSWCConnectionStatusInfo::subscribeForSWCConnectionInfo()
{
	dia_tclFnctTrace trc("dia_ClockSWCConnectionStatusInfo::subscribeForSWCConnectionInfo");

	if (mSWCConnectionStatusInfoSubscriptionDone == FALSE)
	{
		DIA_TR_INF("dia_ClockSWCConnectionStatusInfo::subscribeForSWCConnectionInfo()");
        dia_ISWControl* pSWControl = 0;
		if (querySysAdapterInterface<dia_ISWControl>(&pSWControl) == DIA_SUCCESS)
		{
			 if (pSWControl)
			 {
				 (tVoid) setSysAdapterListener<dia_ISWControlListener>(this);
				 if (pSWControl->registerToSWCConnectionInfo() != DIA_SUCCESS)
				 {
					 (tVoid)unsetSysAdapterListener<dia_ISWControlListener>(this);
					 DIA_TR_ERR("dia_ClockSWCConnectionStatusInfo::subscribeForSWCConnectionInfo registerToSWCConnectionInfo() with ERRORS!");
					 return DIA_FAILED;
				 }
				 DIA_TR_INF("dia_ClockSWCConnectionStatusInfo::subscribeForSWCConnectionInfo DONE!!!");

				 mSWCConnectionStatusInfoSubscriptionDone = TRUE;
			}
		}
	}

	return DIA_SUCCESS;
}

//******************************************************************************************************************************************************
 void dia_ClockSWCConnectionStatusInfo::vOnSWCConnectionInfo ( const dia_SWCConnectionInfo& swcInfo)
{
	m_SWCConnectedState = 0;
   dia_tclFnctTrace trc("dia_ClockSWCConnectionStatusInfo::vOnSWCConnectionInfo(dia_SWCConnectionInfo)");

   //(void) unsetSysAdapterListener<dia_ISWControlListener>(this);

   m_SWCConnectedState = swcInfo.getConnectionState();

   DIA_TR_INF("dia_ClockSWCConnectionStatusInfo::vOnSWCConnectionInfo - connection state SWC: 0x%x", m_SWCConnectedState);

   mSWCConnectionInfoAvailable = TRUE;

}
//******************************************************************************************************************************************************
tU8 dia_ClockSWCConnectionStatusInfo::getSWCConnectionInfo ()
{
	return m_SWCConnectedState;
}

