/**
 * \file      dia_CardStatus.h
 *
 * \brief     Utility class for getting the status of the card (external USB) connected to the target
 * 			  Additionally it provides some data (e.g. I/O rate) related to an internal eMMC card
 *
 *
 *  Created on: Jan 18, 2016
 *      Author: jas1hi
 *
 * \copyright Robert Bosch Car Multimedia 2016
 */
 /*********************************************************************************************
* REVISION HISTORY:
* ------------------------------------------------------------------------------------------------
* Date 				| Rev. 				| Author 		   	| Modification
* ------------------------------------------------------------------------------------------------
*--------------------------------------------------------------------------------------------------------------------
* 02.09.2016		| 1.1	| NLK1KOR (RBEI)	| Implemented feature AIVINS2-19070 Connection status - Optic Disk 
                                                  Connection Status
*--------------------------------------------------------------------------------------------------------------------
*--------------------------------------------------------------------------------------------------------------------
*******************************************************************************************************************************/
#ifndef DIA_CARDSTATUS_H_
#define DIA_CARDSTATUS_H_


#ifndef __INCLUDED_DIA_INTERFACE_DEVICE_MANAGER_LISTENER__
#include "common/interfaces/dia_IDeviceMGRListener.h"
#endif

#ifndef __INCLUDE_DIA_ACTIVE_OBJECT__
#include "common/framework/application/dia_ActiveObject.h"
#endif


class dia_CardStatus: public dia_IDeviceMGRListenerImpl, public dia_ActiveObject
{
public:
	dia_CardStatus();
	virtual ~dia_CardStatus();

	/**
	 * \brief    	subscribe for Card status
	 *
	 *				Function subscribes to the SystemAdapter for getting the Card status.
	 *				The SystemAdapters return the actual values
	 */
	tDiaResult subscribeForCardStatus();

	void vOnUSBDeviceInfo (const std::vector<dia_tDeviceInfo>& deviceInfoList);

    virtual tBool isUSBStatusAvailable() {return m_USBStatusAvailable;}
    virtual tBool iseMMCStatusAvailable() {return m_eMMCStatusAvailable;}
    virtual tBool isCardStatusSubscriptionDone() {return m_cardStatusSubscriptionDone;}
// #ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	virtual tBool isOpticDiskStatusAvailable() {return m_OpticDiskStatusAvailable;}
    virtual tBool isOpticDiskStatusSubscriptionDone() {return m_OpticDiskStatusSubscriptionDone;}
	void vOnOpticDiskConnectionStatus(const  dia_eOpticalDiscSlotState eOpticDiskStatus);
	tU8 getOpticDiskConStatusResult();
// #endif

	//! returns different values (Size, status, FileSystem type, I/O rate) related to USB (latest connected)
    virtual dia_tDeviceInfo getUSBCardStatus();
    virtual tDouble geteMMCReadSpeed();

protected:
    //! @brief Entry point for thread
    //! @param[in,out] pvArg pointer to instances of input&output parameters.
    virtual void vThreadEntrypointObject(void);

private:
    dia_IDeviceMGR* m_pDeviceMGR;
    tBool m_USBStatusAvailable;
    tBool m_eMMCStatusAvailable;
    tBool m_cardStatusSubscriptionDone;
	tBool m_OpticDiskStatusAvailable;
    tBool m_OpticDiskStatusSubscriptionDone;
// #ifdef VARIANT_S_FTR_ENABLE_RNAIVI
    tU8 m_u8OpticDiskConnectionStatus;
// #endif
    std::vector<dia_tDeviceInfo> m_deviceInfoList;
    tDouble m_eMMCReadSpeed;

    //! true if thread has been started and not finished yet, otherwise false
    tBool m_threadStarted;
};

#endif /* DIA_CARDSTATUS_H_ */
