/**
 * \file      dia_BoseAmpInfo.h
 *
 * \brief     Utility class for getting the Audio Bose Amplifier info 
 *
 *
 *  Created on: August 4, 2017
 *      Author: Neera K Ponnappa
 *
 * \copyright Robert Bosch Car Multimedia 2016
 */

#ifndef DIA_BOSEAMPINFO_H_
#define DIA_BOSEAMPINFO_H_

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO_LISTENER__
#include "common/interfaces/dia_IAudioListener.h"
#endif
struct dia_tBoseAmpSWVersionData
{
public:
   //! default constructor
   dia_tBoseAmpSWVersionData ( void )
      : LargeVersion(0),
        MiddleVersion(0),
		SmallVersion(0)
   {}

   //! copy constructor
   dia_tBoseAmpSWVersionData ( const dia_tBoseAmpSWVersionData& obj )
      : LargeVersion(obj.LargeVersion),
        MiddleVersion(obj.MiddleVersion),
		SmallVersion(obj.SmallVersion)
   {}

   //! assignment operator
   dia_tBoseAmpSWVersionData& operator = ( const dia_tBoseAmpSWVersionData& obj )
   {
      if ( this != &obj ) {
         LargeVersion = obj.LargeVersion;
         MiddleVersion = obj.MiddleVersion;
		 SmallVersion = obj.SmallVersion;
      }
      return *this;
   }

   //! class constructor
   dia_tBoseAmpSWVersionData(
         tU8 LargeVersion,
         tU8 MiddleVersion,
		 tU8 SmallVersion
      )
      : LargeVersion(0),
        MiddleVersion(0),
		SmallVersion(0)
   {}

public:
  tU8 LargeVersion;
  tU8 MiddleVersion;
  tU8 SmallVersion;
};

class dia_BoseAmpInfo : public dia_IAudioListenerImpl
{
public :
	dia_BoseAmpInfo();
	virtual ~dia_BoseAmpInfo();
	tDiaResult subscribeForBoseAmpANCVersionInfo();
	tDiaResult subscribeForBoseAmpASCVersionInfo();
	tBool isSubscribeForBoseAmpANCVersionInfoDone() {return mBoseAmpANCVersionInfoSubscriptionDone;}
	tBool isBoseAmpANCVersionInfoAvailable() {return mBoseAmpANCVersionInfoAvailable;}
	tBool isSubscribeForBoseAmpASCVersionInfoDone() {return mBoseAmpASCVersionInfoSubscriptionDone;}
	tBool isBoseAmpASCVersionInfoAvailable() {return mBoseAmpASCVersionInfoAvailable;}
    dia_tBoseAmpSWVersionData getANCSoftwareInfo ();
    dia_tBoseAmpSWVersionData getASCSoftwareInfo ();

   //! response to regToANCSWVersion
   virtual void onANCSWVersionUpdate ( const dia_tBoseAmpSWVersionInfo /*info*/ );
   //! response to regToASCSWVersion
   virtual void onASCSWVersionUpdate ( const dia_tBoseAmpSWVersionInfo /*info*/ );

private :
	tBool mBoseAmpANCVersionInfoSubscriptionDone;
	tBool mBoseAmpANCVersionInfoAvailable;
	tBool mBoseAmpASCVersionInfoSubscriptionDone;
	tBool mBoseAmpASCVersionInfoAvailable;
	dia_tBoseAmpSWVersionData mBoseAmpANCSWVersion;
	dia_tBoseAmpSWVersionData mBoseAmpASCSWVersion;
   
};
#endif /* DIA_BOSEAMPINFO_H_ */

