/*
 * dia_BoseAmpInfo.cpp
 *
 *  Created on: August 4, 2017
 *      Author: nlk1kor
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_BoseAmpInfo.h"


//**********************************************************************************************************************************************

dia_BoseAmpInfo::dia_BoseAmpInfo()
	: mBoseAmpANCVersionInfoSubscriptionDone(FALSE),
	  mBoseAmpANCVersionInfoAvailable(FALSE),
	  mBoseAmpASCVersionInfoSubscriptionDone(FALSE),
	  mBoseAmpASCVersionInfoAvailable(FALSE)
{
	dia_tclFnctTrace trc("dia_BoseAmpInfo::dia_BoseAmpInfo()");
}


//*************************************************************************************************************************************************

dia_BoseAmpInfo::~dia_BoseAmpInfo()
{
	_BP_TRY_BEGIN
	{
	  (void) unsetSysAdapterListener<dia_IAudioListener>(this);
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_BoseAmpInfo::~dia_BoseAmpInfo !!!");
	  DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END


}

//*************************************************************************************************************************************************

tDiaResult dia_BoseAmpInfo::subscribeForBoseAmpANCVersionInfo()
{
	dia_tclFnctTrace trc("dia_BoseAmpInfo::subscribeForBoseAmpANCVersionInfo");

	if (mBoseAmpANCVersionInfoSubscriptionDone == FALSE)
	{
		DIA_TR_INF("dia_BoseAmpInfo::subscribeForBoseAmpANCVersionInfo()");
        dia_IAudio* pAudio = 0;
		if (querySysAdapterInterface<dia_IAudio>(&pAudio) == DIA_SUCCESS)
		{
			 if (pAudio)
			 {
				 (tVoid) setSysAdapterListener<dia_IAudioListener>(this);
				 if (pAudio->regToANCSWVersion() != DIA_SUCCESS)
				 {
					 (tVoid)unsetSysAdapterListener<dia_IAudioListener>(this);
					 DIA_TR_ERR("dia_BoseAmpInfo::subscribeForBoseAmpANCVersionInfo regToANCSWVersion() with ERRORS!");
					 return DIA_FAILED;
				 }
				 DIA_TR_INF("dia_BoseAmpInfo::subscribeForBoseAmpANCVersionInfo DONE!!!");

				 mBoseAmpANCVersionInfoSubscriptionDone = TRUE;
			}
		}
	}

	return DIA_SUCCESS;
}
//*************************************************************************************************************************************************

tDiaResult dia_BoseAmpInfo::subscribeForBoseAmpASCVersionInfo()
{
	dia_tclFnctTrace trc("dia_BoseAmpInfo::subscribeForBoseAmpASCVersionInfo");

	if (mBoseAmpASCVersionInfoSubscriptionDone == FALSE)
	{
		DIA_TR_INF("dia_BoseAmpInfo::subscribeForBoseAmpASCVersionInfo()");
        dia_IAudio* pAudio = 0;
		if (DIA_SUCCESS == querySysAdapterInterface<dia_IAudio>(&pAudio))
		{
			 if (pAudio)
			 {
				 (tVoid) setSysAdapterListener<dia_IAudioListener>(this);
				 if (pAudio->regToASCSWVersion() != DIA_SUCCESS)
				 {
					 (tVoid)unsetSysAdapterListener<dia_IAudioListener>(this);
					 DIA_TR_ERR("dia_BoseAmpInfo::subscribeForBoseAmpASCVersionInfo regToANCSWVersion() with ERRORS!");
					 return DIA_FAILED;
				 }
				 DIA_TR_INF("dia_BoseAmpInfo::subscribeForBoseAmpASCVersionInfo DONE!!!");

				 mBoseAmpASCVersionInfoSubscriptionDone = TRUE;
			}
		}
	}

	return DIA_SUCCESS;
}


   //! response to regToANCSWVersion
 void  dia_BoseAmpInfo::onANCSWVersionUpdate (const dia_tBoseAmpSWVersionInfo ancSWinfo )
 {
	 DIA_TR_INF("dia_BoseAmpInfo::onANCSWVersionUpdate()");
	 DIA_TR_INF("dia_BoseAmpInfo::onANCSWVersionUpdate() ancSWinfo.LargeVersion = %d",ancSWinfo.LargeVersion);
	 DIA_TR_INF("dia_BoseAmpInfo::onANCSWVersionUpdate() ancSWinfo.MiddleVersion = %d",ancSWinfo.MiddleVersion);
	 DIA_TR_INF("dia_BoseAmpInfo::onANCSWVersionUpdate() ancSWinfo.SmallVersion = %d",ancSWinfo.SmallVersion);
	 mBoseAmpANCSWVersion.LargeVersion = ancSWinfo.LargeVersion;
	 mBoseAmpANCSWVersion.MiddleVersion = ancSWinfo.MiddleVersion;
	 mBoseAmpANCSWVersion.SmallVersion = ancSWinfo.SmallVersion;
     mBoseAmpANCVersionInfoAvailable = TRUE;
	 
 }
   //! response to regToASCSWVersion
 void  dia_BoseAmpInfo::onASCSWVersionUpdate (const dia_tBoseAmpSWVersionInfo ascSWinfo )
 {
	 DIA_TR_INF("dia_BoseAmpInfo::onASCSWVersionUpdate()");
	 DIA_TR_INF("dia_BoseAmpInfo::onANCSWVersionUpdate() ascSWinfo.LargeVersion = %d",ascSWinfo.LargeVersion);
	 DIA_TR_INF("dia_BoseAmpInfo::onANCSWVersionUpdate() ascSWinfo.MiddleVersion = %d",ascSWinfo.MiddleVersion);
	 DIA_TR_INF("dia_BoseAmpInfo::onANCSWVersionUpdate() ascSWinfo.SmallVersion = %d",ascSWinfo.SmallVersion);
	 mBoseAmpASCSWVersion.LargeVersion = ascSWinfo.LargeVersion;
	 mBoseAmpASCSWVersion.MiddleVersion = ascSWinfo.MiddleVersion;
	 mBoseAmpASCSWVersion.SmallVersion = ascSWinfo.SmallVersion;
     mBoseAmpASCVersionInfoAvailable = TRUE;
 }
 
 
dia_tBoseAmpSWVersionData dia_BoseAmpInfo::getANCSoftwareInfo ()
{
    DIA_TR_INF("dia_BoseAmpInfo::getANCSoftwareInfo()");
	return mBoseAmpANCSWVersion;
	
}

dia_tBoseAmpSWVersionData dia_BoseAmpInfo::getASCSoftwareInfo ()
{
	DIA_TR_INF("dia_BoseAmpInfo::getASCSoftwareInfo()");
	return mBoseAmpASCSWVersion;
	
}

