/*
 * dia_SrvHandler_XCPMonitoring.cpp
 *
 *  Created on: Sep 30, 2015
 *      Author: jas1hi
 
  **************************************************************************************************/
 /*********************************************************************************************
* REVISION HISTORY:
* ------------------------------------------------------------------------------------------------
* Date 				| Rev. 	| Author 		   	| Modification
* ------------------------------------------------------------------------------------------------
*--------------------------------------------------------------------------------------------------------------------
* 02.09.2016		| 1.1	| NLK1KOR (RBEI)	| Implemented feature AIVINS2-19070 Connection status - Optic Disk 
                                                  Connection Status
*--------------------------------------------------------------------------------------------------------------------
* 12.01.2017		| 1.2	| JAS1HI  (RBCM)	| Utilizing the customer related trace classes
*--------------------------------------------------------------------------------------------------------------------
* 19.01.2017		| 1.3	| NLK1KOR (RBEI)	| Implemented feature AIVI-35187  Performance indicator (Interrupt latency and frequency)
                                                  Connection Status
*--------------------------------------------------------------------------------------------------------------------
* 09.02.2017		| 1.4	| NLK1KOR (RBEI)	| Implemented :
*                                                 - AIVI-42494 Worker class for the tuning of lighting timing
*                                                 - AIVI-28703 Worker class for the Sensor simulation via sensor log file
*                                                 Updated feature AIVI-35187  Performance indicator (Interrupt latency and frequency)
*--------------------------------------------------------------------------------------------------------------------
* 16.02.2017		| 1.5	| NLK1KOR (RBEI)	| Fixed NCG3D-36761
                                                  Implemented : AIVI-28509 - Enable Disable HMI Monitor Info
*--------------------------------------------------------------------------------------------------------------------
* 24.02.2017		| 1.6	| NLK1KOR (RBCM  )	| implemented feature AIVI-28127 XCP_Provider : P-IVI: Worker class for the power status
*--------------------------------------------------------------------------------------------------------------------
* 24.02.2017		| 1.7	| NLK1KOR (RBCM  )	| implemented feature  Feature 	AIVI-38980 	Working class for the Communication (connection) status
*-------------------------------------------------------------------------------------------------------------------
* 01.03.2017		| 1.8	| JAS1HI  (RBCM)	| Implemented: AIVI-28129 - Configuration information
* 												  Implemented: AIVI-28131 - Configuration information of neighboring devices
*-------------------------------------------------------------------------------------------------------------------
* 09.03.2017		| 1.9	| JAS1HI (RBCM)	    | Added new member variables to avoid subsequent subscriptions to already failed items
*--------------------------------------------------------------------------------------------------------------------
* 16.03.2017		| 2.0	| NLK1KOR (RBEI)	| Implemented AIVI-47067  calibration operation status
* 16.03.2017		| 2.1	| NLK1KOR (RBEI)	| Implemented AIVI-28509  secondary Screen Name
*--------------------------------------------------------------------------------------------------------------------
* 12.04.2017		| 2.2	| NLK1KOR (RBEI)	| Implemented AIVI-47067  secondary Screen Name,Next Upper application, Next Lower Application names.
*--------------------------------------------------------------------------------------------------------------------
* 06.06.2017        | 2.3	| NLK1KOR (RBEI  )	| Implemented 
													AIVI-28699 	AIVI-28698 XCP_Provider : P-IVI: key press operation on the secondary display 	
													AIVI-34710 	AIVI-34709 XCP_Provider : P-IVI: operation history (secondary display)
													PIVI-4235 Operation history of touch panel (secondary display)
*--------------------------------------------------------------------------------------------------------------------											
* 26.06.2017        | 2.4	| NLK1KOR (RBEI  )	| Implemented Encoder Push key simulation.
                                                  Implemented reset historz 20 elements.
*--------------------------------------------------------------------------------------------------------------------												
* 18.08.2017       | 2.5	| NLK1KOR (RBEI  )	| Implemented     AIVI-58793 Worker class for Bose Amplifier ANC and ASC SW Version.
*--------------------------------------------------------------------------------------------------------------------
* 05.09.2017       | 2.6	| NLK1KOR (RBEI  )	| Implemented     AIVI-28508 P-IVI: Worker class for different VR steps

*--------------------------------------------------------------------------------------------------------------------
*******************************************************************************************************************************/
 

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef DIA_FILESTREAM_H_
#include "project/services/customer/MonitoringCalibration/stream/dia_FileStream.h"
#endif

#ifndef DIA_HELPER_H_
#include "project/services/customer/MonitoringCalibration/helper/dia_Helper.h"
#endif

#ifndef __INCLUDED_DIA_APPCONTROLLER__
#include "common/framework/application/dia_AppController.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef DIA_TRACEPROJECT_H_
#include "project/framework/trace/dia_traceProject.h"
#endif

#include <limits> // std::numeric_limits

#include "dia_SrvHandler_XCPMonitoring.h"


tCString mcAddressFile = "/var/opt/bosch/persistent/mcAddressFile.add";
tCString MOUNT_POINT_USB_SDA1 = "/media/AAM_dev_sda1/";
tCString MOUNT_POINT_USB_SDB1 = "/media/AAM_dev_sdb1/";

const tU16 REQUEST_DATA_START 			    = 3; // 1 byte (length) +  1 byte (SID) + 1 byte (SF)
const tU16 REQUEST_DATA_LENGTH_FOR_OFFSET   = 1; // Length of the offset bytes within the request

const tU16 RESPONSE_DATA_START 			    = 2; // 1 byte (SID + 0x40) + 1 byte (SF)
const tU16 RESPONSE_MONITORING_LENGTH_FOR_OFFSET  = 2; // Length of the offset bytes within the response for monitoring data
const tU16 RESPONSE_CALIBRATION_LENGTH_FOR_OFFSET  = 1; // Length of the offset bytes within the response for calibration data

const tU16 RESPONSE_MONITORING_LENGTH_FOR_PAYLOAD = 2; // Number of bytes used to provide the Payload length within the response for monitoring data
const tU8  RESPONSE_CALIBRATION_LENGTH_FOR_PAYLOAD = 1; // Number of bytes used to provide the Payload length within the response for calibration data

// Constants for the PD Config Item AllianceVariantType defined in AIVIVariantCoding
const tU8  ALLIANCE_VARIANT_TYPE_NOT_CONFIGURED = 0x00;
//const tU8  ALLIANCE_VARIANT_TYPE_NAVI         = 0x01;
const tU8  ALLIANCE_VARIANT_TYPE_DA             = 0x02;

#define HMI_INFO_SERVICE_ENABLE   1
#define HMI_INFO_SERVICE_DISABLE  0

#define BYTETOBINARYPATTERN "%d%d%d%d%d%d%d%d"
#define BYTETOBINARY(byte)   \
	  (byte & 0x80 ? 1 : 0), \
	  (byte & 0x40 ? 1 : 0), \
	  (byte & 0x20 ? 1 : 0), \
	  (byte & 0x10 ? 1 : 0), \
	  (byte & 0x08 ? 1 : 0), \
	  (byte & 0x04 ? 1 : 0), \
	  (byte & 0x02 ? 1 : 0), \
	  (byte & 0x01 ? 1 : 0)

#define DWORDTOBINARYPATTERN "%d%d%d%d%d%d%d%d %d%d%d%d%d%d%d%d %d%d%d%d%d%d%d%d %d%d%d%d%d%d%d%d"
#define DWORDTOBINARY(dword)   \
	  (dword & 0x80000000 ? 1 : 0), \
	  (dword & 0x40000000 ? 1 : 0), \
	  (dword & 0x20000000 ? 1 : 0), \
	  (dword & 0x10000000 ? 1 : 0), \
	  (dword & 0x08000000 ? 1 : 0), \
	  (dword & 0x04000000 ? 1 : 0), \
	  (dword & 0x02000000 ? 1 : 0), \
	  (dword & 0x01000000 ? 1 : 0), \
	  (dword & 0x00800000 ? 1 : 0), \
	  (dword & 0x00400000 ? 1 : 0), \
	  (dword & 0x00200000 ? 1 : 0), \
	  (dword & 0x00100000 ? 1 : 0), \
	  (dword & 0x00080000 ? 1 : 0), \
	  (dword & 0x00040000 ? 1 : 0), \
	  (dword & 0x00020000 ? 1 : 0), \
	  (dword & 0x00010000 ? 1 : 0), \
	  (dword & 0x00008000 ? 1 : 0), \
	  (dword & 0x00004000 ? 1 : 0), \
	  (dword & 0x00002000 ? 1 : 0), \
	  (dword & 0x00001000 ? 1 : 0), \
	  (dword & 0x00000800 ? 1 : 0), \
	  (dword & 0x00000400 ? 1 : 0), \
	  (dword & 0x00000200 ? 1 : 0), \
	  (dword & 0x00000100 ? 1 : 0), \
	  (dword & 0x00000080 ? 1 : 0), \
	  (dword & 0x00000040 ? 1 : 0), \
	  (dword & 0x00000020 ? 1 : 0), \
	  (dword & 0x00000010 ? 1 : 0), \
	  (dword & 0x00000008 ? 1 : 0), \
	  (dword & 0x00000004 ? 1 : 0), \
	  (dword & 0x00000002 ? 1 : 0), \
	  (dword & 0x00000001 ? 1 : 0)


dia_SrvHandler_XCPMonitoring::dia_SrvHandler_XCPMonitoring()
	:    dia_ServiceHandlerUDS("dia_SrvHandler_XCPMonitoring", 0x99, DIA_C_U8_SUBFUNC_AIVI_XCP_GET_MONITORING_DATA),
	     mRunLevel(DIA_EN_RUNLEVEL_UNDEFINED),
	     mAllianceVariantType(ALLIANCE_VARIANT_TYPE_NOT_CONFIGURED),
	     mProcInfo(),
	     mILMInfo(),
	     mGPUInfo(),
	     mResetInfo(),
	     mPowerStatusInfo(),
	     mVehicleSignalsInfo(),
	     mCommunicationStatus(),
	     mCardStatus(),
	     mStartupStatusInfo(),
	     mGnssInfo(),
	     mWlanInfo(),
	     mSensorInfo(),
	     mHeatControlInfo(),
	     mHMIMonitorInfo(),
	     mSdsGuiPopupInfo(),
	     mHMINavigationInfo(),
	     mPhoneConnectionInfo(),
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	     mBTConnectionStatusInfo(),
#endif
#ifdef VARIANT_S_FTR_ENABLE_RIVIE
	     mDTCInfo(),
	     mConfigInfo(),
	     mVersionInfo(),
#endif
#if defined(VARIANT_S_FTR_ENABLE_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_RIVIE)
	     mInputHistory(),
#endif
	     mMessageXCPMonitoring(),
	     mMaxDataPayload(sizeof(mMessageXCPMonitoring)),
	     mPayloadTransferOffset(mMaxDataPayload),
	     mAddressUpdated(FALSE),
	     mResetHistoryUpdated(FALSE),
	     mResetCounterUpdated(FALSE),
	     mStartupTimeUpdated(FALSE),
	     mCardInfoAvailable(FALSE),
	     mConfigInfoUpdated(FALSE),
	     mVersionInfoUpdated(FALSE),
	     mStartupStatusUpdated(FALSE),
	     mWakeupStatusUpdated(FALSE),
	     mPayloadTransferOffsetIndex(0),
	     mPayloadTransferOffsetListUpdated(FALSE),
	     mTimeSpecStart(),
	     mTimeSpecEnd(),
	     mHMINavigationInfoFailed(FALSE),
	     mHMIMonitorInfoFailed(FALSE),

	     cInputSimulation(),
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	     cWifiPowerChange(),
	     mLightingDimming(),
		 mClockSWCConnectionStatusInfo(),
		 mBoseAmpInfo(),
#endif

	     cMessageXCPCalibration(),
	     cResponseWithCalibrationData(FALSE),
	     cMaxDataPayload(sizeof(cMessageXCPCalibration)),
	     cPayloadTransferOffset(cMaxDataPayload)
{
	 dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::dia_SrvHandler_XCPMonitoring()");

#ifdef __DIA_UNIT_TESTING__
	 mAddressUpdated = true;
#endif

	 mNumericMaxTime = std::numeric_limits<time_t>::max(); // Determine the numeric limit of time_t
}

dia_SrvHandler_XCPMonitoring::~dia_SrvHandler_XCPMonitoring()
{
	// TODO Auto-generated destructor stub
}

tVoid dia_SrvHandler_XCPMonitoring::vProcessRequest ( const std::vector<tVoid*>& /*vecArgs*/ )
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::vProcessRequest");

	// Check if at least Runlevel 2 is reached
	mRunLevel = dia_AppController::getInstance()->getRunLevel();
	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::vProcessRequest: Actual runlevel (%d)", mRunLevel);

	// Get start timestamp
	if( clock_gettime(CLOCK_MONOTONIC, &mTimeSpecStart) == -1 ) {
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::vProcessRequest: Failed to open call clock_gettime()");
	}

	// Check if we have received the right length
	tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();
	DIA_TR_INF("dia_SrvHandler_XCPMonitoring::vProcessRequest: dataLength = %d", dataLength);

	// Check if Address update of parameters is needed
	if (mAddressUpdated == FALSE) {
		dia_FileStream fileStream(mcAddressFile);
		if (fileStream.openForRead() != DIA_STREAM_ERROR) {
			mAddressUpdated = TRUE; // Avoid creation of a new file if file exists already (user has to delete the file manually if an address update is necessary)
			fileStream.close();
		}

		// Determine the Alliance Variant Type
		tU8 aiviVariantCoding[DIA_AIVI_VARIANT_CODING_LENGTH] = { 0 };
		tDiaResult getPropRes = dia_getProperty(DIA_PROP_AIVI_VARIANT_CODING, aiviVariantCoding, DIA_AIVI_VARIANT_CODING_LENGTH);
		if (getPropRes != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::vProcessRequest. ##### FAILED TO GET PROPERTY FOR A-IVI VARIANTS #####");
		}
		else {
			mAllianceVariantType = (aiviVariantCoding[0] & 0x0F);
			DIA_TR_INF("dia_SrvHandler_XCPMonitoring::vProcessRequest Variant Type = 0x%02X", mAllianceVariantType);
		}
	}


	/************ CALIBRATION **************************/

	if (dataLength > REQUEST_DATA_START) { // The request is treated as Calibration request only if there are extra data within the payload

		// extract the data from the received message
		const tU8* pU8 = oDiagMsgBuffer().u8GetBuffer();
		tU8 requestedDataOffset = pU8[REQUEST_DATA_START];
		DIA_TR_INF("dia_SrvHandler_XCPMonitoring::vProcessRequest: Calibration requestedDataOffset = %d", requestedDataOffset);

		// Check if the sent data fits into the predefined data structure for Calibration
		if (requestedDataOffset < sizeof(cMessageXCPCalibration)) {
//		if ((dataLength - REQUEST_DATA_START - REQUEST_DATA_LENGTH_FOR_OFFSET) <= sizeof(cMessageXCPCalibration) - requestedDataOffset) {

			tU16 calibrationDataSizeReceived = sizeof(cMessageXCPCalibration) - requestedDataOffset;
			tU8* bytesMsgXCPCalibration = reinterpret_cast<tU8*>(&cMessageXCPCalibration);
			memcpy(bytesMsgXCPCalibration + requestedDataOffset, pU8 + REQUEST_DATA_START + REQUEST_DATA_LENGTH_FOR_OFFSET, calibrationDataSizeReceived);

			cMaxDataPayload = sizeof(cMessageXCPCalibration); // TODO: If we don't assign it every time, then the value of cMaxDataPayload changes unexpectedly!
			cPayloadTransferOffset = requestedDataOffset; //cMaxDataPayload;
//			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::vProcessRequest requestedDataOffset = [%d]", requestedDataOffset);

//			for (tU16 i=0; i<calibrationDataSizeReceived+1; i++){ // +1 to include the offset byte
//				DIA_TR_INF("dia_SrvHandler_XCPMonitoring::vProcessRequest: Cal request-> pU8[%d]=0x%X", REQUEST_DATA_START + i, pU8[REQUEST_DATA_START + i]);
//			}

			cResponseWithCalibrationData = TRUE;

			// Handle a Calibration requests only if RunLevel >= 2
			if (mRunLevel >= DIA_EN_RUNLEVEL_2) {
				// Start executing the requested Calibration parameters (in reverse order)
				if (cMessageXCPCalibration.cEncRotation.startStop) {
					if (simulateEncRotation() != DIA_SUCCESS) {
						DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- simulateEncRotation() FAILED!!!!");
					}
					cMessageXCPCalibration.cEncRotation.startStop = 0; // Has to be zeroed to signalize within the response a successful execution
				}
				if (cMessageXCPCalibration.cKeyInjection.startStop) {
					if (simulateKeyInjection() != DIA_SUCCESS) {
						DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- simulateKeyInjection() FAILED!!!!");
					}
					cMessageXCPCalibration.cKeyInjection.startStop = 0; // Has to be zeroed to signalize within the response a successful execution
				}
				if (cMessageXCPCalibration.cSingleTouch.startStop) {
					if (simulateSingleTouch() != DIA_SUCCESS) {
						DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- simulateSingleTouch() FAILED!!!!");
					}
					cMessageXCPCalibration.cSingleTouch.startStop = 0; // Has to be zeroed to signalize within the response a successful execution
				}
				if (cMessageXCPCalibration.cTouchSlide.startStop) {
					if (simulateTouchSlide() != DIA_SUCCESS) {
						DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- simulateTouchSlide() FAILED!!!!");
					}
					cMessageXCPCalibration.cTouchSlide.startStop = 0; // Has to be zeroed to signalize within the response a successful execution
				}
				if (cMessageXCPCalibration.cGestureRecord.start) {
					DIA_TR_INF("dia_SrvHandler_XCPMonitoring --- startGestureRecord()...");
					if (startGestureRecord() != DIA_SUCCESS) {
						DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- startGestureRecord() FAILED!!!!");
					}
					cMessageXCPCalibration.cGestureRecord.start = 0; // Has to be zeroed to signalize within the response a successful execution
				}
				if (cMessageXCPCalibration.cGestureRecord.stop) {
					if (stopGestureRecord() != DIA_SUCCESS) {
						DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- stopGestureRecord() FAILED!!!!");
					}
					cMessageXCPCalibration.cGestureRecord.stop = 0; // Has to be zeroed to signalize within the response a successful execution
				}
				if (cMessageXCPCalibration.cGestureReplay.start) {
					if (startGestureReplay() != DIA_SUCCESS) {
						DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- startGestureReplay() FAILED!!!!");
					}
					cMessageXCPCalibration.cGestureReplay.start = 0; // Has to be zeroed to signalize within the response a successful execution
				}
				if (cMessageXCPCalibration.cGestureReplay.stop) {
					if (stopGestureReplay() != DIA_SUCCESS) {
						DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- stopGestureReplay() FAILED!!!!");
					}
					cMessageXCPCalibration.cGestureReplay.stop = 0; // Has to be zeroed to signalize within the response a successful execution
				}
				if (cMessageXCPCalibration.cEncoderPush.startStop) {
					if (simulateEncoderPush() != DIA_SUCCESS) {
						DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- simulateEncoderPush() FAILED!!!!");
					}
					cMessageXCPCalibration.cEncoderPush.startStop = 0; // Has to be zeroed to signalize within the response a successful execution
				}
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
				if (cMessageXCPCalibration.cSinglePIVITouch.startStop) {
					if (simulateSinglePIVITouch() != DIA_SUCCESS) {
						DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- simulateSinglePIVITouch() FAILED!!!!");
					}
					cMessageXCPCalibration.cSinglePIVITouch.startStop = 0; // Has to be zeroed to signalize within the response a successful execution
				}
#endif
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
				if (cMessageXCPCalibration.cWifiPowerChange.startStop) {
					if (changeWifiPower() != DIA_SUCCESS) {
						DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- changeWifiPower() FAILED!!!!");
					}
					cMessageXCPCalibration.cWifiPowerChange.startStop = 0; // Has to be zeroed to signalize within the response a successful execution
				}
				if (cMessageXCPCalibration.cLightingDimmingSet.startStop)
				{
					if (simulateLightingDimming() != DIA_SUCCESS)
					{
						DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- simulateLightingDimming() FAILED!!!!");
					}
					cMessageXCPCalibration.cLightingDimmingSet.startStop = 0; // Has to be zeroed to signalize within the response a successful execution
			    }
				if (cMessageXCPCalibration.cTripReplay.start) {
					if (startTripFileReplay() != DIA_SUCCESS) {
						DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- startTripFileReplay() FAILED!!!!");
					}
					cMessageXCPCalibration.cTripReplay.start = 0; // Has to be zeroed to signalize within the response a successful execution
				}
				if (cMessageXCPCalibration.cTripReplay.stop) {
					//cMessageXCPCalibration.cTripReplay.start = 0;
					if (stopTripFileReplay() != DIA_SUCCESS) {
						DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- stopTripFileReplay() FAILED!!!!");
					}
					//cMessageXCPCalibration.cTripReplay.start = 0;
					DIA_TR_INF("dia_SrvHandler_XCPMonitoring::vProcessRequest: cTripReplay.start = %d", cMessageXCPCalibration.cTripReplay.start);
					cMessageXCPCalibration.cTripReplay.stop = 0; // Has to be zeroed to signalize within the response a successful execution

			}
#endif
			}
			else {
				DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::vProcessRequest: Runlevel=%d, Calibration request saved for later processing...", mRunLevel);
//				memset(bytesMsgXCPCalibration + cPayloadTransferOffset, 0, calibrationDataSizeReceived);

				//  Send negative response for this time
				vSendNegativeResponse(DIA_E_U8_UDS_GENERAL_REJECT);
				return;
			}

		}
		else {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring: requestedDataOffset: %d > sizeof(cMessageXCPCalibration): %d", requestedDataOffset, sizeof(cMessageXCPCalibration));
//			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring: dataLength: %d >= sizeof(mMessageXCPCalibration): %d", (dataLength - REQUEST_DATA_START - requestedDataOffset), sizeof(cMessageXCPCalibration));
//			vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
//			return  vResReadyAndQuit();
		}
	}


	/************ MONITORING **************************/

	// Reset the payload transfer offset
	mPayloadTransferOffset = mMaxDataPayload;
	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::vProcessRequest mMaxDataPayload = %d Bytes", mMaxDataPayload);

	// Reset the payload transfer offset index
	mPayloadTransferOffsetIndex = 0;

	// Handle a Calibration requests only if RunLevel >= 2
	if (mRunLevel >= DIA_EN_RUNLEVEL_2) {
		// The below order of function calls is important
		if (getGPUInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getGPUInfo() FAILED!!!!");
	//		vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);  // TODO: Commented out because some galcore files (e.g. meminfo) are missing on target
	//		return  vResReadyAndQuit();
		}
		if (getProcInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getProcInfo() FAILED!!!!");
	//		vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
	//		return  vResReadyAndQuit();
		}
		if (getPowerStatusInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getPowerStatusInfo() FAILED!!!!");
		}
		if (getVehicleSignalsInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getVehicleSignalsInfo() FAILED!!!!");
		}
		if (getCommunicationStatus() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getCommunicationStatus() FAILED!!!!");
		}
		if (getCardStatus() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getCardStatus() FAILED!!!!");
		}
		if (getSurfaceProperties() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getSurfaceProperties() FAILED!!!!");
		}

		if (getGnssInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getGnssInfo() FAILED!!!!");
		}
		if (getWlanInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getWlanInfo() FAILED!!!!");
		}
		if (getSensorInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getSensorInfo() FAILED!!!!");
		}
		if (getHeatControlInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getHeatControlInfo() FAILED!!!!");
		}
		if (getHMIMonitorInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getHMIMonitorInfo() FAILED!!!!");
		}
		if (getSdsGuiPopupInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getSdsGuiPopupInfo() FAILED!!!!");
		}
		if (getHMINavigationInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getHMINavigationInfo() FAILED!!!!");
		}
		if (getPhoneConnectionInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getPhoneConnectionInfo() FAILED!!!!");
		}
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
		if (getBTConnectionStatusInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getBTConnectionStatusInfo() FAILED!!!!");
		}
		if (getProcInterruptInfo() != DIA_SUCCESS)
		{
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getProcInterruptInfo() FAILED!!!!");
		}
#endif
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
		if (getSystemStatusInfo() != DIA_SUCCESS)
		{
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getSystemStatusInfo() FAILED!!!!");
		}
		if (getSdsDiagnosisServiceInfo() != DIA_SUCCESS)
		{
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getSdsDiagnosisServiceInfo() FAILED!!!!");
		}
#endif
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
		if (getBoseAmpANCversion() != DIA_SUCCESS)
		{
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getBoseAmpANCversion() FAILED!!!!");
		}
		if (getBoseAmpASCversion() != DIA_SUCCESS)
		{
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getBoseAmpASCversion() FAILED!!!!");
		}
		if (getSWCConnectionStatus() != DIA_SUCCESS)
		{
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getSWCConnectionStatus() FAILED!!!!");
		}
#endif
#ifdef VARIANT_S_FTR_ENABLE_RIVIE
		if (getDTCInfo() != DIA_SUCCESS)
		{
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getDTCInfo() FAILED!!!!");
		}
#endif
#if defined(VARIANT_S_FTR_ENABLE_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_RIVIE)|| defined(VARIANT_S_FTR_ENABLE_NPIVI)
		if (getOperationHistoryInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getOperationHistoryInfo() FAILED!!!!");
		}
#endif
		// Get end timestamp
		if( clock_gettime(CLOCK_MONOTONIC, &mTimeSpecEnd) == -1 ) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::vProcessRequest: Failed to open call clock_gettime()");
		}
		if (getStartAndEndTime() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getStartAndEndTime() FAILED!!!!");
		}
		/************ MONITORING One time requests **************************/
		if (getStartupStatus() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getStartupStatus() FAILED!!!!");
		}
		if (getResetInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getResetHistoryInfo() FAILED!!!!");
		}
		if ((mHMIMonitorInfo.setHMIMonitorInfo(HMI_INFO_SERVICE_ENABLE) != DIA_SUCCESS))
		{
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::vProcessRequest: FAILED TO ENABLE HMI MONITOR SERVICE!!!");
		}
#ifdef VARIANT_S_FTR_ENABLE_RIVIE
		if (getConfigInfo() != DIA_SUCCESS)
		{
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getConfigInfo() FAILED!!!!");
		}
		if (getVersionInfo() != DIA_SUCCESS)
		{
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getVersionInfo() FAILED!!!!");
		}

#endif
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
		if (getCalibrationStatusInfo() != DIA_SUCCESS)
		{
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getCalibrationStatusInfo() FAILED!!!!");
		}
#endif
	}
	else {
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::vProcessRequest: Runlevel=%d, Monitoring request is skipped for now...", mRunLevel);

		//  Send negative response for this time
		vSendNegativeResponse(DIA_E_U8_UDS_GENERAL_REJECT);
		return;
	}

	mPayloadTransferOffsetListUpdated = TRUE;

	oDiagMsgBuffer().vSetPosResp();

	// Determine the size of the Monitoring data to transfer
	tU16 monitoringDataSizeToTransfer = (tU16) (mMaxDataPayload - mPayloadTransferOffset);

	if (cResponseWithCalibrationData == TRUE) { // Append the response for the calibration request to the end

		// Determine the size of the Calibration data to transfer
		tU16 calibrationDataSizeToTransfer = cMaxDataPayload - cPayloadTransferOffset;
		DIA_TR_INF("dia_SrvHandler_XCPMonitoring::vProcessRequest calibrationDataSizeToTransfer = %d Bytes", calibrationDataSizeToTransfer);
		DIA_TR_INF("dia_SrvHandler_XCPMonitoring::vProcessRequest cMaxDataPayload: %d  cPayloadTransferOffset %d", cMaxDataPayload, cPayloadTransferOffset);

		oDiagMsgBuffer().vSetDataLength(RESPONSE_DATA_START + RESPONSE_MONITORING_LENGTH_FOR_OFFSET + RESPONSE_MONITORING_LENGTH_FOR_PAYLOAD + monitoringDataSizeToTransfer + RESPONSE_CALIBRATION_LENGTH_FOR_OFFSET + RESPONSE_CALIBRATION_LENGTH_FOR_PAYLOAD + calibrationDataSizeToTransfer);

		// Set the byte for offset
		oDiagMsgBuffer().vSetDataU8((tU16) RESPONSE_DATA_START + RESPONSE_MONITORING_LENGTH_FOR_OFFSET + RESPONSE_MONITORING_LENGTH_FOR_PAYLOAD + monitoringDataSizeToTransfer,  cPayloadTransferOffset & 0xFF); // lower nibble

		// Set the byte for payload length
		oDiagMsgBuffer().vSetDataU8((tU16) RESPONSE_DATA_START + RESPONSE_MONITORING_LENGTH_FOR_OFFSET + RESPONSE_MONITORING_LENGTH_FOR_PAYLOAD + monitoringDataSizeToTransfer + 1,  calibrationDataSizeToTransfer & 0xFF); // lower nibble


		// Get raw bytes from struct
		tU8* bytesMsgXCPCalibration = reinterpret_cast<tU8*>(&cMessageXCPCalibration);

		DIA_TR_INF("dia_SrvHandler_XCPMonitoring::vProcessRequest memcpy Calibration cPayloadTransferOffset: %d", cPayloadTransferOffset);

		tU8* diagMsgBuffer = oDiagMsgBuffer().u8GetBuffer();
		memcpy(diagMsgBuffer + RESPONSE_DATA_START + RESPONSE_MONITORING_LENGTH_FOR_OFFSET + RESPONSE_MONITORING_LENGTH_FOR_PAYLOAD + monitoringDataSizeToTransfer + RESPONSE_CALIBRATION_LENGTH_FOR_OFFSET + RESPONSE_CALIBRATION_LENGTH_FOR_PAYLOAD, bytesMsgXCPCalibration + cPayloadTransferOffset, calibrationDataSizeToTransfer);

//		tU16 startCalIndex = RESPONSE_DATA_START + RESPONSE_MONITORING_LENGTH_FOR_OFFSET + RESPONSE_MONITORING_LENGTH_FOR_PAYLOAD + monitoringDataSizeToTransfer;

//		DIA_TR_INF("dia_SrvHandler_XCPMonitoring::vProcessRequest: Cal response-> startCalIndex: %d", startCalIndex);
//		for (tU16 i=0; i<calibrationDataSizeToTransfer+2; i++){ // +2 to include the offset and length bytes
//			DIA_TR_INF("dia_SrvHandler_XCPMonitoring::vProcessRequest: Cal response-> diagMsgBuffer[%d]=0x%X", startCalIndex+i, diagMsgBuffer[startCalIndex+i]);
//		}

//		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::vProcessRequest cPayloadTransferOffset = %d Bytes", cPayloadTransferOffset);

		cResponseWithCalibrationData = FALSE;
	}
	else { // Response only with monitoring parameters
		oDiagMsgBuffer().vSetDataLength(RESPONSE_DATA_START + RESPONSE_MONITORING_LENGTH_FOR_OFFSET + RESPONSE_MONITORING_LENGTH_FOR_PAYLOAD + monitoringDataSizeToTransfer);
	}

	// Set the bytes for offset
	oDiagMsgBuffer().vSetDataU8((tU16) RESPONSE_DATA_START,     (mPayloadTransferOffset >> 8) & 0xFF); // upper nibble
	oDiagMsgBuffer().vSetDataU8((tU16) RESPONSE_DATA_START + 1,  mPayloadTransferOffset 	  & 0xFF); // lower nibble

	// Set the bytes for payload length
	oDiagMsgBuffer().vSetDataU8((tU16) RESPONSE_DATA_START + 2, (monitoringDataSizeToTransfer >> 8) & 0xFF); // upper nibble
	oDiagMsgBuffer().vSetDataU8((tU16) RESPONSE_DATA_START + 3,  monitoringDataSizeToTransfer 	  & 0xFF); 	  // lower nibble


	// Get raw bytes from struct
	tU8* bytesMsgXCPMonitoring = reinterpret_cast<tU8*>(&mMessageXCPMonitoring);

//	DIA_TR_INF("dia_SrvHandler_XCPMonitoring::vProcessRequest memcpy Monitoring");

	tU8* diagMsgBuffer = oDiagMsgBuffer().u8GetBuffer();
	memcpy(diagMsgBuffer + RESPONSE_DATA_START + RESPONSE_MONITORING_LENGTH_FOR_OFFSET + RESPONSE_MONITORING_LENGTH_FOR_PAYLOAD, bytesMsgXCPMonitoring + mPayloadTransferOffset, monitoringDataSizeToTransfer);

	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::vProcessRequest mPayloadTransferOffset = %d Bytes", mPayloadTransferOffset);


	 // Print the address of elements
	if (mAddressUpdated == FALSE && mRunLevel >= DIA_EN_RUNLEVEL_2) {
		dia_FileStream fileStream(mcAddressFile);
		if (fileStream.openForWrite() != DIA_STREAM_ERROR) {

			// Save the addresses of Monitoring parameters into file
			DIA_TR_INF("dia_SrvHandler_XCPMonitoring: mXcpMonitoringItemAddressMap.size = %d", mXcpMonitoringItemAddressMap.size());
			for(tXcpMonitoringItemAddressMapIter xcpMonitoringItemAddressMapIterator = mXcpMonitoringItemAddressMap.begin(); xcpMonitoringItemAddressMapIterator != mXcpMonitoringItemAddressMap.end(); xcpMonitoringItemAddressMapIterator++) {
//				DIA_TR_INF("dia_SrvHandler_XCPMonitoring: mXcpItemAddressMap[%s] = 0x%X", xcpItemAddressMapIterator->second.c_str(), xcpItemAddressMapIterator->first);

				// Save the address into the buffer
				char addressBuffer[10];
				sprintf ( addressBuffer, "%08x", (tS32)xcpMonitoringItemAddressMapIterator->first );
				std::string addressLine = xcpMonitoringItemAddressMapIterator->second + std::string(":") + std::string(addressBuffer); // variableName:Address
//				DIA_TR_INF("dia_SrvHandler_XCPMonitoring: addressLine: '%s'", addressLine.c_str());
				fileStream.writeLine(addressLine);
			}

			// Triggering explicitly address update of Calibration parameters
			updateAddressOfCalibrationParameters();

			// Save the addresses of Calibration parameters into file
			DIA_TR_INF("dia_SrvHandler_XCPMonitoring: cXcpCalibrationItemAddressMap.size = %d", cXcpCalibrationItemAddressMap.size());
			for(tXcpCalibrationItemAddressMapIter xcpCalibrationItemAddressMapIterator = cXcpCalibrationItemAddressMap.begin(); xcpCalibrationItemAddressMapIterator != cXcpCalibrationItemAddressMap.end(); xcpCalibrationItemAddressMapIterator++) {

				// Save the address into the buffer
				char addressBuffer[10];
				sprintf ( addressBuffer, "%08x", (tS32)xcpCalibrationItemAddressMapIterator->first );
				std::string addressLine = xcpCalibrationItemAddressMapIterator->second + std::string(":") + std::string(addressBuffer); // variableName:Address
//				DIA_TR_INF("dia_SrvHandler_XCPMonitoring: addressLine: '%s'", addressLine.c_str());
				fileStream.writeLine(addressLine);
			}

			fileStream.flush();
			fileStream.close();
		}

		mAddressUpdated = TRUE;
	}

	DIA_TR_INF("dia_SrvHandler_XCPMonitoring::vProcessRequest oDiagMsgBuffer.size = %d Bytes", oDiagMsgBuffer().u16GetDataLength());


    vResReadyAndQuit();
}

tDiaResult dia_SrvHandler_XCPMonitoring::getProcInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring:getProcInfo");

	tU16 i;
	tDouble period = 0.0;
	tULong usedCPUMemKBytes = 0;

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;
		//#####1########
		address = (tU32)&mMessageXCPMonitoring.mTotalCPUMemoryConsumption;
		mXcpMonitoringItemAddressMap[address] = std::string("mTotalCPUMemoryConsumption");
		//#####2########
		address = (tU32)&mMessageXCPMonitoring.mCpuIdleTime;
		mXcpMonitoringItemAddressMap[address] = std::string("mCpuIdleTime");

		//#####3########
		for (i=0; i<MAX_NUMBER_OF_PROCESS; i++) {
			std::string topProcessNameStr = std::string("mLoadTopProcessName") + dia_Helper::tU16ToString(i);
			address = (tU32)&mMessageXCPMonitoring.mLoadTopProcessCPU[i].mLoadTopProcessName[0];
			mXcpMonitoringItemAddressMap[address] = topProcessNameStr;

			std::string topProcessLoadStr = std::string("mLoadTopProcess") + dia_Helper::tU16ToString(i);
			address = (tU32)&mMessageXCPMonitoring.mLoadTopProcessCPU[i].mLoadTopProcess;
			mXcpMonitoringItemAddressMap[address] = topProcessLoadStr;
		}
		//#####4########
		for (i=0; i<MAX_NUMBER_OF_PROCESS; i++) {
			std::string memoryTopCPUProcessNameStr = std::string("mMemoryTopCPUProcessName") + dia_Helper::tU16ToString(i);
			address = (tU32)&mMessageXCPMonitoring.mMemoryTopProcessCPU[i].mMemoryTopProcessName[0];
			mXcpMonitoringItemAddressMap[address] = memoryTopCPUProcessNameStr;

			std::string currentMemoryTopCPUProcessStr = std::string("mCurrentMemoryTopCPUProcess") + dia_Helper::tU16ToString(i);
			address = (tU32)&mMessageXCPMonitoring.mMemoryTopProcessCPU[i].mCurrentMemoryTopProcess;
			mXcpMonitoringItemAddressMap[address] = currentMemoryTopCPUProcessStr;

			std::string maximumMemoryTopCPUProcessStr = std::string("mMaximumMemoryTopCPUProcess") + dia_Helper::tU16ToString(i);
			address = (tU32)&mMessageXCPMonitoring.mMemoryTopProcessCPU[i].mMaximumMemoryTopProcess;
			mXcpMonitoringItemAddressMap[address] = maximumMemoryTopCPUProcessStr;
		}
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(((((mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mTotalCPUMemoryConsumption)) - sizeof(mMessageXCPMonitoring.mCpuIdleTime)) - sizeof(mMessageXCPMonitoring.mLoadTopProcessCPU))) - sizeof(mMessageXCPMonitoring.mMemoryTopProcessCPU));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	if (mProcInfo.scanMemInfo(usedCPUMemKBytes) != DIA_SUCCESS) {
		DIA_TR_CUS_ERR("dia_SrvHandler_XCPMonitoring::getProcInfo: procInfo.scanMemInfo() FAILED");
		return DIA_FAILED;
	}
	else {
		DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getProcInfo: usedCPUMem: %lu Kb", usedCPUMemKBytes);
		//#####1########
		mMessageXCPMonitoring.mTotalCPUMemoryConsumption = (tU32) usedCPUMemKBytes;
	}

	if (mProcInfo.scanCpuTime(period) != DIA_SUCCESS) {
		DIA_TR_CUS_ERR("dia_SrvHandler_XCPMonitoring::getProcInfo: procInfo.scanCpuTime() FAILED");
		return DIA_FAILED;
	}

	if (mProcInfo.updateProcessList(period) != DIA_SUCCESS) {
		DIA_TR_CUS_ERR("dia_SrvHandler_XCPMonitoring::getProcInfo: procInfo.updateProcessList() FAILED");
		return DIA_FAILED;
	}

	tFloat cpuIdleTime  = 0;
	if (mProcInfo.getCPUIdleTime(cpuIdleTime) != DIA_SUCCESS) {
		DIA_TR_CUS_ERR("dia_SrvHandler_XCPMonitoring::getProcInfo: procInfo.getCPUIdleTime() FAILED");
		return DIA_FAILED;
	}
	//#####2########
	mMessageXCPMonitoring.mCpuIdleTime = (tU8) cpuIdleTime;
	DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getProcInfo: CPUIdleTime = %lf", cpuIdleTime);

	// Get top most MAX_NUMBER_OF_PROCESS processes sorted via CPU usage
	mTopProcessSortedViaCpuUsage = mProcInfo.getTopProcessSortedViaCpuUsage(MAX_NUMBER_OF_PROCESS);
	if (mTopProcessSortedViaCpuUsage.size() != MAX_NUMBER_OF_PROCESS) {
		DIA_TR_CUS_ERR("dia_SrvHandler_XCPMonitoring::getProcInfo: procInfo.getTopProcessSortedViaCpuUsage() FAILED");
		return DIA_FAILED;
	}

	mTopProcessSortedReverseIteratorType reverseIteratorCpuUsage;
	i = 0;
	for(reverseIteratorCpuUsage = mTopProcessSortedViaCpuUsage.rbegin(); reverseIteratorCpuUsage != mTopProcessSortedViaCpuUsage.rend(); reverseIteratorCpuUsage++) {
		DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getProcInfo: TopCPU[%s]=%lf", reverseIteratorCpuUsage->second.c_str(), reverseIteratorCpuUsage->first);

		//#####3########
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
		memcpy(mMessageXCPMonitoring.mLoadTopProcessCPU[i].mLoadTopProcessName, reverseIteratorCpuUsage->second.c_str(),(MAX_LENGTH_PROCESS_NAME+MAX_LENGTH_PROCESS_STATE));
#else
		memcpy(mMessageXCPMonitoring.mLoadTopProcessCPU[i].mLoadTopProcessName, reverseIteratorCpuUsage->second.c_str(),MAX_LENGTH_PROCESS_NAME);
#endif
		mMessageXCPMonitoring.mLoadTopProcessCPU[i].mLoadTopProcess = (tU8) reverseIteratorCpuUsage->first;
		i++;
	}

	// Get top most MAX_NUMBER_OF_PROCESS processes sorted via memory usage
	mTopProcessSortedViaMemoryUsage = mProcInfo.getTopProcessSortedViaMemoryUsage(MAX_NUMBER_OF_PROCESS);
	if (mTopProcessSortedViaMemoryUsage.size() != MAX_NUMBER_OF_PROCESS) {
		DIA_TR_CUS_ERR("dia_SrvHandler_XCPMonitoring::getProcInfo: procInfo.getTopProcessSortedViaMemoryUsage() FAILED");
		return DIA_FAILED;
	}

	mTopProcessSortedViaMemoryUsageReverseIteratorType reverseIteratorMemoryUsage;
	i = 0;
	for(reverseIteratorMemoryUsage = mTopProcessSortedViaMemoryUsage.rbegin(); reverseIteratorMemoryUsage != mTopProcessSortedViaMemoryUsage.rend(); reverseIteratorMemoryUsage++) {
		DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getProcInfo: TopMemory[%s]=%lu KB, max: %lu KB", reverseIteratorMemoryUsage->second.command, reverseIteratorMemoryUsage->first, reverseIteratorMemoryUsage->second.m_maximumMemKBytes);

		//#####4########
		memcpy(mMessageXCPMonitoring.mMemoryTopProcessCPU[i].mMemoryTopProcessName, reverseIteratorMemoryUsage->second.command, MAX_LENGTH_PROCESS_NAME);
		mMessageXCPMonitoring.mMemoryTopProcessCPU[i].mCurrentMemoryTopProcess = (tU32) reverseIteratorMemoryUsage->first;
		mMessageXCPMonitoring.mMemoryTopProcessCPU[i].mMaximumMemoryTopProcess = (tU32) reverseIteratorMemoryUsage->second.m_maximumMemKBytes;
		i++;
	}

	// Update offset
	mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);

	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::getGPUInfo()
{
	tU16 i;
	tULong usedGPUMemKBytes;

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;
		//#####5########
		address = (tU32)&mMessageXCPMonitoring.mTotalGPUMemoryConsumption;
		mXcpMonitoringItemAddressMap[address] = std::string("mTotalGPUMemoryConsumption");
		//#####6########
		address = (tU32)&mMessageXCPMonitoring.mGpuIdleTime;
		mXcpMonitoringItemAddressMap[address] = std::string("mGpuIdleTime");
		//#####7########
		for (i=0; i<MAX_NUMBER_OF_PROCESS; i++) {
			std::string memoryTopProcessGPUNameStr = std::string("mMemoryTopGPUProcessName") + dia_Helper::tU16ToString(i);
			address = (tU32)&mMessageXCPMonitoring.mMemoryTopProcessGPU[i].mMemoryTopProcessName[0];
			mXcpMonitoringItemAddressMap[address] = memoryTopProcessGPUNameStr;

			std::string currentMemoryTopProcessGPUStr = std::string("mCurrentMemoryTopGPUProcess") + dia_Helper::tU16ToString(i);
			address = (tU32)&mMessageXCPMonitoring.mMemoryTopProcessGPU[i].mCurrentMemoryTopProcess;
			mXcpMonitoringItemAddressMap[address] = currentMemoryTopProcessGPUStr;

			std::string maximumMemoryTopProcessGPUStr = std::string("mMaximumMemoryTopGPUProcess") + dia_Helper::tU16ToString(i);
			address = (tU32)&mMessageXCPMonitoring.mMemoryTopProcessGPU[i].mMaximumMemoryTopProcess;
			mXcpMonitoringItemAddressMap[address] = maximumMemoryTopProcessGPUStr;
		}
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back((((mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mTotalGPUMemoryConsumption)) - sizeof(mMessageXCPMonitoring.mGpuIdleTime)) - sizeof(mMessageXCPMonitoring.mMemoryTopProcessGPU)));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	if (mGPUInfo.scanMemInfo(usedGPUMemKBytes) != DIA_SUCCESS) {
		return DIA_FAILED;
	}
	else {
		DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getGPUInfo: usedGPUMem: %lu Kb", usedGPUMemKBytes);
		//#####5########
		mMessageXCPMonitoring.mTotalGPUMemoryConsumption = (tU32) usedGPUMemKBytes;
	}

	tFloat gpuIdleTimeInPercent;
	if (mGPUInfo.getGPUIdleTime(gpuIdleTimeInPercent) != DIA_SUCCESS) {
		return DIA_FAILED;
	}
	else {
		DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getGPUInfo: gpuIdleTimeInPercent: %lf", gpuIdleTimeInPercent);
		//#####6########
		mMessageXCPMonitoring.mGpuIdleTime = (tU8) gpuIdleTimeInPercent;
	}

	if (mGPUInfo.updateProcessList() != DIA_SUCCESS) {
		DIA_TR_CUS_ERR("dia_SrvHandler_XCPMonitoring::getGPUInfo: updateProcessList: failed");
		return DIA_FAILED;
	}

	// Get top most MAX_NUMBER_OF_PROCESS processes sorted via GPU memory usage
	mTopProcessSortedViaGPUMemoryUsage = mGPUInfo.getTopProcessSortedViaVideoMemoryUsage(MAX_NUMBER_OF_PROCESS);
	if (mTopProcessSortedViaCpuUsage.size() != MAX_NUMBER_OF_PROCESS) {
		DIA_TR_CUS_ERR("dia_SrvHandler_XCPMonitoring::getGPUInfo: mGPUInfo.getTopProcessSortedViaVideoMemoryUsage() FAILED");
		return DIA_FAILED;
	}

	mTopProcessSortedViaGPUMemoryUsageReverseIteratorType reverseIteratorGpuMemoryUsage;
	i = 0;
	for(reverseIteratorGpuMemoryUsage = mTopProcessSortedViaGPUMemoryUsage.rbegin(); reverseIteratorGpuMemoryUsage != mTopProcessSortedViaGPUMemoryUsage.rend(); reverseIteratorGpuMemoryUsage++) {
		DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getGPUInfo: TopGPUMemory[%s] = %lu,  max: %lu KB", reverseIteratorGpuMemoryUsage->second.command, reverseIteratorGpuMemoryUsage->first, reverseIteratorGpuMemoryUsage->second.m_maximumMemKByte);

		//#####7########
		memcpy(mMessageXCPMonitoring.mMemoryTopProcessGPU[i].mMemoryTopProcessName, reverseIteratorGpuMemoryUsage->second.command, MAX_LENGTH_PROCESS_NAME);
		mMessageXCPMonitoring.mMemoryTopProcessGPU[i].mCurrentMemoryTopProcess = (tU32) reverseIteratorGpuMemoryUsage->first;
		mMessageXCPMonitoring.mMemoryTopProcessGPU[i].mMaximumMemoryTopProcess = (tU32) reverseIteratorGpuMemoryUsage->second.m_maximumMemKByte;
		i++;
	}

	// Update offset
	mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);

	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::getResetInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getResetInfo");

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU16 i;
		tU32 address;
		//#####8########
		for (i=0; i<MAX_NUMBER_OF_RESET_HISTORY_ELEMENTS; i++) {
			std::string mResetHistoryReasonStr = std::string("mResetHistoryReason") + dia_Helper::tU16ToString(i);
			address = (tU32)&mMessageXCPMonitoring.mResetHistory[i].reason;
			mXcpMonitoringItemAddressMap[address] = mResetHistoryReasonStr;

			std::string mResetHistoryDateStr = std::string("mResetHistoryDateStr") + dia_Helper::tU16ToString(i);
			address = (tU32)&mMessageXCPMonitoring.mResetHistory[i].dateStr[0];
			mXcpMonitoringItemAddressMap[address] = mResetHistoryDateStr;
		}

		//#####24########
		std::string mResetCounterApApplicationError = std::string("mResetCounterApApplicationError");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.ApApplicationError;
		mXcpMonitoringItemAddressMap[address] = mResetCounterApApplicationError;

		std::string mResetCounterApECUReset = std::string("mResetCounterApECUReset");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.ApECUReset;
		mXcpMonitoringItemAddressMap[address] = mResetCounterApECUReset;

		std::string mResetCounterApUser = std::string("mResetCounterApUser");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.ApUser;
		mXcpMonitoringItemAddressMap[address] = mResetCounterApUser;

		std::string mResetCounterApDownload = std::string("mResetCounterApDownload");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.ApDownload;
		mXcpMonitoringItemAddressMap[address] = mResetCounterApDownload;

		std::string mResetCounterApDownloadError = std::string("mResetCounterApDownloadError");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.ApDownloadError;
		mXcpMonitoringItemAddressMap[address] = mResetCounterApDownloadError;

		std::string mResetCounterApSoftware = std::string("mResetCounterApSoftware");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.ApSoftware;
		mXcpMonitoringItemAddressMap[address] = mResetCounterApSoftware;

		std::string mResetCounterApUnknown = std::string("mResetCounterApUnknown");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.ApUnknown;
		mXcpMonitoringItemAddressMap[address] = mResetCounterApUnknown;

		std::string mResetCounterApOverTemperature = std::string("mResetCounterApOverTemperature");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.ApOverTemperature;
		mXcpMonitoringItemAddressMap[address] = mResetCounterApOverTemperature;

		std::string mResetCounterApLCMIntern = std::string("mResetCounterApLCMIntern");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.ApLCMIntern;
		mXcpMonitoringItemAddressMap[address] = mResetCounterApLCMIntern;

		std::string mResetCounterApPowerOnReset = std::string("mResetCounterApPowerOnReset");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.ApPowerOnReset;
		mXcpMonitoringItemAddressMap[address] = mResetCounterApPowerOnReset;

		std::string mResetCounterApPowerLoss = std::string("mResetCounterApPowerLoss");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.ApPowerLoss;
		mXcpMonitoringItemAddressMap[address] = mResetCounterApPowerLoss;

		std::string mResetCounterApPowerOff = std::string("mResetCounterApPowerOff");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.ApPowerOff;
		mXcpMonitoringItemAddressMap[address] = mResetCounterApPowerOff;

		std::string mResetCounterApScc = std::string("mResetCounterApScc");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.ApScc;
		mXcpMonitoringItemAddressMap[address] = mResetCounterApScc;

		std::string mResetCounterApWarmStart = std::string("mResetCounterApWarmStart");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.ApWarmStart;
		mXcpMonitoringItemAddressMap[address] = mResetCounterApWarmStart;

		std::string mResetCounterSccHWWdt = std::string("mResetCounterSccHWWdt");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.SccHWWdt;
		mXcpMonitoringItemAddressMap[address] = mResetCounterSccHWWdt;

		std::string mResetCounterSccPowerOn = std::string("mResetCounterSccPowerOn");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.SccPowerOn;
		mXcpMonitoringItemAddressMap[address] = mResetCounterSccPowerOn;

		std::string mResetCounterSccColdStart = std::string("mResetCounterSccColdStart");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.SccColdStart;
		mXcpMonitoringItemAddressMap[address] = mResetCounterSccColdStart;

		std::string mResetCounterSccAppModeChange = std::string("mResetCounterSccAppModeChange");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.SccAppModeChange;
		mXcpMonitoringItemAddressMap[address] = mResetCounterSccAppModeChange;

		std::string mResetCounterSccDuringLpw = std::string("mResetCounterSccDuringLpw");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.SccDuringLpw;
		mXcpMonitoringItemAddressMap[address] = mResetCounterSccDuringLpw;

		std::string mResetCounterSccDuringPllOsz = std::string("mResetCounterSccDuringPllOsz");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.SccDuringPllOsz;
		mXcpMonitoringItemAddressMap[address] = mResetCounterSccDuringPllOsz;

		std::string mResetCounterSccDuringSW = std::string("mResetCounterSccDuringSW");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.SccDuringSW;
		mXcpMonitoringItemAddressMap[address] = mResetCounterSccDuringSW;

		std::string mResetCounterSccWarmStart = std::string("mResetCounterSccWarmStart");
		address = (tU32)&mMessageXCPMonitoring.mResetCounter.SccWarmStart;
		mXcpMonitoringItemAddressMap[address] = mResetCounterSccWarmStart;
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(((mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mResetHistory)) - sizeof(mMessageXCPMonitoring.mResetCounter)));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	// Make first subscription
	if(mResetInfo.isResetInfoSubscriptionDone() == FALSE){
		if (mResetInfo.subscribeToLCMForResetInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mResetHistoryInfo.subscribeToLCMForResetInfo() FAILED!!!!");
			return DIA_FAILED;
		}
	}

	if (mResetHistoryUpdated == FALSE) {
		if (mResetInfo.isResetHistoryAvailable() == TRUE) {
			mResetHistoryElements = mResetInfo.getResetHistory(MAX_NUMBER_OF_RESET_HISTORY_ELEMENTS_FOR_TRACE);

			if (mResetHistoryElements.size() != (MAX_NUMBER_OF_RESET_HISTORY_ELEMENTS_FOR_TRACE)) {
				DIA_TR_INF("dia_SrvHandler_XCPMonitoring::getResetInfo mResetHistoryElements.size: %d != MAX: %d", mResetHistoryElements.size(), MAX_NUMBER_OF_RESET_HISTORY_ELEMENTS);
	//			return DIA_FAILED;
			}

			for (tU16 i=0; i<MAX_NUMBER_OF_RESET_HISTORY_ELEMENTS_FOR_TRACE; i++) {
				DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo: History dateStr: %s, reason: %d", mResetHistoryElements.at(i).dateStr, mResetHistoryElements.at(i).reason);
			}
			for (tU16 i=0; i<MAX_NUMBER_OF_RESET_HISTORY_ELEMENTS; i++) {

				//#####8########
				mMessageXCPMonitoring.mResetHistory[i].reason = mResetHistoryElements.at(i).reason;
				memcpy(mMessageXCPMonitoring.mResetHistory[i].dateStr, mResetHistoryElements.at(i).dateStr, MAX_LENGTH_DATE);
			}

			mResetHistoryUpdated = TRUE;
		}
	}

	if (mResetCounterUpdated == FALSE) {
		if (mResetInfo.isResetCounterAvailable() == TRUE) {
			ResetCounterElement resetCounterElement = mResetInfo.getResetCounter();

			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter ApApplicationError %d", resetCounterElement.ApApplicationError);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter ApECUReset %d", resetCounterElement.ApECUReset);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter ApUser %d", resetCounterElement.ApUser);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter ApDownload %d", resetCounterElement.ApDownload);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter ApDownloadError %d", resetCounterElement.ApDownloadError);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter ApSoftware %d", resetCounterElement.ApSoftware);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter ApUnknown %d", resetCounterElement.ApUnknown);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter ApOverTemperature %d", resetCounterElement.ApOverTemperature);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter ApLCMIntern %d", resetCounterElement.ApLCMIntern);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter ApPowerOnReset %d", resetCounterElement.ApPowerOnReset);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter ApPowerLoss %d", resetCounterElement.ApPowerLoss);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter ApPowerOff %d", resetCounterElement.ApPowerOff);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter ApScc %d", resetCounterElement.ApScc);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter ApWarmStart %d", resetCounterElement.ApWarmStart);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter SccHWWdt %d", resetCounterElement.SccHWWdt);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter SccPowerOn %d", resetCounterElement.SccPowerOn);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter SccColdStart %d", resetCounterElement.SccColdStart);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter SccAppModeChange %d", resetCounterElement.SccAppModeChange);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter SccDuringLpw %d", resetCounterElement.SccDuringLpw);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter SccDuringPllOsz %d", resetCounterElement.SccDuringPllOsz);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter SccDuringSW %d", resetCounterElement.SccDuringSW);
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getResetInfo resetCounter SccWarmStart %d", resetCounterElement.SccWarmStart);

			//#####24########
			mMessageXCPMonitoring.mResetCounter.ApApplicationError = resetCounterElement.ApApplicationError;
			mMessageXCPMonitoring.mResetCounter.ApECUReset = resetCounterElement.ApECUReset;
			mMessageXCPMonitoring.mResetCounter.ApUser = resetCounterElement.ApUser;
			mMessageXCPMonitoring.mResetCounter.ApDownload = resetCounterElement.ApDownload;
			mMessageXCPMonitoring.mResetCounter.ApDownloadError = resetCounterElement.ApDownloadError;
			mMessageXCPMonitoring.mResetCounter.ApSoftware = resetCounterElement.ApSoftware;
			mMessageXCPMonitoring.mResetCounter.ApUnknown = resetCounterElement.ApUnknown;
			mMessageXCPMonitoring.mResetCounter.ApOverTemperature = resetCounterElement.ApOverTemperature;
			mMessageXCPMonitoring.mResetCounter.ApLCMIntern = resetCounterElement.ApLCMIntern;
			mMessageXCPMonitoring.mResetCounter.ApPowerOnReset = resetCounterElement.ApPowerOnReset;
			mMessageXCPMonitoring.mResetCounter.ApPowerLoss = resetCounterElement.ApPowerLoss;
			mMessageXCPMonitoring.mResetCounter.ApPowerOff = resetCounterElement.ApPowerOff;
			mMessageXCPMonitoring.mResetCounter.ApScc = resetCounterElement.ApScc;
			mMessageXCPMonitoring.mResetCounter.ApWarmStart = resetCounterElement.ApWarmStart;
			mMessageXCPMonitoring.mResetCounter.SccHWWdt = resetCounterElement.SccHWWdt;
			mMessageXCPMonitoring.mResetCounter.SccPowerOn = resetCounterElement.SccPowerOn;
			mMessageXCPMonitoring.mResetCounter.SccColdStart = resetCounterElement.SccColdStart;
			mMessageXCPMonitoring.mResetCounter.SccAppModeChange = resetCounterElement.SccAppModeChange;
			mMessageXCPMonitoring.mResetCounter.SccDuringLpw = resetCounterElement.SccDuringLpw;
			mMessageXCPMonitoring.mResetCounter.SccDuringPllOsz = resetCounterElement.SccDuringPllOsz;
			mMessageXCPMonitoring.mResetCounter.SccDuringSW = resetCounterElement.SccDuringSW;
			mMessageXCPMonitoring.mResetCounter.SccWarmStart = resetCounterElement.SccWarmStart;

			mResetCounterUpdated = TRUE;

			// Update offset
			mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1); // Transfer the data even one of the reset info (e.g. ResetHistory) is not available
		}
	}


	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::getPowerStatusInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getPowerStatusInfo");

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		//#####9########
		std::string mPowerStatusStr = std::string("mPowerStatus");
		address = (tU32)&mMessageXCPMonitoring.mPowerStatus;
		mXcpMonitoringItemAddressMap[address] = mPowerStatusStr;
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mPowerStatus));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	// Make first subscription
	if(mPowerStatusInfo.isLCMSubscriptionDone() == FALSE){
		if (mPowerStatusInfo.subscribeToLCMForPowerState() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mPowerStatusInfo.subscribeToLCMForPowerState() FAILED!!!!");
			return DIA_FAILED;
		}
	}

	if (mPowerStatusInfo.isPowerStateAvailable() == TRUE){
		tU8 powerStatus = mPowerStatusInfo.getPowerState();
		if (powerStatus == 0x00) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::getPowerStatusInfo mPowerStatus = 0x00");
			return DIA_FAILED;
		}

		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getPowerStatusInfo mPowerStatus (binary): " BYTETOBINARYPATTERN, BYTETOBINARY(powerStatus));

		//#####9########
		mMessageXCPMonitoring.mPowerStatus = powerStatus;

		// Update offset
		mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);
	}

	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::getVehicleSignalsInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getVehicleSignalsInfo");

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		//#####10########
		std::string mVehicleSignalsStr = std::string("mVehicleSignals");
		address = (tU32)&mMessageXCPMonitoring.mVehicleSignals;
		mXcpMonitoringItemAddressMap[address] = mVehicleSignalsStr;
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mVehicleSignals));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	// Make first subscription
	if(mVehicleSignalsInfo.isVehicleDataSubscriptionDone() == FALSE){
		if (mVehicleSignalsInfo.subscribeForVehicleData() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mVehicleSignalsInfo.subscribeForVehicleData() FAILED!!!!");
			return DIA_FAILED;
		}
	}

	if (mVehicleSignalsInfo.isVehicleDataAvailable() == TRUE){
		tU8 vehicleData = mVehicleSignalsInfo.getVehicleData();

		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getVehicleSignalsInfo vehicleData (binary): " BYTETOBINARYPATTERN, BYTETOBINARY(vehicleData));

		//#####10########
		mMessageXCPMonitoring.mVehicleSignals = vehicleData;

		// Update offset
		mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);
	}

	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::getCommunicationStatus()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getCommunicationStatus");

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		//#####11########
		std::string mCommunicationStatusStr = std::string("mCommunicationStatus");
		address = (tU32)&mMessageXCPMonitoring.mCommunicationStatus;
		mXcpMonitoringItemAddressMap[address] = mCommunicationStatusStr;
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
		//#####27########
		std::string mTCUCommunicationErrorCodeStr = std::string("mTCUCommunicationErrorCode");
		address = (tU32)&mMessageXCPMonitoring.mTCUCommunicationErrorCode;
		mXcpMonitoringItemAddressMap[address] = mTCUCommunicationErrorCodeStr;

		std::string mTCUConnectionStatusStr = std::string("mTCUConnectionStatus");
		address = (tU32)&mMessageXCPMonitoring.mTCUConnectionStatus;
		mXcpMonitoringItemAddressMap[address] = mTCUConnectionStatusStr;

		std::string mMCANConnectionStatusNAVStr = std::string("mMeterConStatusNAV");
		address = (tU32)&mMessageXCPMonitoring.mMeterConStatusNAV;
		mXcpMonitoringItemAddressMap[address] = mMCANConnectionStatusNAVStr;



		std::string mMCANConnectionStatusAUDIOStr = std::string("mMeterConStatusAUDIO");
		address = (tU32)&mMessageXCPMonitoring.mMeterConStatusAUDIO;
		mXcpMonitoringItemAddressMap[address] = mMCANConnectionStatusAUDIOStr;
#endif
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	    mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mCommunicationStatus)- sizeof(mMessageXCPMonitoring.mTCUCommunicationErrorCode)- sizeof(mMessageXCPMonitoring.mTCUConnectionStatus)- sizeof(mMessageXCPMonitoring.mMeterConStatusNAV)- sizeof(mMessageXCPMonitoring.mMeterConStatusAUDIO));
#else
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mCommunicationStatus));
#endif

		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	// Make first subscription
	if (mCommunicationStatus.isConnectionStatusSubscriptionDone() == FALSE) {
		if (mCommunicationStatus.subscribeForConnectionStatus() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mCommunicationStatus.subscribeForConnectionStatus() FAILED!!!!");
			return DIA_FAILED;
		}
	}

	// Make first subscription
	if (mCommunicationStatus.isMCANConnectionStatusSubscriptionDone() == FALSE) {
		if (mCommunicationStatus.subscribeForMCANMeterConnectionStatus() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mCommunicationStatus.subscribeForMCANMeterConnectionStatus() FAILED!!!!");
			return DIA_FAILED;
		}
	}

	if (mCommunicationStatus.isMCANConnectionStatusAvailable() == TRUE) {
		dia_MeterConnectionInfo connectionStatus = mCommunicationStatus.getMeterConnectionStatus();

		//#####30########

		mMessageXCPMonitoring.mMeterConStatusNAV = connectionStatus.connectionstatusNAV;
		mMessageXCPMonitoring.mMeterConStatusAUDIO = connectionStatus.connectionstatusAUDIO;
		
		DIA_TR_INF("dia_SrvHandler_XCPMonitoring::getMeterConnectionStatus - mMeterConStatusNAV = %d", mMessageXCPMonitoring.mMeterConStatusNAV);
		DIA_TR_INF("dia_SrvHandler_XCPMonitoring::getMeterConnectionStatus - mMeterConStatusAUDIO= %d", connectionStatus.connectionstatusAUDIO);
	
	}
#endif
	// Make first subscription
	if(mCommunicationStatus.isCommunicationStatusSubscriptionDone() == FALSE){
		if (mCommunicationStatus.subscribeForCommunicationStatus() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mCommunicationStatus.subscribeForCommunicationStatus() FAILED!!!!");
			return DIA_FAILED;
		}
	}

	if (mCommunicationStatus.isCommunicationStatusAvailable() == TRUE){
		tU8 communicationStatus = mCommunicationStatus.getCommunicationStatus();

		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getCommunicationStatus communicationStatus (binary): " BYTETOBINARYPATTERN, BYTETOBINARY(communicationStatus));

		//#####11########
		mMessageXCPMonitoring.mCommunicationStatus = communicationStatus;
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
		tU8 u8TcucommunicationStatus = mCommunicationStatus.getTCUCommunicationStatus();

		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getTCUCommunicationStatus TCU communicationStatus (binary): " BYTETOBINARYPATTERN, BYTETOBINARY(u8TcucommunicationStatus));

		//#####11########
		mMessageXCPMonitoring.mTCUCommunicationErrorCode = u8TcucommunicationStatus;
		if (mCommunicationStatus.isConnectionStatusAvailable() == TRUE) {
			tU8 connectionStatus = mCommunicationStatus.getConnectionStatus();

			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getCommunicationStatus TCU_MCAN_ConnectionStatus : %d", connectionStatus);

			//#####11########
			mMessageXCPMonitoring.mTCUConnectionStatus = connectionStatus;
		}
#endif

	}

	mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex - 1);
	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::getCardStatus()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getCardStatus");

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		//#####12########
		std::string mUSBConnectionState = std::string("mUSBConnectionState");
		address = (tU32)&mMessageXCPMonitoring.mCardInfo.USBconnectionState;
		mXcpMonitoringItemAddressMap[address] = mUSBConnectionState;

		std::string mUSBDeviceSpeed = std::string("mUSBDeviceSpeed");
		address = (tU32)&mMessageXCPMonitoring.mCardInfo.USBdeviceSpeed;
		mXcpMonitoringItemAddressMap[address] = mUSBDeviceSpeed;

		std::string mUSBFileSystem = std::string("mUSBFileSystem");
		address = (tU32)&mMessageXCPMonitoring.mCardInfo.USBfileSystem;
		mXcpMonitoringItemAddressMap[address] = mUSBFileSystem;

		std::string mUSBSize = std::string("mUSBSize");
		address = (tU32)&mMessageXCPMonitoring.mCardInfo.USBsize;
		mXcpMonitoringItemAddressMap[address] = mUSBSize;

		std::string mUSBReadWriteState = std::string("mUSBReadWriteState");
		address = (tU32)&mMessageXCPMonitoring.mCardInfo.USBReadWriteState;
		mXcpMonitoringItemAddressMap[address] = mUSBReadWriteState;

		std::string meMMCReadWriteState = std::string("meMMCReadWriteState");
		address = (tU32)&mMessageXCPMonitoring.mCardInfo.eMMCReadWriteState;
		mXcpMonitoringItemAddressMap[address] = meMMCReadWriteState;

		std::string meMMCReadSpeed = std::string("meMMCReadSpeed");
		address = (tU32)&mMessageXCPMonitoring.mCardInfo.eMMCReadSpeed;
		mXcpMonitoringItemAddressMap[address] = meMMCReadSpeed;
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
		std::string mOpticDiskConnectionStatus = std::string("mOpticDiskConnectionStatus");
		address = (tU32)&mMessageXCPMonitoring.mCardInfo.OpticDiskConnectionStatus;
		mXcpMonitoringItemAddressMap[address] = mOpticDiskConnectionStatus;
#endif
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mCardInfo));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	// Make first subscription
	if(mCardStatus.isCardStatusSubscriptionDone() == FALSE){
		if (mCardStatus.subscribeForCardStatus() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mCardStatus.subscribeForCardStatus() FAILED!!!!");
			return DIA_FAILED;
		}
	}

	mCardInfoAvailable = FALSE;

	if (mCardStatus.isUSBStatusAvailable() == TRUE){
		dia_tDeviceInfo deviceInfoUSB = mCardStatus.getUSBCardStatus();

		//#####12########
		mMessageXCPMonitoring.mCardInfo.USBconnectionState = deviceInfoUSB.ConnectionState;
		mMessageXCPMonitoring.mCardInfo.USBdeviceSpeed = deviceInfoUSB.DeviceSpeed;
		mMessageXCPMonitoring.mCardInfo.USBfileSystem = deviceInfoUSB.FileSystem;
		mMessageXCPMonitoring.mCardInfo.USBsize = (tU32) ((deviceInfoUSB.Size/1024)/1024);  // convert from Byte to MB (2^10 = 1024)

		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getCardStatus: deviceInfoUSB: con: %d spd: %d, sz[MB]: %d fs: %d", deviceInfoUSB.ConnectionState, deviceInfoUSB.DeviceSpeed, mMessageXCPMonitoring.mCardInfo.USBsize, deviceInfoUSB.FileSystem);

		tU8 eMMCReadWriteState = 0x00;
		tU8 USBReadWriteState  = 0x00;
		if (mProcInfo.scanDiskstats(eMMCReadWriteState, USBReadWriteState) == DIA_SUCCESS){
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getCardStatus: USBReadWriteState: 0x%X, eMMCReadWriteState: 0x%X", USBReadWriteState, eMMCReadWriteState);
		}

		mMessageXCPMonitoring.mCardInfo.USBReadWriteState = USBReadWriteState;
		mMessageXCPMonitoring.mCardInfo.eMMCReadWriteState = eMMCReadWriteState;

		mCardInfoAvailable = TRUE;
	}

	if (mCardStatus.iseMMCStatusAvailable() == TRUE){
		tDouble eMMCReadSpeed = mCardStatus.geteMMCReadSpeed();

		//#####12########
		mMessageXCPMonitoring.mCardInfo.eMMCReadSpeed = (tU8) eMMCReadSpeed;

		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getCardStatus: eMMCReadSpeed: %lf MB/sec", eMMCReadSpeed);

		mCardInfoAvailable = TRUE;
	}

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	if (mCardStatus.isOpticDiskStatusAvailable() == TRUE){
		tU8 opticDiskState = mCardStatus.getOpticDiskConStatusResult();
		mMessageXCPMonitoring.mCardInfo.OpticDiskConnectionStatus = opticDiskState;
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getCardStatus opticDiskState: %d ", opticDiskState);

		mCardInfoAvailable = TRUE;
	}
#endif

	if (mCardInfoAvailable) {
		// Update offset
		mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);
	}

	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::getStartupStatus()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getStartupStatus");
	tU16 i;

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		//#####13########
//			std::string mStartupStatus64 = std::string("mStartupStatus64");
//			address = (tU32)&mMessageXCPMonitoring.mStartupStatus.startupStatus64;
//			mXcpMonitoringItemAddressMap[address] = mStartupStatus64;

		std::string mStartupStatus0_31 = std::string("mStartupStatus0_31");
		address = (tU32)&mMessageXCPMonitoring.mStartupStatus.startupStatus0_31;
		mXcpMonitoringItemAddressMap[address] = mStartupStatus0_31;

		std::string mStartupStatus32_63 = std::string("mStartupStatus32_63");
		address = (tU32)&mMessageXCPMonitoring.mStartupStatus.startupStatus32_63;
		mXcpMonitoringItemAddressMap[address] = mStartupStatus32_63;

		for (i=0; i<MAX_NUMBER_OF_STARTUP_STATUS_ELEMENTS; i++) {
				std::string mStartupTime = std::string("mStartupTime") + dia_Helper::tU16ToString(i);
				address = (tU32)&mMessageXCPMonitoring.mStartupStatus.startTimeSinceStart[i];
				mXcpMonitoringItemAddressMap[address] = mStartupTime;
		}
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mStartupStatus));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	if (mStartupStatusUpdated == FALSE) {
		// Make first subscriptions
		if(mStartupStatusInfo.isStartupStatusSubscriptionDone() == FALSE){
			if (mStartupStatusInfo.subscribeToSPMForStartupStatus() != DIA_SUCCESS) {
				DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mStartupStatusInfo.subscribeToSPMForStartupStatus() FAILED!!!!");
				return DIA_FAILED;
			}
		}

		if (mStartupStatusInfo.isStartupStatusAvailable() == TRUE){
			std::vector<ProcessElement> processElements = mStartupStatusInfo.getStartupStatus(MAX_NUMBER_OF_STARTUP_STATUS_ELEMENTS);
			if (processElements.size() == MAX_NUMBER_OF_STARTUP_STATUS_ELEMENTS) {
				DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getStartupStatus: got an update for %d processes", processElements.size());

				tU64 processStateRunning64 = 1; // used below for bit shifting
				tU64 startupStatus64 = 0;
				mMessageXCPMonitoring.mStartupStatus.startupStatus0_31 = 0;
				mMessageXCPMonitoring.mStartupStatus.startupStatus32_63 = 0;
				for (i=0; i<MAX_NUMBER_OF_STARTUP_STATUS_ELEMENTS; i++) {
					if (processElements.at(i).state == PROCESS_STATE_RUNNING) {
						startupStatus64 |= (processStateRunning64 << processElements.at(i).processID);
						mMessageXCPMonitoring.mStartupStatus.startTimeSinceStart[i] = (tU16)processElements.at(i).startTimeSinceStart;				}
				}
	//			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::(binary 64): "LWORDTOBINARYPATTERN, LWORDTOBINARY(startupStatus64));

				// Split 64 bit startup status into two 32 bit startup statuses
				mMessageXCPMonitoring.mStartupStatus.startupStatus0_31 = (startupStatus64 & 0xFFFFFFFF);
				mMessageXCPMonitoring.mStartupStatus.startupStatus32_63 = ((startupStatus64 >> 32) & 0xFFFFFFFF);
				DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::(binary 00-31): " DWORDTOBINARYPATTERN, DWORDTOBINARY(mMessageXCPMonitoring.mStartupStatus.startupStatus0_31));
				DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::(binary 32-63): " DWORDTOBINARYPATTERN, DWORDTOBINARY(mMessageXCPMonitoring.mStartupStatus.startupStatus32_63));

				// Update offset
				mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);
			}
			else {
				DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::getStartupStatus: processElements.size(%d) != MAX_NUMBER_OF_STARTUP_STATUS_ELEMENTS: %d", processElements.size(), MAX_NUMBER_OF_STARTUP_STATUS_ELEMENTS);
				return DIA_FAILED;
			}

			mStartupStatusUpdated = TRUE;
		}
	}

#ifdef VARIANT_S_FTR_ENABLE_RIVIE
	if (mWakeupStatusUpdated == FALSE) {
		if(mStartupStatusInfo.isWakeupStatusSubscriptionDone() == FALSE){
			if (mStartupStatusInfo.subscribeToSPMForWakeupHistory() != DIA_SUCCESS) {
				DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mStartupStatusInfo.subscribeToSPMForWakeupHistory() FAILED!!!!");
				return DIA_FAILED;
			}
		}

		if (mStartupStatusInfo.isWakeupStatusAvailable() == TRUE){
			std::vector<WakeupHistoryElement> wakeupHistoryElements = mStartupStatusInfo.getWakeupStatus(MAX_NUMBER_OF_WAKEUP_STATUS_ELEMENTS);
			if (wakeupHistoryElements.size() <= MAX_NUMBER_OF_WAKEUP_STATUS_ELEMENTS) {
				for (i=0; i<wakeupHistoryElements.size(); i++) {
					DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getWakeupStatus History(%d). Date: %s Reason: %d", i, wakeupHistoryElements.at(i).dateStr, wakeupHistoryElements.at(i).reason);
				}
			}

			mWakeupStatusUpdated = TRUE;
		}
	}
#endif

	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::getSurfaceProperties()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getSurfaceProperties");

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		//#####14########
		std::string mSurfaceID = std::string("mSurfaceID");
		address = (tU32)&mMessageXCPMonitoring.mSurfaceProperties.surfaceID;
		mXcpMonitoringItemAddressMap[address] = mSurfaceID;

		std::string mSurfaceFPS = std::string("mSurfaceFPS");
		address = (tU32)&mMessageXCPMonitoring.mSurfaceProperties.surfaceFPS;
		mXcpMonitoringItemAddressMap[address] = mSurfaceFPS;
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mSurfaceProperties));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	if (mILMInfo.isIlmInitialized() == TRUE){
		tU16 surfaceID;
		tU16 fpsOfKeyboardFocusSurface;
		std::string surfaceName;
		if (mILMInfo.getPropertiesOfKeyboardFocusSurface(surfaceID, fpsOfKeyboardFocusSurface, surfaceName) != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mILMInfo.getPropertiesOfKeyboardFocusSurface() FAILED!!!!");
			return DIA_FAILED;
		}
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getSurfaceProperties surfaceID: %d fps: %d (%s)", surfaceID, fpsOfKeyboardFocusSurface, surfaceName.c_str());

		mMessageXCPMonitoring.mSurfaceProperties.surfaceID = surfaceID;
		mMessageXCPMonitoring.mSurfaceProperties.surfaceFPS = fpsOfKeyboardFocusSurface;

		// Update offset
		mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);
	}

	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::getGnssInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getGnssInfo");

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		//#####15########
		std::string mGnssFixStatus = std::string("mGnssFixStatus");
		address = (tU32)&mMessageXCPMonitoring.mGnssData.fixStatus;
		mXcpMonitoringItemAddressMap[address] = mGnssFixStatus;

		std::string mGnssVelocityNorth = std::string("mGnssVelocityNorth");
		address = (tU32)&mMessageXCPMonitoring.mGnssData.velocityNorth;
		mXcpMonitoringItemAddressMap[address] = mGnssVelocityNorth;

		std::string mGnssVelocityEast = std::string("mGnssVelocityEast");
		address = (tU32)&mMessageXCPMonitoring.mGnssData.velocityEast;
		mXcpMonitoringItemAddressMap[address] = mGnssVelocityEast;

		std::string mGnssDateStr = std::string("mGnssDateStr");
		address = (tU32)&mMessageXCPMonitoring.mGnssData.dateStr[0];
		mXcpMonitoringItemAddressMap[address] = mGnssDateStr;
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mGnssData));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	if (mAllianceVariantType != ALLIANCE_VARIANT_TYPE_DA){ // In DA variants no Gnss info is available
		// Make first subscription
		if(mGnssInfo.isGnssInfoSubscriptionDone() == FALSE){
			if (mGnssInfo.subscribeForGnssInfo() != DIA_SUCCESS) {
				DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mGnssInfo.subscribeForGnssInfo() FAILED!!!!");
				return DIA_FAILED;
			}
		}
	}

	if (mGnssInfo.isGnssInfoAvailable() == TRUE){
		GnssInfoElement gnssInfoElement = mGnssInfo.getGnssInfoElement();

		mMessageXCPMonitoring.mGnssData.fixStatus = gnssInfoElement.fixStatus;
		mMessageXCPMonitoring.mGnssData.velocityNorth = gnssInfoElement.velocityNorth;
		mMessageXCPMonitoring.mGnssData.velocityEast = gnssInfoElement.velocityEast;
		memcpy(mMessageXCPMonitoring.mGnssData.dateStr, gnssInfoElement.dateStr, MAX_LENGTH_DATE);

		switch(gnssInfoElement.fixStatus)
		{
			case 0x01: // NOFIX:
				DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getGnssInfo. FixStatus: NO-FIX");
				 break;
			case 0x02: //2DFIX:
				DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getGnssInfo. FixStatus: 2D-FIX");
				 break;
			case 0x04: //3DFIX:
				DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getGnssInfo. FixStatus: 3D-FIX");
				 break;
			default:
				 break;
		}

		DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getGnssInfo. velocityNorth: %d m/s, velocityEast: %d m/s", gnssInfoElement.velocityNorth, gnssInfoElement.velocityEast);

		DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getGnssInfo. dateStr: '%s'", gnssInfoElement.dateStr);
#ifdef VARIANT_S_FTR_ENABLE_RIVIE
		// GPS coordinates (Lat + Long) are in milliseconds. Example Latitude: 52.1122266667 * 3600000 = 187604016 milliseconds.
		// There are 60 minutes in each degree, 60 seconds in each minute, and 1000 milliseconds in each second. 3600000 = 60*60*1000.
		DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getGnssInfo. GPS Pos = Lat:%d ms Long:%d ms Alt:%d m", gnssInfoElement.latitudeMSeconds, gnssInfoElement.longitudeMSeconds, gnssInfoElement.altitude);
#endif
		// Update offset
		mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);
	}

	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::getWlanInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getWlanInfo");

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		//#####16########
		std::string mWiFiEssidStr = std::string("mWiFiEssidStr");
		address = (tU32)&mMessageXCPMonitoring.mWiFiData.essIdStr[0];
		mXcpMonitoringItemAddressMap[address] = mWiFiEssidStr;

		std::string mWiFiFrequency = std::string("mWiFiFrequency");
		address = (tU32)&mMessageXCPMonitoring.mWiFiData.frequency;
		mXcpMonitoringItemAddressMap[address] = mWiFiFrequency;

		std::string mWiFiBitrate = std::string("mWiFiBitrate");
		address = (tU32)&mMessageXCPMonitoring.mWiFiData.bitRate;
		mXcpMonitoringItemAddressMap[address] = mWiFiBitrate;

//			std::string mWiFiStandardStr = std::string("mWiFiStandardStr");
//			address = (tU32)&mMessageXCPMonitoring.mWiFiData.standardStr[0];
//			mXcpMonitoringItemAddressMap[address] = mWiFiStandardStr;
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mWiFiData));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	// Make first initialization
	if(mWlanInfo.isNlInitialized() == FALSE){
		if (mWlanInfo.initNlSocket() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getWlanInfo.initNlSocket() FAILED!!!!");
			return DIA_FAILED;
		}
	}

	if (mWlanInfo.updateWiFiInfo() != DIA_SUCCESS) {
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getWlanInfo.updateWiFiInfo() FAILED!!!!");
		return DIA_FAILED;
	}

	if (mWlanInfo.isWlanInfoAvailable()) {
		WiFiInfoElement wifiInfoElement = mWlanInfo.getWiFiInfoElement();

		memcpy(mMessageXCPMonitoring.mWiFiData.essIdStr, wifiInfoElement.essId, MAX_LENGTH_WIFI_ESSID);
		mMessageXCPMonitoring.mWiFiData.frequency = wifiInfoElement.frequency;
		mMessageXCPMonitoring.mWiFiData.bitRate = wifiInfoElement.bitRate;
//		memcpy(mMessageXCPMonitoring.mWiFiData.standardStr, wifiInfoElement.standard, MAX_LENGTH_WIFI_STANDARD);

		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getWlanInfo(): SSID = '%s' freq: %d MHz bitrate: %d Mbps", wifiInfoElement.essId, wifiInfoElement.frequency,  wifiInfoElement.bitRate);

		// Update offset
		mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);
	}

	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::getSensorInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getSensorInfo");

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		//#####17########

		// Gyro
		std::string mGyroRAxisVal = std::string("mGyroRAxisVal");
		address = (tU32)&mMessageXCPMonitoring.mGyroData.rAxisVal;
		mXcpMonitoringItemAddressMap[address] = mGyroRAxisVal;

		std::string mGyroSAxisVal = std::string("mGyroSAxisVal");
		address = (tU32)&mMessageXCPMonitoring.mGyroData.sAxisVal;
		mXcpMonitoringItemAddressMap[address] = mGyroSAxisVal;

		std::string mGyroTAxisVal = std::string("mGyroTAxisVal");
		address = (tU32)&mMessageXCPMonitoring.mGyroData.tAxisVal;
		mXcpMonitoringItemAddressMap[address] = mGyroTAxisVal;

		std::string mGyroRAxisStatus = std::string("mGyroRAxisStatus");
		address = (tU32)&mMessageXCPMonitoring.mGyroData.rAxisStatus;
		mXcpMonitoringItemAddressMap[address] = mGyroRAxisStatus;

		std::string mGyroSAxisStatus = std::string("mGyroSAxisStatus");
		address = (tU32)&mMessageXCPMonitoring.mGyroData.sAxisStatus;
		mXcpMonitoringItemAddressMap[address] = mGyroSAxisStatus;

		std::string mGyroTAxisStatus = std::string("mGyroTAxisStatus");
		address = (tU32)&mMessageXCPMonitoring.mGyroData.tAxisStatus;
		mXcpMonitoringItemAddressMap[address] = mGyroTAxisStatus;

		// Acc
		std::string mAccRAxisVal = std::string("mAccRAxisVal");
		address = (tU32)&mMessageXCPMonitoring.mAccData.rAxisVal;
		mXcpMonitoringItemAddressMap[address] = mAccRAxisVal;

		std::string mAccSAxisVal = std::string("mAccSAxisVal");
		address = (tU32)&mMessageXCPMonitoring.mAccData.sAxisVal;
		mXcpMonitoringItemAddressMap[address] = mAccSAxisVal;

		std::string mAccTAxisVal = std::string("mAccTAxisVal");
		address = (tU32)&mMessageXCPMonitoring.mAccData.tAxisVal;
		mXcpMonitoringItemAddressMap[address] = mAccTAxisVal;

		std::string mAccRAxisStatus = std::string("mAccRAxisStatus");
		address = (tU32)&mMessageXCPMonitoring.mAccData.rAxisStatus;
		mXcpMonitoringItemAddressMap[address] = mAccRAxisStatus;

		std::string mAccSAxisStatus = std::string("mAccSAxisStatus");
		address = (tU32)&mMessageXCPMonitoring.mAccData.sAxisStatus;
		mXcpMonitoringItemAddressMap[address] = mAccSAxisStatus;

		std::string mAccTAxisStatus = std::string("mAccTAxisStatus");
		address = (tU32)&mMessageXCPMonitoring.mAccData.tAxisStatus;
		mXcpMonitoringItemAddressMap[address] = mAccTAxisStatus;
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back((mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mGyroData)) - sizeof(mMessageXCPMonitoring.mAccData));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	if (mAllianceVariantType != ALLIANCE_VARIANT_TYPE_DA){ // In DA variants no Sensor info is available
		// Make first subscription
		if(mSensorInfo.isSensorInfoSubscriptionDone() == FALSE){
			if (mSensorInfo.subscribeForSensorInfo() != DIA_SUCCESS) {
				DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mSensorInfo.subscribeForSensorInfo() FAILED!!!!");
				return DIA_FAILED;
			}
		}
	}

	// Gyro
	if (mSensorInfo.isGyroInfoAvailable() == TRUE){
		SensorInfoElement gyroInfoElement = mSensorInfo.getGyroInfoElement();

		mMessageXCPMonitoring.mGyroData.rAxisVal = gyroInfoElement.rAxisVal;
		mMessageXCPMonitoring.mGyroData.sAxisVal = gyroInfoElement.sAxisVal;
		mMessageXCPMonitoring.mGyroData.tAxisVal = gyroInfoElement.tAxisVal;

		mMessageXCPMonitoring.mGyroData.rAxisStatus = gyroInfoElement.rAxisStatus;
		mMessageXCPMonitoring.mGyroData.sAxisStatus = gyroInfoElement.sAxisStatus;
		mMessageXCPMonitoring.mGyroData.tAxisStatus = gyroInfoElement.tAxisStatus;

		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getGyroInfo(): rAxisVal: %d, sAxisVal: %d, tAxisVal: %d", gyroInfoElement.rAxisVal, gyroInfoElement.sAxisVal, gyroInfoElement.tAxisVal);
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getGyroInfo(): rAxisStatus: %d, sAxisStatus: %d, tAxisStatus: %d", gyroInfoElement.rAxisStatus, gyroInfoElement.sAxisStatus, gyroInfoElement.tAxisStatus);
	}

	// Acc
	if (mSensorInfo.isAccInfoAvailable() == TRUE){
		SensorInfoElement accInfoElement = mSensorInfo.getAccInfoElement();

		mMessageXCPMonitoring.mAccData.rAxisVal = accInfoElement.rAxisVal;
		mMessageXCPMonitoring.mAccData.sAxisVal = accInfoElement.sAxisVal;
		mMessageXCPMonitoring.mAccData.tAxisVal = accInfoElement.tAxisVal;

		mMessageXCPMonitoring.mAccData.rAxisStatus = accInfoElement.rAxisStatus;
		mMessageXCPMonitoring.mAccData.sAxisStatus = accInfoElement.sAxisStatus;
		mMessageXCPMonitoring.mAccData.tAxisStatus = accInfoElement.tAxisStatus;

		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getAccInfo(): rAxisVal: %d, sAxisVal: %d, tAxisVal: %d", accInfoElement.rAxisVal, accInfoElement.sAxisVal, accInfoElement.tAxisVal);
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getAccInfo(): rAxisStatus: %d, sAxisStatus: %d, tAxisStatus: %d", accInfoElement.rAxisStatus, accInfoElement.sAxisStatus, accInfoElement.tAxisStatus);
	}

	if (mSensorInfo.isGyroInfoAvailable() == TRUE && mSensorInfo.isAccInfoAvailable() == TRUE){
		// Update offset
		mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);
	}

	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::getHeatControlInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getHeatControlInfo");

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		//#####18########
		std::string mHeatControlCpuTemperature = std::string("mHeatControlCpuTemperature");
		address = (tU32)&mMessageXCPMonitoring.mHeatControlData.cpuTemperature;
		mXcpMonitoringItemAddressMap[address] = mHeatControlCpuTemperature;

		std::string mHeatControlCpuFanSpeed = std::string("mHeatControlCpuFanSpeed");
		address = (tU32)&mMessageXCPMonitoring.mHeatControlData.cpuFanSpeed;
		mXcpMonitoringItemAddressMap[address] = mHeatControlCpuFanSpeed;
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mHeatControlData));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	// Make first subscription
	if(mHeatControlInfo.isHeatControlInfoSubscriptionDone() == FALSE){
		if (mHeatControlInfo.subscribeForHeatControlInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mHeatControlInfo.subscribeForHeatControlInfo() FAILED!!!!");
			return DIA_FAILED;
		}
	}

	if (mHeatControlInfo.isHeatControlInfoAvailable() == TRUE){
		HeatControlInfoElement heatControlInfoElement = mHeatControlInfo.getHeatControlInfoElement();

		mMessageXCPMonitoring.mHeatControlData.cpuTemperature = heatControlInfoElement.cpuTemperature;
		mMessageXCPMonitoring.mHeatControlData.cpuFanSpeed = heatControlInfoElement.cpuFanSpeed;

		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getHeatControlInfo(): cpuTemperature: %d, cpuFanSpeed: %d", heatControlInfoElement.cpuTemperature, heatControlInfoElement.cpuFanSpeed);

		// Update offset
		mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);
	}

	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::getHMIMonitorInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getHMIMonitorInfo");

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		//#####19########
		std::string mHMIMonitorStartupTime = std::string("mHMIMonitorStartupTime");
		address = (tU32)&mMessageXCPMonitoring.mHmiMonitorStartupTime;
		mXcpMonitoringItemAddressMap[address] = mHMIMonitorStartupTime;

		std::string mHMIMonitorScreenName = std::string("mHMIMonitorScreenName");
		address = (tU32)&mMessageXCPMonitoring.mHmiMonitorScreenName[0];
		mXcpMonitoringItemAddressMap[address] = mHMIMonitorScreenName;
		
	
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
		std::string mHmiMonitorSecondaryScreenName = std::string("mHmiMonitorSecondaryScreenName");
		address = (tU32)&mMessageXCPMonitoring.mHmiMonitorSecondaryScreenName[0];
		mXcpMonitoringItemAddressMap[address] = mHmiMonitorSecondaryScreenName;
		std::string mHmiMonitorNextUpperAppName = std::string("mHmiMonitorNextUpperAppName");
		address = (tU32)&mMessageXCPMonitoring.mHmiMonitorNextUpperAppName[0];
		mXcpMonitoringItemAddressMap[address] = mHmiMonitorNextUpperAppName;
		std::string mHmiMonitorNextLowerAppName = std::string("mHmiMonitorNextLowerAppName");
		address = (tU32)&mMessageXCPMonitoring.mHmiMonitorNextLowerAppName[0];
		mXcpMonitoringItemAddressMap[address] = mHmiMonitorNextLowerAppName;
#endif
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mHmiMonitorScreenName) -  sizeof(mMessageXCPMonitoring.mHmiMonitorSecondaryScreenName) - sizeof(mMessageXCPMonitoring.mHmiMonitorStartupTime)- sizeof(mMessageXCPMonitoring.mHmiMonitorNextUpperAppName)- sizeof(mMessageXCPMonitoring.mHmiMonitorNextLowerAppName));
#else
	    mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mHmiMonitorScreenName) - sizeof(mMessageXCPMonitoring.mHmiMonitorStartupTime));	
#endif		
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::isSetHMIMonitorInfoDone HMI MONITOR INFO ENABLED!!! ");
	// Make first subscription
	if (mHMIMonitorInfo.isHMIMonitorInfoSubscriptionDone() == FALSE) {
		if (mHMIMonitorInfoFailed != TRUE && mHMIMonitorInfo.subscribeForHMIMonitorInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mHMIMonitorInfo.subscribeForHMIMonitorInfo() FAILED!!!!");
			mHMIMonitorInfoFailed = TRUE; // Avoid subsequent subscriptions if first trial already failed
			return DIA_FAILED;
		}
	}


	if (mHMIMonitorInfo.isActiveScreenNameAvailable() == TRUE){
		HMIScreenInfoElement hmiScreenInfoElement = mHMIMonitorInfo.getHMIScreenInfoElement();

		memcpy(mMessageXCPMonitoring.mHmiMonitorScreenName, hmiScreenInfoElement.activeScreenName, MAX_LENGTH_HMI_SCREEN_NAME);
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getHMIMonitorInfo():scrName = '%s", hmiScreenInfoElement.activeScreenName);
}
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
	if (mHMIMonitorInfo.isActiveScreenNameUpperAvailable() == TRUE){
		HMIScreenInfoElement hmiScreenInfoElement1 = mHMIMonitorInfo.getHMIScreenInfoElement();
        memcpy(mMessageXCPMonitoring.mHmiMonitorSecondaryScreenName, hmiScreenInfoElement1.activeScreenNameUpper, MAX_LENGTH_HMI_DATA_LENGTH);
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getHMIMonitorInfo():UpperScreen = '%s", hmiScreenInfoElement1.activeScreenNameUpper);
	}
	if (mHMIMonitorInfo.isNextActiveUpperSceneNameAvailable() == TRUE){
		HMIScreenInfoElement hmiScreenInfoElement2 = mHMIMonitorInfo.getHMIScreenInfoElement();	
        memcpy(mMessageXCPMonitoring.mHmiMonitorNextUpperAppName,hmiScreenInfoElement2.nextActiveUpperScreenName, MAX_LENGTH_HMI_DATA_LENGTH);
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getHMIMonitorInfo():UpperScrNameNext = '%s", mMessageXCPMonitoring.mHmiMonitorNextUpperAppName);
	}
	if (mHMIMonitorInfo.isNextActiveLowerSceneNameAvailable() == TRUE){
		HMIScreenInfoElement hmiScreenInfoElement3 = mHMIMonitorInfo.getHMIScreenInfoElement();	
        memcpy(mMessageXCPMonitoring.mHmiMonitorNextLowerAppName, hmiScreenInfoElement3.nextActiveLowerScreenName, MAX_LENGTH_HMI_DATA_LENGTH);
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getHMIMonitorInfo():LowerScrNameNext = '%s", mMessageXCPMonitoring.mHmiMonitorNextLowerAppName);
		
		}
#endif
	// Update offset
		mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);


	if (mStartupTimeUpdated == FALSE && mHMIMonitorInfo.isStartupTimeIntervalAvailable() == TRUE){ // Needs to be updated only once
		mMessageXCPMonitoring.mHmiMonitorStartupTime = mHMIMonitorInfo.getStartupTimeInterval();

		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getHMIMonitorInfo(): StartupTimeInterval = %d", mMessageXCPMonitoring.mHmiMonitorStartupTime);

//		// Update offset
//		mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);

		mStartupTimeUpdated = TRUE;
	}





	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::getSdsGuiPopupInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getSdsGuiPopupInfo");

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		//#####20########
		std::string mSdsScreenID = std::string("mSdsScreenID");
		address = (tU32)&mMessageXCPMonitoring.mSdsGuiPopupStatus.screenID[0];
		mXcpMonitoringItemAddressMap[address] = mSdsScreenID;
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
		std::string mSdsSpeechStatus = std::string("mSdsSpeechStatus");
		address = (tU32)&mMessageXCPMonitoring.mSdsGuiPopupStatus.sdsSpeechInputStatus;
		mXcpMonitoringItemAddressMap[address] = mSdsSpeechStatus;
#endif
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mSdsGuiPopupStatus));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	if (mAllianceVariantType != ALLIANCE_VARIANT_TYPE_DA){ // In DA variants no SDS info is available
		// Make first subscription
		if(mSdsGuiPopupInfo.isSdsGuiPopupInfoSubscriptionDone() == FALSE){
			if (mSdsGuiPopupInfo.subscribeForSdsGuiPopupInfo() != DIA_SUCCESS) {
				DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mSdsGuiPopupInfo.subscribeForSdsGuiPopupInfo() FAILED!!!!");
				return DIA_FAILED;
			}
		}
	}

	if (mSdsGuiPopupInfo.isSdsGuiPopupInfoAvailable()){
		SdsGuiPopupInfoElement sdsGuiPopupInfoElement = mSdsGuiPopupInfo.getSdsGuiPopupInfoElement();

		memcpy(mMessageXCPMonitoring.mSdsGuiPopupStatus.screenID, sdsGuiPopupInfoElement.screenID, MAX_LENGTH_SDS_SCREEN_NAME);
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getSdsGuiPopupInfo(): screenID = '%s'", sdsGuiPopupInfoElement.screenID);
#ifdef VARIANT_S_FTR_ENABLE_RIVIE
//		mMessageXCPMonitoring.mSdsGuiPopupStatus.sdsSpeechInputStatus = sdsGuiPopupInfoElement.sdsSpeechInputStatus;
		DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getSdsGuiPopupInfo(): sdsSpeechInputStatus = '%d'", sdsGuiPopupInfoElement.sdsSpeechInputStatus);

		switch(sdsGuiPopupInfoElement.sdsSpeechInputStatus)
		{
			case DIA_EN_SPEECH_INPUT_STATUS_IDLE:
				DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getSdsGuiPopupInfo. sdsSpeechInputStatus = IDLE");
				break;

			case DIA_EN_SPEECH_INPUT_STATUS_DIALOGOPEN:
				DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getSdsGuiPopupInfo. sdsSpeechInputStatus = DIALOGOPEN");
				break;

			case DIA_EN_SPEECH_INPUT_STATUS_LOADING:
				DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getSdsGuiPopupInfo. sdsSpeechInputStatus = LOADING");
				break;

			case DIA_EN_SPEECH_INPUT_STATUS_ERROR:
				DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getSdsGuiPopupInfo. sdsSpeechInputStatus = ERROR");
				break;

			case DIA_EN_SPEECH_INPUT_STATUS_LISTENING:
				DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getSdsGuiPopupInfo. sdsSpeechInputStatus = LISTENING");
				break;

			case DIA_EN_SPEECH_INPUT_STATUS_ACTIVE:
				DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getSdsGuiPopupInfo. sdsSpeechInputStatus = ACTIVE");
				break;

			case DIA_EN_SPEECH_INPUT_STATUS_PAUSE:
				DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getSdsGuiPopupInfo. sdsSpeechInputStatus = PAUSE");
				break;

			default:
				DIA_TR_CUS_ERR("dia_SrvHandler_XCPMonitoring::getSdsGuiPopupInfo. ERROR sdsSpeechInputStatus =UNKNOWN");
				break;
		}
#endif
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
	mMessageXCPMonitoring.mSdsGuiPopupStatus.sdsSpeechInputStatus = sdsGuiPopupInfoElement.sdsSpeechInputStatus;
#endif
		// Update offset
		mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);
	}

	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::getHMINavigationInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getHMINavigationInfo");

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		//#####21########
		std::string mRouteCalToFinalDestination = std::string("mRouteCalToFinalDestination");
		address = (tU32)&mMessageXCPMonitoring.mHmiNavigationRouteCalDurationToFinalDest;
		mXcpMonitoringItemAddressMap[address] = mRouteCalToFinalDestination;

		std::string mRouteCalToNextDestination = std::string("mRouteCalToNextDestination");
		address = (tU32)&mMessageXCPMonitoring.mHmiNavigationRouteCalDurationToNextDest;
		mXcpMonitoringItemAddressMap[address] = mRouteCalToNextDestination;
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back((mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mHmiNavigationRouteCalDurationToFinalDest)) - sizeof(mMessageXCPMonitoring.mHmiNavigationRouteCalDurationToNextDest));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	if (mAllianceVariantType != ALLIANCE_VARIANT_TYPE_DA){ // In DA variants no Route info is available
		// Make first subscription
		if(mHMINavigationInfo.isRouteCalDurationAvailable() == FALSE){
			if (mHMINavigationInfoFailed != TRUE && mHMINavigationInfo.subscribeForHMINavigationInfo() != DIA_SUCCESS) {
				DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mHMINavigationInfo.subscribeForHMINavigationInfo() FAILED!!!!");
				mHMINavigationInfoFailed = TRUE; // Avoid subsequent subscriptions if first trial already failed
				return DIA_FAILED;
			}
		}
	}

	if (mHMINavigationInfo.isRouteCalDurationAvailable()){
		HMINavigationInfoElement hmiNavigationInfoElement = mHMINavigationInfo.getHMINavigationInfoElement();

		mMessageXCPMonitoring.mHmiNavigationRouteCalDurationToFinalDest = (tU16)hmiNavigationInfoElement.routeCalDurationToFinalDest;
		mMessageXCPMonitoring.mHmiNavigationRouteCalDurationToNextDest = (tU16)hmiNavigationInfoElement.routeCalDurationToNextDest;
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getHMINavigationInfo(): toFinalDest: %d toNextDest: %d", mMessageXCPMonitoring.mHmiNavigationRouteCalDurationToFinalDest, mMessageXCPMonitoring.mHmiNavigationRouteCalDurationToNextDest);

		// Update offset
		mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);
	}

	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::getPhoneConnectionInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getPhoneConnectionInfo");

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		//#####22########
		std::string mPhoneConEstDuration = std::string("mPhoneConEstDuration");
		address = (tU32)&mMessageXCPMonitoring.mPhoneConnectionEstablishmentDuration;
		mXcpMonitoringItemAddressMap[address] = mPhoneConEstDuration;
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mPhoneConnectionEstablishmentDuration));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	// Make first subscription
	if(mPhoneConnectionInfo.isPhoneConnectionInfoSubscriptionDone() == FALSE){
		if (mPhoneConnectionInfo.subscribeForPhoneConnectionInfo() != DIA_SUCCESS) {
			DIA_TR_CUS_ERR("dia_SrvHandler_XCPMonitoring --- mPhoneConnectionInfo.subscribeForPhoneConnectionInfo() FAILED!!!!");
			return DIA_FAILED;
		}
	}

	if (mPhoneConnectionInfo.isPhoneConnectionInfoAvailable()){
		mMessageXCPMonitoring.mPhoneConnectionEstablishmentDuration = mPhoneConnectionInfo.getPhoneConnectionEstablishmentDuration();
		DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getPhoneConnectionInfo(): connection est. duration: %d [ms]", mMessageXCPMonitoring.mPhoneConnectionEstablishmentDuration);

		// Update offset
		mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);
	}

	return DIA_SUCCESS;
}

//#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
#if defined(VARIANT_S_FTR_ENABLE_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_RIVIE)
tDiaResult dia_SrvHandler_XCPMonitoring::getBTConnectionStatusInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getBTConnectionStatusInfo");

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;
		for (tU16 i = 0; i<MAX_CONNECTED_BT_DEVICES; i++)
		{
			//#####25########
			std::string mBTDeviceNameStr = std::string("mBTConnectionName") + dia_Helper::tU16ToString(i);
			address = (tU32)&mMessageXCPMonitoring.mBTConnectionStatus[i].BTConnectionName[0];
			mXcpMonitoringItemAddressMap[address] = mBTDeviceNameStr;

			std::string mBTDeviceConStatusStr = std::string("mBTDeviceConStatus") + dia_Helper::tU16ToString(i);
			address = (tU32)&mMessageXCPMonitoring.mBTConnectionStatus[i].BTConnectionStatusValue;
			mXcpMonitoringItemAddressMap[address] = mBTDeviceConStatusStr;
		}
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mBTConnectionStatus));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	// Make first subscription
	if (mBTConnectionStatusInfo.isSubscribeForBTConnectionStatusInfoDone() == FALSE) {
		if (mBTConnectionStatusInfo.subscribeForBTConnectionInfo() != DIA_SUCCESS) {
			DIA_TR_CUS_ERR("dia_SrvHandler_XCPMonitoring --- mBTConnectionStatusInfo.subscribeForBTConnectionInfo() FAILED!!!!");
			return DIA_FAILED;
		}
	}

	for (tU8 i = 0; i < MAX_CONNECTED_BT_DEVICES; i++)
	{
		memset(mMessageXCPMonitoring.mBTConnectionStatus[i].BTConnectionName, '\0', sizeof(tChar)*MAX_BT_NAME_STR_LENGTH);
		mMessageXCPMonitoring.mBTConnectionStatus[i].BTConnectionStatusValue = 0;
	}

	if (mBTConnectionStatusInfo.isBTConnectionInfoAvailable() == TRUE)
	{
		std::vector<BTDeviceInfo> mBTDeviceInfo;
		mBTDeviceInfo = mBTConnectionStatusInfo.getBTConnectedDeviceList(MAX_CONNECTED_BT_DEVICES);

		for (tU8 i = 0; i<mBTDeviceInfo.size(); i++)
		{
			memcpy(mMessageXCPMonitoring.mBTConnectionStatus[i].BTConnectionName, mBTDeviceInfo.at(i).btDevName, sizeof(tChar)*MAX_BT_NAME_STR_LENGTH);
			mMessageXCPMonitoring.mBTConnectionStatus[i].BTConnectionStatusValue = mBTDeviceInfo.at(i).btDevConnectionStatus;
			DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getBTConnectionStatusInfo: DeviceName: %s", mBTDeviceInfo.at(i).btDevName);
			DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getBTConnectionStatusInfo: ConnStatus: %d", mBTDeviceInfo.at(i).btDevConnectionStatus);
			DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getBTConnectionStatusInfo: Disconnected Reason: %d", mBTDeviceInfo.at(i).btDevDisconnectedReason);
		}

		// Update offset
	   mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);
	}

#ifdef VARIANT_S_FTR_ENABLE_RIVIE
	mBTConnectionStatusInfo.requestBTSignalQuality();
	if (mBTConnectionStatusInfo.isBTSignalQualityInfoAvailable() == TRUE) {
		// BT Signal quality
		BTSignalQualityInfo mBTSignalQualityInfo;
		mBTSignalQualityInfo = mBTConnectionStatusInfo.getBTSignalQuality();
		DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getBTConnectionStatusInfo: signalQuality: 0x%X", mBTSignalQualityInfo.signalQuality);
	}
#endif

	return DIA_SUCCESS;
}
#endif

//#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
#if defined(VARIANT_S_FTR_ENABLE_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_RIVIE)|| defined(VARIANT_S_FTR_ENABLE_NPIVI)
tDiaResult dia_SrvHandler_XCPMonitoring::getOperationHistoryInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getOperationHistoryInfo");

	// Make first subscription
	if (mInputHistory.isOperationHistorySubscriptionDone() == FALSE)
	{
		if (mInputHistory.subscribeForOperationhistoryInfo() != DIA_SUCCESS)
		{
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mInputHistory.subscribeForOperationhistoryInfo() FAILED!!!!");
			return DIA_FAILED;
		}

		// Save the address of elements
		if (mAddressUpdated == FALSE)
		{
			tU16 i;
			tU32 address;
			for (i = 0; i<MAX_NUMBER_OF_OPERATION_HISTORY_ELEMENTS_PER_CATEGORY; i++)
			{
				//#####26########
				std::string mOpHistoryKeyCode = std::string("mOpHistoryKeyCode") + dia_Helper::tU16ToString(i);
				address = (tU32)&mMessageXCPMonitoring.mOperationHistoryData[i].mKeyCode;
				mXcpMonitoringItemAddressMap[address] = mOpHistoryKeyCode;

				std::string mOpHistoryKeyStatus = std::string("mOpHistoryKeyStatus") + dia_Helper::tU16ToString(i);
				address = (tU32)&mMessageXCPMonitoring.mOperationHistoryData[i].mKeyStatus;
				mXcpMonitoringItemAddressMap[address] = mOpHistoryKeyStatus;
// TODO: At the moment mOpHistoryTouchCordinate_X1 and mOpHistoryTouchCordinate_Y1 are buggy. Waiting for a fix from VD_Input
				std::string mOpHistoryTouchCordinate_X = std::string("mOpHistoryTouchCordinate_X") + dia_Helper::tU16ToString(i);
				address = (tU32)&mMessageXCPMonitoring.mOperationHistoryData[i].mTouchCordinate_X;
				mXcpMonitoringItemAddressMap[address] = mOpHistoryTouchCordinate_X;

				std::string mOpHistoryTouchCordinate_Y = std::string("mOpHistoryTouchCordinate_Y") + dia_Helper::tU16ToString(i);
				address = (tU32)&mMessageXCPMonitoring.mOperationHistoryData[i].mTouchCordinate_Y;
				mXcpMonitoringItemAddressMap[address] = mOpHistoryTouchCordinate_Y;

//				std::string mOpHistoryTouchStatus = std::string("mOpHistoryTouchStatus") + dia_Helper::tU16ToString(i);
//				address = (tU32)&mMessageXCPMonitoring.mOperationHistoryData[i].mTouchStatus;
//				mXcpMonitoringItemAddressMap[address] = mOpHistoryTouchStatus;

				std::string mOpHistoryEncoderType = std::string("mOpHistoryEncoderType") + dia_Helper::tU16ToString(i);
				address = (tU32)&mMessageXCPMonitoring.mOperationHistoryData[i].mEncoderType;
				mXcpMonitoringItemAddressMap[address] = mOpHistoryEncoderType;

				std::string mOpHistoryEncoderDirSteps = std::string("mOpHistoryEncoderDirSteps") + dia_Helper::tU16ToString(i);
				address = (tU32)&mMessageXCPMonitoring.mOperationHistoryData[i].mEncoderDirSteps;
				mXcpMonitoringItemAddressMap[address] = mOpHistoryEncoderDirSteps;
				
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
				
				std::string mOpHisPIVISecTouchCordinate_X = std::string("mOpHisPIVISecTouchCordinate_X") + dia_Helper::tU16ToString(i);
				address = (tU32)&mMessageXCPMonitoring.mOperationHistoryDataPIVI[i].mPIVISecondaryCordinate_X;
				mXcpMonitoringItemAddressMap[address] = mOpHisPIVISecTouchCordinate_X;

				std::string mOpHisPIVISecTouchCordinate_Y = std::string("mOpHisPIVISecTouchCordinate_Y") + dia_Helper::tU16ToString(i);
				address = (tU32)&mMessageXCPMonitoring.mOperationHistoryDataPIVI[i].mPIVISecondaryCordinate_Y;
				mXcpMonitoringItemAddressMap[address] = mOpHisPIVISecTouchCordinate_Y;
#endif
			}
		}
	}

	if (mPayloadTransferOffsetListUpdated == FALSE)
	{
		#ifdef VARIANT_S_FTR_ENABLE_NPIVI
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mOperationHistoryData)- sizeof(mMessageXCPMonitoring.mOperationHistoryDataPIVI));
		#else
			mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mOperationHistoryData));
		#endif
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	if (mInputHistory.isgetPressedKeysInfoAvailable() == TRUE)
	{
		 std::vector<dia_KeyPressedInfoElement> keyInfoElements;
		 keyInfoElements = mInputHistory.getPressedKeyHistory(MAX_NUMBER_OF_OPERATION_HISTORY_ELEMENTS_PER_CATEGORY);

		 // Reset the previous history
		 if (keyInfoElements.size() < MAX_NUMBER_OF_OPERATION_HISTORY_ELEMENTS_PER_CATEGORY)
		 {
			 for (tU16 i = 0; i < MAX_NUMBER_OF_OPERATION_HISTORY_ELEMENTS_PER_CATEGORY; i++)
			 {
				mMessageXCPMonitoring.mOperationHistoryData[i].mKeyCode = 0;
				mMessageXCPMonitoring.mOperationHistoryData[i].mKeyStatus = 0;
			 }
		 }

		 // Save the newest history
		 for (tU8 i = 0; i < keyInfoElements.size(); i++)
		 {
			mMessageXCPMonitoring.mOperationHistoryData[i].mKeyCode = keyInfoElements[i].mKeyCode;
			mMessageXCPMonitoring.mOperationHistoryData[i].mKeyStatus = keyInfoElements[i].mKeyStatus;

#ifdef VARIANT_S_FTR_ENABLE_RIVIE
			DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getOperationhistoryInfo:getPressedKeyHistory[%d] Code: %d, S: %d", i, mMessageXCPMonitoring.mOperationHistoryData[i].mKeyCode, mMessageXCPMonitoring.mOperationHistoryData[i].mKeyStatus);
#endif
		 }

	}
	mInputHistory.requestPressedKeys(); // Request the status for the next cycle

	if (mInputHistory.isgetEncoderDirStatusAvailable() == TRUE)
	{
		std::vector<dia_EncoderDirInfoElement> encoderDirStatusElements;
		encoderDirStatusElements = mInputHistory.getEncoderDirStatus(MAX_NUMBER_OF_OPERATION_HISTORY_ELEMENTS_PER_CATEGORY);

		 // Reset the previous history
		 if (encoderDirStatusElements.size() < MAX_NUMBER_OF_OPERATION_HISTORY_ELEMENTS_PER_CATEGORY)
		 {
			 for (tU16 i = 0; i < MAX_NUMBER_OF_OPERATION_HISTORY_ELEMENTS_PER_CATEGORY; i++)
			 {
				mMessageXCPMonitoring.mOperationHistoryData[i].mEncoderType = 0;
				mMessageXCPMonitoring.mOperationHistoryData[i].mEncoderDirSteps = 0;
			 }
		 }

		 // Save the newest history
		 for (tU8 i = 0; i < encoderDirStatusElements.size(); i++)
		 {
			mMessageXCPMonitoring.mOperationHistoryData[i].mEncoderType = encoderDirStatusElements[i].mEncoderType;
			mMessageXCPMonitoring.mOperationHistoryData[i].mEncoderDirSteps = encoderDirStatusElements[i].mEncoderDirSteps;

#ifdef VARIANT_S_FTR_ENABLE_RIVIE
			DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getOperationhistoryInfo:getEncoderDirStatus[%d] Type: %d, Steps: %d", i, mMessageXCPMonitoring.mOperationHistoryData[i].mEncoderType, mMessageXCPMonitoring.mOperationHistoryData[i].mEncoderDirSteps);
#endif
		 }
	}
	mInputHistory.requestEncoderDirStatus(); // Request the status for the next cycle

	if (mInputHistory.isgetTouchInfoAvailable() == TRUE)
	{
		std::vector<dia_TouchCoordinatesHistory> touchStatusElements;
		touchStatusElements = mInputHistory.getTouchStatus(MAX_NUMBER_OF_OPERATION_HISTORY_ELEMENTS_PER_CATEGORY);

		 // Reset the previous history
		 if (touchStatusElements.size() < MAX_NUMBER_OF_OPERATION_HISTORY_ELEMENTS_PER_CATEGORY)
		 {
			 for (tU16 i = 0; i < MAX_NUMBER_OF_OPERATION_HISTORY_ELEMENTS_PER_CATEGORY; i++)
			 {
				mMessageXCPMonitoring.mOperationHistoryData[i].mTouchCordinate_X = 0;
				mMessageXCPMonitoring.mOperationHistoryData[i].mTouchCordinate_Y = 0;
			 }
		 }

		 // Save the newest history
		 for (tU8 i = 0; i < touchStatusElements.size(); i++)
		 {
			mMessageXCPMonitoring.mOperationHistoryData[i].mTouchCordinate_X = touchStatusElements[i].xCoord;
			mMessageXCPMonitoring.mOperationHistoryData[i].mTouchCordinate_Y = touchStatusElements[i].yCoord;

#ifdef VARIANT_S_FTR_ENABLE_RIVIE
			DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getOperationhistoryInfo:getTouchInfoElements [%d] X: %d, Y: %d", i, mMessageXCPMonitoring.mOperationHistoryData[i].mTouchCordinate_X, mMessageXCPMonitoring.mOperationHistoryData[i].mTouchCordinate_Y);
#endif
		 }
	}
	mInputHistory.requestTouchInfo(); // Request the status for the next cycle
	
#ifdef VARIANT_S_FTR_ENABLE_NPIVI	

		if (mInputHistory.isgetPIVITouchInfoAvailable() == TRUE)
	{
	
		std::vector<dia_TouchCoordinatesHistory> touchStatusElementsPIVI;
		touchStatusElementsPIVI = mInputHistory.getPIVITouchStatus(MAX_NUMBER_OF_OPERATION_HISTORY_ELEMENTS_PER_CATEGORY);

		 // Reset the previous history
		 if (touchStatusElementsPIVI.size() < MAX_NUMBER_OF_OPERATION_HISTORY_ELEMENTS_PER_CATEGORY)
		 {
			 for (tU16 i = 0; i < MAX_NUMBER_OF_OPERATION_HISTORY_ELEMENTS_PER_CATEGORY; i++)
			 {
				mMessageXCPMonitoring.mOperationHistoryDataPIVI[i].mPIVISecondaryCordinate_X = 0;
				mMessageXCPMonitoring.mOperationHistoryDataPIVI[i].mPIVISecondaryCordinate_Y = 0;
			 }
		 }

		 // Save the newest history
		 for (tU8 i = 0; i < touchStatusElementsPIVI.size(); i++)
		 {
			mMessageXCPMonitoring.mOperationHistoryDataPIVI[i].mPIVISecondaryCordinate_X = touchStatusElementsPIVI[i].xCoord;
			mMessageXCPMonitoring.mOperationHistoryDataPIVI[i].mPIVISecondaryCordinate_Y = touchStatusElementsPIVI[i].yCoord;


			DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getOperationhistoryInfo:getTouchInfoElements [%d] X: %d, Y: %d", i, mMessageXCPMonitoring.mOperationHistoryDataPIVI[i].mPIVISecondaryCordinate_X, mMessageXCPMonitoring.mOperationHistoryDataPIVI[i].mPIVISecondaryCordinate_Y);

		 }
	}
	mInputHistory.requestPIVITouchInfo(); // Request the status for the next cycle
#endif

	// Update offset
	mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex - 1);

	return DIA_SUCCESS;
}
#endif

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
tDiaResult dia_SrvHandler_XCPMonitoring::getProcInterruptInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getProcInterruptInfo");

	// Save the address of elements
	if (mAddressUpdated == FALSE)
	{
		tU32 address;
		for (tU16 i = 0; i<MAX_NUMBER_OF_INTERRUPT_INFO_OF_DEVICES; i++)
		{
			//#####25########
			std::string mTopInterruptDeviceStr = std::string("mTopInterruptDevice") + dia_Helper::tU16ToString(i);
			address = (tU32)&mMessageXCPMonitoring.mTopInterruptDevice[i].TopInterruptDevice[0];
			mXcpMonitoringItemAddressMap[address] = mTopInterruptDeviceStr;

		}
	}
	if (mPayloadTransferOffsetListUpdated == FALSE)
	{
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mTopInterruptDevice));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}
	mPayloadTransferOffsetIndex++;
	// Make first subscription
	if (mProcInfo.getProcInterruptsInfo() != DIA_SUCCESS)
	{
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- getProcInterruptInfo() FAILED!!!!");
			return DIA_FAILED;
	}
	else
	{
			std::vector<std::string> topInterruptProcessInfoElement;
			topInterruptProcessInfoElement = mProcInfo.getProcInterruptsInfoResult();

			if (!topInterruptProcessInfoElement.empty())
			{
				for (tU16 i = 0; i < MAX_NUMBER_OF_INTERRUPT_INFO_OF_DEVICES; i++)
				{
					std::string mInterruptProcessEntry = topInterruptProcessInfoElement[i];
					memcpy(mMessageXCPMonitoring.mTopInterruptDevice[i].TopInterruptDevice, mInterruptProcessEntry.c_str(),MAX_DEVICE_INTERRUPT_INFO_LENGTH);
					DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::mTopInterruptProcess %s ", mMessageXCPMonitoring.mTopInterruptDevice[i].TopInterruptDevice);
				}
			}


	}

	// Update offset
	mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex - 1);
	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getProcInterruptInfo: mPayloadTransferOffset=%d bytes", mPayloadTransferOffset);
	return DIA_SUCCESS;

}
#endif

#ifdef VARIANT_S_FTR_ENABLE_RIVIE
tDiaResult dia_SrvHandler_XCPMonitoring::getDTCInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getDTCInfo");

	// Make first subscription for ErrorLog
	if (mDTCInfo.isErrorLogSubscriptionDone() == FALSE)
	{
		if (mDTCInfo.subscribeForErrorLog() != DIA_SUCCESS)
		{
			DIA_TR_CUS_ERR("dia_SrvHandler_XCPMonitoring --- mDTCInfo.subscribeForErrorLog() FAILED!!!!");
			return DIA_FAILED;
		}
	}

	if (mDTCInfo.isDTCStatusAvailable() == TRUE)
	{
		std::vector<DTCInfoElement> dtcInfoList = mDTCInfo.getDTCStatusList();
		std::vector<DTCInfoElement>::iterator iter = dtcInfoList.begin();
		for ( ; iter != dtcInfoList.end(); iter++ ) {
			DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getDTCInfo - DTC: 0x%X, Status: 0x%X", iter->dtc, iter->status);
		}
	}

	return DIA_SUCCESS;
}
#endif

#ifdef VARIANT_S_FTR_ENABLE_RIVIE
tDiaResult dia_SrvHandler_XCPMonitoring::getConfigInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getConfigInfo");

	if (mConfigInfoUpdated == FALSE) {
		//Request first ECU Identification Info
		if (mConfigInfo.requestEcuIdentificationInfo() != DIA_SUCCESS)
		{
			DIA_TR_CUS_ERR("dia_SrvHandler_XCPMonitoring --- mConfigInfo.requestEcuIdentificationInfo() FAILED!!!!");
			return DIA_FAILED;
		}

		if (mConfigInfo.isConfigInfoAvailable() == TRUE)
		{
			EcuIdentificationInfo ecuIdentificationInfo = mConfigInfo.getEcuIdentificationInfo();

			DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getConfigInfo - SW-ID: %s", ecuIdentificationInfo.sw_id);
			DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getConfigInfo - VIN: %s", ecuIdentificationInfo.vin);
			DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getConfigInfo - ECU SW No.: %s", ecuIdentificationInfo.ecu_sw_no);

			mConfigInfoUpdated = TRUE;
		}
	}

	return DIA_SUCCESS;
}
#endif

#ifdef VARIANT_S_FTR_ENABLE_RIVIE
tDiaResult dia_SrvHandler_XCPMonitoring::getVersionInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getVersionInfo");

	if (mVersionInfoUpdated == FALSE) {
		// Request TCU version info
		if (mVersionInfo.subscribeForTCUVersionInfo() != DIA_SUCCESS)
		{
			DIA_TR_CUS_ERR("dia_SrvHandler_XCPMonitoring --- getVersionInfo.subscribeForTCUVersionInfo() FAILED!!!!");
			return DIA_FAILED;
		}
		if (mVersionInfo.isTCUVersionInfoAvailable() == TRUE)
		{
			TCUVersionInfo tcuVersionInfo = mVersionInfo.getTCUVersionInfo();

			DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getVersionInfo - TCU SW: U: %d - M: %d - L: %d", tcuVersionInfo.tcuSoftwareVersion.m_Upper, tcuVersionInfo.tcuSoftwareVersion.m_Mid, tcuVersionInfo.tcuSoftwareVersion.m_Lower);
			DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getVersionInfo - TCU HW: U: %d - M: %d - L: %d", tcuVersionInfo.tcuHardwareVersion.m_Upper, tcuVersionInfo.tcuHardwareVersion.m_Mid, tcuVersionInfo.tcuHardwareVersion.m_Lower);
		}

		// Request USB-Hub info
		if (mVersionInfo.readUSBInfo() != DIA_SUCCESS)
		{
			DIA_TR_CUS_ERR("dia_SrvHandler_XCPMonitoring --- getVersionInfo.readUSBInfo() FAILED!!!!");
			return DIA_FAILED;
		}
		if (mVersionInfo.isUSBHubInfoAvailable() == TRUE)
		{
			std::vector<USBVersionInfoElement> usbHubInfoElements = mVersionInfo.getUSBHubInfo();

			for (tU8 i=0; i<usbHubInfoElements.size(); i++) {
				DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getVersionInfo - USB-%d '%s'", i, usbHubInfoElements[i].lineT.c_str());
				DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getVersionInfo - USB-%d '%s'", i, usbHubInfoElements[i].lineD.c_str());
				DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getVersionInfo - USB-%d '%s'", i, usbHubInfoElements[i].lineP.c_str());
			}
		}

		mVersionInfoUpdated = TRUE;
	}

	return DIA_SUCCESS;
}
#endif

tDiaResult dia_SrvHandler_XCPMonitoring::getStartAndEndTime()
{
	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		//#####23########
		std::string mStartTimestamp = std::string("mStartTimestamp");
		address = (tU32)&mMessageXCPMonitoring.mStartTimestamp;
		mXcpMonitoringItemAddressMap[address] = mStartTimestamp;

		std::string mEndTimestamp = std::string("mEndTimestamp");
		address = (tU32)&mMessageXCPMonitoring.mEndTimestamp;
		mXcpMonitoringItemAddressMap[address] = mEndTimestamp;
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back((mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mStartTimestamp)) - sizeof(mMessageXCPMonitoring.mEndTimestamp));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	if (mTimeSpecStart.tv_sec < mNumericMaxTime && mTimeSpecEnd.tv_sec < mNumericMaxTime /*&& mTimeSpecStart.tv_nsec>0 && mTimeSpecEnd.tv_nsec>0*/) { // Make sure no overflow occured
		mMessageXCPMonitoring.mStartTimestamp = (tU32) (mTimeSpecStart.tv_sec*1000 + mTimeSpecStart.tv_nsec / 1000000); // Convert timespec to milliseconds
		mMessageXCPMonitoring.mEndTimestamp = (tU32) (mTimeSpecEnd.tv_sec*1000 + mTimeSpecEnd.tv_nsec / 1000000); // Convert timespec to milliseconds
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getStartAndEndTime START: %u ms END: %u ms", mMessageXCPMonitoring.mStartTimestamp, mMessageXCPMonitoring.mEndTimestamp);

		// Update offset
		mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex-1);
	}
	else {
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::getStartAndEndTime. Max. numeric limit (%d) is reached", mNumericMaxTime);

		return DIA_FAILED;
	}

	return DIA_SUCCESS;
}
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
tDiaResult dia_SrvHandler_XCPMonitoring::getSystemStatusInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getSystemStatusInfo");

	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		//#####29########
		std::string mSystemStatusStr = std::string("mSystemStatus");
		address = (tU32)&mMessageXCPMonitoring.mSystemStatus;
		mXcpMonitoringItemAddressMap[address] = mSystemStatusStr;


	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mSystemStatus));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;

	// Make first subscription
	if (mPowerStatusInfo.isSystemStateSubscriptionDone() == FALSE) {
		if (mPowerStatusInfo.subscribeToLCMForSystemState() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mPowerStatusInfo.subscribeToLCMForSystemState() FAILED!!!!");
			return DIA_FAILED;
		}
	}

	if (mPowerStatusInfo.isSystemStateAvailable() == TRUE) {
		tU8 systemStatus = mPowerStatusInfo.getSystemState();
		if (systemStatus == 0x00) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::getSystemStatusInfo mSystemStatus = 0x00");
			return DIA_FAILED;
		}
		//#####29########
		mMessageXCPMonitoring.mSystemStatus = systemStatus;
		DIA_TR_CUS_INF("dia_SrvHandler_XCPMonitoring::getSystemStatusInfo mSystemStatus:%d", mMessageXCPMonitoring.mSystemStatus);
		// Update offset
		mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex - 1);
	}

	return DIA_SUCCESS;
}
#endif
/****************************************************************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
tDiaResult dia_SrvHandler_XCPMonitoring::getCalibrationStatusInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getCalibrationStatusInfo");

	// Save the address of elements
	if (mAddressUpdated == FALSE)
	{
		tU32 address;

		//#####30########
		std::string mKeyInjectionstatusStr = std::string("mKeyInjectionstatus");
		address = (tU32)&mMessageXCPMonitoring.mCalibrationStatus.mKeyInjectionstatus;
		mXcpMonitoringItemAddressMap[address] = mKeyInjectionstatusStr;
		
		std::string mEncRotationStatusStr = std::string("mEncRotationStatus");
		address = (tU32)&mMessageXCPMonitoring.mCalibrationStatus.mEncRotationStatus;
		mXcpMonitoringItemAddressMap[address] = mEncRotationStatusStr;
		
		std::string mTouchSimulationStatusStr = std::string("mTouchSimulationStatus");
		address = (tU32)&mMessageXCPMonitoring.mCalibrationStatus.mTouchSimulationStatus;
		mXcpMonitoringItemAddressMap[address] = mTouchSimulationStatusStr;
		
		std::string mGestureRecordStatusStr = std::string("mGestureRecordStatus");
		address = (tU32)&mMessageXCPMonitoring.mCalibrationStatus.mGestureRecordStatus;
		mXcpMonitoringItemAddressMap[address] = mGestureRecordStatusStr;
		
		std::string mGestureReplayStatusStr = std::string("mGestureReplayStatus");
		address = (tU32)&mMessageXCPMonitoring.mCalibrationStatus.mGestureReplayStatus;
		mXcpMonitoringItemAddressMap[address] = mGestureReplayStatusStr;
		
		std::string mTripReplayStatusStr = std::string("mTripReplayStatus");
		address = (tU32)&mMessageXCPMonitoring.mCalibrationStatus.mTripReplayStatus;
		mXcpMonitoringItemAddressMap[address] = mTripReplayStatusStr;

		std::string mWifiPowerStatusStr = std::string("mWifiPowerStatus");
		address = (tU32)&mMessageXCPMonitoring.mCalibrationStatus.mWifiPowerStatus;
		mXcpMonitoringItemAddressMap[address] = mWifiPowerStatusStr;
	}
	if (mPayloadTransferOffsetListUpdated == FALSE)
	{
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mCalibrationStatus));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}
	mPayloadTransferOffsetIndex++;
	// Make first subscription
     
	tU8 keyInjectionstatusValue = cInputSimulation.getKeyInjectionstatus();
	mMessageXCPMonitoring.mCalibrationStatus.mKeyInjectionstatus = keyInjectionstatusValue;
	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::mKeyInjectionstatus %d ",mMessageXCPMonitoring.mCalibrationStatus.mKeyInjectionstatus);
	
	tU8 encRotationStatusValue = cInputSimulation.getEncRotationstatus();
	mMessageXCPMonitoring.mCalibrationStatus.mEncRotationStatus = encRotationStatusValue;
	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::mEncRotationStatus %d ",mMessageXCPMonitoring.mCalibrationStatus.mEncRotationStatus);
	
	tU8 touchSimulationStatusValue = cInputSimulation.getTouchSimulationstatus();
	mMessageXCPMonitoring.mCalibrationStatus.mTouchSimulationStatus = touchSimulationStatusValue;
	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::mTouchSimulationStatus %d ",mMessageXCPMonitoring.mCalibrationStatus.mTouchSimulationStatus);
	
	tU8 gestureRecordStatusValue = cInputSimulation.getGestureRecordstatus();
	mMessageXCPMonitoring.mCalibrationStatus.mGestureRecordStatus = gestureRecordStatusValue;
	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::mGestureRecordStatus %d ",mMessageXCPMonitoring.mCalibrationStatus.mGestureRecordStatus);
	
	tU8 gestureReplayStatusValue = cInputSimulation.getGestureReplaystatus();
	mMessageXCPMonitoring.mCalibrationStatus.mGestureReplayStatus = gestureReplayStatusValue;
	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::mGestureReplayStatus %d ",mMessageXCPMonitoring.mCalibrationStatus.mGestureReplayStatus);
	
	tU8 tripReplayStatusValue = mHMINavigationInfo.getTripReplaystatus();
	mMessageXCPMonitoring.mCalibrationStatus.mTripReplayStatus = tripReplayStatusValue;
	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::mTripReplayStatus %d ",mMessageXCPMonitoring.mCalibrationStatus.mTripReplayStatus);

	tU8 wifiPowerStatusValue = cWifiPowerChange.getWifiPowerstatus();
	mMessageXCPMonitoring.mCalibrationStatus.mWifiPowerStatus = wifiPowerStatusValue;
	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::mWifiPowerStatus %d ",mMessageXCPMonitoring.mCalibrationStatus.mWifiPowerStatus);



	// Update offset
	mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex - 1);
	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getProcInterruptInfo: mPayloadTransferOffset=%d bytes", mPayloadTransferOffset);
	return DIA_SUCCESS;

}
#endif
/****************************************************************************************************************************/

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
tDiaResult dia_SrvHandler_XCPMonitoring::getSWCConnectionStatus()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getSWCConnectionStatus");

	// Save the address of elements
	if (mAddressUpdated == FALSE)
	{
		tU32 address;
		//#####27########
		std::string mMCANConnectionStatusSWCStr = std::string("mMeterConStatusSWC");
		address = (tU32)&mMessageXCPMonitoring.mMeterConStatusSWC;
		mXcpMonitoringItemAddressMap[address] = mMCANConnectionStatusSWCStr;
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element


		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mMeterConStatusSWC));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;



	// Make first subscription
	if (mClockSWCConnectionStatusInfo.isSubscribeForSWCConnectionStatusInfoDone() == FALSE) {
		if (mClockSWCConnectionStatusInfo.subscribeForSWCConnectionInfo() != DIA_SUCCESS) {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mClockSWCConnectionStatusInfo.subscribeForSWCConnectionInfo() FAILED!!!!");
			return DIA_FAILED;
		}
	}

	if (mClockSWCConnectionStatusInfo.isSWCConnectionInfoAvailable() == TRUE) {
		//#####30########
		mMessageXCPMonitoring.mMeterConStatusSWC = mClockSWCConnectionStatusInfo.getSWCConnectionInfo();
		DIA_TR_INF("dia_SrvHandler_XCPMonitoring::getMeterConnectionStatus - mMeterConStatusSWC= %d", mMessageXCPMonitoring.mMeterConStatusSWC);
	}


	mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex - 1);
	return DIA_SUCCESS;
}
#endif
/*****************************************************************************************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
tDiaResult dia_SrvHandler_XCPMonitoring::getSdsDiagnosisServiceInfo()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getSdsDiagnosisServiceInfo");
	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		std::string mSdsEventStatus = std::string("mSdsEventStatus");
		address = (tU32)&mMessageXCPMonitoring.mSdsDiagStatus.sdsSpeechEventStatus;
		mXcpMonitoringItemAddressMap[address] = mSdsEventStatus;

		std::string mSdsEventTimeStamp = std::string("mSdsEventTimeStamp");
		address = (tU32)&mMessageXCPMonitoring.mSdsDiagStatus.sdsSpeechEventTimeStamp;
		mXcpMonitoringItemAddressMap[address] = mSdsEventTimeStamp;

	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mSdsDiagStatus));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;
		if(mSdsGuiPopupInfo.isDiagnosisServiceInfoSubscriptionDone() == FALSE){
			if (mSdsGuiPopupInfo.subscribeForSdsDiagnosisServiceInfo() != DIA_SUCCESS) {
				DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mSdsGuiPopupInfo.subscribeForSdsDiagnosisServiceInfo() FAILED!!!!");
				return DIA_FAILED;
			}
		}

#if defined (VARIANT_S_FTR_ENABLE_NPIVI) 

		if (mSdsGuiPopupInfo.isSdsDiagnosisServiceInfoAvailable())
		{
			SdsDiagServiceInfoElement sdsDiagServiceInfoElement = mSdsGuiPopupInfo.getSdsDiagServiceInfoElement();
			DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getSdsDiagServiceInfoElement:SDS_EVENT_ID = '%d'", sdsDiagServiceInfoElement.sdsEventStatus);
            DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::getSdsDiagServiceInfoElement:SDS_EVENT_TIME_STAMP= '%d'",sdsDiagServiceInfoElement.sdsEventTimeStamp);
			mMessageXCPMonitoring.mSdsDiagStatus.sdsSpeechEventStatus = sdsDiagServiceInfoElement.sdsEventStatus;
			mMessageXCPMonitoring.mSdsDiagStatus.sdsSpeechEventTimeStamp = sdsDiagServiceInfoElement.sdsEventTimeStamp;
		}
#endif
		mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex - 1);
	return DIA_SUCCESS;
}
#endif
/*****************************************************************************************************************************************************/
tVoid dia_SrvHandler_XCPMonitoring::updateAddressOfCalibrationParameters()
{
	// Save the address of elements
	if (mAddressUpdated == FALSE) {
		tU32 address;

		//#####1########
		std::string cKeyInjectionStartStop = std::string("cKeyInjectionStartStop");
		address = (tU32)&cMessageXCPCalibration.cKeyInjection.startStop;
		cXcpCalibrationItemAddressMap[address] = cKeyInjectionStartStop;

		std::string cKeyInjectionCode = std::string("cKeyInjectionCode");
		address = (tU32)&cMessageXCPCalibration.cKeyInjection.keyCode;
		cXcpCalibrationItemAddressMap[address] = cKeyInjectionCode;

		std::string cKeyInjectionReleaseTime= std::string("cKeyInjectionReleaseTime");
		address = (tU32)&cMessageXCPCalibration.cKeyInjection.releaseTime;
		cXcpCalibrationItemAddressMap[address] = cKeyInjectionReleaseTime;

		//#####2########
		std::string cEncRotationStartStop = std::string("cEncRotationStartStop");
		address = (tU32)&cMessageXCPCalibration.cEncRotation.startStop;
		cXcpCalibrationItemAddressMap[address] = cEncRotationStartStop;

		std::string cEncRotationType = std::string("cEncRotationType");
		address = (tU32)&cMessageXCPCalibration.cEncRotation.encType;
		cXcpCalibrationItemAddressMap[address] = cEncRotationType;

		std::string cEncRotationSteps = std::string("cEncRotationSteps");
		address = (tU32)&cMessageXCPCalibration.cEncRotation.encSteps;
		cXcpCalibrationItemAddressMap[address] = cEncRotationSteps;

		//#####3########
		std::string cSingleTouchStartStop = std::string("cSingleTouchStartStop");
		address = (tU32)&cMessageXCPCalibration.cSingleTouch.startStop;
		cXcpCalibrationItemAddressMap[address] = cSingleTouchStartStop;

		std::string cSingleTouchXCoord = std::string("cSingleTouchXCoord");
		address = (tU32)&cMessageXCPCalibration.cSingleTouch.xCoord;
		cXcpCalibrationItemAddressMap[address] = cSingleTouchXCoord;

		std::string cSingleTouchYCoord = std::string("cSingleTouchYCoord");
		address = (tU32)&cMessageXCPCalibration.cSingleTouch.yCoord;
		cXcpCalibrationItemAddressMap[address] = cSingleTouchYCoord;

		std::string cSingleTouchReleaseTime= std::string("cSingleTouchReleaseTime");
		address = (tU32)&cMessageXCPCalibration.cSingleTouch.releaseTime;
		cXcpCalibrationItemAddressMap[address] = cSingleTouchReleaseTime;

		//#####4########
		std::string cTouchSlideStartStop = std::string("cTouchSlideStartStop");
		address = (tU32)&cMessageXCPCalibration.cTouchSlide.startStop;
		cXcpCalibrationItemAddressMap[address] = cTouchSlideStartStop;

		std::string cTouchSlideXCoordStart = std::string("cTouchSlideXCoordStart");
		address = (tU32)&cMessageXCPCalibration.cTouchSlide.xCoordStart;
		cXcpCalibrationItemAddressMap[address] = cTouchSlideXCoordStart;

		std::string cTouchSlideYCoordStart = std::string("cTouchSlideYCoordStart");
		address = (tU32)&cMessageXCPCalibration.cTouchSlide.yCoordStart;
		cXcpCalibrationItemAddressMap[address] = cTouchSlideYCoordStart;

		std::string cTouchSlideXCoordEnd = std::string("cTouchSlideXCoordEnd");
		address = (tU32)&cMessageXCPCalibration.cTouchSlide.xCoordEnd;
		cXcpCalibrationItemAddressMap[address] = cTouchSlideXCoordEnd;

		std::string cTouchSlideYCoordEnd = std::string("cTouchSlideYCoordEnd");
		address = (tU32)&cMessageXCPCalibration.cTouchSlide.yCoordEnd;
		cXcpCalibrationItemAddressMap[address] = cTouchSlideYCoordEnd;

		std::string cTouchSlideDuration = std::string("cTouchSlideDuration");
		address = (tU32)&cMessageXCPCalibration.cTouchSlide.duration;
		cXcpCalibrationItemAddressMap[address] = cTouchSlideDuration;

		//#####5########
		std::string cGestureRecordStart = std::string("cGestureRecordStart");
		address = (tU32)&cMessageXCPCalibration.cGestureRecord.start;
		cXcpCalibrationItemAddressMap[address] = cGestureRecordStart;

		std::string cGestureRecordStop = std::string("cGestureRecordStop");
		address = (tU32)&cMessageXCPCalibration.cGestureRecord.stop;
		cXcpCalibrationItemAddressMap[address] = cGestureRecordStop;

		std::string cGestureRecordOnUSB = std::string("cGestureRecordOnUSB");
		address = (tU32)&cMessageXCPCalibration.cGestureRecord.onUSB;
		cXcpCalibrationItemAddressMap[address] = cGestureRecordOnUSB;

		std::string cGestureRecordFileName = std::string("cGestureRecordFileName");
		address = (tU32)&cMessageXCPCalibration.cGestureRecord.fileName[0];
		cXcpCalibrationItemAddressMap[address] = cGestureRecordFileName;

		//#####6########
		std::string cGestureReplayStart = std::string("cGestureReplayStart");
		address = (tU32)&cMessageXCPCalibration.cGestureReplay.start;
		cXcpCalibrationItemAddressMap[address] = cGestureReplayStart;

		std::string cGestureReplayStop = std::string("cGestureReplayStop");
		address = (tU32)&cMessageXCPCalibration.cGestureReplay.stop;
		cXcpCalibrationItemAddressMap[address] = cGestureReplayStop;

		std::string cGestureReplayFromUSB = std::string("cGestureReplayFromUSB");
		address = (tU32)&cMessageXCPCalibration.cGestureReplay.fromUSB;
		cXcpCalibrationItemAddressMap[address] = cGestureReplayFromUSB;

		std::string cGestureReplayFileName = std::string("cGestureReplayFileName");
		address = (tU32)&cMessageXCPCalibration.cGestureReplay.fileName[0];
		cXcpCalibrationItemAddressMap[address] = cGestureReplayFileName;

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
		//#####7########
		std::string cWiFiPowerChangeStartStop = std::string("cWiFiPowerChangeStartStop");
		address = (tU32)&cMessageXCPCalibration.cWifiPowerChange.startStop;
		cXcpCalibrationItemAddressMap[address] = cWiFiPowerChangeStartStop;

		std::string cWiFiPowerChangeValue = std::string("cWiFiPowerChangeValue");
		address = (tU32)&cMessageXCPCalibration.cWifiPowerChange.value;
		cXcpCalibrationItemAddressMap[address] = cWiFiPowerChangeValue;

		std::string cLightingTimingDelayStartStop = std::string("cLightingTimingDelayStartStop");
		address = (tU32)&cMessageXCPCalibration.cLightingDimmingSet.startStop;
		cXcpCalibrationItemAddressMap[address] = cLightingTimingDelayStartStop;

		std::string cLightingTimingDelayValue = std::string("cLightingTimingDelayValue");
		address = (tU32)&cMessageXCPCalibration.cLightingDimmingSet.lightingTimingvalue;
		cXcpCalibrationItemAddressMap[address] = cLightingTimingDelayValue;
				//#####8########
		std::string cTripReplayStart = std::string("cTripReplayStart");
		address = (tU32)&cMessageXCPCalibration.cTripReplay.start;
		cXcpCalibrationItemAddressMap[address] = cTripReplayStart;

		std::string cTripReplayStop = std::string("cTripReplayStop");
		address = (tU32)&cMessageXCPCalibration.cTripReplay.stop;
		cXcpCalibrationItemAddressMap[address] = cTripReplayStop;

		std::string cTripReplayFileName = std::string("cTripReplayFileName");
		address = (tU32)&cMessageXCPCalibration.cTripReplay.fileName[0];
		cXcpCalibrationItemAddressMap[address] = cTripReplayFileName;
#endif
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
		//#####3########
		std::string cSinglePIVITouchStartStop = std::string("cSinglePIVITouchStartStop");
		address = (tU32)&cMessageXCPCalibration.cSinglePIVITouch.startStop;
		cXcpCalibrationItemAddressMap[address] = cSinglePIVITouchStartStop;

		std::string cSinglePIVITouchXCoord = std::string("cSinglePIVITouchXCoord");
		address = (tU32)&cMessageXCPCalibration.cSinglePIVITouch.xCoord;
		cXcpCalibrationItemAddressMap[address] = cSinglePIVITouchXCoord;

		std::string cSinglePIVITouchYCoord = std::string("cSinglePIVITouchYCoord");
		address = (tU32)&cMessageXCPCalibration.cSinglePIVITouch.yCoord;
		cXcpCalibrationItemAddressMap[address] = cSinglePIVITouchYCoord;
		
		std::string cSinglePIVITouchScreenNumber = std::string("cSinglePIVITouchScreenNumber");
		address = (tU32)&cMessageXCPCalibration.cSinglePIVITouch.screenNumber;
		cXcpCalibrationItemAddressMap[address] = cSinglePIVITouchScreenNumber;

		std::string cSinglePIVITouchReleaseTime= std::string("cSinglePIVITouchReleaseTime");
		address = (tU32)&cMessageXCPCalibration.cSinglePIVITouch.releaseTime;
		cXcpCalibrationItemAddressMap[address] = cSinglePIVITouchReleaseTime;
#endif
		//#####11########
		std::string cEncoderPushStartStop = std::string("cEncoderPushStartStop");
		address = (tU32)&cMessageXCPCalibration.cEncoderPush.startStop;
		cXcpCalibrationItemAddressMap[address] = cEncoderPushStartStop;
	}
}

tDiaResult dia_SrvHandler_XCPMonitoring::simulateKeyInjection()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::simulateKeyInjection");

	DIA_TR_INF("dia_SrvHandler_XCPMonitoring::simulateKeyInjection: sending the code %d with release time: %d ms", cMessageXCPCalibration.cKeyInjection.keyCode, cMessageXCPCalibration.cKeyInjection.releaseTime);

	// TODO: At the moment no need to enable the input events
//	if (cInputSimulation.isInputEventsEnabled() == FALSE) {
//		if (cInputSimulation.enableInputEvents() != DIA_SUCCESS) {
//			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- cInputSimulation.enableInputEvents() FAILED!!!!");
//			return DIA_FAILED;
//		}
//	}

	if (cInputSimulation.simulateKeyInjection(cMessageXCPCalibration.cKeyInjection.keyCode, cMessageXCPCalibration.cKeyInjection.releaseTime) != DIA_SUCCESS) {
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- cInputSimulation.simulateKeyInjection() FAILED!!!!");
		return DIA_FAILED;
	}
	else {
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::simulateKeyInjection: successfully sent the code %d (release time: %d ms)", cMessageXCPCalibration.cKeyInjection.keyCode, cMessageXCPCalibration.cKeyInjection.releaseTime);
	cMessageXCPCalibration.cKeyInjection.startStop = 0;
	}


	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::simulateEncRotation()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::simulateEncRotation");

	DIA_TR_INF("dia_SrvHandler_XCPMonitoring::simulateEncRotation: sending the type %d with steps: %d", cMessageXCPCalibration.cEncRotation.encType, cMessageXCPCalibration.cEncRotation.encSteps);

	if (cInputSimulation.simulateEncRotation(cMessageXCPCalibration.cEncRotation.encType, cMessageXCPCalibration.cEncRotation.encSteps) != DIA_SUCCESS) {
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- cInputSimulation.simulateEncRotation() FAILED!!!!");
		return DIA_FAILED;
	}
	else {
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::simulateEncRotation: successfully sent the type %d with steps: %d", cMessageXCPCalibration.cEncRotation.encType, cMessageXCPCalibration.cEncRotation.encSteps);
	}


	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::simulateSingleTouch()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::simulateSingleTouch");

	DIA_TR_INF("dia_SrvHandler_XCPMonitoring::simulateSingleTouch: Coordinates X:Y (%d:%d) release time: %d ms", cMessageXCPCalibration.cSingleTouch.xCoord, cMessageXCPCalibration.cSingleTouch.yCoord, cMessageXCPCalibration.cSingleTouch.releaseTime);

	if (cInputSimulation.simulateSingleTouch(cMessageXCPCalibration.cSingleTouch.xCoord, cMessageXCPCalibration.cSingleTouch.yCoord, cMessageXCPCalibration.cSingleTouch.releaseTime) != DIA_SUCCESS) {
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- cInputSimulation.simulateSingleTouch() FAILED!!!!");
		return DIA_FAILED;
	}
	else {
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::simulateSingleTouch: OK on X:Y (%d:%d) release time: %d ms", cMessageXCPCalibration.cSingleTouch.xCoord, cMessageXCPCalibration.cSingleTouch.yCoord, cMessageXCPCalibration.cSingleTouch.releaseTime);
	}

	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::simulateTouchSlide()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::simulateTouchSlide");

	DIA_TR_INF("dia_SrvHandler_XCPMonitoring::simulateTouchSlide: sending the Start X:Y(%d:%d) - End X:Y(%d:%d) duration: %d ms", cMessageXCPCalibration.cTouchSlide.xCoordStart, cMessageXCPCalibration.cTouchSlide.yCoordStart, cMessageXCPCalibration.cTouchSlide.xCoordEnd, cMessageXCPCalibration.cTouchSlide.yCoordEnd, cMessageXCPCalibration.cTouchSlide.duration);

	if (cInputSimulation.simulateTouchSlide(cMessageXCPCalibration.cTouchSlide.xCoordStart, cMessageXCPCalibration.cTouchSlide.yCoordStart, cMessageXCPCalibration.cTouchSlide.xCoordEnd, cMessageXCPCalibration.cTouchSlide.yCoordEnd, cMessageXCPCalibration.cTouchSlide.duration) != DIA_SUCCESS) {
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- cInputSimulation.simulateTouchSlide() FAILED!!!!");
		return DIA_FAILED;
	}
	else {
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::simulateTouchSlide - Start X:Y(%d:%d) - End X:Y(%d:%d) duration: %d ms", cMessageXCPCalibration.cTouchSlide.xCoordStart, cMessageXCPCalibration.cTouchSlide.yCoordStart, cMessageXCPCalibration.cTouchSlide.xCoordEnd, cMessageXCPCalibration.cTouchSlide.yCoordEnd, cMessageXCPCalibration.cTouchSlide.duration);
	}

	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::startGestureRecord()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::startGestureRecord");

	// Check if provided file name contains illegal chars (e.g. it should not contain "/")
	std::vector<std::string> splittedFileStr = dia_Helper::SplitString(std::string(cMessageXCPCalibration.cGestureRecord.fileName), '/');
	for (tU16 i=0; i<splittedFileStr.size(); i++){
		DIA_TR_INF("dia_SrvHandler_XCPMonitoring::startGestureRecord. splittedFileStr[%d]='%s'", i, splittedFileStr.at(i).c_str());
	}

	if (splittedFileStr.size() == 1 && splittedFileStr.at(0).compare(std::string(cMessageXCPCalibration.cGestureRecord.fileName)) == 0){
		DIA_TR_INF("dia_SrvHandler_XCPMonitoring::startGestureRecord. Legal fileName='%s'", cMessageXCPCalibration.cGestureRecord.fileName);
	}
	else{
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::startGestureRecord. illegal chars in fileName: '%s'", cMessageXCPCalibration.cGestureRecord.fileName);
        cInputSimulation.m_GestureRecordStatus = DIA_ERR_INVALID_REQUEST;
		return DIA_FAILED;
	}

	// Decide if gesture recording shall be done on USB or /tmp.
	std::string startGestureRecordFilePath;
	if (cMessageXCPCalibration.cGestureRecord.onUSB){
		// Determine the mount point of USB device
		// TODO: Determine the mount point through the CardStatus (Monitoring parameter)
		if (dia_Helper::isDirectory(MOUNT_POINT_USB_SDA1)){
			startGestureRecordFilePath = std::string(MOUNT_POINT_USB_SDA1) + std::string(cMessageXCPCalibration.cGestureRecord.fileName);
			// Remount USB as "rw"
			dia_Helper::mountFileSystemRw(MOUNT_POINT_USB_SDA1);
			DIA_TR_INF("dia_SrvHandler_XCPMonitoring::startGestureRecord. remount '%s' as rw", MOUNT_POINT_USB_SDA1);
		}
		else if (dia_Helper::isDirectory(MOUNT_POINT_USB_SDB1)){
			startGestureRecordFilePath = std::string(MOUNT_POINT_USB_SDB1) + std::string(cMessageXCPCalibration.cGestureRecord.fileName);
			// Remount USB as "rw"
			dia_Helper::mountFileSystemRw(MOUNT_POINT_USB_SDB1);
			DIA_TR_INF("dia_SrvHandler_XCPMonitoring::startGestureRecord. remount '%s' as rw", MOUNT_POINT_USB_SDB1);
		}
		else {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::startGestureRecord. USB device is not available!!!");
			cInputSimulation.m_GestureRecordStatus = DIA_ERR_INVALID_REQUEST;
			return DIA_FAILED;
		}
	}
	else {
		startGestureRecordFilePath = std::string("/tmp/") + std::string(cMessageXCPCalibration.cGestureRecord.fileName);
	}

	if (DIA_SUCCESS != cInputSimulation.startGestureRecording(startGestureRecordFilePath)){
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- cInputSimulation.startGestureRecording() FAILED!!!!");
		cInputSimulation.m_GestureRecordStatus = DIA_ERR_REQUEST_SEND;
		return DIA_FAILED;
	}

	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::startGestureRecord - STARTED on: '%s'", startGestureRecordFilePath.c_str());

	return DIA_SUCCESS;
}


tDiaResult dia_SrvHandler_XCPMonitoring::stopGestureRecord()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::stopGestureRecord");

	// Check if provided file name contains illegal chars (e.g. it should not contain "/")
	std::vector<std::string> splittedFileStr = dia_Helper::SplitString(std::string(cMessageXCPCalibration.cGestureRecord.fileName), '/');
	if (splittedFileStr.size() == 1 && splittedFileStr.at(0).compare(std::string(cMessageXCPCalibration.cGestureRecord.fileName)) == 0){
		DIA_TR_INF("dia_SrvHandler_XCPMonitoring::stopGestureRecord. Legal fileName='%s'", cMessageXCPCalibration.cGestureRecord.fileName);
	}
	else{
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::stopGestureRecord. illegal chars in fileName: '%s'", cMessageXCPCalibration.cGestureRecord.fileName);
		return DIA_FAILED;
	}

	// Decide if gesture recording shall be stopped on USB or /tmp.
	std::string stopGestureRecordFilePath;
	if (cMessageXCPCalibration.cGestureRecord.onUSB){
		// Determine the mount point of USB device
		// TODO: Determine the mount point through the CardStatus (Monitoring parameter)
		if (dia_Helper::isDirectory(MOUNT_POINT_USB_SDA1)){
			stopGestureRecordFilePath = std::string(MOUNT_POINT_USB_SDA1) + std::string(cMessageXCPCalibration.cGestureRecord.fileName);
		}
		else if (dia_Helper::isDirectory(MOUNT_POINT_USB_SDB1)){
			stopGestureRecordFilePath = std::string(MOUNT_POINT_USB_SDB1) + std::string(cMessageXCPCalibration.cGestureRecord.fileName);
		}
		else {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::stopGestureRecord. USB device is not available!!!");
			cInputSimulation.m_GestureRecordStatus = DIA_ERR_INVALID_REQUEST;
			return DIA_FAILED;
		}
	}
	else {
		stopGestureRecordFilePath = std::string("/tmp/") + std::string(cMessageXCPCalibration.cGestureRecord.fileName);
	}

	if (DIA_SUCCESS != cInputSimulation.stopGestureRecording(stopGestureRecordFilePath)){
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- cInputSimulation.stopGestureRecording() FAILED!!!!");
		cInputSimulation.m_GestureRecordStatus = DIA_ERR_REQUEST_SEND;
		return DIA_FAILED;
	}

	// As a final step remount USB as "ro"
	if (cMessageXCPCalibration.cGestureRecord.onUSB){
		dia_FileStream fileStream(stopGestureRecordFilePath.c_str());
		if (fileStream.openForRead() != DIA_STREAM_ERROR) { // Gesture file was created successfully
			fileStream.close();
			if (stopGestureRecordFilePath.compare(0, strlen(MOUNT_POINT_USB_SDA1), MOUNT_POINT_USB_SDA1) == 0){
				dia_Helper::mountFileSystemRo(MOUNT_POINT_USB_SDA1);
				DIA_TR_INF("dia_SrvHandler_XCPMonitoring::stopGestureRecord. remount '%s' as ro", MOUNT_POINT_USB_SDA1);
			}
			else if (stopGestureRecordFilePath.compare(0, strlen(MOUNT_POINT_USB_SDB1), MOUNT_POINT_USB_SDB1) == 0){
				dia_Helper::mountFileSystemRo(MOUNT_POINT_USB_SDB1);
				DIA_TR_INF("dia_SrvHandler_XCPMonitoring::stopGestureRecord. remount '%s' as ro", MOUNT_POINT_USB_SDB1);
			}
		}
	}

	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::stopGestureRecord - STOPPED on: '%s'", stopGestureRecordFilePath.c_str());

	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::startGestureReplay()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::startGestureReplay");

	// Check if provided file name contains illegal chars (e.g. it should not contain "/")
	std::vector<std::string> splittedFileStr = dia_Helper::SplitString(std::string(cMessageXCPCalibration.cGestureReplay.fileName), '/');
	if (splittedFileStr.size() == 1 && splittedFileStr.at(0).compare(std::string(cMessageXCPCalibration.cGestureReplay.fileName)) == 0){
		DIA_TR_INF("dia_SrvHandler_XCPMonitoring::startGestureReplay. Legal fileName='%s'", cMessageXCPCalibration.cGestureReplay.fileName);
	}
	else{
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::startGestureReplay. illegal chars in fileName: '%s'", cMessageXCPCalibration.cGestureReplay.fileName);
		return DIA_FAILED;
	}

	// Decide if gesture replay shall be done from USB or /tmp.
	std::string startGestureReplayFilePath;
	if (cMessageXCPCalibration.cGestureReplay.fromUSB){
		// Determine the mount point of USB device
		// TODO: Determine the mount point through the CardStatus (Monitoring parameter)
		if (dia_Helper::isDirectory(MOUNT_POINT_USB_SDA1)){
			startGestureReplayFilePath = std::string(MOUNT_POINT_USB_SDA1) + std::string(cMessageXCPCalibration.cGestureReplay.fileName);
		}
		else if (dia_Helper::isDirectory(MOUNT_POINT_USB_SDB1)){
			startGestureReplayFilePath = std::string(MOUNT_POINT_USB_SDB1) + std::string(cMessageXCPCalibration.cGestureReplay.fileName);
		}
		else {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::startGestureReplay. USB device is not available!!!");
			cInputSimulation.m_GestureReplayStatus = DIA_ERR_INVALID_REQUEST;
			return DIA_FAILED;
		}
	}
	else {
		startGestureReplayFilePath = std::string("/tmp/") + std::string(cMessageXCPCalibration.cGestureReplay.fileName);
	}

	// Check if requested gesture file exists
	if (dia_Helper::isFileExists(startGestureReplayFilePath.c_str()) == FALSE) {
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::startGestureReplay. File doesn't exist: '%s'", startGestureReplayFilePath.c_str());
		cInputSimulation.m_GestureReplayStatus = DIA_ERR_INPUT_FILE_INVALID;
		return DIA_FAILED;
	}

	if (DIA_SUCCESS != cInputSimulation.startGestureReplay(startGestureReplayFilePath)){
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- cInputSimulation.startGestureReplay() FAILED!!!!");
		cInputSimulation.m_GestureReplayStatus = DIA_ERR_REQUEST_SEND;
		return DIA_FAILED;
	}

	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::startGestureReplay - STARTED on: '%s'", startGestureReplayFilePath.c_str());

	return DIA_SUCCESS;
}

tDiaResult dia_SrvHandler_XCPMonitoring::stopGestureReplay()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::stopGestureReplay");

	// Check if provided file name contains illegal chars (e.g. it should not contain "/")
	std::vector<std::string> splittedFileStr = dia_Helper::SplitString(std::string(cMessageXCPCalibration.cGestureReplay.fileName), '/');
	if (splittedFileStr.size() == 1 && splittedFileStr.at(0).compare(std::string(cMessageXCPCalibration.cGestureReplay.fileName)) == 0){
		DIA_TR_INF("dia_SrvHandler_XCPMonitoring::stopGestureReplay. Legal fileName='%s'", cMessageXCPCalibration.cGestureReplay.fileName);
	}
	else{
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::stopGestureReplay. illegal chars in fileName: '%s'", cMessageXCPCalibration.cGestureReplay.fileName);
		cInputSimulation.m_GestureReplayStatus = DIA_ERR_INVALID_REQUEST;
		return DIA_FAILED;
	}

	// Decide if gesture replay shall be stopped from USB or /tmp.
	std::string stopGestureReplayFilePath;
	if (cMessageXCPCalibration.cGestureReplay.fromUSB){
		// Determine the mount point of USB device
		// TODO: Determine the mount point through the CardStatus (Monitoring parameter)
		if (dia_Helper::isDirectory(MOUNT_POINT_USB_SDA1)){
			stopGestureReplayFilePath = std::string(MOUNT_POINT_USB_SDA1) + std::string(cMessageXCPCalibration.cGestureReplay.fileName);
		}
		else if (dia_Helper::isDirectory(MOUNT_POINT_USB_SDB1)){
			stopGestureReplayFilePath = std::string(MOUNT_POINT_USB_SDB1) + std::string(cMessageXCPCalibration.cGestureReplay.fileName);
		}
		else {
			cInputSimulation.m_GestureReplayStatus = DIA_ERR_INVALID_REQUEST;
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::stopGestureReplay. USB device is not available!!!");
			return DIA_FAILED;
		}
	}
	else {
		stopGestureReplayFilePath = std::string("/tmp/") + std::string(cMessageXCPCalibration.cGestureReplay.fileName);
	}


	if (DIA_SUCCESS != cInputSimulation.stopGestureReplay(stopGestureReplayFilePath)){
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- cInputSimulation.stopGestureReplay() FAILED!!!!");
		cInputSimulation.m_GestureReplayStatus = DIA_ERR_REQUEST_SEND;
		return DIA_FAILED;
	}

	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::stopGestureReplay - STOPPED on: '%s'", stopGestureReplayFilePath.c_str());

	return DIA_SUCCESS;
}

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
tDiaResult dia_SrvHandler_XCPMonitoring::changeWifiPower()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::changeWifiPower");

	DIA_TR_INF("dia_SrvHandler_XCPMonitoring::changeWifiPower: New value '%d' [dB]", cMessageXCPCalibration.cWifiPowerChange.value);

	if (cWifiPowerChange.changeWifiTransmitPower(cMessageXCPCalibration.cWifiPowerChange.value) != DIA_SUCCESS) {
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- cWifiPowerChange.changeWifiTransmitPower() FAILED!!!!");
		return DIA_FAILED;
	}
	else {
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::changeWifiPower: with value '%d' [dB] done", cMessageXCPCalibration.cWifiPowerChange.value);
	}

	return DIA_SUCCESS;
}

/*******************************************************************************************************************************************************/
tDiaResult dia_SrvHandler_XCPMonitoring::simulateLightingDimming()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::simulateLightingDimming");

	DIA_TR_INF("dia_SrvHandler_XCPMonitoring::simulateLightingDimming: sending the Lighting Time Value: %d", cMessageXCPCalibration.cLightingDimmingSet.lightingTimingvalue);
	
	if (DIA_SUCCESS != mLightingDimming.setLightingDimmingParameter(cMessageXCPCalibration.cLightingDimmingSet.lightingTimingvalue))
	{

		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- cLightingDimming.simulateLightingDimming() FAILED!!!!");
		return DIA_FAILED;
	}
	else
	{
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::simulateLightingDimming: successfully set Lighting Time Value: %d ", cMessageXCPCalibration.cLightingDimmingSet.lightingTimingvalue);

	}

	return DIA_SUCCESS;
}
#endif

/****************************************************************************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
tDiaResult dia_SrvHandler_XCPMonitoring::stopTripFileReplay()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::stopTripFileReplay");
	if (DIA_SUCCESS != mHMINavigationInfo.stopTripFileReplayRequest()) {
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mHMINavigationInfo.stopTripFileReplay() FAILED!!!!");
		mHMINavigationInfo.m_TripReplaystatus = DIA_ERR_REQUEST_SEND;
		return DIA_FAILED;
	}
	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::stopTripFileReplay - STOPPED ");

	return DIA_SUCCESS;
}

/****************************************************************************************************************************************/
tDiaResult dia_SrvHandler_XCPMonitoring::startTripFileReplay()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::startTripFileReplay");

	// Check if provided file name contains illegal chars (e.g. it should not contain "/")
	std::vector<std::string> splittedFileStr = dia_Helper::SplitString(std::string(cMessageXCPCalibration.cTripReplay.fileName), '/');
	if (splittedFileStr.size() == 1 && splittedFileStr.at(0).compare(std::string(cMessageXCPCalibration.cTripReplay.fileName)) == 0) {
		DIA_TR_INF("dia_SrvHandler_XCPMonitoring::startTripFileReplay. Legal fileName='%s'", cMessageXCPCalibration.cTripReplay.fileName);
	}
	else {
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::startTripFileReplay. illegal chars in fileName: '%s'", cMessageXCPCalibration.cTripReplay.fileName);
		return DIA_FAILED;
	}

	// Decide if trip replay shall be done from USB or /tmp.
	std::string startTripReplayFilePath;

		// Determine the mount point of USB device
		// TODO: Determine the mount point through the CardStatus (Monitoring parameter)
		if (dia_Helper::isDirectory(MOUNT_POINT_USB_SDA1)) {
			startTripReplayFilePath = std::string(MOUNT_POINT_USB_SDA1) + std::string(cMessageXCPCalibration.cTripReplay.fileName);
		}
		else if (dia_Helper::isDirectory(MOUNT_POINT_USB_SDB1)) {
			startTripReplayFilePath = std::string(MOUNT_POINT_USB_SDB1) + std::string(cMessageXCPCalibration.cTripReplay.fileName);
		}
		else {
			DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::startTripFileReplay. USB device is not available!!!");
			mHMINavigationInfo.m_TripReplaystatus = DIA_ERR_INPUT_FILE_INVALID;
			return DIA_FAILED;
		}


	// Check if requested replay file exists
	if (dia_Helper::isFileExists(startTripReplayFilePath.c_str()) == FALSE) {
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring::startTripFileReplay. File doesn't exist: '%s'", startTripReplayFilePath.c_str());
		mHMINavigationInfo.m_TripReplaystatus = DIA_ERR_INPUT_FILE_INVALID;
		return DIA_FAILED;
	}

	if (DIA_SUCCESS != mHMINavigationInfo.startTripFileReplayRequest(std::string(cMessageXCPCalibration.cTripReplay.fileName))) {
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mHMINavigationInfo.startTripFileReplay() FAILED!!!!");
		mHMINavigationInfo.m_TripReplaystatus = DIA_ERR_REQUEST_SEND;
		return DIA_FAILED;
	}

	DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::startTripFileReplay - STARTED on: '%s'", startTripReplayFilePath.c_str());

	return DIA_SUCCESS;
}



#endif
#ifdef VARIANT_S_FTR_ENABLE_NPIVI
tDiaResult dia_SrvHandler_XCPMonitoring::simulateSinglePIVITouch()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::simulateSinglePIVITouch");

	DIA_TR_INF("dia_SrvHandler_XCPMonitoring::simulateSinglePIVITouch: Coordinates X:Y (%d:%d) release time: %d ms", cMessageXCPCalibration.cSinglePIVITouch.xCoord, cMessageXCPCalibration.cSinglePIVITouch.yCoord, cMessageXCPCalibration.cSinglePIVITouch.releaseTime);

	if (cInputSimulation.simulatePIVITouch(cMessageXCPCalibration.cSinglePIVITouch.xCoord, cMessageXCPCalibration.cSinglePIVITouch.yCoord,2, cMessageXCPCalibration.cSinglePIVITouch.releaseTime) != DIA_SUCCESS) {
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- cInputSimulation.simulateSinglePIVITouch() FAILED!!!!");
		return DIA_FAILED;
	}
	else {
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::simulateSinglePIVITouch: OK on X:Y (%d:%d) release time: %d ms", cMessageXCPCalibration.cSinglePIVITouch.xCoord, cMessageXCPCalibration.cSinglePIVITouch.yCoord, cMessageXCPCalibration.cSinglePIVITouch.releaseTime);
	}

	return DIA_SUCCESS;
}
#endif


tDiaResult dia_SrvHandler_XCPMonitoring::simulateEncoderPush()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::simulateEncoderPush");
    tBool mode = 1;
	if (cPowerStatusInfo.simulateOnOffTrigger(mode) != DIA_SUCCESS) {
		DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- cPowerStatusInfo.simulateOnOffTrigger() FAILED!!!!");
		return DIA_FAILED;
	}
	else {
		DIA_TR_CUS("dia_SrvHandler_XCPMonitoring::simulateOnOffTrigger: successfully sent the mode 1 " );
	}


	return DIA_SUCCESS;
}

/*****************************************************************************************************************************************************/


#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
tDiaResult dia_SrvHandler_XCPMonitoring::getBoseAmpANCversion()
{
	
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getBoseAmpANCversion");
    dia_tBoseAmpSWVersionData mBoseAmpSWVersionData;
	// Save the address of elements
	if (mAddressUpdated == FALSE)
	{
		tU32 address;
		std::string mANCLargeVersion  = std::string("mANCLargeVersion");
		address = (tU32)&mMessageXCPMonitoring.mANCSWVersion.mANCLargeVersion; 
		mXcpMonitoringItemAddressMap[address] = mANCLargeVersion;
		
		std::string mANCMiddleVersion = std::string("mANCMiddleVersion");
		address = (tU32)&mMessageXCPMonitoring.mANCSWVersion.mANCMiddleVersion; 
		mXcpMonitoringItemAddressMap[address] = mANCMiddleVersion;
		
		std::string mANCSmallVersion  = std::string("mANCSmallVersion");
		address = (tU32)&mMessageXCPMonitoring.mANCSWVersion.mANCSmallVersion; 
		mXcpMonitoringItemAddressMap[address] = mANCSmallVersion;
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mANCSWVersion));
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;
	if (mBoseAmpInfo.isSubscribeForBoseAmpANCVersionInfoDone() == FALSE)
		{
			if (mBoseAmpInfo.subscribeForBoseAmpANCVersionInfo() != DIA_SUCCESS) 
			{
				DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mBoseAmpInfo.subscribeForBoseAmpANCVersionInfo() FAILED!!!!");
				return DIA_FAILED;
			}
	    }

	if (mBoseAmpInfo.isBoseAmpANCVersionInfoAvailable() == TRUE) {
		mBoseAmpSWVersionData = mBoseAmpInfo.getANCSoftwareInfo();

         DIA_TR_INF("dia_SrvHandler_XCPMonitoring::getBoseAmpANCversion - LargeVersion = %d", mBoseAmpSWVersionData.LargeVersion);
         DIA_TR_INF("dia_SrvHandler_XCPMonitoring::getBoseAmpANCversion - MiddleVersion = %d", mBoseAmpSWVersionData.MiddleVersion);
         DIA_TR_INF("dia_SrvHandler_XCPMonitoring::getBoseAmpANCversion - SmallVersion = %d", mBoseAmpSWVersionData.SmallVersion);
		 mMessageXCPMonitoring.mANCSWVersion.mANCLargeVersion = mBoseAmpSWVersionData.LargeVersion;
		 mMessageXCPMonitoring.mANCSWVersion.mANCMiddleVersion = mBoseAmpSWVersionData.MiddleVersion;
		 mMessageXCPMonitoring.mANCSWVersion.mANCSmallVersion = mBoseAmpSWVersionData.SmallVersion;

	}


	mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex - 1);
	return DIA_SUCCESS;
	

}
#endif
/*****************************************************************************************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
tDiaResult dia_SrvHandler_XCPMonitoring::getBoseAmpASCversion()
{
	dia_tclFnctTrace trc("dia_SrvHandler_XCPMonitoring::getBoseAmpASCversion");
    dia_tBoseAmpSWVersionData mBoseAmpSWVersionData;
	// Save the address of elements
	if (mAddressUpdated == FALSE)
	{
		tU32 address;
		std::string mASCLargeVersion  = std::string("mASCLargeVersion");
		address = (tU32)&mMessageXCPMonitoring.mASCSWVersion.mASCLargeVersion; 
		mXcpMonitoringItemAddressMap[address] = mASCLargeVersion;
		
		std::string mASCMiddleVersion = std::string("mASCMiddleVersion");
		address = (tU32)&mMessageXCPMonitoring.mASCSWVersion.mASCMiddleVersion; 
		mXcpMonitoringItemAddressMap[address] = mASCMiddleVersion;
		
		std::string mASCSmallVersion  = std::string("mASCSmallVersion");
		address = (tU32)&mMessageXCPMonitoring.mASCSWVersion.mASCSmallVersion; 
		mXcpMonitoringItemAddressMap[address] = mASCSmallVersion;
	}

	if (mPayloadTransferOffsetListUpdated == FALSE) {
		// Update Payload transfer offset of this element
		mPayloadTransferOffsetList.push_back(mPayloadTransferOffset - sizeof(mMessageXCPMonitoring.mASCSWVersion));
		// Update offset for the first time
		mPayloadTransferOffset = mPayloadTransferOffsetList.back();
	}

	mPayloadTransferOffsetIndex++;


   
	// Make first subscription

	if (mBoseAmpInfo.isSubscribeForBoseAmpASCVersionInfoDone() == FALSE)
		{
			if (mBoseAmpInfo.subscribeForBoseAmpASCVersionInfo() != DIA_SUCCESS) 
			{
				DIA_TR_ERR("dia_SrvHandler_XCPMonitoring --- mBoseAmpInfo.subscribeForBoseAmpASCVersionInfo() FAILED!!!!");
				return DIA_FAILED;
			}
	    }

	if (mBoseAmpInfo.isBoseAmpASCVersionInfoAvailable() == TRUE) {

		mBoseAmpSWVersionData = mBoseAmpInfo.getASCSoftwareInfo();

         DIA_TR_INF("dia_SrvHandler_XCPMonitoring::getBoseAmpASCversion - LargeVersion = %d", mBoseAmpSWVersionData.LargeVersion);
         DIA_TR_INF("dia_SrvHandler_XCPMonitoring::getBoseAmpASCversion - MiddleVersion = %d", mBoseAmpSWVersionData.MiddleVersion);
         DIA_TR_INF("dia_SrvHandler_XCPMonitoring::getBoseAmpASCversion - SmallVersion = %d", mBoseAmpSWVersionData.SmallVersion);
		 mMessageXCPMonitoring.mASCSWVersion.mASCLargeVersion = mBoseAmpSWVersionData.LargeVersion;
		 mMessageXCPMonitoring.mASCSWVersion.mASCMiddleVersion = mBoseAmpSWVersionData.MiddleVersion;
		 mMessageXCPMonitoring.mASCSWVersion.mASCSmallVersion = mBoseAmpSWVersionData.SmallVersion;
	}


	mPayloadTransferOffset = mPayloadTransferOffsetList.at(mPayloadTransferOffsetIndex - 1);
	return DIA_SUCCESS;
	

}
#endif
/*****************************************************************************************************************************************************/