/**
 * \file      dia_FileStream.h
 *
 * \brief     Class for concrete file stream implementation
 *
 *
 *  Created on: Oct 20, 2015
 *      Author: jas1hi
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */

#ifndef DIA_FILESTREAM_H_
#define DIA_FILESTREAM_H_

#ifndef DIA_BASESTREAM_H_
#include "dia_BaseStream.h"
#endif


class dia_FileStream: public dia_BaseStream {
	 // Just make compiler happy to identify copy constructor and assignment operator.
	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_FileStream); //coverity fix:52686,52602: copy constructor and assignment operator.
public:
	dia_FileStream(tCString fileName);
	virtual ~dia_FileStream();

private:
	/**
	* @return true if stream is open
	*/
	tBool isOpened()const{ return m_file != NULL; }

	/// Full path of file
	std::string		m_fname;

	/// File object used for reading/writing
	FILE*			m_file;

protected:
	dia_FileStream(); // To calm down Lint with default ctor warning

	/**
	*   Writes data of specified length to the stream
	*	Note: Implements the base definition
	*	@return number of bytes written or -1 if error is detected
	*/
    virtual tS32 writeBytes( const tVoid* buffer, tSize length  ) ;

	/**
	*   Reads data of from the stream
	*	Note: Implements the base definition
	*	@return number of bytes read or -1 if error is detected
	*/
	virtual tS32 readBytes(  tVoid* buffer, tSize length )const;

public:
    /**
	* Open stream for reading
	* @return non zero value if open is successful
			-1 if open failed
    */
	tS32 openForRead();

    /**
	* Open stream for writing
	* @return non zero value if open is successful
			-1 if open failed
    */
	tS32 openForWrite();

	/**
	* Set position for read/write operation
	* @param position new read/write position
	* @return previous position or -1 if error is detected
	*/
	tSize setPosition( tSize position );

	/**
	*	Returns current position for read/write operation
	*	@return current position for read/write operation
	*/
	tS32 getPosition()const;

	/**
	* Flush stream
	* @return -1 if error, otherwise 1
	*/
	tS32 flush();

	/**
	*	Close file
	*/
	tVoid close();

};

#endif /* DIA_FILESTREAM_H_ */
