/*
 * dia_FileStream.cpp
 *
 *  Created on: Oct 20, 2015
 *      Author: jas1hi
 */

#include "dia_FileStream.h"

dia_FileStream::dia_FileStream(tCString fileName)
	: m_fname(fileName),
	  m_file(NULL)
{
}

dia_FileStream::~dia_FileStream()
{
	if( m_file != NULL ){
		fclose( m_file );
		m_file = NULL;
	}
}

tS32 dia_FileStream::openForRead(){
	m_file = fopen( m_fname.c_str(), "rb" );
	if( m_file == NULL ){
		DIA_TR_ERR("dia_FileStream::openForRead, failed to open file for read");
		return DIA_STREAM_ERROR;
	}

//	DIA_TR_INF( "dia_FileStream::openForRead, opened file: '%s'", m_fname.c_str());

	return 0;
}

tS32 dia_FileStream::openForWrite(){

	m_file = fopen (  m_fname.c_str(), "w" );
	if( m_file == NULL ){
		DIA_TR_ERR("dia_FileStream: Failed to open file for write, file %s ",  m_fname.c_str()  );
//		LOG_ERROR("dia_FileStream: Failed to open file for write, errno %s",  strerror(errno) );
		return DIA_STREAM_ERROR;
	}

//	DIA_TR_INF( "dia_FileStream::openForWrite() opened file: '%s'", m_fname.c_str());

	return 0;
}

tS32 dia_FileStream::writeBytes( const tVoid* buffer, tSize length  ) {
	 DIA_ASSERT( buffer != NULL );

	if( isOpened() == false ){
		DIA_TR_ERR("dia_FileStream::writeBytes() failed to write bytes, file is not opened" );
		return DIA_STREAM_ERROR;
	}

	tS32 writtenBytes = 0;

	if (buffer != NULL && m_file != NULL)
		writtenBytes =  (tS32)fwrite( buffer, 1, length, m_file );

	if( writtenBytes == 0 ){
		DIA_TR_ERR("dia_FileStream::writeBytes() failed to write bytes" );
		return DIA_STREAM_ERROR;
	}

	return writtenBytes;
}

tS32 dia_FileStream::readBytes( tVoid* buffer, tSize length )const {
	DIA_ASSERT( buffer != NULL );

	if( isOpened() == false ){
		DIA_TR_ERR("dia_FileStream::readBytes() failed to read bytes, file is not opened" );
		return DIA_STREAM_ERROR;
	}

	tS32 readNumberOfBytes = 0;

	if (buffer != NULL && m_file != NULL)
		readNumberOfBytes = (tS32)fread( buffer, 1, length, m_file );

	if( readNumberOfBytes == 0 ){
		if (m_file != NULL) { // Needed for Lint
			if (feof(m_file)) {
//				LOG_INFO("dia_FileStream::readBytes() End-of-File reached.");
				return DIA_STREAM_EOF;
			}
			else {
				DIA_TR_ERR("dia_FileStream::readBytes() failed to read bytes" );
				return DIA_STREAM_ERROR;
			}
		}
	}

	return readNumberOfBytes;
}

tSize dia_FileStream::setPosition( tSize position ){
	tSize previous = (tSize) getPosition();

	if (m_file != NULL)	{
		if(fseek ( m_file,  (long int)position, SEEK_SET ) == 0){ //coverity fix:18612: return value of library function(fseek)is checked.
			return 0;
		}
	}
	return previous;
}

tS32 dia_FileStream::getPosition()const {
	tS32 thePosition = -1;

	if (m_file != NULL)
		thePosition =  (tS32)ftell ( m_file );

	return thePosition;
}

tS32 dia_FileStream::flush() {
	tS32 flushResult = -1;

	if (m_file != NULL)
		flushResult = fflush( m_file );

	return flushResult;
}

tVoid dia_FileStream::close() {
	if( m_file != NULL ){
		fclose( m_file );
		m_file = NULL;
	}
//	DIA_TR_INF( "dia_FileStream::close() successfully closed file");
}
