/*****************************************************************************************
*
* \file       dia_IWifiMost.h
*
* \brief      interface of dia_IWifiMost
*
* \details    The interface-class covers methods for sending requests and data to SAFeature.
*             The reception and processing is replied with a tDiaResult value.
*             For details about the available methods see the list below.
*
* \author     jas1hi (generated with dia_igen tool)
*
* \date       28 November 2016
*
* \copyright  (c) 2016 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_WIFIMOST__
#define __INCLUDED_DIA_INTERFACE_WIFIMOST__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_PROJECT_INTERFACES__
#include "project/interfaces/dia_project_interfaces.h"
#endif

//------------------------------------------------------------------------------

class dia_IWifiMost
{
   DIA_DECL_INTERFACE_IID(IID_WIFIMOST)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! Change the transmission power of Wi-Fi chip. The range is between 0dB and 10dB. But an actual range depends on modulation and Wi-Fi chip calibration settings.
   virtual tDiaResult vChangeWifiTransmitPower ( const tU8 wifiPowerAttenuation ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IWifiMost ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_WIFIMOST__ */

