/*****************************************************************************************
*
* \file       dia_IVehicleClientListener.h
*
* \brief      Definition of the listener interface to the vehicle client handler
*
* \details    The listener-class covers methods with requested diagnosis responses from SAFeature to service handler.
*             The reception and processing on service handler side is not verified with a return value.*             For details about the available methods see the list below.
*
* \author     umah1kor (generated with dia_igen tool)
*
* \date       4 March 2024
*
* \copyright  (c) 2024 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_VEHICLECLIENT_LISTENER__
#define __INCLUDED_DIA_INTERFACE_VEHICLECLIENT_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_VEHICLECLIENT__
#include "dia_IVehicleClient.h"
#endif

/**
 *
 *  \class dia_IVehicleClientListener
 *
 */

class dia_IVehicleClientListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_VEHICLE_CLIENT_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! reply on getting total distance info from CAN
   virtual void vOnTotalVehDistDiag ( tU32 TotalVehDistDiagValue ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IVehicleClientListener ( void ) {}
};

/**
 *
 *  \class dia_IVehicleClientListenerImpl
 *
 */

class dia_IVehicleClientListenerImpl
   : public dia_IVehicleClientListener
{
public:
   //! reply on getting total distance info from CAN
   virtual void vOnTotalVehDistDiag ( tU32 /*TotalVehDistDiagValue*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IVehicleClientListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_IVehicleClientNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IVehicleClientNotifier
   : public dia_IVehicleClientListener,
     public dia_Notifier<dia_IVehicleClientListener>
{
public:
   //! reply on getting total distance info from CAN
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnTotalVehDistDiag,tU32)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_VEHICLECLIENT_LISTENER__ */

