/*****************************************************************************************
*
* \file       dia_IVehicleClient.h
*
* \brief      interface of dia_IVehicleClient
*
* \details    The interface-class covers methods for sending requests and data to SAFeature.
*             The reception and processing is replied with a tDiaResult value.
*             For details about the available methods see the list below.
*
* \author     umah1kor (generated with dia_igen tool)
*
* \date       4 March 2024
*
* \copyright  (c) 2024 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_VEHICLECLIENT__
#define __INCLUDED_DIA_INTERFACE_VEHICLECLIENT__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_PROJECT_INTERFACES__
#include "project/interfaces/dia_project_interfaces.h"
#endif

//------------------------------------------------------------------------------

class dia_IVehicleClient
{
   DIA_DECL_INTERFACE_IID(IID_VEHICLE_CLIENT)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! returns total distance info from CAN
   virtual tDiaResult getTotalVehDistDiag ( void  ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IVehicleClient ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_VEHICLECLIENT__ */

