/*****************************************************************************************
*
* \file    dia_ITunerDABListener.h
*
* \brief   listener of dia_ITunerDABListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ITunerDAB.xml
*
* (c) 2018 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_TUNERDAB_LISTENER__
#define __INCLUDED_DIA_INTERFACE_TUNERDAB_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_TUNERDAB__
#include "common/interfaces/dia_ITunerDAB.h"
#endif

#define IID_TUNER_DAB_LISTENER ((dia::IID) 0x7b85f216)
/**
 *
 *  \class dia_ITunerDABListener
 *
 */

class dia_ITunerDABListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_TUNER_DAB_LISTENER; }
public:
   //! information about the DAB module
   virtual void vOnGetTunerDABTestModeDataInfo (tU32 dabBitErrRateFIC, tU32 dabBitErrRateMSC ) = 0;
   //! information about the DAB module
   virtual void vOnTunerDABTestModeData (const dia_tDABTestModeData& mode ) = 0;
   //! information about the DAB module - background data
   virtual void vOnTunerDABBGTestModeData (const dia_tDABBGTestModeData& data ) = 0;
   //! tuner status about the DAB module
   virtual void vOnTunerDABStatus (const dia_tTunerDABStatus& status ) = 0;
   //! Channel info of tuner DAB
   virtual void vOnTunerDABChannelInfo (const dia_tTunerDABChannelInfo& info ) = 0;
   //! Active ensemble info of tuner DAB
   virtual void vOnTunerDABActiveEnsembleInfo (const dia_tTunerDABActEnsInfo& info ) = 0;
   //! Active component info of tuner DAB
   virtual void vOnTunerDABActiveComponentInfo (const dia_tTunerDABActCompInfo& info ) = 0;
   //! Active service info of tuner DAB
   virtual void vOnTunerDABActiveServiceInfo (const dia_tTunerDABActSrvInfo& info ) = 0;
   //! information about the EnsembleFrequency status
   virtual void vOnDABStatusEnsembleFrequency (tU32 ensembleFrequency ) = 0;
   //! information about the serviceID status
   virtual void vOnDABStatusServiceID (tU32 serviceID ) = 0;
   //! information about the signalQuality status
   virtual void vOnDABStatusSignalQuality (tU32 msc, tU32 fic ) = 0;
   //! tuner status about the DAB module
   virtual void vOnDABStatusSignalFieldStrengh (tS8 signalFieldStrengh ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ITunerDABListener( void ) {}
};
/**
 *
 *  \class dia_ITunerDABListenerImpl
 *
 */

class dia_ITunerDABListenerImpl
   : public dia_ITunerDABListener
{
public:
   //! information about the DAB module
   virtual void vOnGetTunerDABTestModeDataInfo (tU32 /*dabBitErrRateFIC*/, tU32 /*dabBitErrRateMSC*/ ) {}
   //! information about the DAB module
   virtual void vOnTunerDABTestModeData (const dia_tDABTestModeData& /*mode*/ ) {}
   //! information about the DAB module - background data
   virtual void vOnTunerDABBGTestModeData (const dia_tDABBGTestModeData& /*data*/ ) {}
   //! tuner status about the DAB module
   virtual void vOnTunerDABStatus (const dia_tTunerDABStatus& /*status*/ ) {}
   //! Channel info of tuner DAB
   virtual void vOnTunerDABChannelInfo (const dia_tTunerDABChannelInfo& /*info*/ ) {}
   //! Active ensemble info of tuner DAB
   virtual void vOnTunerDABActiveEnsembleInfo (const dia_tTunerDABActEnsInfo& /*info*/ ) {}
   //! Active component info of tuner DAB
   virtual void vOnTunerDABActiveComponentInfo (const dia_tTunerDABActCompInfo& /*info*/ ) {}
   //! Active service info of tuner DAB
   virtual void vOnTunerDABActiveServiceInfo (const dia_tTunerDABActSrvInfo& /*info*/ ) {}
   //! information about the EnsembleFrequency status
   virtual void vOnDABStatusEnsembleFrequency (tU32 /*ensembleFrequency*/ ) {}
   //! information about the serviceID status
   virtual void vOnDABStatusServiceID (tU32 /*serviceID*/ ) {}
   //! information about the signalQuality status
   virtual void vOnDABStatusSignalQuality (tU32 /*msc*/, tU32 /*fic*/ ) {}
   //! tuner status about the DAB module
   virtual void vOnDABStatusSignalFieldStrengh (tS8 /*signalFieldStrengh*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_ITunerDABListenerImpl( void ) {}
};
/**
 *
 *  \class dia_ITunerDABNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_ITunerDABNotifier
   : public dia_ITunerDABListener,
     public dia_Notifier<dia_ITunerDABListener>
{
public:
   //! information about the DAB module
   virtual void vOnGetTunerDABTestModeDataInfo (tU32 dabBitErrRateFIC, tU32 dabBitErrRateMSC)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetTunerDABTestModeDataInfo(dabBitErrRateFIC, dabBitErrRateMSC);
      }
   }
   //! information about the DAB module
   virtual void vOnTunerDABTestModeData (const dia_tDABTestModeData& mode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerDABTestModeData(mode);
      }
   }
   //! information about the DAB module - background data
   virtual void vOnTunerDABBGTestModeData (const dia_tDABBGTestModeData& data)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerDABBGTestModeData(data);
      }
   }
   //! tuner status about the DAB module
   virtual void vOnTunerDABStatus (const dia_tTunerDABStatus& status)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerDABStatus(status);
      }
   }
   //! Channel info of tuner DAB
   virtual void vOnTunerDABChannelInfo (const dia_tTunerDABChannelInfo& info)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerDABChannelInfo(info);
      }
   }
   //! Active ensemble info of tuner DAB
   virtual void vOnTunerDABActiveEnsembleInfo (const dia_tTunerDABActEnsInfo& info)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerDABActiveEnsembleInfo(info);
      }
   }
   //! Active component info of tuner DAB
   virtual void vOnTunerDABActiveComponentInfo (const dia_tTunerDABActCompInfo& info)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerDABActiveComponentInfo(info);
      }
   }
   //! Active service info of tuner DAB
   virtual void vOnTunerDABActiveServiceInfo (const dia_tTunerDABActSrvInfo& info)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerDABActiveServiceInfo(info);
      }
   }
   //! information about the EnsembleFrequency status
   virtual void vOnDABStatusEnsembleFrequency (tU32 ensembleFrequency)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDABStatusEnsembleFrequency(ensembleFrequency);
      }
   }
   //! information about the serviceID status
   virtual void vOnDABStatusServiceID (tU32 serviceID)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDABStatusServiceID(serviceID);
      }
   }
   //! information about the signalQuality status
   virtual void vOnDABStatusSignalQuality (tU32 msc, tU32 fic)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDABStatusSignalQuality(msc, fic);
      }
   }
   //! tuner status about the DAB module
   virtual void vOnDABStatusSignalFieldStrengh (tS8 signalFieldStrengh)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDABStatusSignalFieldStrengh(signalFieldStrengh);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_TUNERDAB_LISTENER__ */
