/*****************************************************************************************
*
* \file       dia_ITunerAMFMPrj.h
*
* \brief      interface of dia_ITunerAMFMPrj
*
* \details    The interface-class covers methods for sending requests and data to SAFeature.
*             The reception and processing is replied with a tDiaResult value.
*             For details about the available methods see the list below.
*
* \author     urm7kor (generated with dia_igen tool)
*
* \date       28 February 2019
*
* \copyright  (c) 2019 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_TUNERAMFMPRJ__
#define __INCLUDED_DIA_INTERFACE_TUNERAMFMPRJ__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_PROJECT_INTERFACES__
#include "project/interfaces/dia_project_interfaces.h"
#endif
//------------------------------------------------------------------------------

enum dia_eBandAMFMWB
{
   DIA_EN_AMFMWBTUNER_BAND_UNKNOWN = 0,
   DIA_EN_AMFMWBTUNER_BAND_AM,
   DIA_EN_AMFMWBTUNER_BAND_FM,
   DIA_EN_AMFMWBTUNER_BAND_WB,
   DIA_EN_AMFMWBTUNER_BAND_COUNT
};

//------------------------------------------------------------------------------

class dia_ITunerAMFMPrj
{
   DIA_DECL_INTERFACE_IID(IID_TUNER_AMFM_PRJ)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! Function from SH to SA to read the field intensity and Band of the current tuner station on tuner AM/FM1/WB.
   virtual tDiaResult tunerAMFMWB_TunerBandFieldStrength_Get (  ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ITunerAMFMPrj ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_TUNERAMFMPRJ__ */

