/*
 * dia_ISubsystemDiagnosisProxyListener.h
 *
 *  Created on: 03.02.2020
 */

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS_PROXY_LISTENER__
#define __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS_PROXY_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS__
#include "project/interfaces/dia_ISubsystemDiagnosisProxy.h"
#endif

struct subsystem {
	int sin_family;
	int sin_port;
	int s_addr;
	char sin_zero[8];
	int logAdr;
	tU8 EID[6];
	tU8 GID[6];
	tU8 VIN[17];
};
//-----------------------------------------------------------------------------

class dia_ISubsystemDiagnosisProxyListener
    : public virtual dia_Listener
{
    DIA_DECL_INTERFACE_IID(IID_SUBSYSTEM_DIAGNOSIS_PROXY_LISTENER)

public:
	
	virtual void onStartUDPComm ( tDiaResult result ) = 0;
	virtual void onBroadcastVehIdResults ( tDiaResult result, ::std::vector< subsystem > nodeList ) = 0;
	virtual void onStartAvdeccFilesDelete ( tDiaResult result ) = 0;

protected:
    //! virtual base class destructor
    virtual ~dia_ISubsystemDiagnosisProxyListener ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_ISubsystemDiagnosisProxyListenerImpl
    : public dia_ISubsystemDiagnosisProxyListener
{
public:
	 
	 virtual void onStartUDPComm ( tDiaResult /* result */ ) {}
	 virtual void onBroadcastVehIdResults ( tDiaResult /* result */ , ::std::vector< subsystem > /* nodeList */) {}
	 virtual void onStartAvdeccFilesDelete ( tDiaResult /*result*/ ) {}


protected:
    //! virtual base class destructor
    virtual ~dia_ISubsystemDiagnosisProxyListenerImpl ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_ISubsystemDiagnosisProxyNotifier
    : public dia_ISubsystemDiagnosisProxyListener,
      public dia_Notifier<dia_ISubsystemDiagnosisProxyListener>
{
public:
    DIA_M_ADD_NOTIFIER_ONE_ARG(onStartUDPComm,tDiaResult )
	DIA_M_ADD_NOTIFIER_ONE_ARG(onStartAvdeccFilesDelete, tDiaResult )
    DIA_M_ADD_NOTIFIER_TWO_ARG(onBroadcastVehIdResults,tDiaResult, ::std::vector< subsystem > )


};


#endif /* __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS_LISTENER__ */
