/*
 * dia_ISubsystemDiagnosis.h
 *
 *  Created on: 23.09.2019
 *
 */

#ifndef __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS__
#define __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS__

#ifndef __INCLUDED_DIA_PROJECT_INTERFACES__
#include "project/interfaces/dia_project_interfaces.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_DIAGNOSIS__
#include <project/framework/cis/subsystem/dia_defsSubsystemDiagnosis.h>
#endif


struct dia_tSubsystemInfo
{
public:
   //! default constructor
   dia_tSubsystemInfo ( void )
      : subsystemEntityName(0),
        subsystemSupplierName(0),
		subsystemHWVariant(0),
		subsystemSWVariant(0),
        subsystemIPAddress(0),
		subsystemEntityID{0}
   {}

  /* //! copy constructor
   dia_tSubsystemInfo ( const dia_tSubsystemInfo& obj )
      : subsystemEntityName(obj.subsystemEntityName),
        subsystemSupplierName(obj.subsystemSupplierName),
		subsystemHWVariant(obj.subsystemHWVariant),
        subsystemSWVariant(obj.subsystemSWVariant),
		subsystemIPAddress(obj.subsystemIPAddress),
        subsystemEntityID(obj.subsystemEntityID[10])
		
   {}

   //! assignment operator
   dia_tSubsystemInfo& operator = ( const dia_tSubsystemInfo& obj )
   {
      if ( this != &obj ) 
	  {
		subsystemEntityName = obj.subsystemEntityName;
        subsystemSupplierName = obj.subsystemSupplierName;
		subsystemHWVariant = obj.subsystemHWVariant;
        subsystemSWVariant = obj.subsystemSWVariant;
		subsystemIPAddress = obj.subsystemIPAddress;
        subsystemEntityID[10] = obj.subsystemEntityID[10];
      }
	  
      return *this;
   }*/

   //! class constructor
   dia_tSubsystemInfo (
		tU16 /*subsystemEntityName*/,
		tU8  /*subsystemSupplierName*/,
		tU8  /*subsystemHWVariant*/,
		tU16 /*subsystemSWVariant*/,
		tU32 /*subsystemIPAddress*/,
		tU8  /*subsystemEntityID[6]*/
      )
      : subsystemEntityName(0),
        subsystemSupplierName(0),
		subsystemHWVariant(0),
		subsystemSWVariant(0),
        subsystemIPAddress(0),
		subsystemEntityID{0}
   {}

public:
   tU16 subsystemEntityName;
   tU8  subsystemSupplierName;
   tU8  subsystemHWVariant;
   tU16 subsystemSWVariant;
   tU32 subsystemIPAddress;
   tU8  subsystemEntityID[6];
};

//--------------------------------------------------------------------

class dia_ISubsystemDiagnosis
{
    DIA_DECL_INTERFACE_IID(IID_SUBSYSTEM_DIAGNOSIS)

public:

//	//! process a subsystem session activation request
//	virtual tDiaResult activateSubsystemSession ( void ) = 0;
//	//! process a subsystem session deactivation request
//	virtual tDiaResult deactivateSubsystemSession ( void ) = 0;
//	//! process a request to discover entities
//	virtual tDiaResult identyfyAllSubsystems ( std::vector<tU8>& requestData ) = 0;
//    //! process a request to discover entities request result
//	virtual tDiaResult identyfyAllSubsystemsRequestResult( std::vector<tU8>& requestData ) = 0;
//	//! process a request to connect to subsystem
//	virtual tDiaResult connectToSubsystem ( std::vector<tU8>& requestData ) = 0;
//	//! process a route request
//	virtual tDiaResult routeRequestToSubsystem ( std::vector<tU8>& requestData ) = 0;

protected:
    //! virtual base class destructor
    virtual ~dia_ISubsystemDiagnosis (void) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_SUBSYSTEM_DIAGNOSIS__ */
