/*****************************************************************************************
*
* \file    dia_ISdsGuiPopupListener.h
*
* \brief   listener of dia_ISdsGuiPopupListener
*
* The listener-class covers methods with requested diagnosis responses from SAFeature to service handler. The reception and processing on service handler side is not verified with a return value.
* For details about the available methods see the list below.
*
* \author  jas1hi (generated with dia_igen tool)
*
* \date    19 April 2016
*
* (c) 2016 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SDSGUIPOPUP_LISTENER__
#define __INCLUDED_DIA_INTERFACE_SDSGUIPOPUP_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_SDSGUIPOPUP__
#include "dia_ISdsGuiPopup.h"
#endif

/**
 *
 *  \class dia_ISdsGuiPopupListener
 *
 */

class dia_ISdsGuiPopupListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_SDS_GUI_POPUP_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! response to getSdsSpeechInputStatus
   virtual void vOnSdsSpeechStatus ( dia_eSpeechInputStatus sdsSpeechInputStatus ) = 0;
   //! response to getSdsScreenID
   virtual void vOnSdsScreenIDStatus ( std::string sdsScreenID ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ISdsGuiPopupListener ( void ) {}
};

/**
 *
 *  \class dia_ISdsGuiPopupListenerImpl
 *
 */

class dia_ISdsGuiPopupListenerImpl
   : public dia_ISdsGuiPopupListener
{
public:
   //! response to getSdsSpeechInputStatus
   virtual void vOnSdsSpeechStatus ( dia_eSpeechInputStatus /*sdsSpeechInputStatus*/ ) {}
   //! response to getSdsScreenID
   virtual void vOnSdsScreenIDStatus ( std::string /*sdsScreenID*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_ISdsGuiPopupListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_ISdsGuiPopupNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_ISdsGuiPopupNotifier
   : public dia_ISdsGuiPopupListener,
     public dia_Notifier<dia_ISdsGuiPopupListener>
{
public:
   //! response to getSdsSpeechInputStatus
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnSdsSpeechStatus,dia_eSpeechInputStatus)
   //! response to getSdsScreenID
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnSdsScreenIDStatus,std::string)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_SDSGUIPOPUP_LISTENER__ */

