/*****************************************************************************************
*
* \file       dia_IResetTouchCntlExtDisplay.h
*
* \brief      interface of dia_IResetTouchCntlExtDisplay
*
* \details    The interface-class covers methods for sending requests and data to SAFeature.
*             The reception and processing is replied with a tDiaResult value.
*             For details about the available methods see the list below.
*
* \author     abe6kor (generated with dia_igen tool)
*
* \date       05 May 2017
*
* \copyright  (c) 2017 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_RESET_TOUCHCNTL_EXTDISPLAY__
#define __INCLUDED_DIA_INTERFACE_RESET_TOUCHCNTL_EXTDISPLAY__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_PROJECT_INTERFACES__
#include "project/interfaces/dia_project_interfaces.h"
#endif

//------------------------------------------------------------------------------

enum dia_eResetTouchCntlExtDisplay
{
   DIA_EN_RESETTOUCHCNTLEXTDISPLAY_UNKNOWN = 0,
   DIA_EN_RESETTOUCHCNTLEXTDISPLAY_OFF,
   DIA_EN_RESETTOUCHCNTLEXTDISPLAY_ON,
   DIA_EN_RESETTOUCHCNTLEXTDISPLAY_COUNT
};

//------------------------------------------------------------------------------

class dia_IResetTouchCntlExtDisplay
{
   DIA_DECL_INTERFACE_IID(IID_RESET_TC)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! set the reset TouchController of External Display
   virtual tDiaResult setResetTouchCntlExtDisplay ( tU8 extDisplay, dia_eResetTouchCntlExtDisplay mode ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IResetTouchCntlExtDisplay ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_RESET_TOUCHCNTL_EXTDISPLAY__ */

