/*
 * dia_IRearControlSwitchListener.h
 *
 *  Created on: 15.08.2016
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_INTERFACE_REAR_CONTROL_SWITCH_LISTENER__
#define __INCLUDED_DIA_INTERFACE_REAR_CONTROL_SWITCH_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_REAR_CONTROL_SWITCH__
#include "dia_IRearControlSwitch.h"
#endif

//-----------------------------------------------------------------------------

class dia_RcsConnectionInfo
{
public:
    //! class constructor
    dia_RcsConnectionInfo ( void )
    {
		m_AbsentState = 0xff;
    }
    //! class destructor
    ~dia_RcsConnectionInfo ( void ) {}

    //! check if the given ECU is absent
    tU8 getAbsentState ( ) const { return m_AbsentState; }

	//! set absent mode for the given ECU
    void setAbsentState ( tU8 absentState ) { m_AbsentState = absentState; }

protected:
    //! absent mode for the set of given ECUs
    tU8 m_AbsentState;
};

//-----------------------------------------------------------------------------

class dia_IRearControlSwitchListener
    : public virtual dia_Listener
{
    DIA_DECL_SYSADAPTER_UID(IID_SYSADAPTER_REAR_CONTROL_SWITCH_LISTENER)

public:
    //! notify the network status
    virtual void vOnConnectionInfo ( const dia_RcsConnectionInfo& ) = 0;

protected:
    //! virtual base class destructor
    virtual ~dia_IRearControlSwitchListener ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_RearControlSwitchListenerImpl
    : public dia_IRearControlSwitchListener
{
public:
    //! notify connection state of ECUs connected to the MCAN
    virtual void vOnConnectionInfo ( const dia_RcsConnectionInfo& ) {}

protected:
    //! virtual base class destructor
    virtual ~dia_RearControlSwitchListenerImpl ( void ) {}
};

//-----------------------------------------------------------------------------

class dia_RearControlSwitchNotifier
    : public dia_IRearControlSwitchListener,
      public dia_Notifier<dia_IRearControlSwitchListener>
{
public:
    DIA_M_ADD_NOTIFIER_ONE_ARG(vOnConnectionInfo,const dia_RcsConnectionInfo&)
};


#endif /* __INCLUDED_DIA_INTERFACE_REAR_CONTROL_SWITCH_LISTENER__ */
