/*****************************************************************************************
*
* \file       dia_IPhonebookPrjListener.h
*
* \brief      Definition of the listener interface to the Phone book feature
*
* \details    The listener-class covers methods with requested diagnosis responses from SAFeature to service handler.
*             The reception and processing on service handler side is not verified with a return value.*             For details about the available methods see the list below.
*
* \author     nik6kor (generated with dia_igen tool)
*
* \date       23 March 2021
*
* \copyright  (c) 2021 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_PHONEBOOKPRJ_LISTENER__
#define __INCLUDED_DIA_INTERFACE_PHONEBOOKPRJ_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_PHONEBOOKPRJ__
#include "dia_IPhonebookPrj.h"
#endif

#ifndef IID_PHONE_BOOK_PRJ_LISTENER
#define IID_PHONE_BOOK_PRJ_LISTENER							((dia::IID) 0x271f92eb) // {263E0898-7D96-45CB-8ABF-DC297AF4F5DE}
#endif

/**
 *
 *  \class dia_IPhonebookPrjListener
 *
 */

class dia_IPhonebookPrjListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_PHONE_BOOK_PRJ_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! result on the vOnPhoneBook_MAxContactEntries_Get call
   virtual void vOnPhoneBook_MaxContactEntries_Get ( tU32 maxcontactcount ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IPhonebookPrjListener ( void ) {}
};

/**
 *
 *  \class dia_IPhonebookPrjListenerImpl
 *
 */

class dia_IPhonebookPrjListenerImpl
   : public dia_IPhonebookPrjListener
{
public:
   //! result on the vOnPhoneBook_MAxContactEntries_Get call
   virtual void vOnPhoneBook_MaxContactEntries_Get ( tU32 /*maxcontactcount*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IPhonebookPrjListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_IPhonebookPrjNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IPhonebookPrjNotifier
   : public dia_IPhonebookPrjListener,
     public dia_Notifier<dia_IPhonebookPrjListener>
{
public:
   //! result on the vOnPhoneBook_MAxContactEntries_Get call
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnPhoneBook_MaxContactEntries_Get,tU32)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_PHONEBOOKPRJ_LISTENER__ */

