/*****************************************************************************************
*
* \file       dia_IPhonebookPrj.h
*
* \brief      interface of dia_IPhonebookPrj
*
* \details    The interface-class covers methods for sending requests and data to SAFeature.
*             The reception and processing is replied with a tDiaResult value.
*             For details about the available methods see the list below.
*
* \author     nik6kor (generated with dia_igen tool)
*
* \date       23 March 2021
*
* \copyright  (c) 2021 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_PHONEBOOKPRJ__
#define __INCLUDED_DIA_INTERFACE_PHONEBOOKPRJ__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#ifndef IID_PHONE_BOOK_PRJ
#define IID_PHONE_BOOK_PRJ									((dia::IID) 0xc7e4b73e) // {0048E500-4137-404C-801B-BBB1D935972D}
#endif

//------------------------------------------------------------------------------

class dia_IPhonebookPrj
{
   DIA_DECL_INTERFACE_IID(IID_PHONE_BOOK_PRJ)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! Function from SH to SA to read the phone book maximum contact entries over life time.
   virtual tDiaResult phonBook_MaxContactEntries_Get (  ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IPhonebookPrj ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_PHONEBOOKPRJ__ */

