/*****************************************************************************************
*
* \file       dia_IPhoneConnectionSetting.h
*
* \brief      interface of dia_IPhoneConnectionSetting
*
* \details    The interface-class covers methods for sending requests and data to SAFeature.
*             The reception and processing is replied with a tDiaResult value.
*             For details about the available methods see the list below.
*
* \author     jas1hi (generated with dia_igen tool)
*
* \date       02 June 2016
*
* \copyright  (c) 2016 Robert Bosch GmbH
*
* The reproduction, distribution and utilization of this file as
* well as the communication of its contents to others without express
* authorization is prohibited. Offenders will be held liable for the
* payment of damages. All rights reserved in the event of the grant
* of a patent, utility model or design.
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_PHONECONNECTIONSETTING__
#define __INCLUDED_DIA_INTERFACE_PHONECONNECTIONSETTING__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif

//------------------------------------------------------------------------------

class dia_IPhoneConnectionSetting
{
   DIA_DECL_INTERFACE_IID(IID_PHONE_CONNECTION_SETTING)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! retrieve the latest connection establishment duration for Bluetooth Hands-Free Profile (HFP) in ms
   virtual tDiaResult getPhoneConnectionEstablishmentDuration ( void ) = 0;
   //! register to the property for an update of connection establishment duration for Bluetooth Hands-Free Profile (HFP) in ms
   virtual tDiaResult registerToPhoneConnectionEstablishmentDuration ( void ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IPhoneConnectionSetting ( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_PHONECONNECTIONSETTING__ */

