/*****************************************************************************************
*
* \file    dia_IPIVIInputHandlingListener.h
*
* \brief   Definition of the listener interface to the InputHandling feature
*
* The listener-class covers methods with requested diagnosis responses from SAFeature to service handler. The reception and processing on service handler side is not verified with a return value.
* For details about the available methods see the list below.
*
* \author  nlk1kor (generated with dia_igen tool)
*
* \date    06 June 2017
*
* (c) 2017 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_PIVIINPUTHANDLING_LISTENER__
#define __INCLUDED_DIA_INTERFACE_PIVIINPUTHANDLING_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_PIVIINPUTHANDLING__
#include "dia_IPIVIInputHandling.h"
#endif

/**
 *
 *  \class dia_IPIVIInputHandlingListener
 *
 */

class dia_IPIVIInputHandlingListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_PIVI_INPUT_HANDLING_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! reply for getTouchPIVISecondaryInfo
   virtual void vOnPIVITouchInfohistory ( const std::vector<dia_tTouchPressHistoryInfoPrj> vecTouchPressInfo ) = 0;
   //! reply on simulating PIVI touch slide on HMI screen
   virtual void vOnSetPIVITouch ( const tDiaResult eDiaResult ) = 0;
   //! reply on recording the gesture in file system
   virtual void vOnRecordGesture ( const tDiaResult eDiaResult ) = 0;
   //! reply on replaying the gesture saved in file system
   virtual void vOnReplayGesture ( const tDiaResult eDiaResult ) = 0;
   //! returns the touch error
   virtual void vOnTouchInfoError ( void ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IPIVIInputHandlingListener ( void ) {}
};

/**
 *
 *  \class dia_IPIVIInputHandlingListenerImpl
 *
 */

class dia_IPIVIInputHandlingListenerImpl
   : public dia_IPIVIInputHandlingListener
{
public:
   //! reply for getTouchPIVISecondaryInfo
   virtual void vOnPIVITouchInfohistory ( const std::vector<dia_tTouchPressHistoryInfoPrj> /*vecTouchPressInfo*/ ) {}
   //! reply on simulating PIVI touch slide on HMI screen
   virtual void vOnSetPIVITouch ( const tDiaResult /*eDiaResult*/ ) {}
   //! reply on recording the gesture in file system
   virtual void vOnRecordGesture ( const tDiaResult /*eDiaResult*/ ) {}
   //! reply on replaying the gesture saved in file system
   virtual void vOnReplayGesture ( const tDiaResult /*eDiaResult*/ ) {}
   //! returns the touch error
   virtual void vOnTouchInfoError ( void ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IPIVIInputHandlingListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_IPIVIInputHandlingNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IPIVIInputHandlingNotifier
   : public dia_IPIVIInputHandlingListener,
     public dia_Notifier<dia_IPIVIInputHandlingListener>
{
public:
   //! reply for getTouchPIVISecondaryInfo
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnPIVITouchInfohistory,const std::vector<dia_tTouchPressHistoryInfoPrj>)
   //! reply on simulating PIVI touch slide on HMI screen
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnSetPIVITouch,const tDiaResult)
   //! reply on recording the gesture in file system
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnRecordGesture,const tDiaResult)
   //! reply on replaying the gesture saved in file system
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnReplayGesture,const tDiaResult)
   //! returns the touch error
   DIA_M_ADD_NOTIFIER_NO_ARG(vOnTouchInfoError)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_PIVIINPUTHANDLING_LISTENER__ */

