/*****************************************************************************************
*
* \file    dia_INissanLanguageListener.h
*
* \brief   Definition of the listener interface to the dia_INissanLanguageListener features
*
* The listener-class covers methods with requested diagnosis responses from SAFeature to service handler. The reception and processing on service handler side is not verified with a return value.
* For details about the available methods see the list below.
*
* \author  shw2abt (generated with dia_igen tool)
*
* \date    06 November 2014
*
* (c) 2014 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_NISSANLANGUAGE_LISTENER__
#define __INCLUDED_DIA_INTERFACE_NISSANLANGUAGE_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_NISSANLANGUAGE__
#include "dia_INissanLanguage.h"
#endif

/**
 *
 *  \class dia_INissanLanguageListener
 *
 */

class dia_INissanLanguageListener
   : public virtual dia_Listener
{
   DIA_DECL_INTERFACE_IID(IID_NISSAN_LANGUAGE_LISTENER)
//   DIA_DECL_INTERFACE_VERSION_MAJOR_MINOR(1,0)

public:
   //! result of the setHMILanguage operations
   virtual void vOnSetHMILanguage ( tDiaResult result ) = 0;
   //! result of the getHMILanguage operation
   virtual void vOnGetHMILanguage ( dia_eNissanLanguage language ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_INissanLanguageListener ( void ) {}
};

/**
 *
 *  \class dia_INissanLanguageListenerImpl
 *
 */

class dia_INissanLanguageListenerImpl
   : public dia_INissanLanguageListener
{
public:
   //! result of the setHMILanguage operations
   virtual void vOnSetHMILanguage ( tDiaResult /*result*/ ) {}
   //! result of the getHMILanguage operation
   virtual void vOnGetHMILanguage ( dia_eNissanLanguage /*language*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_INissanLanguageListenerImpl ( void ) {}
};

/**
 *
 *  \class dia_INissanLanguageNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_INissanLanguageNotifier
   : public dia_INissanLanguageListener,
     public dia_Notifier<dia_INissanLanguageListener>
{
public:
   //! result of the setHMILanguage operations
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnSetHMILanguage,tDiaResult)
   //! result of the getHMILanguage operation
   DIA_M_ADD_NOTIFIER_ONE_ARG(vOnGetHMILanguage,dia_eNissanLanguage)
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_NISSANLANGUAGE_LISTENER__ */

